from twisted.internet import task
from nevow import rend, loaders, liveevil, tags as t
from nevow.taglibrary import progressBar as pb, progressGlue, progressCSS

incr = 0
def done(client, *args):
    def send():
        global incr
        incr = incr + 1
        if incr >= 100:
            t.stop()
        func = liveevil.literal('setPercProgress')
        client.sendScript(func('upload_progress', str(incr)))
    t = task.LoopingCall(send)
    t.start(1)

class Progressbar(rend.Page):
    addSlash = True
    def data_pgdata(self, ctx, data):
        vars = {
            'name': 'upload_progress',
        }
        return vars

    def onclick(self, ctx, data):
        attr = liveevil.handler(done)
        return ctx.tag(onclick=attr)

    docFactory = loaders.stan(
        t.html[
            t.head[
                t.title["Progressbar Example"],
                liveevil.glue,
                progressGlue,
                progressCSS
            ],
            t.body[
                t.invisible(data=t.directive('pgdata'), render=pb),
                t.p[
                    t.a(href="", render=onclick)['Set meter']
                ]
            ]
        ]
    )
 
def createResource():
    from twisted.cred import portal, checkers
    from nevow import guard
    return guard.SessionWrapper(
        portal.Portal(liveevil.SimpleRealm(Progressbar()), [checkers.AllowAnonymousAccess()]),
        mindFactory=liveevil.LiveEvil)
