# don't know how different I can do this
%define majorver 2.2
%define version 2.2.1
%define relver 1
%define nutuser nutmon

# what version of RH are we building for?
%define redhat7 1
%define redhat6 0

# Options for Redhat version 6.x:
# rpm -ba|--rebuild --define "rh6 1"
%{?rh6:%define redhat7 0}
%{?rh6:%define redhat6 1}

# some systems dont have initrddir defined
%{?_initrddir:%define _initrddir /etc/rc.d/init.d}

Name: nut
Group: Applications/System
Summary: Multi-vendor UPS Monitoring Project Client Utilities
Version: %{version}
Release: %{relver}
Source: http://www.networkupstools.org/source/%{majorver}/%{name}-%{version}.tar.gz
Copyright: GPL
BuildRoot: /var/tmp/%{name}-%{version}-root
Prereq: chkconfig fileutils
Obsoletes: nut-client
#
# configure file locations
# confdir etc are not really negotiable, so are not configurable here
%define PACKAGE		ups
%define CGIPATH        	%{_localstatedir}/www/cgi-bin
%define HTMLPATH	%{_localstatedir}/www/html/%{PACKAGE}

%description
These programs are part of a developing project to monitor the assortment 
of UPSes that are found out there in the field. Many models have serial 
ports of some kind that allow some form of state checking. This
capability has been harnessed where possible to allow for safe shutdowns, 
live status tracking on web pages, and more.

This package includes the client utilities that are required to monitor a
UPS that the client host is powered from - either connected directly via
a serial port (in which case the main nut package needs to be installed on
this machine) or across the network (where another host on the network
monitors the UPS via serial cable and runs the main nut package to allow
clients to see the information).

%package server
Requires: nut
Summary: Multi-vendor UPS Monitoring Project server
Group: Applications/System
Requires: nut = %{version} patch

%description server
These programs are part of a developing project to monitor the assortment 
of UPSes that are found out there in the field. Many models have serial 
serial ports of some kind that allow some form of state checking. This
capability has been harnessed where possible to allow for safe shutdowns, 
live status tracking on web pages, and more.

This package is the main NUT upsd daemon and the associated per-UPS-model
drivers which talk to the UPSes.  You also need to install the base NUT
package.

%package cgi
Group: Applications/System
Summary: CGI utils for Multi-vendor UPS Monitoring Project
Requires: gd >= 1.6
BuildRequires: gd-devel >= 1.6, libpng-devel

%description cgi
These programs are part of a developing project to monitor the assortment 
of UPSes that are found out there in the field. Many models have serial 
serial ports of some kind that allow some form of state checking. This
capability has been harnessed where possible to allow for safe shutdowns, 
live status tracking on web pages, and more.

This package adds the web CGI programs.   These can be installed on a
separate machine to the rest of the NUT package.

%package snmp
Group: Applications/System
Summary: SNMP support for Multi-vendor UPS Monitoring Project
Requires: net-snmp openssl nut-server
BuildRequires: net-snmp-devel openssl-devel

%description snmp
These programs are part of a developing project to monitor the assortment 
of UPSes that are found out there in the field. Many models have serial 
serial ports of some kind that allow some form of state checking. This
capability has been harnessed where possible to allow for safe shutdowns, 
live status tracking on web pages, and more.

This package adds the snmp-ups driver, that allow NUT to monitor a SNMP
capable UPS.

%prep
%setup -q
autoconf

%build
autoconf
CFLAGS="$RPM_OPT_FLAGS" ./configure \
	--prefix=%{_prefix} \
	--exec-prefix=%{_exec_prefix} \
	--sysconfdir=%{_sysconfdir}/%{PACKAGE} \
	--with-statepath=%{_localstatedir}/%{PACKAGE} \
	--with-drvpath=%{_sbindir} \
	--with-cgipath=%{CGIPATH} \
	--with-htmlpath=%{HTMLPATH} \
	--with-cgi \
	--with-user=%{nutuser} \
	--with-group=%{nutuser} \
	--mandir=%{_mandir} \
        --datadir=%{_datadir}/%{PACKAGE} \
	--enable-shared
make

%install
rm -rf %{buildroot}
#
# Build basic directories here - if they exist already then the
# installer doesn't try to create and chown them (the chown is
# a killer if we are building as non-root
mkdir -p %{buildroot}%{_sysconfdir}/%{PACKAGE}
mkdir -p %{buildroot}%{_sbindir}
mkdir -p %{buildroot}%{CGIPATH}
mkdir -p %{buildroot}%{HTMLPATH}
mkdir -p %{buildroot}%{_localstatedir}/%{PACKAGE}
mkdir -p %{buildroot}%{_mandir}
mkdir -p %{buildroot}%{_bindir}
make DESTDIR=%{buildroot} install
(cd conf; make DESTDIR=%{buildroot} install)

# move the *.sample config files to their real locations
# we don't need to worry about overwriting anything since
# they are marked as %config files within the package
for file in %{buildroot}%{_sysconfdir}/%{PACKAGE}/*.sample
do
    mv $file %{buildroot}%{_sysconfdir}/%{PACKAGE}/`basename $file .sample`
done

# install SYSV init stuff
mkdir -p %{buildroot}%{_initrddir}
install scripts/RedHat/upsd %{buildroot}%{_initrddir}
install scripts/RedHat/upsmon %{buildroot}%{_initrddir}
install scripts/RedHat/halt.patch %{buildroot}%{_initrddir}
mkdir -p %{buildroot}/etc/sysconfig
install scripts/RedHat/ups %{buildroot}/etc/sysconfig
##%if %{redhat7}
##install scripts/RedHat-6.0/upspowerdown.rh7 %{buildroot}%{_initrddir}/upspowerdown
##%else
##install scripts/RedHat-6.0/upspowerdown %{buildroot}%{_initrddir}
##%endif

%pre
%{_sbindir}/groupadd -r -f %{nutuser}
grep \^%{nutuser}: /etc/passwd >/dev/null
if [ $? -ne 0 ]; then
  %{_sbindir}/useradd -d /etc/${PACKAGE} -g %{nutuser} -M -r %{nutuser}
fi

%pre server
%{_sbindir}/groupadd -r -f %{nutuser}
grep \^%{nutuser}: /etc/passwd >/dev/null
if [ $? -ne 0 ]; then
  %{_sbindir}/useradd -d /etc/${PACKAGE} -g %{nutuser} -M -r %{nutuser}
fi

%pre cgi
%{_sbindir}/groupadd -r -f %{nutuser}
grep \^%{nutuser}: /etc/passwd >/dev/null
if [ $? -ne 0 ]; then
  %{_sbindir}/useradd -d /etc/${PACKAGE} -g %{nutuser} -M -r %{nutuser}
fi

%preun
# only do this if it is not an upgrade
if [ $1 -eq 0 ]
then 
   /sbin/chkconfig --del upsmon
   [ -f %{_initrddir}/upsmon ] && \
   	%{_initrddir}/upsmon stop
fi

%post
/sbin/chkconfig --add upsmon
# restart server if this is an upgrade
if [ $1 -gt 1 ]
then
   [ -f %{_initrddir}/upsmon ] && \
   	%{_initrddir}/upsmon restart
fi


%preun server
# only do this if it is not an upgrade
if [ $1 -eq 0 ]
then 
##   /sbin/chkconfig --del upspowerdown
   /sbin/chkconfig --del upsd
   [ -f %{_initrddir}/upsd ] && \
   	%{_initrddir}/upsd stop
fi

%post server
/usr/bin/patch -N -b -p0<%{_initrddir}/halt.patch
rm -f %{_initrddir}/halt.patch
##/sbin/chkconfig --add upspowerdown
/sbin/chkconfig --add upsd
# restart server if this is an upgrade
if [ $1 -gt 1 ]
then
   [ -f %{_initrddir}/upsd ] && \
   	%{_initrddir}/upsd restart
fi

%clean
rm -rf %{buildroot}

%files server
%defattr(-,root,root)
%{_sbindir}/upsd
%{_sbindir}/upsdrvctl
# serial
%{_sbindir}/al175
%{_sbindir}/apcsmart
%{_sbindir}/bcmxcp
%{_sbindir}/belkin
%{_sbindir}/belkinunv
%{_sbindir}/bestfcom
%{_sbindir}/bestuferrups
%{_sbindir}/bestups
%{_sbindir}/cpsups
%{_sbindir}/cyberpower
%{_sbindir}/dummy-ups
%{_sbindir}/etapro
%{_sbindir}/everups
%{_sbindir}/gamatronic
%{_sbindir}/genericups
%{_sbindir}/isbmex
%{_sbindir}/liebert
%{_sbindir}/masterguard
%{_sbindir}/megatec
%{_sbindir}/metasys
%{_sbindir}/mge-shut
%{_sbindir}/mge-utalk
%{_sbindir}/newmge-shut
%{_sbindir}/nitram
%{_sbindir}/oneac
%{_sbindir}/optiups
%{_sbindir}/powercom
%{_sbindir}/rhino
%{_sbindir}/safenet
%{_sbindir}/skel
%{_sbindir}/solis
%{_sbindir}/tripplite
%{_sbindir}/tripplitesu
%{_sbindir}/upscode2
%{_sbindir}/victronups
%{_sbindir}/powerpanel
# libusb
%{_sbindir}/usbhid-ups
%{_sbindir}/bcmxcp_usb
%{_sbindir}/tripplite_usb
# hiddev
%{_sbindir}/energizerups
##%attr(755,root,root) %{_initrddir}/upspowerdown
%attr(755,root,root) %{_initrddir}/upsd
%attr(400,root,root) %{_initrddir}/halt.patch
%dir %attr(755,root,root) %{_sysconfdir}/%{PACKAGE}
%config(noreplace) %attr(444,root,root) %{_sysconfdir}/%{PACKAGE}/ups.conf
%config(noreplace) %attr(444,root,root) %{_sysconfdir}/%{PACKAGE}/upsd.conf
%config(noreplace) %attr(400,root,root) %{_sysconfdir}/%{PACKAGE}/upsd.users
%{_mandir}/man8/al175.8.gz
%{_mandir}/man8/apcsmart.8.gz
%{_mandir}/man8/bcmxcp.8.gz
%{_mandir}/man8/belkin.8.gz
%{_mandir}/man8/belkinunv.8.gz
%{_mandir}/man8/bestfcom.8.gz
%{_mandir}/man8/bestuferrups.8.gz
%{_mandir}/man8/bestups.8.gz
%{_mandir}/man8/cpsups.8.gz
%{_mandir}/man8/cyberpower.8.gz
%{_mandir}/man8/dummy-ups.8.gz
%{_mandir}/man8/energizerups.8.gz
%{_mandir}/man8/etapro.8.gz
%{_mandir}/man8/everups.8.gz
%{_mandir}/man8/gamatronic.8.gz
%{_mandir}/man8/genericups.8.gz
%{_mandir}/man8/isbmex.8.gz
%{_mandir}/man8/liebert.8.gz
%{_mandir}/man8/masterguard.8.gz
%{_mandir}/man8/megatec.8.gz
%{_mandir}/man8/metasys.8.gz
%{_mandir}/man8/mge-shut.8.gz
%{_mandir}/man8/mge-utalk.8.gz
%{_mandir}/man8/nitram.8.gz
%{_mandir}/man8/nutupsdrv.8.gz
%{_mandir}/man8/oneac.8.gz
%{_mandir}/man8/optiups.8.gz
%{_mandir}/man8/powercom.8.gz
%{_mandir}/man8/powerpanel.8.gz
%{_mandir}/man8/rhino.8.gz
%{_mandir}/man8/safenet.8.gz
%{_mandir}/man8/solis.8.gz
%{_mandir}/man8/tripplite.8.gz
%{_mandir}/man8/tripplitesu.8.gz
%{_mandir}/man8/upscode2.8.gz
%{_mandir}/man8/victronups.8.gz
%{_mandir}/man8/bcmxcp_usb.8.gz
%{_mandir}/man8/tripplite_usb.8.gz
%{_mandir}/man8/usbhid-ups.8.gz
%{_mandir}/man8/upsd.8.gz
%{_mandir}/man8/upsdrvctl.8.gz
%{_mandir}/man5/ups.conf.5.gz
%{_mandir}/man5/upsd.conf.5.gz
%{_mandir}/man5/upsd.users.5.gz
%{_datadir}/%{PACKAGE}

%files snmp
%defattr(-,root,root)
%{_mandir}/man8/snmp-ups.8.gz
%{_sbindir}/snmp-ups

%files
%defattr(-,root,root)
%doc ChangeLog COPYING AUTHORS INSTALL README docs/
%dir %attr(755,root,root) %{_sysconfdir}/%{PACKAGE}
%config(noreplace) %attr(400,%{nutuser},%{nutuser}) %{_sysconfdir}/%{PACKAGE}/upsmon.conf
%config(noreplace) %attr(400,%{nutuser},%{nutuser}) %{_sysconfdir}/%{PACKAGE}/upssched.conf
%config(noreplace) %attr(644,root,root) %{_sysconfdir}/sysconfig/ups
%dir %attr(755,%{nutuser},%{nutuser}) %{_localstatedir}/%{PACKAGE}
%attr(755,root,root) %{_initrddir}/upsmon
%{_bindir}/upsc
%{_bindir}/upscmd
%{_bindir}/upsrw
%{_bindir}/upslog
%{_sbindir}/upsmon
%{_sbindir}/upssched
%config(noreplace) %{_bindir}/upssched-cmd
%{_mandir}/man5/upsmon.conf.5.gz
%{_mandir}/man5/upssched.conf.5.gz
%{_mandir}/man8/nutupsdrv.8.gz
%{_mandir}/man8/upsc.8.gz
%{_mandir}/man8/upsrw.8.gz
%{_mandir}/man8/upslog.8.gz
%{_mandir}/man8/upscmd.8.gz
%{_mandir}/man8/upsmon.8.gz
%{_mandir}/man8/upssched.8.gz

%files cgi
%defattr(-,root,root)
%dir %attr(755,root,root) %{_sysconfdir}/%{PACKAGE}
%config(noreplace) %attr(600,%{nutuser},root) %{_sysconfdir}/%{PACKAGE}/upsset.conf
%config(noreplace) %attr(644,root,root) %{_sysconfdir}/%{PACKAGE}/hosts.conf
%attr(644,root,root) %{_sysconfdir}/%{PACKAGE}/upsstats.html
%attr(644,root,root) %{_sysconfdir}/%{PACKAGE}/upsstats-single.html
%{_mandir}/man5/hosts.conf.5.gz
%{_mandir}/man5/upsset.conf.5.gz
%{_mandir}/man5/upsstats.html.5.gz
%{_mandir}/man8/upsimage.cgi.8.gz
%{_mandir}/man8/upsset.cgi.8.gz
%{_mandir}/man8/upsstats.cgi.8.gz
%dir %{CGIPATH}
%{CGIPATH}/upsimage.cgi
%{CGIPATH}/upsset.cgi
%{CGIPATH}/upsstats.cgi
%dir %{HTMLPATH}
%{HTMLPATH}/index.html
%{HTMLPATH}/header.html
%{HTMLPATH}/bottom.html
%{HTMLPATH}/nut-banner.png

%changelog
* Mon Jan 08 2007 Niels Baggesen <nba@users.sourceforge.net>
- Further added/removed files
- Added the snmp sub-package
- Fix some left-over explicit nutmon

* Tue May 02 2006 William Bell <w.bell@physics.gla.ac.uk>
- Corrected files list for other man pages.
- Modified install paths to use the RH standards from /usr/lib/rpm/macros
- Moved cmdvartab and driver.list into a sensible place.
- Fixed a number of other broken paths.

* Fri Jan 31 2003 Antonino Albanese <al.an@monkeysweb.net>
- Updated startup files (don't know if they still works on 6x)
- Modified model path in /sbin cause upsdrvctl have to stay on
  an already mounted filesystem
- Create a system user and group %{nutuser} and compile everything
  --with-user=%{nutuser}
- no upspowerdown script anymore. I modify halt script directly
- added missing html files to nut-cgi

* Thu Feb  7 2002 Nigel Metheringham <Nigel.Metheringham@InTechnology.co.uk>
- Rearranged config files again
- Updated startup files (for RH 7x - rpm builds for eith 6x or 7x)
- More man pages
- Macrofied even more of the spec file
- stripped SNMP support for main line, will fully integrate soon

* Fri Feb  1 2002 Nigel Metheringham <Nigel.Metheringham@InTechnology.co.uk>
- Integrated SNMP support back in (from my branch)
- moved the config files around a little - default into samples subdir

* Wed Oct 24 2001 Peter Bieringer <pb@bieringer.de> (0.45.3pre1)
- Take man path given by rpm instead of hardwired
- Add some missing man pages to %files

* Wed Feb 07 2001 Karl O. Pinc <kop@meme.com> (0.44.3-pre2)
- Cgi package buildrequires gd >= 1.6
- Added man pages for apcsmart and powercom models

* Tue Dec 05 2000 <Nigel.Metheringham@InTechnology.co.uk> (0.44.2)
- Made cgi package standalone (needs no other parts of NUT)
- Moved some configs into cgi
- Shared hosts.conf between cgi & main

* Fri Nov 24 2000 <Nigel.Metheringham@InTechnology.co.uk> (0.44.2)
- Moved models to be more FHS compliant and make sure they are there
  if everything but root is unmounted
- Moved a few things around

* Mon Aug 21 2000 <Nigel.Metheringham@Vdata.co.uk> (0.44.1)
- Added new model drivers into rpm list
- Made it wildcard more stuff so this doesn't need to be
  maintained for every little change.
  ** NOTE this breaks things if modelpath isn't distinct **

* Mon Jul 17 2000 <Nigel.Metheringham@Vdata.co.uk> (0.44.0)
- Fixed some problems in the spec file
- Dropped the older changelog entries since there is some
  intermediate history thats been missed.
- Added new model drivers into rpm list
- Updated descriptions somewhat

