/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _PIXEL_DESCRIPTION_H_
#define _PIXEL_DESCRIPTION_H_

#include <vector>

namespace GTLCore {
  class Type;
  /**
   * This class holds the definition of a pixel structure, number of channels
   * and the type of each channel.
   * @ingroup GTLCore
   */
  class PixelDescription {
    public:
      /**
       * Create a PixelDescription with multiple channels of the same type.
       * @param _channelType the type of the channel
       * @param _channels the number of channels
       */
      PixelDescription( const Type* _channelType, int _channels);
      /**
       * Create a PixelDescription with multiple channels of different types.
       * @param _channelsType a vector with the list of channels types
       */
      PixelDescription( const std::vector<const Type* >& _channelsType);
      PixelDescription( const PixelDescription& pixelDescription);
      PixelDescription& operator=(const PixelDescription& rhs);
      ~PixelDescription();
      /**
       * @return the list of channels
       */
      const std::vector<const Type*>& channelTypes() const;
      /**
       * @return the number of channels
       */
      int channels() const;
      /**
       * @return true if all channels have the same type
       */
      bool sameTypeChannels() const;
      /**
       * @return the size of a pixel in bits
       */
      int bitsSize() const;
      bool operator<( const PixelDescription& _rhs ) const;
      bool operator==( const PixelDescription& _rhs ) const;
      bool operator!=( const PixelDescription& _rhs ) const;
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
