/*************************************************************************
 *
 *  $RCSfile: QueryHit.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

// !!! public now
public final class QueryHit implements Comparable {
    private final double _penalty;
    private final int    _doc;
    private final int    _begin;
    private final int    _end;
    private final int[]  _matches; // ...concept, word number, ...

    public QueryHit(int nColumns, double penalty, int doc, int begin, int end) {
	_penalty = penalty;
	_doc   = doc;
	_begin = begin;
	_end   = end;
	_matches = new int[2 * nColumns];
    }
  
    public String toString() {
	return "[doc = "+_doc+", "+_begin+", "+_end+", "+_penalty+"]";
    }

    public int getDocument() {
	return _doc;
    }

    public int[] getMatches() {
	return _matches;
    }

    public int getBegin() {
	return _begin;
    }

    public int getEnd() {
	return _end;
    }

    public double getPenalty() {
	return _penalty;
    }

    /** for Arrays.sort() */
    public int compareTo(Object o) {
	if (_penalty != ((QueryHit)o)._penalty)
	    return _penalty < ((QueryHit)o)._penalty ? -1 : 1;
	else if (_begin != ((QueryHit)o)._begin)
	    return _begin < ((QueryHit)o)._begin ? -1 : 1;
	else if (_end   != ((QueryHit)o)._end)
	    return _end < ((QueryHit)o)._end ? -1 : 1;
	else
	    return 0;
    }

    public boolean betterThan(QueryHit x) {
	if (_penalty != x._penalty)
	    return _penalty < x._penalty;
	else if (_begin != x._begin)
	    return _begin < x._begin;
	else if (_end   != x._end)
	    return _end < x._end;
	else
	    return false;
    }
  
    public boolean worseThan(double penalty, int begin, int end) {
	if (_penalty != penalty)
	    return _penalty > penalty;
	else if (_begin != begin)
	    return _begin > begin;
	else if (_end   != end)
	    return _end > end;
	else
	    return false;
    }
}
