/*************************************************************************
 *
 *  $RCSfile: modeldata.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2002/09/17 15:02:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "modeldata.hxx"

#include "memchrt.hxx"

#include <algorithm>

#ifndef _E3D_LABEL3D_HXX
#include <svx/label3d.hxx>
#endif

template< class ListType, class ElemType >
    void lcl_CopyPtrList( const ListType & rSrc, ListType & rDest )
{
    // clear destination
    const long nDestSize = rDest.Count();
    long i = 0;

    for( i = 0; i < nDestSize; ++i )
        delete rDest.GetObject( i );
    rDest.Clear();

    // fill destination with copies of the source elements
    const long nSize = rSrc.Count();

    for( i = 0; i < nSize; ++i )
    {
        ElemType * pObj = static_cast< ElemType* >( rSrc.GetObject( i ));
        if( pObj == NULL )
            rDest.Insert( pObj, CONTAINER_APPEND );
        else
            rDest.Insert( new ElemType( * pObj ), CONTAINER_APPEND );
    }
}

SchModelData::SchModelData( const ChartModel & rModel ) :
        aBarY1( rModel.aBarY1 ),
        aBarY2( rModel.aBarY2 ),
        nChartStatus( rModel.nChartStatus ),
        mxChartAddIn( rModel.mxChartAddIn ),
        nBarPercentWidth( rModel.nBarPercentWidth ),
        nNumLinesInColChart( rModel.nNumLinesInColChart ),
        m_nDefaultColorSet( rModel.m_nDefaultColorSet ),

        aChartRect( rModel.aChartRect ),
        aInitialSize( rModel.aInitialSize ),

        m_apChartData( new SchMemChart( * rModel.pChartData )),

        fMinData( rModel.fMinData ),
        fMaxData( rModel.fMaxData ),
        fAmbientIntensity( rModel.fAmbientIntensity ),
        aAmbientColor( rModel.aAmbientColor ),
        fSpotIntensity( rModel.fSpotIntensity ),
        aSpotColor( rModel.aSpotColor ),
        eChartStyle( rModel.eChartStyle ),
        eOldChartStyle( rModel.eOldChartStyle ),
        bTextScalable( rModel.bTextScalable ),
        bIsCopied( rModel.bIsCopied ),
        bLegendVisible( rModel.bLegendVisible ),
        bShowAverage( rModel.bShowAverage ),
        eErrorKind( rModel.eErrorKind ),
        eIndicate( rModel.eIndicate ),
        eRegression( rModel.eRegression ),
        fIndicatePercent( rModel.fIndicatePercent ),
        fIndicateBigError( rModel.fIndicateBigError ),
        fIndicatePlus( rModel.fIndicatePlus ),
        fIndicateMinus( rModel.fIndicateMinus ),
        nSplineDepth( rModel.nSplineDepth ),
        nGranularity( rModel.nGranularity ),

        bSwitch3DColRow( rModel.bSwitch3DColRow ),

        nMarkLen( rModel.nMarkLen ),
        nPieHeight( rModel.nPieHeight ),
        pPieSegOfs( new long[ rModel.nPieSegCount ] ),
        nPieSegCount( rModel.nPieSegCount ),
        nXAngle( rModel.nXAngle ),
        nYAngle( rModel.nYAngle ),
        nZAngle( rModel.nZAngle ),

        bCanRebuild( rModel.bCanRebuild ),

        bShowMainTitle( rModel.bShowMainTitle ),
        bShowSubTitle( rModel.bShowSubTitle ),
        bShowXAxisTitle( rModel.bShowXAxisTitle ),
        bShowYAxisTitle( rModel.bShowYAxisTitle ),
        bShowZAxisTitle( rModel.bShowZAxisTitle ),

        aMainTitle( rModel.aMainTitle ),
        aSubTitle( rModel.aSubTitle ),
        aXAxisTitle( rModel.aXAxisTitle ),
        aYAxisTitle( rModel.aYAxisTitle ),
        aZAxisTitle( rModel.aZAxisTitle ),

        bShowXGridMain( rModel.bShowXGridMain ),
        bShowXGridHelp( rModel.bShowXGridHelp ),
        bShowYGridMain( rModel.bShowYGridMain ),
        bShowYGridHelp( rModel.bShowYGridHelp ),
        bShowZGridMain( rModel.bShowZGridMain ),
        bShowZGridHelp( rModel.bShowZGridHelp ),

        bShowDataDescr( rModel.bShowDataDescr ),

        m_apTitleAttr( new SfxItemSet( *rModel.pTitleAttr )),
        m_apMainTitleAttr( new SfxItemSet( *rModel.pMainTitleAttr )),
        m_apSubTitleAttr( new SfxItemSet( *rModel.pSubTitleAttr )),
        m_apXAxisTitleAttr( new SfxItemSet( *rModel.pXAxisTitleAttr )),
        m_apYAxisTitleAttr( new SfxItemSet( *rModel.pYAxisTitleAttr )),
        m_apZAxisTitleAttr( new SfxItemSet( *rModel.pZAxisTitleAttr )),
        m_apAxisAttr( new SfxItemSet( *rModel.pAxisAttr )),

        m_apGridAttr( new SfxItemSet( *rModel.pGridAttr )),
        m_apXGridMainAttr( new SfxItemSet( *rModel.pXGridMainAttr )),
        m_apYGridMainAttr( new SfxItemSet( *rModel.pYGridMainAttr )),
        m_apZGridMainAttr( new SfxItemSet( *rModel.pZGridMainAttr )),
        m_apXGridHelpAttr( new SfxItemSet( *rModel.pXGridHelpAttr )),
        m_apYGridHelpAttr( new SfxItemSet( *rModel.pYGridHelpAttr )),
        m_apZGridHelpAttr( new SfxItemSet( *rModel.pZGridHelpAttr )),
        m_apDiagramAreaAttr( new SfxItemSet( *rModel.pDiagramAreaAttr )),
        m_apDiagramWallAttr( new SfxItemSet( *rModel.pDiagramWallAttr )),
        m_apDiagramFloorAttr( new SfxItemSet( *rModel.pDiagramFloorAttr )),
        m_apLegendAttr( new SfxItemSet( *rModel.pLegendAttr )),
        m_apDummyAttr( new SfxItemSet( *rModel.pDummyAttr )),

        m_apStockLineAttr( new SfxItemSet( *rModel.pStockLineAttr )),
        m_apStockLossAttr( new SfxItemSet( *rModel.pStockLossAttr )),
        m_apStockPlusAttr( new SfxItemSet( *rModel.pStockPlusAttr )),

        m_apChartAttr( new SfxItemSet( *rModel.pChartAttr )),

        eDataDescr( rModel.eDataDescr ),
        bShowSym( rModel.bShowSym ),
        bSwitchData( rModel.bSwitchData ),

        bNoBuildChart( rModel.bNoBuildChart ),
        bShouldBuildChart( rModel.bShouldBuildChart ),
        bReadError( rModel.bReadError ),
        mbIsInitialized( rModel.mbIsInitialized ),

        bFormatXAxisTextInMultipleLinesIfNecessary( rModel.bFormatXAxisTextInMultipleLinesIfNecessary ),
        bFormatYAxisTextInMultipleLinesIfNecessary( rModel.bFormatYAxisTextInMultipleLinesIfNecessary ),
        bFormatZAxisTextInMultipleLinesIfNecessary( rModel.bFormatZAxisTextInMultipleLinesIfNecessary ),
        bFormatLegendTextInMultipleLinesIfNecessary( rModel.bFormatLegendTextInMultipleLinesIfNecessary ),

        nXAxisTextMaximumNumberOfLines( rModel.nXAxisTextMaximumNumberOfLines ),
        nYAxisTextMaximumNumberOfLines( rModel.nYAxisTextMaximumNumberOfLines ),
        nZAxisTextMaximumNumberOfLines( rModel.nZAxisTextMaximumNumberOfLines ),

        nWidthOfFirstXAxisText( rModel.nWidthOfFirstXAxisText ),
        nWidthOfLastXAxisText( rModel.nWidthOfLastXAxisText ),

        aTitleTopCenter( rModel.aTitleTopCenter ),
        aSubTitleTopCenter( rModel.aSubTitleTopCenter ),
        aDiagramRectangle( rModel.aDiagramRectangle ),
        aLastDiagramRectangle( rModel.aLastDiagramRectangle ),
        aLegendTopLeft( rModel.aLegendTopLeft ),

        aTitleXAxisPosition( rModel.aTitleXAxisPosition ),
        aTitleYAxisPosition( rModel.aTitleYAxisPosition ),
        aTitleZAxisPosition( rModel.aTitleZAxisPosition ),

        eAdjustXAxesTitle( rModel.eAdjustXAxesTitle ),
        eAdjustYAxesTitle( rModel.eAdjustYAxesTitle ),
        eAdjustZAxesTitle( rModel.eAdjustZAxesTitle ),

        bUseRelativePositionsForChartGroups( rModel.bUseRelativePositionsForChartGroups ),

        bAdjustMarginsForLegend( rModel.bAdjustMarginsForLegend ),
        bAdjustMarginsForMainTitle( rModel.bAdjustMarginsForMainTitle ),
        bAdjustMarginsForSubTitle( rModel.bAdjustMarginsForSubTitle ),
        bAdjustMarginsForXAxisTitle( rModel.bAdjustMarginsForXAxisTitle ),
        bAdjustMarginsForYAxisTitle( rModel.bAdjustMarginsForYAxisTitle ),
        bAdjustMarginsForZAxisTitle( rModel.bAdjustMarginsForZAxisTitle ),

        bDiagramHasBeenMovedOrResized( rModel.bDiagramHasBeenMovedOrResized ),
        bMainTitleHasBeenMoved( rModel.bMainTitleHasBeenMoved ),
        bSubTitleHasBeenMoved( rModel.bSubTitleHasBeenMoved ),
        bLegendHasBeenMoved( rModel.bLegendHasBeenMoved ),
        bXAxisTitleHasBeenMoved( rModel.bXAxisTitleHasBeenMoved ),
        bYAxisTitleHasBeenMoved( rModel.bYAxisTitleHasBeenMoved ),
        bZAxisTitleHasBeenMoved( rModel.bZAxisTitleHasBeenMoved ),

        aInitialSizefor3d( rModel.aInitialSizefor3d ),

        nXLastNumFmt( rModel.nXLastNumFmt ),
        nYLastNumFmt( rModel.nYLastNumFmt ),
        nBLastNumFmt( rModel.nBLastNumFmt ),

        eLanguage( rModel.eLanguage ),
        eLanguageCJK( rModel.eLanguageCJK ),
        eLanguageCTL( rModel.eLanguageCTL ),

        eProjection( rModel.eProjection )
{
    lcl_CopyPtrList< DescrList, E3dLabelObj >( rModel.aXDescrList, aXDescrList );
    lcl_CopyPtrList< DescrList, E3dLabelObj >( rModel.aYDescrList, aYDescrList );
    lcl_CopyPtrList< DescrList, E3dLabelObj >( rModel.aZDescrList, aZDescrList );

    lcl_CopyPtrList< ItemSetList, SfxItemSet >( rModel.aDataRowAttrList, aDataRowAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( rModel.aDataPointAttrList, aDataPointAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( rModel.aSwitchDataPointAttrList, aSwitchDataPointAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( rModel.aRegressAttrList, aRegressAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( rModel.aAverageAttrList, aAverageAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( rModel.aErrorAttrList, aErrorAttrList );

    ::std::copy( rModel.pPieSegOfs, rModel.pPieSegOfs + rModel.nPieSegCount,
                 pPieSegOfs );
}

void SchModelData::ApplyTo( ChartModel & rModel )
{
    rModel.SetChartData( * new SchMemChart( * m_apChartData.get() ));

    rModel.aBarY1 = aBarY1;
    rModel.aBarY2 = aBarY2;
    rModel.nChartStatus = nChartStatus;
    rModel.mxChartAddIn = mxChartAddIn;
    rModel.nBarPercentWidth = nBarPercentWidth;
    rModel.nNumLinesInColChart = nNumLinesInColChart;
    rModel.m_nDefaultColorSet = m_nDefaultColorSet;

    rModel.aChartRect = aChartRect;
    rModel.aInitialSize = aInitialSize;

    rModel.fMinData = fMinData;
    rModel.fMaxData = fMaxData;
    rModel.fAmbientIntensity = fAmbientIntensity;
    rModel.aAmbientColor = aAmbientColor;
    rModel.fSpotIntensity = fSpotIntensity;
    rModel.aSpotColor = aSpotColor;
    rModel.eChartStyle = eChartStyle;
    rModel.eOldChartStyle = eOldChartStyle;
    rModel.bTextScalable = bTextScalable;
    rModel.bIsCopied = bIsCopied;
    rModel.bLegendVisible = bLegendVisible;
    rModel.bShowAverage = bShowAverage;
    rModel.eErrorKind = eErrorKind;
    rModel.eIndicate = eIndicate;
    rModel.eRegression = eRegression;
    rModel.fIndicatePercent = fIndicatePercent;
    rModel.fIndicateBigError = fIndicateBigError;
    rModel.fIndicatePlus = fIndicatePlus;
    rModel.fIndicateMinus = fIndicateMinus;
    rModel.nSplineDepth = nSplineDepth;
    rModel.nGranularity = nGranularity;

    rModel.bSwitch3DColRow = bSwitch3DColRow;

    rModel.nMarkLen = nMarkLen;
    rModel.nPieHeight = nPieHeight;

    rModel.nPieSegCount = nPieSegCount;
    rModel.AllocPieSegOfs( nPieSegCount );
    ::std::copy( pPieSegOfs, pPieSegOfs + nPieSegCount,
                 rModel.pPieSegOfs );

    rModel.nXAngle = nXAngle;
    rModel.nYAngle = nYAngle;
    rModel.nZAngle = nZAngle;

    rModel.bCanRebuild = bCanRebuild;

    rModel.bShowMainTitle = bShowMainTitle;
    rModel.bShowSubTitle = bShowSubTitle;
    rModel.bShowXAxisTitle = bShowXAxisTitle;
    rModel.bShowYAxisTitle = bShowYAxisTitle;
    rModel.bShowZAxisTitle = bShowZAxisTitle;

    rModel.aMainTitle = aMainTitle;
    rModel.aSubTitle = aSubTitle;
    rModel.aXAxisTitle = aXAxisTitle;
    rModel.aYAxisTitle = aYAxisTitle;
    rModel.aZAxisTitle = aZAxisTitle;

    rModel.bShowXGridMain = bShowXGridMain;
    rModel.bShowXGridHelp = bShowXGridHelp;
    rModel.bShowYGridMain = bShowYGridMain;
    rModel.bShowYGridHelp = bShowYGridHelp;
    rModel.bShowZGridMain = bShowZGridMain;
    rModel.bShowZGridHelp = bShowZGridHelp;

    rModel.bShowDataDescr = bShowDataDescr;

    if( rModel.pTitleAttr )
    {
        rModel.pTitleAttr->ClearItem();
        rModel.pTitleAttr->Put( *m_apTitleAttr.get() );
    }
    if( rModel.pMainTitleAttr )
    {
        rModel.pMainTitleAttr->ClearItem();
        rModel.pMainTitleAttr->Put( *m_apMainTitleAttr.get() );
    }
    if( rModel.pSubTitleAttr )
    {
        rModel.pSubTitleAttr->ClearItem();
        rModel.pSubTitleAttr->Put( *m_apSubTitleAttr.get() );
    }
    if( rModel.pXAxisTitleAttr )
    {
        rModel.pXAxisTitleAttr->ClearItem();
        rModel.pXAxisTitleAttr->Put( *m_apXAxisTitleAttr.get() );
    }
    if( rModel.pYAxisTitleAttr )
    {
        rModel.pYAxisTitleAttr->ClearItem();
        rModel.pYAxisTitleAttr->Put( *m_apYAxisTitleAttr.get() );
    }
    if( rModel.pZAxisTitleAttr )
    {
        rModel.pZAxisTitleAttr->ClearItem();
        rModel.pZAxisTitleAttr->Put( *m_apZAxisTitleAttr.get() );
    }
    if( rModel.pAxisAttr )
    {
        rModel.pAxisAttr->ClearItem();
        rModel.pAxisAttr->Put( *m_apAxisAttr.get() );
    }

    if( rModel.pGridAttr )
    {
        rModel.pGridAttr->ClearItem();
        rModel.pGridAttr->Put( *m_apGridAttr.get() );
    }
    if( rModel.pXGridMainAttr )
    {
        rModel.pXGridMainAttr->ClearItem();
        rModel.pXGridMainAttr->Put( *m_apXGridMainAttr.get() );
    }
    if( rModel.pYGridMainAttr )
    {
        rModel.pYGridMainAttr->ClearItem();
        rModel.pYGridMainAttr->Put( *m_apYGridMainAttr.get() );
    }
    if( rModel.pZGridMainAttr )
    {
        rModel.pZGridMainAttr->ClearItem();
        rModel.pZGridMainAttr->Put( *m_apZGridMainAttr.get() );
    }
    if( rModel.pXGridHelpAttr )
    {
        rModel.pXGridHelpAttr->ClearItem();
        rModel.pXGridHelpAttr->Put( *m_apXGridHelpAttr.get() );
    }
    if( rModel.pYGridHelpAttr )
    {
        rModel.pYGridHelpAttr->ClearItem();
        rModel.pYGridHelpAttr->Put( *m_apYGridHelpAttr.get() );
    }
    if( rModel.pZGridHelpAttr )
    {
        rModel.pZGridHelpAttr->ClearItem();
        rModel.pZGridHelpAttr->Put( *m_apZGridHelpAttr.get() );
    }
    if( rModel.pDiagramAreaAttr )
    {
        rModel.pDiagramAreaAttr->ClearItem();
        rModel.pDiagramAreaAttr->Put( *m_apDiagramAreaAttr.get() );
    }
    if( rModel.pDiagramWallAttr )
    {
        rModel.pDiagramWallAttr->ClearItem();
        rModel.pDiagramWallAttr->Put( *m_apDiagramWallAttr.get() );
    }
    if( rModel.pDiagramFloorAttr )
    {
        rModel.pDiagramFloorAttr->ClearItem();
        rModel.pDiagramFloorAttr->Put( *m_apDiagramFloorAttr.get() );
    }
    if( rModel.pLegendAttr )
    {
        rModel.pLegendAttr->ClearItem();
        rModel.pLegendAttr->Put( *m_apLegendAttr.get() );
    }
    if( rModel.pDummyAttr )
    {
        rModel.pDummyAttr->ClearItem();
        rModel.pDummyAttr->Put( *m_apDummyAttr.get() );
    }
    if( rModel.pStockLineAttr )
    {
        rModel.pStockLineAttr->ClearItem();
        rModel.pStockLineAttr->Put( *m_apStockLineAttr.get() );
    }
    if( rModel.pStockLossAttr )
    {
        rModel.pStockLossAttr->ClearItem();
        rModel.pStockLossAttr->Put( *m_apStockLossAttr.get() );
    }
    if( rModel.pStockPlusAttr )
    {
        rModel.pStockPlusAttr->ClearItem();
        rModel.pStockPlusAttr->Put( *m_apStockPlusAttr.get() );
    }

    if( rModel.pChartAttr )
    {
        rModel.pChartAttr->ClearItem();
        rModel.pChartAttr->Put( *m_apChartAttr.get() );
    }

    rModel.eDataDescr = eDataDescr;
    rModel.bShowSym = bShowSym;
    rModel.bSwitchData = bSwitchData;

    rModel.bNoBuildChart = bNoBuildChart;
    rModel.bShouldBuildChart = bShouldBuildChart;
    rModel.bReadError = bReadError;
    rModel.mbIsInitialized = mbIsInitialized;

    rModel.bFormatXAxisTextInMultipleLinesIfNecessary = bFormatXAxisTextInMultipleLinesIfNecessary;
    rModel.bFormatYAxisTextInMultipleLinesIfNecessary = bFormatYAxisTextInMultipleLinesIfNecessary;
    rModel.bFormatZAxisTextInMultipleLinesIfNecessary = bFormatZAxisTextInMultipleLinesIfNecessary;
    rModel.bFormatLegendTextInMultipleLinesIfNecessary = bFormatLegendTextInMultipleLinesIfNecessary;

    rModel.nXAxisTextMaximumNumberOfLines = nXAxisTextMaximumNumberOfLines;
    rModel.nYAxisTextMaximumNumberOfLines = nYAxisTextMaximumNumberOfLines;
    rModel.nZAxisTextMaximumNumberOfLines = nZAxisTextMaximumNumberOfLines;

    rModel.nWidthOfFirstXAxisText = nWidthOfFirstXAxisText;
    rModel.nWidthOfLastXAxisText = nWidthOfLastXAxisText;

    rModel.aTitleTopCenter = aTitleTopCenter;
    rModel.aSubTitleTopCenter = aSubTitleTopCenter;
    rModel.aDiagramRectangle = aDiagramRectangle;
    rModel.aLastDiagramRectangle = aLastDiagramRectangle;
    rModel.aLegendTopLeft = aLegendTopLeft;

    rModel.aTitleXAxisPosition = aTitleXAxisPosition;
    rModel.aTitleYAxisPosition = aTitleYAxisPosition;
    rModel.aTitleZAxisPosition = aTitleZAxisPosition;

    rModel.eAdjustXAxesTitle = eAdjustXAxesTitle;
    rModel.eAdjustYAxesTitle = eAdjustYAxesTitle;
    rModel.eAdjustZAxesTitle = eAdjustZAxesTitle;

    rModel.bUseRelativePositionsForChartGroups = bUseRelativePositionsForChartGroups;

    rModel.bAdjustMarginsForLegend = bAdjustMarginsForLegend;
    rModel.bAdjustMarginsForMainTitle = bAdjustMarginsForMainTitle;
    rModel.bAdjustMarginsForSubTitle = bAdjustMarginsForSubTitle;
    rModel.bAdjustMarginsForXAxisTitle = bAdjustMarginsForXAxisTitle;
    rModel.bAdjustMarginsForYAxisTitle = bAdjustMarginsForYAxisTitle;
    rModel.bAdjustMarginsForZAxisTitle = bAdjustMarginsForZAxisTitle;

    rModel.bDiagramHasBeenMovedOrResized = bDiagramHasBeenMovedOrResized;
    rModel.bMainTitleHasBeenMoved = bMainTitleHasBeenMoved;
    rModel.bSubTitleHasBeenMoved = bSubTitleHasBeenMoved;
    rModel.bLegendHasBeenMoved = bLegendHasBeenMoved;
    rModel.bXAxisTitleHasBeenMoved = bXAxisTitleHasBeenMoved;
    rModel.bYAxisTitleHasBeenMoved = bYAxisTitleHasBeenMoved;
    rModel.bZAxisTitleHasBeenMoved = bZAxisTitleHasBeenMoved;

    rModel.aInitialSizefor3d = aInitialSizefor3d;

    rModel.nXLastNumFmt = nXLastNumFmt;
    rModel.nYLastNumFmt = nYLastNumFmt;
    rModel.nBLastNumFmt = nBLastNumFmt;

    rModel.eLanguage = eLanguage;
    rModel.eLanguageCJK = eLanguageCJK;
    rModel.eLanguageCTL = eLanguageCTL;

    rModel.eProjection = eProjection;    

    lcl_CopyPtrList< DescrList, E3dLabelObj >( aXDescrList, rModel.aXDescrList );
    lcl_CopyPtrList< DescrList, E3dLabelObj >( aYDescrList, rModel.aYDescrList );
    lcl_CopyPtrList< DescrList, E3dLabelObj >( aZDescrList, rModel.aZDescrList );

    lcl_CopyPtrList< ItemSetList, SfxItemSet >( aDataRowAttrList, rModel.aDataRowAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( aDataPointAttrList, rModel.aDataPointAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( aSwitchDataPointAttrList, rModel.aSwitchDataPointAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( aRegressAttrList, rModel.aRegressAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( aAverageAttrList, rModel.aAverageAttrList );
    lcl_CopyPtrList< ItemSetList, SfxItemSet >( aErrorAttrList, rModel.aErrorAttrList );

    rModel.BuildChart( FALSE );
}
