/*************************************************************************
 *
 *  $RCSfile: instdb.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SETUP_INSTDB_HXX
#define SETUP_INSTDB_HXX

#include <limits.h>

#include "ident.hxx"
#include "hashtbl.hxx"
#include "simode.hxx"

#if SUPD < 364

#else
#ifndef _DATE_HXX //autogen
#include <tools/date.hxx>
#endif
#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#endif


// Vorwaerts-Deklarationen

class SiCompiledScript;
class SiDeclarator;
class SiModule;
class SiFile;
class SiProcedure;
class SiCustom;
class SiDirectory;
class SiDirectoryList;
class SiFolder;
class SiFolderItem;
class SiOs2Class;
class SiOs2Creator;
class SiOs2Template;
class SiRegistryItem;

class SiFileStream;

DECLARE_HASHTABLE(SiDBDoneList,ByteString,UINT32);

class SiDatabase
{
	SiFileStream&	m_aStream;
	SiInstallMode 	m_eInstallMode;
	SiDBDoneList  	m_aDoneList;
	int           	m_nListPos;
	BOOL			m_bScpMode;

	USHORT 			m_nLaguage;

	BOOL WriteObject(SiDeclarator const*);

	void AddSeparator();
	static ByteString Quote(ByteString const&);

	BOOL Create(SiDirectoryList const&);
	BOOL Create(SiDirectory const*);
	BOOL Create(SiFile const*);
	BOOL Create(SiProcedure const*);
	BOOL Create(SiCustom const*);
	BOOL Create(SiModule const*);
	BOOL Create(SiFolder const*);
	BOOL Create(SiFolderItem const*);

	BOOL Create(SiOs2Class const*);
	BOOL Create(SiOs2Creator const*);
	BOOL Create(SiOs2Template const*);

	BOOL Create(SiRegistryItem const*);

public:

	void BeginDeclaration (ByteString const& aName, SiDeclarator const*);
	void WriteProperty (ByteString const& aName, BOOL, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, long, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, sal_uInt32, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, int, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, ByteString const&, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, SiIdentifier const&, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, SiDeclarator const*, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, Date const&, USHORT nLanguage = USHRT_MAX);
	void WriteProperty (ByteString const& aName, Time const&, USHORT nLanguage = USHRT_MAX);
	void EndDeclaration();

	void BeginProperty (ByteString const& aName, USHORT nLang) { m_nLaguage = nLang; BeginProperty(aName); }
	void BeginProperty (ByteString const& aName);
	void BeginList();
	void AddListValue(long);
	void AddListValue(ByteString const&, BOOL bNewLine = FALSE);
	void AddListValue(SiIdentifier const&);
	void AddListValue(SiDeclarator const*);
	void EndList();
	void EndProperty();
	void WriteFreeStyle(const ByteString& rFreeCode);

public:
		SiDatabase(SiFileStream&);

	BOOL		Create(SiCompiledScript const*, SiInstallMode, ByteString const& aPath, BOOL bInstallFromNet);
	BOOL 		Create(SiCompiledScript const*);
};

#endif // SETUP_INSTDB_HXX

