/*************************************************************************
 *
 *  $RCSfile: pwaddr.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 09:56:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "maindlg.hxx"
#include "environ.hxx"

#include "pwaddr.hxx"
#include "pwaddr.hrc"

PageWarnAddress::PageWarnAddress( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFILogo			( this, ResId(IMG_EXPMARK, rResId.GetResMgr()) ),
	aFTAllInfo1		( this, ResId(FT_ALL1, rResId.GetResMgr()) ),
	aFTAllInfo2		( this, ResId(FT_ALL2, rResId.GetResMgr()) ),
	aLabelUsername	( this, ResId(FT_LABEL_USERNAME, rResId.GetResMgr()) ),
	aUsername		( this, ResId(FT_USERNAME, rResId.GetResMgr()) ),
	aLabelStreet	( this, ResId(FT_LABEL_STREET, rResId.GetResMgr()) ),
	aStreet			( this, ResId(FT_STREET, rResId.GetResMgr()) ),
	aLabelAddress	( this, ResId(FT_LABEL_ADDRESS, rResId.GetResMgr()) ),
	aAddress		( this, ResId(FT_ADDRESS, rResId.GetResMgr()) ),
	aLabelEmail		( this, ResId(FT_LABEL_EMAIL, rResId.GetResMgr()) ),
	aEmail			( this, ResId(FT_EMAIL, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aTitle );
	FreeResource();

	aTitle = aFTAllInfo2.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"), pParent->GetBackText() );
	aFTAllInfo2.SetText( aTitle );

	Font aBold( aUsername.GetFont() );
	aBold.SetWeight( WEIGHT_BOLD );

	aUsername.SetFont( aBold );
	aStreet.SetFont( aBold );
	aAddress.SetFont( aBold );
	aEmail.SetFont( aBold );

	SiEnvironment* pEnv = GETDLG()->GetEnv();
	ByteString aText;
	ByteString aCnvt;

	aCnvt = pEnv->GetUserFirstName();
	aCnvt.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
	aText += aCnvt;
	aText += " ";
	aCnvt = pEnv->GetUserName();
	aCnvt.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
	aText += aCnvt;
	aUsername.SetText( aText );


	aCnvt = pEnv->GetStreet();
	aCnvt.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
	aStreet.SetText( aCnvt );

	aCnvt = pEnv->GetZip();
	aCnvt.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
	aText = aCnvt;
	aText += " ";
	aCnvt = pEnv->GetCity();
	aCnvt.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
	aText += aCnvt;
	aAddress.SetText( aText );

	aCnvt = pEnv->GetUserEMail();
	aCnvt.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
	aEmail.SetText( aCnvt );
}

PageWarnAddress::~PageWarnAddress()
{
}

SvAgentPage* PageWarnAddress::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageWarnAddress( pParent, rResId );
}

