/*************************************************************************
 *
 *  $RCSfile: unloader.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 15:15:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>

#include <ctype.h>
#include <direct.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\locking.h>

#include "unloader.h"


#define APPDELAY_TIMER			1
#define MAX_LOOP				50
#define MAX_LINE_BUF			_MAX_PATH

//////////////////////////////////////////////////////////////////////////
// globals

#ifdef WIN
HANDLE	hInstallInst;
#else
UINT	hInstallInst;
#endif

HINSTANCE	hInst;
HWND	hWnd;
HFILE	hDelFile;
OFSTRUCT ofDelFile;
int 	nLoop = 0;

//////////////////////////////////////////////////////////////////////////
// _RemoveFile( const char* pFileName )

BOOL _RemoveFile( const char* pFileName )
{
	OFSTRUCT	ofFile;
	HFILE		hFile = OpenFile( pFileName, &ofFile, OF_EXIST );

	if( HFILE_ERROR == hFile )
		return TRUE;

	char cPath[_MAX_PATH];
	strncpy( cPath, pFileName, sizeof(cPath)-1 );
    cPath[ sizeof(cPath)-1 ] = '\0';

	for( DWORD i = strlen(cPath); i > 0; --i )
		if( cPath[i] == '\\' )
		{
			cPath[i] = 0x00;
			break;
		}

	chdir( cPath );
	_chmod( pFileName, _S_IWRITE );
	if( remove(pFileName) == -1 )
		return FALSE;

	chdir( ".." );
	rmdir( cPath );

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////
//	WinMain()

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
					LPSTR lpCmdLine, int nCmdShow )
{
	MSG message;
	if( hPrevInstance )
		return FALSE;
	else if( !InitApplication(hInstance) )
		return FALSE;
	if( !InitInstance(hInstance, nCmdShow) )
		return FALSE;

    if( !lpCmdLine )
		return FALSE;

    char strFileName[MAX_LINE_BUF];
    int nLen = strlen( lpCmdLine );
    if ( nLen > MAX_LINE_BUF )
        nLen = MAX_LINE_BUF - 1;

    // remove quotes
    if ( lpCmdLine[0] == '"' )
    {
        strncpy( strFileName, lpCmdLine+1, nLen - 2 );
        strFileName[ nLen-2 ] = '\0';
    }
    else
	{
        strncpy( strFileName, lpCmdLine, nLen );
        strFileName[ nLen ] = '\0';
	}

	hDelFile = OpenFile( strFileName, &ofDelFile, OF_READ );
	if( HFILE_ERROR == hDelFile )
		return FALSE;

	SetTimer( hWnd, APPDELAY_TIMER, 3000, NULL );

	while( GetMessage(&message, 0, 0, 0) )
	{
		TranslateMessage( &message );
		DispatchMessage( &message );
	}

	_lclose( hDelFile );
	_RemoveFile( strFileName );

	return message.wParam;
}


//////////////////////////////////////////////////////////////////////////
//	InitApplication( HANDLE hInstance )

BOOL InitApplication( HINSTANCE hInstance )
{
	WNDCLASS  wc;

	wc.style		 = 0;
	wc.lpfnWndProc	 = MainWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hIcon		 = 0;
	wc.hCursor		 = LoadCursor( 0, IDC_ARROW );
	wc.hbrBackground = 0;
	wc.lpszMenuName  = 0;
	wc.lpszClassName = "UnloadLWClass";

	return RegisterClass( &wc );
}

//////////////////////////////////////////////////////////////////////////
//	InitInstance( HANDLE hInstance, int nCmdShow )

BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
	hInst = hInstance;

	hWnd = CreateWindow( "UnloadLWClass", 0, WS_POPUP | WS_DLGFRAME,
		( GetSystemMetrics( SM_CXSCREEN ) - WINDOW_WIDTH )	/ 2,
		( GetSystemMetrics( SM_CYSCREEN ) - WINDOW_HEIGHT ) / 2,
		WINDOW_WIDTH, WINDOW_HEIGHT, 0, 0, hInstance, 0 );

	if( hWnd )
		return TRUE;

	return FALSE;
}

//////////////////////////////////////////////////////////////////////////
//	MainWndProc()

LONG FAR PASCAL MainWndProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch (message)
	{
		////////////////////////////
		// WM_COMMAND
		case WM_COMMAND: {
			if( wParam == ID_START )
			{
				BOOL bDeleteAll = TRUE;
				char strLineBuf[MAX_LINE_BUF];
				ULONG nRead = 1;

				_llseek( hDelFile, 0L, SEEK_SET );
				while( nRead != 0 )
				{
					int	 nIdx = 0;
					char cChar[1];
					memset( strLineBuf, 0, MAX_LINE_BUF );

					do
					{
						nRead = _lread( hDelFile, cChar, 1 );
						if( nRead && cChar[0] != 0x0d && cChar[0] != 0x0a)
							strLineBuf[nIdx++] = cChar[0];
					} while( nRead != 0 && (cChar[0] != 0x0d && cChar[0] != 0x0a) );

					strLineBuf[nIdx] = 0x00;
					if( !strlen(strLineBuf) )
						continue;
					if( !_RemoveFile(strLineBuf) )
						bDeleteAll = FALSE;
				}

				if( !bDeleteAll )
					SetTimer( hWnd, APPDELAY_TIMER, 3000, NULL );
				else
					PostMessage( hWnd, WM_CLOSE, 0, 0 );
			}
			else
				return DefWindowProc( hWnd, message, wParam, lParam );
		} break;

		////////////////////////////
		// WM_TIMER
		case WM_TIMER: {
			if( wParam == APPDELAY_TIMER )
			{
				if( nLoop++ < MAX_LOOP )
				{
					KillTimer( hWnd, APPDELAY_TIMER );
					PostMessage( hWnd, WM_COMMAND, ID_START, 0 );
				}
				else PostMessage( hWnd, WM_CLOSE, 0, 0 );
			}
		} break;

		////////////////////////////
		// WM_DESTROY
		case WM_DESTROY: {
			PostQuitMessage(0);
		} break;

		////////////////////////////
		// default
		default: {
			return DefWindowProc( hWnd, message, wParam, lParam );
		} break;
	}
	return 0;
}
