/*************************************************************************
 *
 *  $RCSfile: filearc2.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FILEARC2_HXX
#define _FILEARC2_HXX


#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#include "svarray.hxx"

class FileEntry
{
private:
	String	aURL;
	ULONG 	nFilePos;
	ULONG 	nFileLen;
	USHORT	nOptions;	// Falls spaeter mal gepackte Dateien.

public:
		FileEntry( const String& rURL, ULONG nPos, ULONG nLen, USHORT nOps );
		~FileEntry();

	ULONG			GetFilePos() const 				{ return nFilePos; }
	ULONG			GetFileLen() const 				{ return nFileLen; }
	USHORT			GetOptions() const 				{ return nOptions; }

	const String& 	GetURL() const 					{ return aURL; }
	void			SetURL( const String& rURL ) 	{ aURL = rURL; }
};

SV_DECL_PTRARR_DEL( FileEntries, FileEntry*, 0, 128 )

class SortedFileEntries : private FileEntries
{
protected:
	BOOL			SeekEntry( const String& rURL, USHORT* pnPos );

public:
	FileEntry*		FindEntry( const String& rURL );
	BOOL			InsertEntry( const FileEntry* pEntry );
	void			RemoveEntry( const FileEntry* pEntry );

	USHORT			Count() const { return FileEntries::Count(); }
	void			Reset() { DeleteAndDestroy( 0, Count() ); }
	FileEntry*		GetEntry( USHORT nPos ) const { return FileEntries::GetObject( nPos ); }
};

#endif // _FILEARC2_HXX

