/*************************************************************************
 *
 *  $RCSfile: SwUndoTempAutoCorr.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2002/11/21 14:42:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// #102505# (whole file)

#ifndef _SWUNDOTEMPAUTOCORR_HXX
#define _SWUNDOTEMPAUTOCORR_HXX

#include <tempauto.hxx>
#include <undobj.hxx>

/**
   Undo for inserting an entry into a list of temporal
   autocorrections.

 */
class SwUndoTempAutoCorr : public SwUndo
{
    /** 
        Word corrected by the correction.
    */
    String aWrong;

    /** 
        Corrected Word inserted by the correction.
    */
    String aCorrect;
    
    /**
       List receiving the correction.
     */
    SwTempAuto & aList;

    /**
       Inserts the correction defined by @a aWrong and @a aCorrect into
       @a aList and set @a bInsertSucceeded accordingly.
    */
    void _InsertCorrection();

public:
    /**
       Constructor
       
       @param _aList list to insert correction into
       @param _aWrong the word to be corrected
       @param _aCorrect the correct word
    */
    SwUndoTempAutoCorr(USHORT nL, SwTempAuto & _aList,
                       const String & _aWrong, const String & _aCorrect);

    /**
       Destructor
    */
    virtual ~SwUndoTempAutoCorr();

    /**
       Undos the insertion of @a aCorr, i.e. removes @a aCorr from
       @a aList.
    */
    virtual void Undo(SwUndoIter & aIter);

    /**
       Redos the insertion of @a aCorr into @a aList.
    */
    virtual void Redo(SwUndoIter & aIter);
};

#endif // _SWUNDOTEMPAUTOCORR_HXX
