/*************************************************************************
 *
 *  $RCSfile: longname.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#include <svpm.h>

#include <stdlib.h>
#include <string.h>
#include "longname.hxx"


/*********************
 *
 * Data structures
 *
 *********************
 */


static const char cBackSlash = '\\';

typedef struct {
    PM_USHORT type;
    PM_USHORT nLen;
    CHAR      value[CCHMAXPATHCOMP];
} EALONGNAME, *PEALONGNAME;

typedef struct {
    UCHAR    nLen;
    CHAR     value[CCHMAXPATHCOMP];
} FILENAME, *PFILENAME;

// for OS/2 temporary changes any GEA2LIST structure, no static structure can be used:
// this would not be thread-save. so save some work from being done in every call.
static const char   szLongNameEA[] = ".LONGNAME";

// the size of the buffer to copy szLongNameEA to
static const size_t nLongNameEA    = sizeof( szLongNameEA ) - 1;

// the  size of the complete structure, alligned to dword boundary
static const size_t nGEA2List      = ( sizeof( GEA2LIST ) + nLongNameEA + 3 ) & ~3;

// when allocating memory, get a hole page. this is as fast as getting a smaller buffer, but
// you don't have to think about the size every time.
//static const size_t nPageSize      = 4096;
static const size_t nPageSize      = 4000;


/*********************
 *
 * helper functions
 *
 *********************
 */

inline PEAOP2 setEABuffer( const char * pszLongName, size_t n )
{
    PFEA2LIST pFEAList;
    PEAOP2    pEAOP;
    
    // allocate Buffer
    pEAOP = (PEAOP2) new PM_BYTE [nPageSize];
    if( !pEAOP ) return NULL;

    // this structure can directly follow the EAOP2
    pFEAList = (PFEA2LIST) &pEAOP[1];

    // setup EAOP2 structure
    pEAOP->oError = 0L;
    pEAOP->fpGEA2List = NULL;
    pEAOP->fpFEA2List = pFEAList;

    // set buffer size of FEA2List
    pFEAList->cbList = sizeof( FEA2LIST );

    pFEAList->list[0].oNextEntryOffset = 0L;  // no more entries;
    pFEAList->list[0].cbName = nLongNameEA;
    strcpy( pFEAList->list[0].szName, szLongNameEA );

    if( pszLongName )
    {
        // correct buffer sizes
        pFEAList->cbList += sizeof( EALONGNAME );
        pFEAList->list[0].cbValue = sizeof( EALONGNAME );
        
        PEALONGNAME pLongNameEA = (PEALONGNAME)
            ((PBYTE) &pFEAList->list[1] + pFEAList->list[0].cbName);
        
        pLongNameEA->type  = EAT_ASCII;
        pLongNameEA->nLen  = n;
        strcpy( pLongNameEA->value, pszLongName );
    }
    else
        pFEAList->list[0].cbValue = 0;

    return pEAOP;
}


/*
 * getEABuffer - allocate buffer ans set up data for getting .LONGNAME EAs
 */

inline PEAOP2 getEABuffer( PULONG pulBufSize )
{
    PGEA2LIST pGEAList;
    PFEA2LIST pFEAList;
    PEAOP2    pEAOP;

    // first check if enough space for complete operation
    static size_t nMinSize = nGEA2List + sizeof( EAOP2 );

    // allocate Buffer
    pEAOP = (PEAOP2) new PM_BYTE [nPageSize];
    if( !pEAOP ) return NULL;

    // to make it possible to delete the data from outside,
    // put this structure at the end of the of the buffer
    pGEAList = (PGEA2LIST) ( (PBYTE) pEAOP + nPageSize - nGEA2List );

    // this structure can directly follow the EAOP2
    pFEAList = (PFEA2LIST) &pEAOP[1];

    // copy GEA2LIST to the beginning of the buffer
    pGEAList->cbList = nGEA2List;

    pGEAList->list[0].oNextEntryOffset = 0L;  // no more entries;
    pGEAList->list[0].cbName = nLongNameEA;
    strcpy( pGEAList->list[0].szName, szLongNameEA );

    // setup EAOP2 structure
    pEAOP->oError = 0L;
    pEAOP->fpGEA2List = pGEAList;
    pEAOP->fpFEA2List = pFEAList;

    // set buffer size of FEA2List
    pFEAList->cbList = nPageSize - nMinSize;

    if( pulBufSize )
        *pulBufSize = pFEAList->cbList;

    return pEAOP;
}


/*
 * longNameEA - get long name from buffer
 */

inline const char * longNameEA( PFEA2LIST pFEAList, char * pszFileName )
{
    PFEA2       pFEA        = &pFEAList->list[0];
    PEALONGNAME pLongNameEA = (PEALONGNAME) ((PBYTE) &pFEAList->list[1] + pFEA->cbName);

    if( pszFileName )
    {
        PFILENAME pFileName = (PFILENAME) ((PBYTE) pFEAList + pFEAList->cbList);

        strncpy( pszFileName, pFileName->value, pFileName->nLen );
        pszFileName[pFileName->nLen] = '\0';
    }
        
    if( pFEA->cbValue != 0 && pLongNameEA->type == EAT_ASCII )
    {
        pLongNameEA->value[pLongNameEA->nLen] = '\0';
        return pLongNameEA->value;
    }

    return NULL;
}
    

/*********************************
 *
 * isValidFileName()
 *
 */

BOOL isValidFileName( const String& aFileName )
{

    /*
     * filenames that contain blanks and are shorter than 8.3 characters
     * should be invalid, but are valid for compatibility with direntries.
     */
#if 0
    // check if filename contains blanks
    if( aFileName.Search( ' ' ) != STRING_NOTFOUND )
        return FALSE;
#endif

    // find extension
    USHORT nPos = aFileName.Search( '.' );
    USHORT nLen = aFileName.Len();
    
    // no extension ?
    if( nPos++ == STRING_NOTFOUND )
        return nLen <= 8;

    return nPos <= 9 && (nLen - nPos <= 3);
}


/*********************************
 *
 * getValidFileName()
 *
 */        

BOOL getValidFileName( const PCSZ pszPath, const String& aLongName,
                       String& aValidName, const PCSZ pszShortName )
{
    String aTmpName(aLongName);

    /*
     * filenames with spaces are valid for OS/2 but not for DOS,
     * so replace them as the WPS does.
     */
    
    // replace all spaces with '_'
    USHORT nPos = 0;
    while(nPos = aTmpName.SearchAndReplace(' ', '_', nPos) != STRING_NOTFOUND)
        ;

    // replace all slashes with '!'
    nPos = 0;
    while(nPos = aTmpName.SearchAndReplace('/', '!', nPos) != STRING_NOTFOUND)
        ;

    // find extension
    String aShortName;
    nPos = aTmpName.Search( '.' );

    // create a short (8.3) name
    if( nPos != STRING_NOTFOUND )
    {
        aShortName = aTmpName.Copy( 0, nPos > 8 ? 8 : nPos );
        aShortName += aTmpName.Copy( nPos, 4 );
        
        if( nPos > 8 )
            nPos = 8;
    }
    else
    {
        aShortName = aTmpName.Copy( 0, 8 );
        nPos = 8;
    }

    // nPos now is the last character before '.'
    nPos--;

    // find out if file exists
    UCHAR n = 1;
    while( TRUE )
    {
        FILESTATUS3	 fsStatus;
        String       aTmpPath;
        APIRET rc;

        // setup new path
        aTmpPath = pszPath;
        if( aTmpPath.GetChar( aTmpPath.Len() - 1 ) != '\\' )
            aTmpPath += '\\';
        aTmpPath += aShortName;

        rc = DosQueryPathInfo( aTmpPath, FIL_STANDARD, &fsStatus, sizeof( fsStatus ));

        // file does not exist
        if( rc == ERROR_FILE_NOT_FOUND )
        {
            aValidName = aShortName;
            return TRUE;
        }
        
        // break on any other error
        if( rc ) return FALSE;

        // check if old filename can be used again
        if( pszShortName && aShortName.ICompare( pszShortName ) == COMPARE_EQUAL )
        {
            aValidName = aShortName;
            return TRUE;
        }

        // do not handle more than 100 files.
        if( n == 100 )
            return FALSE;

        if( n == 1 )
        {
            if( nPos < 7 )
                aShortName.Insert( '1', ++nPos );
            else
                aShortName[nPos] = '1';

            n++;
            continue;
        }

        if( n == 10 )
        {
            if( nPos < 7 )
                aShortName.Insert( '1', nPos++ );
            else
                aShortName[nPos - 1] = '1';
            
            aShortName[nPos]     = '0';

            n++;
            continue;
        }

        String aNo( (ULONG) n );
        if( n++ > 10 )
            aShortName.Replace( nPos - 1, 2, aNo );
        else
            aShortName.Replace( nPos, 1, aNo );
    }
}


/*******************************************************************
 *
 * isLongNameFS - check FS driver for long filename support
 *
 *******************************************************************
 */

BOOL isLongNameFS( const PCSZ pszPath )
{
    char szDrive[] = "a:";

    if( (pszPath[0] == cBackSlash) && (pszPath[1] == cBackSlash) )
        return TRUE;

    // this is a relative path - handle as longname FS
    if( pszPath[1] != szDrive[1] )
        return TRUE;

    // do not test drives only
    if(pszPath[2] == '\0')
        return TRUE;
    
    szDrive[0] = pszPath[0];

    BYTE       	fsqBuffer[ sizeof(FSQBUFFER2) + 3 * CCHMAXPATHCOMP ];
    PFSQBUFFER2 pFSQBuffer = (PFSQBUFFER2) &fsqBuffer;
    ULONG	n = sizeof( fsqBuffer );

    if(DosQueryFSAttach( szDrive, 0, FSAIL_QUERYNAME, pFSQBuffer, &n ))
        return FALSE; // this should be an exception

    PSZ cp = (PSZ) pFSQBuffer->szName + pFSQBuffer->cbName + 1;
    return strcmp( cp, "FAT" ) != 0;
}


/*******************************************************************
 *
 * getValidPath - search for relating short filenames
 *
 *******************************************************************
 */

BOOL getValidPath( const PCSZ pszLongPath, PSZ pszPath, size_t n,
                   const PCSZ pszShortName )
{
    char szLongNamesBuffer  [CCHMAXPATHCOMP];

    // copy long path for strtok destroys it
    strcpy( szLongNamesBuffer, pszLongPath );

    // copy first token to short names buffer
    char *tok = strtok( szLongNamesBuffer, "\\" );
    strcpy( pszPath, tok );

    // find the end of first token 
    char *cp = pszPath + strlen( pszPath );

    // if more tokens, search short names
    tok = strtok( NULL, "\\" );
    
    PEAOP2 pEAOP = NULL;
    ULONG  nBufSize;
    if( tok )
    {
        pEAOP = getEABuffer( &nBufSize );
        if( !pEAOP ) return FALSE;
    }
        
    while( tok )
    {
        USHORT nLen, nPos = 0;
        char * tok2;

        // append seperator
        strcpy( cp++, "\\" );

        // check if filename to long
        nLen = strlen(tok);
        if( tok2 = strrchr( tok, '.' ))
            nPos = tok2 - tok + 1;
        
        if( ( nPos == 0 && nLen <= 8 ) || ( nPos <= 9 && nLen - nPos <= 3 ) )
        {
            // filename is short, copy it
            strcpy( cp, tok );
            cp += strlen(tok);

            // get next token and continue
            tok = strtok( NULL, "\\" );
            continue;
        }

        // can one part of the long name be used as a filter ?
        if( nPos > 0 && nPos <= 9 )
        {
            // short names can be ended by numbers, so use only 6 chars of file name
            if( nPos > 7 ) nPos = 7;
            strncpy( cp, tok, nPos-- );
            cp[nPos] = '\0';
            strcat( cp, "*.*" );
        }
        else if( nPos > 0 && nLen - nPos <= 3 )
        {
            strcpy( cp, "*" );
            strcat( cp, tok + nPos );
        }
        else
        {
            strcpy( cp, "*.*" );
        }

        // search for any kind of file
        ULONG ulFindFlags = 0x00000037;
        
        // if it is not the last token, it must be a folder
        tok2 = strtok( NULL, "\\" );
        
        if( tok2 )
        {
            // exclude non directories
            ulFindFlags |= MUST_HAVE_DIRECTORY;
        }

        HDIR	hDir = HDIR_CREATE;
        ULONG	ulCount = 1;
        APIRET  rc;


        // iterate over all matching files
        for ( rc = DosFindFirst( pszPath, &hDir, ulFindFlags,
                                 pEAOP, nBufSize,
                                 &ulCount, FIL_QUERYEASFROMLIST );
              rc == NO_ERROR;
              rc = DosFindNext( hDir, pEAOP, nBufSize, &ulCount )
            )
        {
            PFEA2LIST pFEAList = (PFEA2LIST)
                ((PBYTE) &((PFILEFINDBUF3) &pEAOP[1])->attrFile + sizeof(ULONG));

            const char * pszLongName = longNameEA( pFEAList, cp );
            if( pszLongName && strcmpi( tok, pszLongName ) == 0 )
            {
                cp += strlen( cp );
                break;
            }
        }

        if( rc )
        {
            if( pEAOP )
                delete [] pEAOP;

            String aShortName; *cp = '\0';
            // return a valid short file name
            if( getValidFileName( pszPath, String( tok ), aShortName, pszShortName ))
                strcpy( cp, aShortName );
            else
                strcpy( cp , "" );
            
            return FALSE;
        }

        tok = tok2;
    }

    if( pEAOP )
        delete [] pEAOP;

    return TRUE;
}


/******************************************************************************************
 *
 * handle .LONGNAME extended attributes
 *
 ******************************************************************************************
 */

BOOL createLongNameEA( const PCSZ pszPath, ULONG ulAttributes, const String& aLongName )
{
    APIRET rc;

    // allocate buffer and setup data
    PEAOP2 pEAOP = setEABuffer( aLongName, aLongName.Len() );
    if( !pEAOP ) return FALSE;

    // destinguish between files and directories here
    if( ulAttributes & FILE_DIRECTORY )
    {
        rc = DosSetPathInfo( pszPath, FIL_QUERYEASIZE, (PVOID) pEAOP,
                               sizeof( EAOP2 ), DSPI_WRTTHRU );
    }
    else
    {
        HFILE		 hfFileHandle = 0L;
        ULONG		 ulAction = 0L;
        
        rc = DosOpen( pszPath, &hfFileHandle, &ulAction, 0L, ulAttributes,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE,
                      NULL );

        if( rc != NO_ERROR )
            goto cleanup;

        rc = DosSetFileInfo( hfFileHandle, FIL_QUERYEASIZE,(PVOID) pEAOP,
                               sizeof( EAOP2 ));

        DosClose( hfFileHandle );
    }

cleanup:
    delete [] pEAOP;
    return rc == NO_ERROR;
}


/*
 *  queryLongNameEA()
 */

BOOL queryLongNameEA( const PCSZ pszPath, ULONG ulAttributes, String& aLongName )
{
    APIRET rc;
    USHORT nIndex;

    // setup EA Buffer
    PEAOP2 pEAOP = getEABuffer( NULL );
    if( !pEAOP ) return FALSE;

    // must destinguish between directories and files here
    if( ulAttributes & FILE_DIRECTORY )
    {
        rc = DosQueryPathInfo( pszPath, FIL_QUERYEASFROMLIST,
                               (PVOID) pEAOP, sizeof( EAOP2 ));
    }
    else
    {
        HFILE		 hfFileHandle = 0L;
        ULONG		 ulAction = 0L;
        
        rc = DosOpen( pszPath, &hfFileHandle, &ulAction, 0L, ulAttributes,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
                      NULL );

        if( rc != NO_ERROR )
            goto cleanup;

        rc = DosQueryFileInfo( hfFileHandle, FIL_QUERYEASFROMLIST,
                               (PVOID) pEAOP, sizeof( EAOP2 ));

        DosClose( hfFileHandle );
    }

    if( rc == NO_ERROR )
    {
        aLongName = longNameEA( pEAOP->fpFEA2List, NULL );
        
        if( aLongName.Len() == 0 )
            rc = ~rc;
    }

cleanup:
    delete [] pEAOP;
    return rc == NO_ERROR;
}


/*
 * removeLongNameEA()
 */

BOOL removeLongNameEA( const PCSZ pszPath, ULONG ulAttributes )
{
    APIRET rc;

    // allocate buffer and setup data
    PEAOP2  pEAOP = setEABuffer( NULL, 0 );
    if( !pEAOP ) return FALSE;

    // destinguish between files and directories here
    if( ulAttributes & FILE_DIRECTORY )
    {
        rc = DosSetPathInfo( pszPath, FIL_QUERYEASIZE, (PVOID) pEAOP,
                               sizeof( EAOP2 ), DSPI_WRTTHRU );
    }
    else
    {
        HFILE		 hfFileHandle = 0L;
        ULONG		 ulAction = 0L;
        
        rc = DosOpen( pszPath, &hfFileHandle, &ulAction, 0L, ulAttributes,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE,
                      NULL );

        if( rc != NO_ERROR )
            goto cleanup;

        rc = DosSetFileInfo( hfFileHandle, FIL_QUERYEASIZE,(PVOID) pEAOP,
                               sizeof( EAOP2 ));

        DosClose( hfFileHandle );
    }
    
cleanup:
    delete [] pEAOP;
    return rc == NO_ERROR;
}


                         


