/*************************************************************************
 *
 *  $RCSfile: rapofflinecommandinfo.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDINFO_HXX
#include "rapofflinecommandinfo.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDMAP_HXX
#include "rapofflinecommandmap.hxx"
#endif

#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif

using namespace com::sun;
using ucprmt::offline::CommandInfo;
using ucprmt::offline::CommandMap;

CommandInfo::CommandInfo(rtl::Reference< CommandMap > const & rCommandMap):
    m_xCommandMap(rCommandMap)
{
    OSL_ASSERT(m_xCommandMap.is());
}

CommandInfo::~CommandInfo()
{}

star::uno::Sequence< star::ucb::CommandInfo > SAL_CALL
CommandInfo::getCommands()
    throw (star::uno::RuntimeException)
{
    star::uno::Sequence< star::ucb::CommandInfo >
        aCommands(m_xCommandMap->size());
    sal_Int32 i = 0;
    for (CommandMap::iterator aIt(m_xCommandMap->begin());
         aIt != m_xCommandMap->end(); ++aIt)
    {
        aCommands[i].Name = aIt->first;
        aCommands[i].Handle = -1;
        aCommands[i].ArgType = aIt->second.m_aArgType;
    }
    return aCommands;
}

star::ucb::CommandInfo SAL_CALL
CommandInfo::getCommandInfoByName(rtl::OUString const & rName)
    throw (star::ucb::UnsupportedCommandException,
           star::uno::RuntimeException)
{
    CommandMap::iterator aIt(m_xCommandMap->find(rName));
    if (aIt == m_xCommandMap->end())
        throw
            star::ucb::UnsupportedCommandException(
                rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                       "ucprmt::offline::CommandInfo::getCommandInfoByName "))
                    + rName,
                *this);
    return star::ucb::CommandInfo(rName, -1, aIt->second.m_aArgType);
}

star::ucb::CommandInfo SAL_CALL CommandInfo::getCommandInfoByHandle(sal_Int32)
    throw (star::ucb::UnsupportedCommandException,
           star::uno::RuntimeException)
{
    throw star::ucb::UnsupportedCommandException(
              rtl::OUString(
                  RTL_CONSTASCII_USTRINGPARAM(
                      "ucprmt::offline::CommandInfo::getCommandInfoByHandle:"
                          " no handles supported ")),
              *this);
}

sal_Bool SAL_CALL CommandInfo::hasCommandByName(rtl::OUString const & rName)
    throw (star::uno::RuntimeException)
{
    return m_xCommandMap->find(rName) != m_xCommandMap->end();
}

sal_Bool SAL_CALL CommandInfo::hasCommandByHandle(sal_Int32 nHandle)
    throw (star::uno::RuntimeException)
{
    return false;
}
