/*************************************************************************
 *
 *  $RCSfile: longcurr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mt $ $Date: 2001/06/29 10:17:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LONGCURR_HXX
#define _LONGCURR_HXX

#ifndef _BIGINT_HXX
#include <tools/bigint.hxx>
#endif
#ifndef _FIELD_HXX
#include <field.hxx>
#endif

class LocaleDataWrapper;

// -------------------------
// - LongCurrencyFormatter -
// -------------------------

class LongCurrencyFormatter : public FormatterBase
{
#if _SOLAR__PRIVATE
#ifdef VCL_LONGCURR_CXX
	friend BOOL ImplLongCurrencyReformat( const XubString&, BigInt, BigInt, USHORT, const LocaleDataWrapper&, XubString&, LongCurrencyFormatter& );
	void					ImpInit();
#endif
#endif

protected:
	BigInt					mnFieldValue;
	BigInt					mnLastValue;
	BigInt					mnMin;
	BigInt					mnMax;
	BigInt					mnCorrectedValue;
    String                  maCurrencySymbol;
	USHORT					mnType;
	USHORT                  mnDecimalDigits;
    BOOL                    mbThousandSep;

    ULONG                   mnDummy;
    BOOL                    mbDummy;

							LongCurrencyFormatter();
	void					ImplLoadRes( const ResId& rResId );

public:
							~LongCurrencyFormatter();

	virtual void			Reformat();
	virtual void			ReformatAll();

    void                    SetUseThousandSep( BOOL b );
    BOOL                    IsUseThousandSep() const { return mbThousandSep; }

    void                    SetCurrencySymbol( const String& rStr );
    String                  GetCurrencySymbol() const;

    void					SetMin( BigInt nNewMin );
	BigInt					GetMin() const { return mnMin; }
	void					SetMax( BigInt nNewMax );
	BigInt					GetMax() const { return mnMax; }

	void					SetDecimalDigits( USHORT nDigits );
	USHORT					GetDecimalDigits() const;
	void					SetValue( BigInt nNewValue );
	void					SetUserValue( BigInt nNewValue );
	BigInt					GetValue() const;
	BOOL					IsValueModified() const;

	void					SetEmptyValue();
	BOOL					IsEmptyValue() const { return !GetField()->GetText().Len(); }

	BigInt					GetCorrectedValue() const { return mnCorrectedValue; }

	BigInt					Normalize( BigInt nValue ) const;
	BigInt					Denormalize( BigInt nValue ) const;
};

// ---------------------
// - LongCurrencyField -
// ---------------------

class LongCurrencyField : public SpinField, public LongCurrencyFormatter
{
#if _SOLAR__PRIVATE
#ifdef VCL_LONGCURR_CXX
	friend void ImplNewLongCurrencyFieldValue( LongCurrencyField*, BigInt );
#endif
#endif

private:
	BigInt			mnSpinSize;
	BigInt			mnFirst;
	BigInt			mnLast;

protected:
	void			ImplLoadRes( const ResId& rResId );

public:
					LongCurrencyField( Window* pParent, WinBits nWinStyle );
					LongCurrencyField( Window* pParent, const ResId& rResId );
					~LongCurrencyField();

	long			PreNotify( NotifyEvent& rNEvt );
	long			Notify( NotifyEvent& rNEvt );

	void			Modify();
	void			Up();
	void			Down();
	void			First();
	void			Last();

	void			SetFirst( BigInt nNewFirst ) { mnFirst = nNewFirst; }
	BigInt			GetFirst() const { return mnFirst; }
	void			SetLast( BigInt nNewLast ) { mnLast = nNewLast; }
	BigInt			GetLast() const { return mnLast; }
	void			SetSpinSize( BigInt nNewSize ) { mnSpinSize = nNewSize; }
	BigInt			GetSpinSize() const { return mnSpinSize; }
};


// -------------------
// - LongCurrencyBox -
// -------------------

class LongCurrencyBox : public ComboBox, public LongCurrencyFormatter
{
public:
					LongCurrencyBox( Window* pParent, WinBits nWinStyle );
					LongCurrencyBox( Window* pParent, const ResId& rResId );
					~LongCurrencyBox();

	long			PreNotify( NotifyEvent& rNEvt );
	long			Notify( NotifyEvent& rNEvt );

	void			Modify();
	void			ReformatAll();

	void			InsertValue( BigInt nValue,
								 USHORT nPos = COMBOBOX_APPEND );
	void			RemoveValue( BigInt nValue );
	BigInt			GetValue() const
						{ return LongCurrencyFormatter::GetValue(); }
	BigInt			GetValue( USHORT nPos ) const;
	USHORT			GetValuePos( BigInt nValue ) const;
};


#endif // _LONGCURR_HXX
