/*************************************************************************
 *
 *  $RCSfile: javainfoimpl.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 09:41:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if !defined INCLUDED_JVMACCESS_JAVAINFOIMPL_HXX
#define INCLUDED_JVMACCESS_JAVAINFOIMPL_HXX

#include "sunversion.hxx"

#include "jvmaccess/javainfo.hxx"

#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.hxx"

#include <vector>


/**
   Currently only only the information of accessibility support is
   retrieved after initialization.
*/
class jvmaccess::JavaInfo::Impl
{
public:
    enum JavaType
    {
        UNKNOWN_TYPE = 0,
        JRE_TYPE,
        SDK_TYPE
    };

    /* for std::find_if
       Used to find a JavaInfo::Impl object in a std::vector<Impl*> which has a member usJavaHome
       as the specified string in the constructor.
     */
    struct InfoFindSame
    {
        rtl::OUString usJava;
        InfoFindSame(const rtl::OUString& usJavaHome):usJava(usJavaHome){}

        bool operator () (const Impl* info)
            {
                return info->usJavaHome.equals(usJava) == sal_True ? true : false;
            }
    };



    /*
       Creates object based on the values obtained from the windows registry.
       @exception JavaInfoInitException
    */
    Impl(const jvmaccess::impl::SunVersion& version, const rtl::OUString& usJavaHome, JavaType nType);
    /* Creates an object based on a given Java installation. 
       @exception jvmaccess::JavaInfo::InitException
     */
    Impl(const rtl::OUString& usJavaHome);
    /* Creates an object based on values obtained with getPathsAndTypeFromBin and
       getPathsAndTypeFromLib which are used to extract data from the PATH and
       LD_LIBRARY_PATH environment variable.It executes "java -version"
       to obtain the version.
    */
    Impl(const rtl::OUString& usJavaHome, const rtl::OUString& usRuntimeLib, JavaType type);
    ~Impl();

    /* Creates Impl objects for all found Javas which correspond to the requirements.
       If bIgnoreRequirements is true then it is searched for all Javas otherwise the first
       Java that meets the requirements will be returned.
     */
    static void createImpl(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements, bool bIgnoreRequirements);

    const rtl::OUString& getVersion();

    /** Accessibility is late initialized because it can be costly.
        May throw JavaInfo::UnsupportedException when the JavaInstallation
        does not provide this information.
    */
    bool supportsAccessibility();
    // url to runtime library
    rtl::OUString usRuntimeLib;
    // URL to the java directory
    rtl::OUString usJavaHome;
    rtl::OUString usLibLocations;

    bool isComplete();
    JavaType type;
    rtl::OUString usType;

    jvmaccess::impl::SunVersion version;

    /** true if type, version, accessibility etc. could be determined.
     */
    mutable bool bComplete;

    static bool getPathsAndTypeFromBin(const rtl::OUString& usBinDir, rtl::OUString& usJavaHome, rtl::OUString& usRuntime, JavaType *pType);
    static bool getPathsAndTypeFromLib(const rtl::OUString& usBinDir, rtl::OUString& usJavaHome, rtl::OUString& usRuntime, JavaType *pType);
protected:
    static void init();
    /* requires usJavaHome */
    bool initType();
    /* requires usJavaHome, type */
    bool initRuntimeLib();
    /* requires usRuntimeLib */
    bool initLibDirs();
    /* requires usJavaHome, type
       May throw JavaInfo::UnsupportedException, if the Java installation does
       not provide this information*/
    bool initAccessibility();
    /* requires usJavaHome, type */
    bool initVersion();

#if defined WNT
    /* The function creates Impl objects based on information from the registry. If bIgnoreRequirements
      is true then all found Javas are evaluated, otherwise only the first  Java that meets the requirements (
      usVersion and requirements) will be used. vecImpl then contains only one elements. If bIgnoreRequirements is
      true then Javas found which do not meet the requirments are remembered by putting their installation
      directory into the std::vector badJava.
      @param vecImpl
             [inout] The function puts all created Impl objects in this std::vector.
      @param usVersion
             [in] A version string.
      @param requirments
             [in] flags indicating certain requirements
      @param bIgnoreRequirements
             [in] true requirements are ignored. It is searched for all Javas. false - it is searched for one
             Java that exactly meets the requirements.
      @param bRequirementsMet
             [out] true vecImpl contains one element that meets the requirements, false otherwise.
      @param badJava
             [inout] If bIgnoreRequirements is false then the function put Java installation dirs
             into the std::vector which do not meet the requirements
     */
    static void createImplFromWinReg(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<rtl::OUString>& badJava);
#endif // WNT

    static void createImplFromJavaHome(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<rtl::OUString>& badJava);
    static void createImplFromPath(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<rtl::OUString>& badJava);

#if defined UNX
    /* Looks for Java in the directory where the executable is */
    static void createImplFromBinDir(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<rtl::OUString>& badJava);

    /* This function tries to find a runtime lib based on a few default directories
       and Java names.
    */
    static void createImplDirScan(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<rtl::OUString>& badJava);

    /* This function tries to find a runtime lib based on a few default directories
       and Java names. It starts searching in the home directory of the user
    */
    static void createImplDirScanHome(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<rtl::OUString>& badJava);

    /* looks for a directory that contains a libjvm.so */
    static void createImplFromLibPath(std::vector<Impl*>& vecImpl, const rtl::OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<rtl::OUString>& badJava);
#endif // UNX

    /* Returns the directory where the file is located.
       @param usFilePath file URL
    */
    inline static rtl::OUString getDirFromFile(const rtl::OUString& usFilePath);
    /* If the given requirements are met by pImpl then the function returns true.
     */
    static bool checkRequirements(Impl *pImpl, const rtl::OUString& usVersion, int requirements);
    /* Checks if the Java whose install dir is given in usJavaHome (file URL) was already evaluated.
       If so then there is an according Impl object in vecImpl. If bIgnoreRequirements is false, then
       it is checked it usJavaHome is contained in vecBadJava.
     */
    static bool isAlreadyEvaluated(const rtl::OUString& usJavaHome, const std::vector<Impl*>& vecImpl,
                                   bool bIgnoreRequirements, const std::vector<rtl::OUString>& vecBadJava);
    // contains the strings used to looking for runtime lib
    // they are relativ to the java installation directory, e.g
    // \jre\bin\client\jvm.dll
    static com::sun::star::uno::Sequence<rtl::OUString> seqJRESearchPaths;
    static com::sun::star::uno::Sequence<rtl::OUString> seqSDKSearchPaths;
    /* Platform depend delimiter. Either '\' or '//'
     */
    static rtl::OUString usPathDelim;
    /* Platform depend separator. Either ';' or ':'
     */
    static rtl::OUString usPathSep;

    /* '.!
     */
    static rtl::OUString usCurDir;
    /* '..'
     */
    static rtl::OUString usParentDir;
    /* "/jre"
     */
    static rtl::OUString usJreDir;

#if defined UNX
    static com::sun::star::uno::Sequence<rtl::OUString> JavaInfo::Impl::seqJavaDirNames;
    static com::sun::star::uno::Sequence<rtl::OUString> JavaInfo::Impl::seqDefSearchPath;
    static com::sun::star::uno::Sequence<rtl::OUString> JavaInfo::Impl::seqJavaCollectDir;
#endif // UNX

    enum {access_not_init=0, access_no, access_ok} accessibility;

};

#endif // INCLUDED_JVMACCESS_JAVAINFOIMPL_HXX
