/*************************************************************************
 *
 *  $RCSfile: sbaobj.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 15:31:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SBA_SBAOBJ_HXX
#define _SBA_SBAOBJ_HXX

#ifndef _SBA_SBADLL_HXX
#include "sbadll.hxx"       // fuer SbaModuleDummy
#endif

#ifndef _SBA_SBAENUM_HXX
#include "sbaenum.hxx"
#endif

#ifndef _SBA_DBDEFOBJ_HXX
#include "dbdefobj.hxx"
#endif

#ifndef _SBA_DBOBJENU_HXX
#include "dbobjenu.hxx"
#endif

#ifndef _SBA_SBADB_HXX
#include "sbadb.hxx"
#endif

#ifndef _SFXBRDCST_HXX //autogen
#include <svtools/brdcst.hxx>
#endif

#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

#ifndef _SVX_DBEXCH_HRC
#include <svx/dbexch.hrc>
#endif

class SdbStatus;
class SbaAddrPI;
class SbaSelectionList;
class SdbConnection;
class SbaDatabase;
class SdbWorkspace;
class SdbEnvironment;
struct SdbLoginInformation;
class SdbEnvironmentRef;
class ResMgr;
class Window;
class SbaDBDef;
class SfxExplorerContent;
class ToolBox;
class SbaDBDefHint;
class SbaDBHint;
class SdbDatabase;

//==================================================================
// SbaObject
//==================================================================
class SbaObject: public SbaModuleDummy
{
private:
	friend class SbaResId;				// Zugriff auf Resourcen
	friend class SbaObjectExt;
	friend class SbaAddrPI;				// Adressbuch
	friend class SbaDLL;
	friend class OEnvironment;

	SbaAddrPI*			pSbaAddrPI;
	SbaObjectExt*		pObjExt;		// Erweiterung fuer Zugriff innerhalb der ofadll

	SdbEnvironmentRef*	pSDBEnv;		// Umgebung von SDB

	sal_uInt32			nDBActionCount,
						nWaitCount;		// counter fuer die Sanduhr

	Timer				aWaitTimer;		// verzoegertes Anzeigen der Sanduhr

#if _SOLAR__PRIVATE
	sal_Bool			UpdateAddrBook( const String& rConnArgs );
	void 				ReleaseAddrPI() { pSbaAddrPI = NULL; }
	sal_Bool			SearchAddrBookField( const String& rSearchStr,
										 SbaEmailField eField,
										 String& rFoundField,
										 String& rFound );

	DECL_LINK(PasswordHdl, String*);
	DECL_LINK(ExtendedPasswordHandler, SdbLoginInformation*);
	DECL_LINK(BusyHdl, SdbObj*);
	DECL_LINK(BeginHdl, SdbObj*);
	DECL_LINK(EndHdl, SdbObj*);
	DECL_LINK(WaitHdl, void*);
	DECL_LINK(CreateDBHdl, SdbWorkspace*);
#endif

protected:
	SbaDatabaseRef LoadDatabase(const String& _rName);

public:
	TYPEINFO();

    SbaObject( SfxObjectFactory* p1, SfxObjectFactory* p2, SfxObjectFactory* p3, SfxObjectFactory* p4, SfxObjectFactory* p5 );
	virtual	~SbaObject();

	virtual SfxModule* Load();

// Erzeugen und Oeffnen von sdb-Datenbanken
	// Erzeugen eines Datenbankobjekts
	virtual sal_Bool CreateDatabase(const String& rName, const String& rTitle, const String& rConnectStr, sal_Bool bShowError=sal_False);

	// Oeffnen eines Datenbankobjekts
	virtual SbaDatabase* GetDatabase(const String& rName, sal_Bool bShowError=sal_False);

	// auslesen des Verbindungsstrings
	virtual String GetDatabaseConnectStr(const String& rName, sal_Bool bShowError = sal_False);

	// Aendern einer Datenbankverbindung
	virtual sal_Bool AlterDatabase(const String& rName, const String& rConnectStr, sal_Bool bShowError = sal_False);
	virtual sal_Bool AlterDatabaseName(const String& rOldName, const String& rNewName, sal_Bool bShowError = sal_False);
	virtual sal_Bool AlterDatabaseTitle(const String& rName, const String& rTitle, sal_Bool bShowError = sal_False);

	// Loeschen einer Datenbank, Loescht nicht das Datenbankobjekt!
	virtual sal_Bool DropDatabase(const String& rName, sal_Bool bShowError = sal_False);

	// Liste aller Datenbanken, die als Link im Datenbankverzeichnis abgelegt werden
	virtual String GetDatabaseNames() const;

	// Gibt den Datenbanknamen zurueck
	virtual String GetDatabaseName(const String& rDBTitle) const;

	// Oeffnet eine Connection, diese wird nicht registriert
	virtual SdbConnection*	OpenConnection(const String& rConnArgs, sal_Bool bShowError=sal_False);

	//	Datenbankfehlermeldungen
	virtual void			ShowDbStatus(const SdbStatus& rStatus);

	// Datenbankpfad
	virtual String			GetDatabasePath() const;

// (Schnittstelle zum Addressbuch)
	// wird das Addressbuch nicht gefunden, dann kann be bCreateOnError ein neues Addressbuch erstellt werden
	virtual SbaDatabase*	OpenAddrDatabase(sal_Bool bCreateOnError = sal_True, sal_Bool bQueryOnCreation = sal_True);
	virtual void			SetAddressBookEntry(const String& rFileName, const String& rTableName);

	virtual String			GetAddrDBName() const;
	virtual String			GetAddrTableName() const;		// Tabellenname des Addressbuchs

	virtual sal_Bool			OpenAddrPI(sal_Bool bInsert = sal_True, sal_Bool bMerge = sal_True);
	virtual void			CloseAddrPI();
	sal_Bool					IsAddrPIOpen() const {return pSbaAddrPI != NULL;}

	virtual	void ShowDBObj(const String& rURL);

//	Object ueber Url oeffen
	virtual SbaDBDef*	OpenDBDef(const String& rURL);

	// Addressbuch Specials
	virtual void			AddrBookSelect( const String& rName,
											SbaSearchField eInField );
	virtual void			AddrBookNew( const String& rName,
										 SbaSearchField eInField );
	virtual sal_uInt16			SearchEMail( const String& rName,
										 String& rFoundThis,
										 SbaEmailField eMailType,
										 SbaSearchField& rInField );
	sal_Bool					SearchAddrBookURL( const String& rSearchString,
											   String& rFoundInField,
											   String& rURL );

// sonstiges
	// Quotierung von Identifiern fuer SQL-Statements
	virtual String			StringQuotation(const String& rString);

	// unterstuetzung fuer beim Casten von Notifications
	virtual SbaDBHint* DB_CAST(const SfxHint& rHint) const;
	virtual SbaDBDefHint* DBDEF_CAST(const SfxHint& rHint) const;
	virtual void NOTIFY_DBDEF(SbaDBDef* pDef, sal_uInt16 eAction) const;
		// aAction muss ein gecastetes SbaDBDefHint::SbaDBDefAction sein, ich will mir nur das includen der Defintion von SbaDBDefHint sparen
	virtual sal_Bool SplitTableName(const String& strFull, String& rCatalog, String& rSchema, String& rName, SdbDatabase* pLocation);

	virtual	SfxItemSet*			CreateItemSet( sal_uInt16 nId );
	virtual void				ApplyItemSet( sal_uInt16 nId, const SfxItemSet& rSet );
	virtual SfxTabPage*			CreateTabPage( sal_uInt16 nId, Window* pParent, const SfxItemSet& rSet );

	// Busyhandling
	const Link&	BusyHdl() const;
	const Link&	BeginHdl()const;
	const Link&	EndHdl() const;

	// Klammern fuer mehrere Datenbankaktionen
	void BeginDBAction();
	void CancelDBAction();
	void EndDBAction();

	void ShowDbStatus(const SdbStatus& rStatus, DBErrorContext eContext,Window *pParent=NULL);

	SbaObjectExt* GetSbaObjectExt() const {return pObjExt;}

	// Registrierung des PrivateURL Exchange Formats
	static sal_uInt32 RegisterSbaPrivateURL();
};

/*************************************************************************
|*
|* Pointer auf Applikationsdaten
|*
\************************************************************************/

#define SBA_MOD() ( *(SbaObject**) GetAppData(SHL_SBA) )

#endif//_SBAOBJ_HXX

