/*************************************************************************
 *
 *  $RCSfile: GetCurrentDirectory.c,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2002/07/24 08:45:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <systools/win32/StrConvert.h>
#include "GetCurrentDirectory.h"

DWORD WINAPI GetCurrentDirectoryW_9x(
    DWORD  nBufferLength,   // size of directory buffer
    LPWSTR lpBuffer         // directory buffer
)
{
    LPSTR lpBuffA  = NULL;    
	int   lenBuffA = 0;
    DWORD dwRet;
    DWORD dwLastError;
	int   nConv;

    // allocate ansi buffer on the stack
	lenBuffA = nBufferLength * sizeof(char);
    lpBuffA  = _alloca(lenBuffA);

	if (lpBuffA)
	{
		/*	GetCurrentDirectory returns the number of characters
			written to the buffer, not including the terminating
			character on success else 0
		*/ 
		dwRet = GetCurrentDirectoryA(lenBuffA, lpBuffA);

		dwLastError = GetLastError();

		if (dwRet)
		{			
			/*	string returned by GetCurrentDirectory 
				is '\0' terminated, that's why -1
			*/
			nConv = MultiByteToWideChar( 
				CP_ACP, 
				0, 
				lpBuffA, 
				-1, 
				lpBuffer, 
				nBufferLength);

			// MultiByteToWideChar returns the number of
			// chars written to the buffer including the
			// trailing '\0' if we provide -1 as 4. param
			// but because GetCurrentDirectory returns the
			// number of characters written to the buffer
			// without trailing '\0' we have to substract 
			// it
			nConv -= 1; 

			SetLastError(dwLastError);
		}
	}
	else
	{
		nConv = 0;
		SetLastError(ERROR_OUTOFMEMORY);
	}

    return nConv;
}
