/*************************************************************************
 *
 *  $RCSfile: light3d.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: thb $ $Date: 2001/08/16 15:41:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDIO_HXX
#include "svdio.hxx"
#endif

#ifndef _E3D_GLOBL3D_HXX
#include "globl3d.hxx"
#endif

#ifndef _E3D_LIGHT3D_HXX
#include "light3d.hxx"
#endif

#ifndef _SVDPAGE_HXX
#include "svdpage.hxx"
#endif

TYPEINIT1(E3dLight, E3dPointObj);

/*************************************************************************
|*
|* E3dLight-Konstruktor
|*
\************************************************************************/

E3dLight::E3dLight(const Vector3D& rPos, const Color& rColor,
					double fLightIntensity) :
	E3dPointObj(rPos),
	fIntensity(fLightIntensity),
	bOn(TRUE),
	bVisible(FALSE)
{
	SetColor(rColor);
	aLocalBoundVol = Volume3D();
	bBoundVolValid = FALSE;
}

/*************************************************************************
|*
|* E3dLight-Konstruktor 2
|*
\************************************************************************/

E3dLight::E3dLight() :
	E3dPointObj(Vector3D()),

	aColor(255, 255, 255),

	fRed(1.0),
	fGreen(1.0),
	fBlue(1.0),
	fIntensity(1.0),
	bOn(TRUE),
	bVisible(FALSE)
{
}

/*************************************************************************
|*
|* protected, daher kein Einfuegen von Objekten von aussen moeglich
|*
\************************************************************************/

void E3dLight::Insert3DObj(E3dObject* p3DObj)
{
//	E3dPointObj::Insert3DObj(p3DObj);
	GetSubList()->InsertObject(p3DObj);
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 E3dLight::GetObjIdentifier() const
{
	return E3D_LIGHT_ID;
}

/*************************************************************************
|*
|* Lichtstaerke an uebergeben Punkt bestimmen und die akkumulierte
|* Punktfarbe berechnen; Return = TRUE bedeutet, dass die maximale
|* Farbintensitaet aller Farbanteile erreicht ist.
|*
\************************************************************************/

FASTBOOL E3dLight::ImpCalcLighting(Color& rNewColor, const Color& rPntColor,
									double fR, double fG, double fB) const
{
	ULONG	nR(rNewColor.GetRed()),
			nG(rNewColor.GetGreen()),
			nB(rNewColor.GetBlue());
	ULONG	nPntR(rPntColor.GetRed()),
			nPntG(rPntColor.GetGreen()),
			nPntB(rPntColor.GetBlue());

	if ( bOn )
	{
		nR += (ULONG) (fR * nPntR);
		nG += (ULONG) (fG * nPntG);
		nB += (ULONG) (fB * nPntB);

		nR = Min(nR, nPntR);
		nG = Min(nG, nPntG);
		nB = Min(nB, nPntB);

		rNewColor.SetRed((USHORT) nR);
		rNewColor.SetGreen((USHORT) nG);
		rNewColor.SetBlue((USHORT) nB);
	}
	return ( nR == nPntR && nG == nPntG && nB == nPntB );
}

/*************************************************************************
|*
|* Lichtstaerke an uebergeben Punkt bestimmen und die akkumulierte
|* Punktfarbe berechnen
|*
\************************************************************************/

FASTBOOL E3dLight::CalcLighting(Color& rNewColor,
								const Vector3D& rPnt,
								const Vector3D& rPntNormal,
								const Color& rPntColor)
{
	return ImpCalcLighting(rNewColor, rPntColor, fRed, fGreen, fBlue);
}

/*************************************************************************
|*
|* neue Position setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

void E3dLight::SetPosition(const Vector3D& rNewPos)
{
	E3dPointObj::SetPosition(rNewPos);
	CreateLightObj();
}

/*************************************************************************
|*
|* neue Intensitaet setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

void E3dLight::SetIntensity(double fNew)
{
	if ( fIntensity != fNew )
	{
		fIntensity = fNew;
		StructureChanged(this);
		SetColor(aColor);
	}
}

/*************************************************************************
|*
|* neue Farbe setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

void E3dLight::SetColor(const Color& rNewColor)
{
	if ( aColor != rNewColor )
	{
		aColor = rNewColor;
		StructureChanged(this);
	}

	fRed    = fIntensity * aColor.GetRed()   / 255;
	fGreen  = fIntensity * aColor.GetGreen() / 255;
	fBlue   = fIntensity * aColor.GetBlue()  / 255;
}

/*************************************************************************
|*
|* Lichtquelle ein-/ausschalten und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

void E3dLight::SetOn(FASTBOOL bNewOn)
{
	if ( bOn != bNewOn )
	{
		bOn = bNewOn;
		StructureChanged(this);
	}
}

/*************************************************************************
|*
|* Darstellung des Lichtobjekts in der Szene ein-/ausschalten
|*
\************************************************************************/

void E3dLight::SetLightObjVisible(FASTBOOL bNewVisible)
{
	if ( bVisible != bNewVisible )
	{
		bVisible = bNewVisible;
		CreateLightObj();

		if ( bVisible )
			aLocalBoundVol = Volume3D(aPosition, Vector3D(), FALSE);
		else
			aLocalBoundVol = Volume3D();

		bBoundVolValid = FALSE;
		StructureChanged(this);
	}
}

/*************************************************************************
|*
|* Darstellung des Lichtobjekts in der Szene ein-/ausschalten
|*
\************************************************************************/

void E3dLight::CreateLightObj()
{
}

/*************************************************************************
|*
|* sichern
|*
\************************************************************************/

void E3dLight::WriteData(SvStream& rOut) const
{
#ifndef SVX_LIGHT
	E3dPointObj::WriteData(rOut);

#ifdef E3D_STREAMING

	SdrDownCompat aCompat(rOut, STREAM_WRITE);
#ifdef DBG_UTIL
	aCompat.SetID("E3dLight");
#endif

	rOut << aColor;
	rOut << fIntensity;
	rOut << fRed;
	rOut << fGreen;
	rOut << fBlue;
	rOut << BOOL(bOn);
	rOut << BOOL(bVisible);
#endif
#endif	// #ifndef SVX_LIGHT
}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

void E3dLight::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
{
	if (ImpCheckSubRecords (rHead, rIn))
	{
		E3dPointObj::ReadData(rHead, rIn);

		SdrDownCompat aCompat(rIn, STREAM_READ);
#ifdef DBG_UTIL
		aCompat.SetID("E3dLight");
#endif

		BOOL bTmp;

		rIn >> aColor;
		rIn >> fIntensity;
		rIn >> fRed;
		rIn >> fGreen;
		rIn >> fBlue;
		rIn >> bTmp; bOn = bTmp;
		rIn >> bTmp; bVisible = bTmp;
	}
}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void E3dLight::operator=(const SdrObject& rObj)
{
	E3dPointObj::operator=(rObj);

	const E3dLight& r3DObj = (const E3dLight&) rObj;

	aColor		= r3DObj.aColor;
	fIntensity	= r3DObj.fIntensity;
	fRed		= r3DObj.fRed;
	fGreen		= r3DObj.fGreen;
	fBlue		= r3DObj.fBlue;
	bOn			= r3DObj.bOn;
	bVisible	= r3DObj.bVisible;
}

/*************************************************************************
|*
|* Attribute setzen
|*
\************************************************************************/

void E3dLight::NbcSetStyleSheet(SfxStyleSheet* pNewStyleSheet, FASTBOOL bDontRemoveHardAttr)
{
}

/*************************************************************************
|*
|* Attribute setzen
|*
\************************************************************************/

void E3dLight::SetStyleSheet(SfxStyleSheet* pNewStyleSheet, FASTBOOL bDontRemoveHardAttr)
{
}

/*************************************************************************
|*
|* Attribute abfragen
|*
\************************************************************************/

SfxStyleSheet*E3dLight::GetStyleSheet() const
{
	return 0;
}


