/*************************************************************************
 *
 *  $RCSfile: jstest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:12:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <so3/factory.hxx>
#include <vcl/svapp.hxx>
#include <svtools/sbx.hxx>
#include <runtime.hxx>
#include <basmgr.hxx>

#include <so3/svstor.hxx>
#include <usr/refl.hxx>
#include <usr/conver.hxx>
#include <usr/lstcont.hxx>

#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUES_HXX_
#include <smart/com/sun/star/beans/PropertyValues.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/PropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/XPropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyStateChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyStateChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_XTYPECONVERTER_HXX_
#include <smart/com/sun/star/script/XTypeConverter.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_FINISHENGINEEVENT_HXX_
#include <smart/com/sun/star/script/FinishEngineEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_INTERRUPTREASON_HXX_
#include <smart/com/sun/star/script/InterruptReason.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_XENGINELISTENER_HXX_
#include <smart/com/sun/star/script/XEngineListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_XDEBUGGING_HXX_
#include <smart/com/sun/star/script/XDebugging.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_XINVOCATION_HXX_
#include <smart/com/sun/star/script/XInvocation.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_CONTEXTINFORMATION_HXX_
#include <smart/com/sun/star/script/ContextInformation.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_FINISHREASON_HXX_
#include <smart/com/sun/star/script/FinishReason.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_XENGINE_HXX_
#include <smart/com/sun/star/script/XEngine.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_INTERRUPTENGINEEVENT_HXX_
#include <smart/com/sun/star/script/InterruptEngineEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCRIPT_XLIBRARYACCESS_HXX_
#include <smart/com/sun/star/script/XLibraryAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCOMPONENTENUMERATION_HXX_
#include <smart/com/sun/star/container/XComponentEnumeration.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XCOMPONENT_HXX_
#include <smart/com/sun/star/lang/XComponent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCOMPONENTENUMERATIONACCESS_HXX_
#include <smart/com/sun/star/container/XComponentEnumerationAccess.hxx>
#endif

#include <hilight.hxx>

#include <vos/diagnose.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

class MyTestListener : public XDebuggingListener, public UsrObject
{
public:
	SMART_UNO_DECLARATION(ScriptPropSet,UsrObject);
	XInterface *			queryInterface( Uik aUik )
	{
		if( aUik == XDebuggingListener::getSmartUik() )
			return (XDebuggingListener *)this;
		else if( aUik == XEventListener::getSmartUik() )
			return (XEventListener *)this;
		return UsrObject::queryInterface( aUik );
	}

	virtual void disposing(const EventObject& Source)
	{
	}

	virtual void error(const DebuggingErrorEvent& aEvent)
	{
	}

	virtual void breaking(const DebuggingEvent& aEvent)
	{
	}

	virtual void running(const EventObject& aEvent)
	{
	}

	virtual void ready(const EventObject& aEvent)
	{
	}

};



/** Implemetiert eine PropertySet-Interface fr die Member "Height", "Width"
 * und "Name". Die Member "Height" und "Width" sind gebundene Properties. Bei ihnen
 * wird eine ChangeEvent gefeuert, sobald sich eine Property ndert.
 */
class ScriptPropSet : public XPropertySet, public UsrObject
{
	UString						aName;
	INT32						nWidth;
	INT32						nHeight;
	ListenerContainer			aWidthListeners;	// Container fr alle width Listener
	ListenerContainer			aHeightListeners;	// Container fr alle height Listener
public:
	ScriptPropSet();
	~ScriptPropSet();

	SMART_UNO_DECLARATION(ScriptPropSet,UsrObject);

	XInterface *			queryInterface( Uik aUik );
	virtual XIdlClassRef	getIdlClass( void );

	virtual XPropertySetInfoRef getPropertySetInfo() const;
	virtual void setPropertyValue(const UString& aPropertyName, const UsrAny& aValue);
	virtual UsrAny getPropertyValue(const UString& aPropertyName) const;
	virtual void addPropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& aListener);
	virtual void removePropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& aListener);
	virtual void addVetoableChangeListener(const UString& aPropertyName, const XVetoableChangeListenerRef& aListener);
	virtual void removeVetoableChangeListener(const UString& aPropertyName, const XVetoableChangeListenerRef& aListener);
};

/**
 * Liefert Informationen ber die Member "Width", "Height" und "Name".
 */
class ScriptPropSetInfo : public XPropertySetInfo, public UsrObject
{
public:
	ScriptPropSetInfo();
	SMART_UNO_DECLARATION(ScriptPropSetInfo,UsrObject);

	XInterface * queryInterface( Uik aUik );

	virtual Sequence<Property> getProperties(void) const;
	virtual Property getProperty(const UString& aPropertyName) const;
};

//------------------------------------------------------------------
ScriptPropSetInfo::ScriptPropSetInfo()
{
	// nie wieder freigeben
	acquire();
}

//------------------------------------------------------------------
SMART_UNO_IMPLEMENTATION(ScriptPropSetInfo,UsrObject)

XInterface * ScriptPropSetInfo::queryInterface( Uik aUik )
{
	if( aUik == XPropertySetInfo::getSmartUik() )
		return (XPropertySetInfo *)this;
	return UsrObject::queryInterface( aUik );
}

//------------------------------------------------------------------
Sequence<Property> ScriptPropSetInfo::getProperties() const
{
	static Sequence<Property> * pSeq = NULL;

	if( !pSeq )
	{
		// die Informationen fr die Properties "Width", "Height" und "Name" anlegen
		pSeq = new Sequence<Property>( 3 );
		Property * pAry = pSeq->getArray();

		pAry[0].Name = L"Width";
		pAry[0].Handle = -1;
		pAry[0].Type = INT32_getReflection()->getIdlClass();
		pAry[0].Attributes = PROPERTY_BOUND | PROPERTY_TRANSIENT;

		pAry[1].Name = L"Height";
		pAry[1].Handle = -1;
		pAry[1].Type = INT32_getReflection()->getIdlClass();
		pAry[1].Attributes = PROPERTY_BOUND | PROPERTY_TRANSIENT;

		pAry[2].Name = L"Name";
		pAry[2].Handle = -1;
		pAry[2].Type = UString_getReflection()->getIdlClass();
		pAry[2].Attributes = PROPERTY_TRANSIENT;
	}
	// Die Information ber alle drei Properties liefern.
	return *pSeq;
};

//------------------------------------------------------------------
Property ScriptPropSetInfo::getProperty(const UString& aPropertyName) const
{
	Sequence<Property> aSeq = getProperties();
	const Property * pAry = aSeq.getConstArray();

	for( UINT32 i = aSeq.getLen(); i--; i > 0 )
	{
		if( pAry[i-1].Name == aPropertyName )
			return pAry[i-1];
	}
	// Property unbekannt, also leere liefern
	return Property();
}


//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------
SMART_UNO_IMPLEMENTATION(ScriptPropSet,UsrObject);

ScriptPropSet::ScriptPropSet()
		: nWidth( 0 )
		, nHeight( 0 )
{
}

//------------------------------------------------------------------
ScriptPropSet::~ScriptPropSet()
{
}

//------------------------------------------------------------------
XInterface * ScriptPropSet::queryInterface( Uik aUik )
{
	if( aUik == XPropertySet::getSmartUik() )
		return (XPropertySet *)this;
	return UsrObject::queryInterface( aUik );
}

//===============================================================
XIdlClassRef ScriptPropSet::getIdlClass()
{
	XIdlClassRef xCls = createStandardClass( L"ScriptPropSetInfo",
		UsrObject::getUsrObjectIdlClass(), 1,
		XPropertySet_getReflection() );

	return xCls;
}

//------------------------------------------------------------------
XPropertySetInfoRef ScriptPropSet::getPropertySetInfo() const
{
	static ScriptPropSetInfo aInfo;
	// Alle Objekt haben die gleichen Properties, deshalb kann
	// die INfo fr alle gleich sein
	return &aInfo;
}

void ScriptPropSet::setPropertyValue(const UString& aPropertyName, const UsrAny& aValue)
{
	if( aPropertyName == L"Width" )
	{
		// narrowing conversion
		INT32 n = TypeConversion::toINT32( aValue );
		if( nWidth != n )
		{
			// Der Wert hat sich gendert
			INT32 nOld = nWidth;
			// neuen Wert eintragen
			nWidth = n;
			if( aWidthListeners.getLen() )
			{
				PropertyChangeEvent aEvt;
				// Event Objekt fllen
				aEvt.Source = (UsrObject *)this;
				aEvt.PropertyName = aPropertyName;
				aEvt.PropertyHandle = -1;
				aEvt.OldValue = nOld;
				aEvt.NewValue = n;
				aEvt.PropagationId = XInterfaceRef();

				// ber alle Listener iterieren und Events senden
				ListenerIterator aIt( aWidthListeners );
				while( aIt.hasMoreElements() )
					((XPropertyChangeListener *)aIt.next())->propertyChange( aEvt );
			}
		}
	}
	else if( aPropertyName == L"Height" )
	{
		INT32 n = TypeConversion::toINT32( aValue );
		if( nHeight != n )
		{
			INT32 nOld = nHeight;
			nHeight = n;
			if( aHeightListeners.getLen() )
			{
				PropertyChangeEvent aEvt;
				aEvt.Source = (UsrObject *)this;
				aEvt.PropertyName = aPropertyName;
				aEvt.PropertyHandle = -1;
				aEvt.OldValue = nOld;
				aEvt.NewValue = n;
				aEvt.PropagationId = XInterfaceRef();

				ListenerIterator aIt( aHeightListeners );
				while( aIt.hasMoreElements() )
					((XPropertyChangeListener *)aIt.next())->propertyChange( aEvt );
			}
		}
	}
	else if( aPropertyName == L"Name" )
	{
		aName = TypeConversion::toString( aValue );
	}
	// Exception
}

UsrAny ScriptPropSet::getPropertyValue(const UString& aPropertyName) const
{
	// Wert der Property in einem Any zurckgeben
	if( aPropertyName == L"Width" )
	{
		return UsrAny( nWidth );
	}
	else if( aPropertyName == L"Height" )
	{
		return UsrAny( nHeight );
	}
	else if( aPropertyName == L"Name" )
	{
		return UsrAny( aName );
	}
	// Exception
	UsrAny aAny;
	return aAny;
}

void ScriptPropSet::addPropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& aListener)
{
	if( aPropertyName == L"Width" )
		// Listener fr "Width" anmelden
		aWidthListeners.addListener( aListener );
	else if( aPropertyName == L"Height" )
		// Listener fr "Height" anmelden
		aHeightListeners.addListener( aListener );
	else if( aPropertyName == UString() )
	{
		// Listener fr "Width" und "Height" anmelden
		// ein "" String bedeutet, zu allen Bound-Properties anmelden
		aWidthListeners.addListener( aListener );
		aHeightListeners.addListener( aListener );
	}
	//else
	//	  Exception
}

void ScriptPropSet::removePropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& aListener)
{
	if( aPropertyName == L"Width" )
		aWidthListeners.removeListener( aListener );
	else if( aPropertyName == L"Height" )
		aHeightListeners.removeListener( aListener );
	else if( aPropertyName == UString() )
	{
		// Listener fr "Width" und "Height" anmelden
		// ein "" String bedeutet, alleabmelden
		aWidthListeners.removeListener( aListener );
		aHeightListeners.removeListener( aListener );
	}
	//else
	//	  Exception
}

void ScriptPropSet::addVetoableChangeListener(const UString& aPropertyName, const XVetoableChangeListenerRef& aListener)
{
}
void ScriptPropSet::removeVetoableChangeListener(const UString& aPropertyName, const XVetoableChangeListenerRef& aListener)
{
}


class JSTestApp : public Application
{
public:
	void  Main( );
	DECL_LINK( LateInit, void * );

protected:
	void TestHighlighter(HighlighterLanguage eLanguage);
	BOOL TestTokenResult(SyntaxHighlighter* pSH,
									String* str,
									UINT16 pTokenPosTabExpected[12][12],
									TokenTypes pTokenTypeTabExpected[12][12],
									Range repaintExpected,
									Range newRepaint,
									BOOL bLongOutput);
	void AddStringsToArray(String* str,
									  UINT16 nStrCount,
									  String* toAdd,
									  UINT16 nAddedLineCount,
									  UINT16 nFirstChangedLine);
};
JSTestApp aApp; 					// Applikations-Instanz

IMPL_LINK( JSTestApp, LateInit, void *, pDummy )
{

	SvStorageRef xStor = new SvStorage( "" );
	BasicManager aMgr( *&xStor );

	{
	{
	String aCode =
		"function bla()\n"
		"{\n"
		"\tHeight=6;\n"
		"}\n";

	StarBASIC * pLib = aMgr.CreateLib( "Test2" );
	XPropertySetRef xRoot = new ScriptPropSet();
	pLib->setRoot( xRoot );
	SbModule* pMod;
	SbxObjectRef xMod = pMod = pLib->MakeJScriptModule( "testMod", aCode);
	}

	String aCode =
		"function test()\n"
		"{\n"
		"\tHeight=7;\n"
		"\tWidth=6;\n"
		"\tbla1();\n"
		"\tTest2.bla();\n"
		"\tTest2.testMod.bla();\n"
		"}\n"
		"function bla1()\n"
		"{\n"
		"\tHeight=6;\n"
		"}\n";


	StarBASIC * pLib = aMgr.CreateLib( "Test1" );
	XPropertySetRef xRoot = new ScriptPropSet();
	pLib->setRoot( xRoot );
	SbModule* pMod;
	SbxObjectRef xMod = pMod = pLib->MakeJScriptModule( "test", aCode);
	XScriptingEngineRef xEngine = pLib->getScriptingEngine();
	XDebuggingRef xDeb = (XDebugging *)xEngine->queryInterface( XDebugging::getSmartUik() );
	// Muss vor Compile gesetzt werden!!!
	xDeb->addDebuggingListener( new MyTestListener() );
	pLib->Compile( NULL );
	XInvocationRef xInv = (XInvocation *)xEngine->queryInterface( XInvocation::getSmartUik() );
	Sequence< UsrAny > aArgs;
	xInv->invoke( L"test.test", INVOKEKIND_FUNC, aArgs );
	}

	/*
	String aCode =
		"sub main\n"
		"\tprint \"Markus ist ...\"\n"
		"end sub\n";

	StarBASIC aBasic;
	SbModule* pMod;
	SbxObjectRef xMod = pMod = aBasic.MakeModule( "test", aCode);
	aBasic.Compile( pMod );

	SbMethod* pMain = (SbMethod*) pMod->Find( "Main", SbxCLASS_METHOD );
	if( pMain )
		pMain->Run();

	StarBASIC::Stop();
	*/
	return 0;
}

void JSTestApp::Main( )
{
	TestHighlighter(HIGHLIGHT_JAVASCRIPT);
	TestHighlighter(HIGHLIGHT_BASIC);

/*	SvFactory::Init();
	createAndSetDefaultServiceManager();
	GetpApp()->PostUserEvent( LINK( this, JSTestApp, LateInit ) );
	Execute();
*/
}

TokenTypes test1TTJScript[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT  },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER  },
	{ TT_COMMENT },
	{ TT_KEYWORD, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER }
};

TokenTypes test2TTJScript[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT  },
	{ TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER  },
	{ TT_COMMENT },
	{ TT_KEYWORD, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER }
};

TokenTypes test3TTJScript[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT  },
	{ TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER  },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER }
};

TokenTypes test4TTJScript[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT  },
	{ TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_COMMENT, TT_WHITESPACE, TT_IDENTIFIER },
};

UINT16 test1PosJScript[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 17, 18 },
	{ 0, 5, 6 },
	{ 0, 8, 9 },
	{ 0 },
	{ 0, 6, 7 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 26, 27 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 16, 17 }
};

UINT16 test2PosJScript[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 17, 18 },
	{ 0, 5, 6 },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0, 8, 9 },
	{ 0 },
	{ 0, 6, 7 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 26, 27 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 16, 17 }
};

UINT16 test3PosJScript[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 17, 18 },
	{ 0, 5, 6 },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0, 8, 9 },
	{ 0, 13, 14 },
	{ 0 },
	{ 0 },
	{ 0, 20, 21 },
	{ 0, 5, 6, 26, 27 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 16, 17 }
};

UINT16 test4PosJScript[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 17, 18 },
	{ 0, 5, 6 },
	{ 0 },
	{ 0 },
	{ 0, 8, 9, 15, 16 },
	{ 0 },
	{ 0 },
	{ 0, 20, 21 },
	{ 0, 5, 6, 26, 27 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 16, 17 },
};

UINT16 test1RangeJScript[] = { 0, 12 };
UINT16 test2RangeJScript[] = { 3, 6 };
UINT16 test3RangeJScript[] = { 7, 10 };
UINT16 test4RangeJScript[] = { 5, 8 };

TokenTypes test1TTBasic[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_KEYWORD, TT_WHITESPACE, TT_COMMENT }
};

TokenTypes test2TTBasic[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_KEYWORD, TT_WHITESPACE, TT_COMMENT }
};

TokenTypes test3TTBasic[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_KEYWORD, TT_WHITESPACE, TT_COMMENT }
};

TokenTypes test4TTBasic[][12] = { { TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_KEYWORD },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_IDENTIFIER },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_COMMENT },
	{ TT_IDENTIFIER, TT_WHITESPACE, TT_OPERATOR, TT_OPERATOR, TT_WHITESPACE, TT_IDENTIFIER },
	{ TT_KEYWORD, TT_WHITESPACE, TT_COMMENT }
};

UINT16 test1PosBasic[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 7, 8, 9, 14, 15, 16, 17, 18 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 1, 2, 3, 8, 10, 11, 12, 13, 16, 17, 18 },
	{ 0, 6, 7 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9, 14, 15 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 4, 5 }
};

UINT16 test2PosBasic[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 7, 8, 9, 14, 15, 16, 17, 18 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 1, 2, 3, 8, 10, 11, 12, 13, 16, 17, 18 },
	{ 0, 6, 7 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9, 14, 15 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 4, 5 }
};

UINT16 test3PosBasic[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 7, 8, 9, 14, 15, 16, 17, 18 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 13, 14, 15, 16, 17 },
	{ 0 },
	{ 0, 6, 7 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9, 14, 15 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 4, 5 }
};

UINT16 test4PosBasic[][12] = { { 0, 4, 5, 15, 16, 19, 20 },
	{ 0, 5, 6, 7, 8, 9, 14, 15, 16, 17, 18 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0 },
	{ 0 },
	{ 0, 5, 6, 7, 8, 9, 15, 16, 17, 18, 19 },
	{ 0 },
	{ 0, 6, 7 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9, 14, 15 },
	{ 0, 5, 6 },
	{ 0, 5, 6 },
	{ 0, 5, 6, 7, 8, 9 },
	{ 0, 4, 5 }
};


UINT16 test1RangeBasic[] = { 0, 11 };
UINT16 test2RangeBasic[] = { 3, 5 };
UINT16 test3RangeBasic[] = { 7, 8 };
UINT16 test4RangeBasic[] = { 5, 5 };

void JSTestApp::TestHighlighter(HighlighterLanguage eLanguage)
{
	// Higlighter test
	SyntaxHighlighter* pSH = new SyntaxHighlighter();
	pSH->initialize(eLanguage);

	if (eLanguage == HIGHLIGHT_JAVASCRIPT)
		printf("\n\nTESTING JAVASCRIPT...\n");
	else if (eLanguage == HIGHLIGHT_BASIC)
		printf("\n\nTESTING BASIC...\n");

	const UINT16 nStrCount = 20;
	String str[nStrCount];
	Range newRepaint;
	BOOL bSuccess;

	str[0] = String("dies implements ein goto");
	str[1] = String("text1 /* Error */ if");
	str[2] = String("text1 /* text2");
	str[3] = String("text1 */ text2");
	str[4] = String("/* text1  /* For */");
	str[5] = String("native // text2");
	str[6] = String("text1 // /* text2 */ text3");
	str[7] = String("text1 /* text2 // text3 */ text4");
	str[8] = String("text1 // /* Case");
	str[9] = String("text1 // */ text2");
	str[10] = String("text1 /* text2");
	str[11] = String("Call // text2 */ text3");

	for (UINT16 i=12; i<nStrCount; i++)
		str[i] = String("");

	// erstmal Test aufbauen
	newRepaint = pSH->notifyChange( 0, 12, str, 12);
	if (eLanguage == HIGHLIGHT_JAVASCRIPT)
		bSuccess = TestTokenResult(pSH, str, test1PosJScript, test1TTJScript,
					Range(test1RangeJScript[0], test1RangeJScript[1]), newRepaint, TRUE);
	else if (eLanguage == HIGHLIGHT_BASIC)
		bSuccess = TestTokenResult(pSH, str, test1PosBasic, test1TTBasic,
					Range(test1RangeBasic[0], test1RangeBasic[1]), newRepaint, TRUE);

	if (!bSuccess)
	{
		printf("#### THE 1. TEST FAILED!!!!\n");
		VOS_ENSHURE(FALSE, "#### THE 1. TEST FAILED!!!!");
	}
	else
		printf("#### THE 1. SUCCEEDED!!!!\n");

	// drei neue Strings in einen Kommentar dazwischenschieben
	String toAdd[3];
	toAdd[0] = String("added_text1");
	toAdd[1] = String("added_text2");
	toAdd[2] = String("added_text3");

	AddStringsToArray(str, nStrCount, toAdd, 3/*newLineCount*/, 3/*offset*/);
//	str[6] = String("*/ hallotext");

	newRepaint = pSH->notifyChange( 3/*firstChangedLine*/, 3/*newLineCount*/, &str[3], 3/*changedLineCount*/ );
	if (eLanguage == HIGHLIGHT_JAVASCRIPT)
		bSuccess = TestTokenResult(pSH, str, test2PosJScript, test2TTJScript,
					Range(test2RangeJScript[0], test2RangeJScript[1]), newRepaint, TRUE);
	else if (eLanguage == HIGHLIGHT_BASIC)
		bSuccess = TestTokenResult(pSH, str, test2PosBasic, test2TTBasic,
					Range(test2RangeBasic[0], test2RangeBasic[1]), newRepaint, TRUE);

	if (!bSuccess)
	{
		printf("#### THE 2. TEST FAILED!!!!\n");
		VOS_ENSHURE(FALSE, "#### THE 2. TEST FAILED!!!!");
	}
	else
		printf("#### THE 2. SUCCEEDED!!!!\n");


	// ein neuen String dazwischenschieben
	AddStringsToArray(str, nStrCount, toAdd, 1, 8);
	// und Kommentar zerstoeren
	str[7] = "changed_text1 /* changed_text2";
	newRepaint = pSH->notifyChange( 7, 1, &str[7], 2 );
	if (eLanguage == HIGHLIGHT_JAVASCRIPT)
		bSuccess = TestTokenResult(pSH, str, test3PosJScript, test3TTJScript,
					Range(test3RangeJScript[0], test3RangeJScript[1]), newRepaint, TRUE);
	else if (eLanguage == HIGHLIGHT_BASIC)
		bSuccess = TestTokenResult(pSH, str, test3PosBasic, test3TTBasic,
					Range(test3RangeBasic[0], test3RangeBasic[1]), newRepaint, TRUE);

	if (!bSuccess)
	{
		printf("#### THE 3. TEST FAILED!!!!\n");
		VOS_ENSHURE(FALSE, "#### THE 3. TEST FAILED!!!!");
	}
	else
		printf("#### THE 3. SUCCEEDED!!!!\n");

	// zwei Zeilen loeschen, eine aendern
	for (i=6; i < nStrCount-2; i++)
		str[i] = str[i+2];
	str[5] = String("text1 */ native /* changed_text1");
	newRepaint = pSH->notifyChange( 5, -2, &str[5], 1 );
	if (eLanguage == HIGHLIGHT_JAVASCRIPT)
		bSuccess = TestTokenResult(pSH, str, test4PosJScript, test4TTJScript,
					Range(test4RangeJScript[0], test4RangeJScript[1]), newRepaint, TRUE);
	else if (eLanguage == HIGHLIGHT_BASIC)
		bSuccess = TestTokenResult(pSH, str, test4PosBasic, test4TTBasic,
					Range(test4RangeBasic[0], test4RangeBasic[1]), newRepaint, TRUE);

	if (!bSuccess)
	{
		printf("#### THE 4. TEST FAILED!!!!\n");
		VOS_ENSHURE(FALSE, "#### THE 4. TEST FAILED!!!!");
	}
	else
		printf("#### THE 4. SUCCEEDED!!!!\n");

}

void JSTestApp::AddStringsToArray(String* str,
								  UINT16 nStrCount,
								  String* toAdd,
								  UINT16 nAddedLineCount,
								  UINT16 nAddOffset)
{
	for (UINT16 i=nStrCount-1; i>=nAddOffset+nAddedLineCount; i--)
		str[i] = str[i-nAddedLineCount];

	for (i=nAddOffset; i < nAddOffset+nAddedLineCount; i++)
	{
		str[i] = toAdd[i-nAddOffset];
	}
}

BOOL JSTestApp::TestTokenResult(SyntaxHighlighter* pSH,
								String* str,
								UINT16 pTokenPosTabExpected[12][12],
								TokenTypes pTokenTypeTabExpected[12][12],
								Range repaintExpected,
								Range newRepaint,
								BOOL bLongOutput)
{
	BOOL		bErrorOccured = FALSE;

	if (bLongOutput)
		printf("\nResult of the SyntaxHighlighter (to be repainted: from line %d to line %d):\n",
														newRepaint.Min(), newRepaint.Max());

	if (repaintExpected != newRepaint)
	{
		printf(" ### ERROR ### ");
		bErrorOccured = TRUE;
	}

	for (UINT16 i = 0; i < 20; i++)
	{
		HighlightPortions portions(0, 4);

		pSH->getHighlightPortions( i, str[i], portions );

		if (bLongOutput)
		{
			if (portions.Count() > 0)
			{
				printf("tokens of line %d (%s): ",i, str[i].GetStr());

				for (UINT16 j=0; (j < portions.Count()); j++)
				{
					printf("(%d, ", portions[j].nBegin);

					if (portions[j].tokenType == TT_UNKNOWN)
						printf("TT_UNKNOWN");
					else if (portions[j].tokenType == TT_IDENTIFIER)
						printf("TT_IDENTIFIER");
					else if (portions[j].tokenType == TT_WHITESPACE)
						printf("TT_WHITESPACE");
					else if (portions[j].tokenType == TT_NUMBER)
						printf("TT_NUMBER");
					else if (portions[j].tokenType == TT_STRING)
						printf("TT_STRING");
					else if (portions[j].tokenType == TT_EOL)
						printf("TT_EOL");
					else if (portions[j].tokenType == TT_COMMENT)
						printf("TT_COMMENT");
					else if (portions[j].tokenType == TT_ERROR)
						printf("TT_ERROR");
					else if (portions[j].tokenType == TT_OPERATOR)
						printf("TT_OPERATOR");
					else if (portions[j].tokenType == TT_KEYWORD)
						printf("TT_KEYWORD");
					else
						printf("unknown token symbol");

					printf("), ");

					if ((pTokenPosTabExpected != NULL) && (pTokenPosTabExpected[i][j] != portions[j].nBegin))
					{
						printf(" ### POS ERROR ### ");
						bErrorOccured = TRUE;
					}
					if ((pTokenTypeTabExpected != NULL) && (pTokenTypeTabExpected[i][j] != portions[j].tokenType))
					{
						printf(" ### TOKEN ERROR ### ");
						bErrorOccured = TRUE;
					}
				}
				printf("\n");
			}
		}
	}

	return !bErrorOccured;
}

