/*************************************************************************
 *
 *  $RCSfile: tpltools.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: np $ $Date: 2002/11/01 12:18:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CSV_TPLTOOLS_HXX
#define CSV_TPLTOOLS_HXX


#include <vector>
#include <map>


namespace csv
{


template <class COLLECTION>
void		  		erase_container(
						COLLECTION &		o_rCollection );

/// Version for std::map
template <class COLLECTION>
void		  		erase_map_of_heap_ptrs(
						COLLECTION &		o_rCollection );

/// Version for other containers than std::map, with non-pair value_type.
template <class COLLECTION>
void		  		erase_container_of_heap_ptrs(
						COLLECTION &		o_rCollection );

template <class VECTOR_ELEM>
void                adjust_vector_size(
                        std::vector<VECTOR_ELEM> &
                                            io_rVector,
                        uintt               i_nSize,
                        const VECTOR_ELEM & i_nFill );


template <class KEY, class VAL>
const VAL *	        find_in_map(            /// Usable for all kinds of values
						const std::map< KEY, VAL > &
											i_rMap,
						const KEY &			i_rKey );

template <class KEY, class VAL>
VAL					value_from_map(         /// Unlike find_in_map(), usable only for values, which can be assigned 0.
						const std::map< KEY, VAL > &
											i_rMap,
						const KEY &			i_rKey );

// Object oriented for_each:
template <class COLLECTION, class CLASS, class MEMFUNC>
void                call_for_each(
                        const COLLECTION &  i_rList,
                        CLASS *             io_pThis,
                        MEMFUNC             i_fMethod );


// IMPLEMENTATION

template <class COLLECTION>
inline void
erase_container( COLLECTION & o_rCollection )
{
	o_rCollection.erase( o_rCollection.begin(),
						 o_rCollection.end() );
}

template <class COLLECTION>
void
erase_map_of_heap_ptrs( COLLECTION & o_rCollection )
{
    typename COLLECTION::iterator itEnd = o_rCollection.end();
    for ( typename COLLECTION::iterator it = o_rCollection.begin();
          it != itEnd;
          ++it )
    {
        delete (*it).second;
    }

	o_rCollection.erase( o_rCollection.begin(),
						 o_rCollection.end() );
}

template <class COLLECTION>
void
erase_container_of_heap_ptrs( COLLECTION & o_rCollection )
{
	typename COLLECTION::iterator itEnd = o_rCollection.end();
	for ( typename COLLECTION::iterator it = o_rCollection.begin();
		  it != itEnd;
		  ++it )
	{
		delete *it;
	}

	o_rCollection.erase( o_rCollection.begin(),
						 o_rCollection.end() );
}

template <class VECTOR_ELEM>
void
adjust_vector_size( std::vector<VECTOR_ELEM> & io_rVector,
                    uintt                      i_nSize,
                    const VECTOR_ELEM &        i_nFill )
{
    if ( io_rVector.size() > i_nSize )
    {
        io_rVector.erase( io_rVector.begin() + i_nSize, io_rVector.end() );
    }
    else
    {
        io_rVector.reserve(i_nSize);
        while ( io_rVector.size() <  i_nSize )
            io_rVector.push_back(i_nFill);
    }
}


template <class KEY, class VAL>
const VAL *
find_in_map( const std::map< KEY, VAL > & i_rMap,
			 const KEY &			      i_rKey )
{
	typename std::map< KEY, VAL >::const_iterator
			ret =  i_rMap.find(i_rKey);
	return ret != i_rMap.end()
				?	& (*ret).second
				:	(const VAL*)0;
}

template <class KEY, class VAL>
VAL
value_from_map( const std::map< KEY, VAL > & i_rMap,
			    const KEY &			         i_rKey )
{
	typename std::map< KEY, VAL >::const_iterator
			ret =  i_rMap.find(i_rKey);
	return ret != i_rMap.end()
				?	(*ret).second
				:	VAL(0);
}

template <class COLLECTION, class CLASS, class MEMFUNC>
void
call_for_each( const COLLECTION &  i_rList,
               CLASS *             io_pThis,
               MEMFUNC             i_fMethod )
{
    typename COLLECTION::const_iterator it = i_rList.begin();
    typename COLLECTION::const_iterator itEnd = i_rList.end();
    for ( ; it != itEnd; ++it )
    {
        (io_pThis->*i_fMethod)(*it);
    }
}


}   // namespace csv




#endif





