/*************************************************************************
 *
 *  $RCSfile: wrapper.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: cd $ $Date: 2001/07/10 05:35:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "wrapper.hxx"

#include <offmgr/app.hxx>
#include <sw/swdll.hxx>
#include <sc/scdll.hxx>
#include <sd/sddll.hxx>
#include <sch/schdll.hxx>
#include <starmath/smdll.hxx>
#include <svx/svdetc.hxx>
#include <osl/mutex.hxx>
#include <cppuhelper/factory.hxx>
#include <sfx2/docfac.hxx>
#include <sfx2/docfilt.hxx>
#include <sfx2/fcontnr.hxx>
#include <sfx2/app.hxx>
#include <unotools/processfactory.hxx>
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
#include <rtl/logfile.hxx>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

#define DEFINE_CONST_UNICODE(CONSTASCII)        UniString(RTL_CONSTASCII_USTRINGPARAM(CONSTASCII##))

static SwDLL*  pSwDLL=0;
static SdDLL*  pSdDLL=0;
static ScDLL*  pScDLL=0;
static SchDLL* pSchDLL=0;
static SimDLL* pSimDLL=0;
static SmDLL*  pSmDLL=0;

SFX_IMPL_XSERVICEINFO( OfficeWrapper, "com.sun.star.office.OfficeWrapper", "com.sun.star.comp.desktop.OfficeWrapper" )

Reference< XInterface >  SAL_CALL OfficeWrapper_CreateInstance( const Reference< XMultiServiceFactory >  & rSMgr )
{
    return (XComponent*) ( new OfficeWrapper( rSMgr ) );
}

OfficeWrapper::OfficeWrapper( const Reference < XMultiServiceFactory >& xFactory )
    : aListeners( aMutex )
    , pApp( new OfficeApplication )
{
	RTL_LOGFILE_CONTEXT( aLog, "OfficeWrapper::OfficeWrapper()" );
	SvtModuleOptions aMOpt;
//    if ( aMOpt.IsWriter() )
    {
        pSwDLL  = new SwDLL;
		SwDLL::LibInit();
    }
	if ( aMOpt.IsDraw() || aMOpt.IsImpress() )
    {
        pSdDLL  = new SdDLL;
		SdDLL::LibInit();
    }
    if ( aMOpt.IsCalc() )
    {
        pScDLL  = new ScDLL;
		ScDLL::LibInit();
    }
    if ( aMOpt.IsChart() )
	{
        pSchDLL = new SchDLL;
		SchDLL::LibInit();
	}
    if ( aMOpt.IsMath() )
	{
        pSmDLL = new SmDLL;
		SmDLL::LibInit();
	}
}

OfficeWrapper::~OfficeWrapper()
{
//    if ( pApp->HasFeature( SFX_FEATURE_SCALC ) )        ???????????
//        ScDLL::PreExit();           // der Teil vom Exit der noch Svx etc. braucht
    {
        // all ConfigItems must be destroyed before destroying the SfxApp
        SvtModuleOptions aMOpt;

    if ( aMOpt.IsChart() )
    {
        SchDLL::LibExit();
        DELETEZ( pSchDLL );
    }
    if ( aMOpt.IsMath() )
    {
        SmDLL::LibExit();
        DELETEZ( pSmDLL );
    }
  //  if ( aMOpt.IsWriter() )
	{
		SwDLL::LibExit();
        DELETEZ( pSwDLL );
    }
    if ( aMOpt.IsDraw() || aMOpt.IsImpress() )
    {
		SdDLL::LibExit();
        DELETEZ( pSdDLL );
    }
    if ( aMOpt.IsCalc() )
    {
        ScDLL::PreExit();           // der Teil vom Exit der noch Svx etc. braucht
		ScDLL::LibExit();
        DELETEZ( pScDLL );
    }
    }

    delete pApp;
    delete &GetSdrGlobalData(); // ??????????
}

void SAL_CALL OfficeWrapper::dispose() throw ( RuntimeException )
{
    EventObject aObject;
    aObject.Source = (XComponent*)this;
    aListeners.disposeAndClear( aObject );
}

void SAL_CALL OfficeWrapper::addEventListener( const Reference< XEventListener > & aListener) throw ( RuntimeException )
{
    aListeners.addInterface( aListener );
}

void SAL_CALL OfficeWrapper::removeEventListener( const Reference< XEventListener > & aListener ) throw ( RuntimeException )
{
    aListeners.removeInterface( aListener );
}

extern "C" {

void SAL_CALL component_getImplementationEnvironment(	const	sal_Char**			ppEnvironmentTypeName	,
																uno_Environment**	ppEnvironment			)
{
	*ppEnvironmentTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME ;
}

sal_Bool SAL_CALL component_writeInfo(  void*   pServiceManager , void*   pRegistryKey    )
{
    Reference< XMultiServiceFactory >  xMan( reinterpret_cast< XMultiServiceFactory* >( pServiceManager ) ) ;
//    ::utl::setProcessServiceFactory( xMan );
    Reference< XRegistryKey > xKey( reinterpret_cast< XRegistryKey* >( pRegistryKey ) ) ;

    // Eigentliche Implementierung und ihre Services registrieren
    ::rtl::OUString aTempStr;

    ::rtl::OUString aImpl( RTL_CONSTASCII_USTRINGPARAM("/") );
    aImpl += OfficeWrapper::impl_getStaticImplementationName();
    aImpl += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/UNO/SERVICES"));
    Reference< XRegistryKey > xNewKey = xKey->createKey( aImpl );
    xNewKey->createKey( ::rtl::OUString::createFromAscii("com.sun.star.office.OfficeWrapper") );

//    sal_Bool bRet = SwDLL::RegisterFrameLoaders( pServiceManager, pRegistryKey );
//    return bRet;
	  return sal_False;
}

void* SAL_CALL component_getFactory(	const	sal_Char*	pImplementationName	,
												void*		pServiceManager		,
												void*		pRegistryKey		)
{
	// Set default return value for this operation - if it failed.
	void* pReturn = NULL ;
    if  ( pImplementationName && pServiceManager )
	{
		// Define variables which are used in following macros.
        Reference< XSingleServiceFactory >   xFactory                                             ;
        Reference< XMultiServiceFactory >    xServiceManager( reinterpret_cast< XMultiServiceFactory* >( pServiceManager ) ) ;

        if ( OfficeWrapper::impl_getStaticImplementationName().compareToAscii( pImplementationName ) == COMPARE_EQUAL )
        {
            xFactory = ::cppu::createOneInstanceFactory( xServiceManager, OfficeWrapper::impl_getStaticImplementationName(),
                    OfficeWrapper::impl_createInstance, OfficeWrapper::impl_getStaticSupportedServiceNames() );
        }

/*
        if ( !xFactory.is() )
            xFactory = (XSingleServiceFactory*) SwDLL::CreateFrameLoader( pImplementationName, pServiceManager, pRegistryKey );
        if ( !xFactory.is() )
            xFactory = ScDLL::CreateFrameLoader( aImplementationName, xServiceManager, xRegistryKey );
        if ( !xFactory.is() )
            xFactory = SdDLL::CreateFrameLoader( aImplementationName, xServiceManager, xRegistryKey );
        if ( !xFactory.is() )
            xFactory = SchDLL::CreateFrameLoader( aImplementationName, xServiceManager, xRegistryKey );
        if ( !xFactory.is() )
            xFactory = SimDLL::CreateFrameLoader( aImplementationName, xServiceManager, xRegistryKey );
        if ( !xFactory.is() )
            xFactory = SmDLL::CreateFrameLoader( aImplementationName, xServiceManager, xRegistryKey );
*/
//        if ( ByteString( pImplementationName ).CompareToAscii( "com.sun.star.comp.filter", 24 ) == COMPARE_EQUAL )
//            xFactory = SfxFrameLoader::GetFactory( xServiceManager, String::CreateFromAscii(pImplementationName));

		// Factory is valid - service was found.
		if ( xFactory.is() )
		{
			xFactory->acquire();
			pReturn = xFactory.get();
		}
	}

	// Return with result of this operation.
	return pReturn ;
}
} // extern "C"

