/*************************************************************************
 *
 *  $RCSfile: DocViewer.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 15:29:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *  
 *  Copyright (c) 2003 by Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *     
 *************************************************************************/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.File;

import com.sun.star.beans.LocalOfficeConnection;

public class DocViewer
{
	private Frame frame = null;
	private JTextField currentSelection = null;
	private OfficeWriter mOfficeWriter = null;

	private void initBean()
	{
		if (mOfficeWriter == null)
		{
			mOfficeWriter = new OfficeWriter();
			mOfficeWriter.setOfficeConnection(new LocalOfficeConnection());
			mOfficeWriter.addSelectionChangeListener(new DocViewerChangeListener());
			frame.add(mOfficeWriter, BorderLayout.CENTER);
		}
	}

	private void initUI()
	{
		frame = new Frame();
		frame.setTitle( "OfficeWriterBean demo" );
		frame.setLayout(new BorderLayout());

		JButton newDocButton = new JButton("New");
		newDocButton.setPreferredSize(new Dimension(100, 30));
		newDocButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				createDocument(evt);
			}
		});

		JButton loadDocButton = new JButton("Open");
		loadDocButton.setPreferredSize(new Dimension(100, 30));
		loadDocButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				loadDocument(evt);
			}
		});

		JButton hideDocButton = new JButton("Hide");
		hideDocButton.setPreferredSize(new Dimension(100, 30));
		hideDocButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				mOfficeWriter.hide();
			}
		});

		JButton showDocButton = new JButton("Show");
		showDocButton.setPreferredSize(new Dimension(100, 30));
		showDocButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				mOfficeWriter.show();
			}
		});

		currentSelection = new JTextField();
		currentSelection.setPreferredSize(new Dimension(200, 30));
		currentSelection.setEditable(false);

		Panel p = new Panel();
		p.add(newDocButton);
		p.add(loadDocButton);
		p.add(hideDocButton);
		p.add(showDocButton);
		p.add(currentSelection);

		frame.add(p, BorderLayout.SOUTH);
		frame.addWindowListener(new ExitListener());
		frame.setSize(500, 500);
		frame.show();
	}

	private void createDocument(ActionEvent evt)
	{
		initBean();

		try {
			mOfficeWriter.load(OfficeWriter.NEW_DOCUMENT);
		}
		catch (Exception e) {
			e.printStackTrace(System.err);
		}
		mOfficeWriter.setObjectBarVisible(false);
	}

	private JFileChooser fc = null;

	private void loadDocument(ActionEvent evt)
	{
		if (fc == null)
			fc = new JFileChooser();

		int returnVal = fc.showOpenDialog((Component)evt.getSource());
		if (returnVal == JFileChooser.APPROVE_OPTION)
		{
			initBean();

			File file = fc.getSelectedFile();

			try {
				if (file.exists())
					mOfficeWriter.load(file.toURL().toString());
				else
					mOfficeWriter.load(OfficeWriter.NEW_DOCUMENT);
			}
			catch (Exception e) {
				e.printStackTrace(System.err);
			}
			mOfficeWriter.setObjectBarVisible(false);
		}
	}

	public static void main(String[] args)
	{
		DocViewer dv = new DocViewer();
		dv.initUI();
	}

	class ExitListener extends WindowAdapter
	{
		public void windowClosed(WindowEvent e)
		{
			if (mOfficeWriter != null)
				mOfficeWriter.closeConnection();
			System.exit(0);
		}

		public void windowClosing(WindowEvent e)
		{
			((Window)e.getSource()).dispose();
		}
	}

	class DocViewerChangeListener implements ChangeListener
	{
		public void stateChanged(ChangeEvent event)
		{
			String s = mOfficeWriter.getSelection();
			currentSelection.setText(s);
		}
	}
}
