/*************************************************************************
 *
 *  $RCSfile: fulegend.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: bm $ $Date: 2000/11/10 17:24:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#include <svx/svxids.hrc>

#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "attrib.hrc"
#include "attrib.hxx"
#include "unlegend.hxx"
#include "fulegend.hxx"

TYPEINIT1(SchFuLegend, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuLegend::SchFuLegend(SchViewShell* pViewSh, SchWindow* pWin,
						 SchView* pView, ChartModel* pDoc,
						 SfxRequest& rReq, Point &rMDPos)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	aMDPos       = rMDPos;

	const SfxItemSet* pArgs = rReq.GetArgs();

	if (!pArgs)
	{
		SfxItemSet aAttr(pDoc->GetFullLegendAttr());

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//		SchAttribTabDlg* pDlg =	new SchAttribTabDlg(&pViewSh->GetViewFrame()->GetWindow(),
//							                        ATTR_LEGEND, &aAttr,
//								                    pDoc->GetObjectShell(), pDoc,
//                                                    0, pDoc->ChartStyle());
		SchAttribTabDlg* pDlg =	new SchAttribTabDlg(NULL,
													ATTR_LEGEND, &aAttr,
													pDoc->GetObjectShell(), pDoc,
													0, pDoc->ChartStyle());

		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*pDlg->GetOutputItemSet());
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	SfxItemSet aOldAttr(pDoc->GetLegendAttr());

	pDoc->ChangeLegendAttr(*pArgs);//, TRUE);
	SchUndoLegend* pUndo = new SchUndoLegend(*pDoc, aOldAttr, *pArgs);
	pUndo->SetComment(String(SchResId(STR_UNDO_LEGEND)));
	pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuLegend::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuLegend::Deactivate()
{
}



