/*************************************************************************
 *
 *  $RCSfile: jvmdlg.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/15 14:33:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#ifndef _JVMDLG_HXX
#define _JVMDLG_HXX

#include <vcl/button.hxx>
#include <vcl/dialog.hxx>
#include <vcl/fixed.hxx>
#include <vcl/lstbox.hxx>
#include <vcl/group.hxx>
#include <vcl/window.hxx>
#include <vcl/tabpage.hxx>

#include <svtools/svmedit.hxx>

#include "sicustom.hxx"
#include "jvmscan.hxx"

class JVMDialog : public ModalDialog
{
private:
	OKButton					maOK;
	CancelButton				maCancel;
	HelpButton					maHelp;

	TabPage						maContainer;

	RadioButton					maRbtInstall;
	RadioButton					maRbtNoJava;
	RadioButton					maRbtUseExisting;

	ListBox						maJavaVMs;
	PushButton					maBrowse;

	FixedLine					maLine;

	FixedText					maInfoText;
	FixedText					maListboxText;
	FixedText					maJavaHomeText;
	FixedText					maBrowseText;

	MultiLineEdit				maHelpEdit;

	BOOL						bIsSetupMode;
	BOOL						bHelpMode;
	BOOL						bAbort;
	ResMgr*						pResMgr;
	Window*						pParent;

	SiCustomEnvironment*		pCustomEnv;
	SiCustomModuleList*			pModuleList;

	ByteString					aSourcePath;
	ByteString 					aDestPath;
	ByteString					aInstallPackage;
    ByteString                  aVersion;

    String                      maNoTermMsg;

    USHORT                      nJVMCount;

	DECL_STATIC_LINK( JVMDialog, ImplSelectionChanged, RadioButton * );
	DECL_LINK( HelpHdl, Button * );
	DECL_LINK( CancelHdl, CancelButton * );
	DECL_LINK( OKHdl, OKButton * );
	DECL_LINK( BrowseHdl, PushButton * );

	DECL_LINK( SelectHdl, ListBox *);

public:

	JVMDialog(	Window*					pParent,
				ResMgr*					pResMgr,
				SiCustomEnvironment*	pEnv,
				SiCustomModuleList*		pModList,
				ByteString				srcPath,
				ByteString				destPath,
				ByteString				instPackage,
                const ByteString&       version,
				BOOL					isSetupMode
			);
	~JVMDialog();

	virtual void StateChanged( StateChangedType nStateChange );

	BOOL isInstall();
	BOOL isUseExisting();
	BOOL isNoJava();

	void selectUseExisting( BOOL bSelect );
	void selectNoJava( BOOL bSelect );
	void selectInstall( BOOL bSelect );

    BOOL abort() { return bAbort; }

	SiCustomEnvironment* getCustomEnv() { return pCustomEnv; }

    String getNoTermMsg() const { return maNoTermMsg; }
	USHORT getEntryCount();

	BOOL insertEntry( const UniString& rEntry, ULONG pUserData);
	void clearList();
	BOOL getSelectedEntry( ULONG & pUserData );
	void selectEntry( USHORT nPos );

	void enableListBox( BOOL bEnable );

    void enableUseExistingRbt( BOOL bEnable );
	void enableInstallRbt( BOOL bEnable );
	
    void update( USHORT nCount, USHORT nSelect, const JVMEntry* pEntryList );
	void updateJavaHomeComment();

	void install();

    void selectInstalledJVM( USHORT nSelect );
};

#endif

