/*************************************************************************
 *
 *  $RCSfile: tplsetup.cxx,v $
 *
 *  $Revision: 1.20.114.2.2.5 $
 *
 *  last change: $Author: vg $ $Date: 2004/08/27 13:30:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000-2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#include <tools/solar.h>
#include <sifsys.hxx>
#include <tools/debug.hxx>
#include <tools/stream.hxx>
#include <tools/string.hxx>
#include <rtl/string.hxx>

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _OSL_MODULE_H_
#include <osl/module.h>
#endif

#ifndef _UTL_CONFIGMGR_HXX_
#include <unotools/configmgr.hxx>
#endif

#include "environ.hxx"

#include "sicustom.hxx"

#include <stdio.h>

#ifdef UNX
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <grp.h>
#endif


#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#include <tools/urlobj.hxx>
#include <tools/resid.hxx>
#include <tools/lang.hxx>
#include <tools/config.hxx>
#include <tools/isolang.hxx>

#include <vcl/resary.hxx>

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif

#ifndef  _UCBHELPER_CONTENT_HXX
#include <ucbhelper/content.hxx>
#endif
#ifndef  _UCBHELPER_CONTENTBROKER_HXX
#include <ucbhelper/contentbroker.hxx>
#endif

#ifndef  _COMPHELPER_REGPATHHELPER_HXX_
#include <comphelper/regpathhelper.hxx>
#endif
#ifndef	 _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif

#ifndef  _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef  _COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HPP_
#include <com/sun/star/beans/XPropertyContainer.hpp>
#endif
#ifndef  _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef  _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef  _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_XSTANDALONEDOCUMENTINFO_HPP_
#include <com/sun/star/document/XStandaloneDocumentInfo.hpp>
#endif
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#ifndef  _COM_SUN_STAR_IO_IOEXCEPTION_HPP_
#include <com/sun/star/io/IOException.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XPERSIST_HPP_
#include <com/sun/star/io/XPersist.hpp>
#endif

#ifndef  _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif

#ifndef  _COM_SUN_STAR_REGISTRY_XIMPLEMENTATIONREGISTRATION_HPP_
#include <com/sun/star/registry/XImplementationRegistration.hpp>
#endif

#ifndef  _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef  _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCOMMANDENVIRONMENT_HPP_
#include <com/sun/star/ucb/XCommandEnvironment.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include <com/sun/star/ucb/XContent.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include "tplsetup.hrc"

//------------------------------------------------------------------------

#define HIERARCHIE_ROOT_URL		"vnd.sun.star.hier:/"
#define TEMPLATE_ROOT_URL		"vnd.sun.star.hier:/templates/"
#define TEMPLATE_DIR_NAME		"templates"
#define TITLE					"Title"
#define MIME_TYPE				"MIMEType"
#define IS_FOLDER				"IsFolder"
#define PROPERTY_TYPE			"TypeDescription"
#define TARGET_URL				"TargetURL"
#define TYPE_FOLDER				"application/vnd.sun.star.hier-folder"
#define TYPE_LINK				"application/vnd.sun.star.hier-link"
#define TYPE_FSYS_FOLDER		"application/vnd.sun.staroffice.fsys-folder"

#define TARGET_DIR_URL			"TargetDirURL"
#define COMMAND_DELETE			"delete"
#define COMMAND_TRANSFER		"transfer"

#define STANDARD_FOLDER			"standard"

#define SERVICENAME_DOCINFO		"com.sun.star.document.DocumentProperties"
#define WFS_URL					"vnd.sun.star.wfs:///inst"

#define	C_DELIM					';'


//------------------------------------------------------------------------

#define STRPOS_NOTFOUND					-1

#define ASCII_STR(s)					OUString( RTL_CONSTASCII_USTRINGPARAM(s) )

#define	SIGN_STARTVARIABLE				ASCII_STR("$(")
#define	SIGN_ENDVARIABLE				ASCII_STR(")")

#define	SUBSTITUTE_VLANG				ASCII_STR("$(vlang)")
#define	REPLACELENGTH_VLANG				8

// Strings to replace $(vlang)
#define	REPLACEMENT_ARABIC				ASCII_STR("arabic")
#define REPLACEMENT_BASQUE				ASCII_STR("basque")
#define	REPLACEMENT_CZECH				ASCII_STR("czech")
#define	REPLACEMENT_DANISH				ASCII_STR("danish")
#define	REPLACEMENT_DUTCH				ASCII_STR("dutch")
#define	REPLACEMENT_ENGLISH				ASCII_STR("english")
#define	REPLACEMENT_ESTONIAN				ASCII_STR("estonian")
#define	REPLACEMENT_FINNISH				ASCII_STR("finnish")
#define	REPLACEMENT_FRENCH				ASCII_STR("french")
#define	REPLACEMENT_GERMAN				ASCII_STR("german")
#define	REPLACEMENT_GREEK				ASCII_STR("greek")
#define	REPLACEMENT_HEBREW				ASCII_STR("hebrew")
#define	REPLACEMENT_ITALIAN				ASCII_STR("italian")
#define	REPLACEMENT_JAPANESE				ASCII_STR("japanese")
#define	REPLACEMENT_KOREAN				ASCII_STR("korean")
#define	REPLACEMENT_LITHUANIAN				ASCII_STR("lithuanian")
#define	REPLACEMENT_POLISH				ASCII_STR("polish")
#define	REPLACEMENT_RUSSIAN				ASCII_STR("russian")
#define	REPLACEMENT_SLOVAK				ASCII_STR("slovak")
#define	REPLACEMENT_SPANISH				ASCII_STR("spanish")
#define	REPLACEMENT_GALICIAN				ASCII_STR("galician")
#define	REPLACEMENT_SWEDISH				ASCII_STR("swedish")
#define	REPLACEMENT_TURKISH				ASCII_STR("turkish")
#define	REPLACEMENT_NORWEGIAN				ASCII_STR("norwegian")
#define	REPLACEMENT_NORWEGIAN_NYNORSK			ASCII_STR("norwegian_nynorsk")
#define	REPLACEMENT_HUNGARIAN				ASCII_STR("hungarian")
#define	REPLACEMENT_BULGARIAN				ASCII_STR("bulgarian")
#define	REPLACEMENT_CHINESE_TRADITIONAL			ASCII_STR("chinese_traditional")
#define	REPLACEMENT_CHINESE_SIMPLIFIED			ASCII_STR("chinese_simplified")
#define	REPLACEMENT_PORTUGUESE				ASCII_STR("portuguese")
#define	REPLACEMENT_SLOVENIAN				ASCII_STR("slovenian")
#define	REPLACEMENT_WELSH				ASCII_STR("welsh")
#define REPLACEMENT_AFRIKAANS				ASCII_STR("afrikaans")
#define REPLACEMENT_NORTHERNSOTHO			ASCII_STR("northernsotho")
#define REPLACEMENT_ZULU				ASCII_STR("zulu")
#define REPLACEMENT_TSWANA				ASCII_STR("tswana")
#define REPLACEMENT_KANNADA				ASCII_STR("kannada")

//------------------------------------------------------------------------

using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::document;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::uno;

using namespace comphelper;
using namespace cppu;
using namespace ucb;
using namespace rtl;

//------------------------------------------------------------------------

struct NamePair_Impl
{
	OUString maShortName;
	OUString maLongName;
};

DECLARE_LIST( NameList_Impl, NamePair_Impl* );

//------------------------------------------------------------------------

//

class Hierarchy_Impl
{
	Reference< XMultiServiceFactory >	 mxFactory;
	Reference< XContentProviderManager > mxUcb;
	Reference< XInterface >				 mxConfig;
	Reference< XPersist >				 mxInfo;
	NameList_Impl						 maNames;
	SiCustomEnvironment					*mpEnv;
	OUString							 mnSubstSource;
	OUString							 mnSubstDest;
	sal_Bool							 mbSubstTarget;

private:
	void				InitializeUCB();
	sal_Bool			GetTemplateRoot( Content &rTemplRoot,
										 sal_Bool &rNew,
										 LanguageType nLanguage ) const;
	sal_Bool			GetTemplateDir( const OUString& rTplDirURL, Content &rTemplateDir ) const;
	OUString			GetTemplateDirs( USHORT nLangId ) const;
	void				GetFolders( Content& rRoot, Content& rFolder );
	void				GetTemplates( Content& rTargetFolder, Content& rParentFolder );
	void				AddToStandard( Content& rRoot, Content& rFolder );
	OUString			GetLongName( const OUString& rShortName );
	BOOL				GetTitleFromURL( const OUString& rURL, OUString& aTitle, OUString& aType );
	void				AddEntry( Content& rParentFolder,
								  const OUString& rTitle,
								  const OUString& rType,
								  const OUString& rTargetURL );

	void				ReadFolderList( LanguageType nLanguage );
	ResMgr*				GetResourceManager( const ByteString resName,
										    const ByteString resPath,
											const LanguageType langType );
	OUString			SubstituteVariable( const OUString& rVar, USHORT nLangId ) const;
	LanguageType		ConvertLanguage( USHORT nID ) const;
	OUString			SubstituteTargetURL( const OUString& rTargetURL ) const;
	void				ClearNames();

public:
						Hierarchy_Impl( SiCustomEnvironment* pEnv );
						~Hierarchy_Impl();

	sal_Bool			CreateHierarchy( USHORT nLangId );
};

LanguageType Hierarchy_Impl::ConvertLanguage( USHORT nID ) const
{
	switch ( nID )
	{
		case 01: return LANGUAGE_ENGLISH_US;
		case 02: return LANGUAGE_FRENCH_CANADIAN;
		case 03: return LANGUAGE_PORTUGUESE;
		case 07: return LANGUAGE_RUSSIAN;
		case 10: return LANGUAGE_BASQUE;
		case 26: return LANGUAGE_NORTHERNSOTHO;
		case 27: return LANGUAGE_AFRIKAANS;
		case 28: return LANGUAGE_ZULU;
		case 29: return LANGUAGE_TSWANA;
		case 30: return LANGUAGE_GREEK;
		case 31: return LANGUAGE_DUTCH;
		case 33: return LANGUAGE_FRENCH;
		case 34: return LANGUAGE_SPANISH;
        case 35: return LANGUAGE_FINNISH;
		case 36: return LANGUAGE_HUNGARIAN;
        case 37: return LANGUAGE_CATALAN;
       		case 38: return LANGUAGE_GALICIAN;
		case 39: return LANGUAGE_ITALIAN;
		case 42: return LANGUAGE_CZECH;
		case 43: return LANGUAGE_SLOVAK;
		case 44: return LANGUAGE_ENGLISH;
		case 45: return LANGUAGE_DANISH;
		case 46: return LANGUAGE_SWEDISH;
		case 47: return LANGUAGE_NORWEGIAN;
		case 48: return LANGUAGE_POLISH;
		case 49: return LANGUAGE_GERMAN;
		case 50: return LANGUAGE_SLOVENIAN;
		case 53: return LANGUAGE_WELSH;
		case 55: return LANGUAGE_PORTUGUESE_BRAZILIAN;
		case 58: return LANGUAGE_LITHUANIAN;
		case 61: return LANGUAGE_ENGLISH_AUS;
        case 66: return LANGUAGE_THAI;
        	case 77: return LANGUAGE_ESTONIAN;
		case 79: return LANGUAGE_NORWEGIAN_NYNORSK;
		case 81: return LANGUAGE_JAPANESE;
		case 82: return LANGUAGE_KOREAN;
		case 86: return LANGUAGE_CHINESE_SIMPLIFIED;
		case 88: return LANGUAGE_CHINESE_TRADITIONAL;
		case 90: return LANGUAGE_TURKISH;
        case 91: return LANGUAGE_HINDI;
		case 93: return LANGUAGE_KANNADA;
		case 96: return LANGUAGE_ARABIC;
		case 97: return LANGUAGE_HEBREW;
		default: return LANGUAGE_ENGLISH_US;
	}
}



//------------------------------------------------------------------------
Hierarchy_Impl::Hierarchy_Impl( SiCustomEnvironment* pEnv )
{
	mbSubstTarget = sal_False;
	mpEnv = pEnv;
	InitializeUCB();

	SiEnvironment *pBigEnv = pEnv->GetBigEnv();

	USHORT nStep = pBigEnv->GetResponseStep();

	if ( nStep == 2 )
	{
		// the share path comes next
		INetURLObject aURL;
		mnSubstSource = OUString::createFromAscii( mpEnv->GetDestPath().GetBuffer() );
		aURL.SetSmartProtocol( INET_PROT_FILE );
		aURL.SetSmartURL( mnSubstSource );

		mnSubstSource = aURL.GetMainURL(INetURLObject::NO_DECODE);

		mnSubstDest	  = OUString( RTL_CONSTASCII_USTRINGPARAM( WFS_URL ) );
		mbSubstTarget = sal_True;
	}
}

//------------------------------------------------------------------------
Hierarchy_Impl::~Hierarchy_Impl()
{
	ClearNames();
}

//------------------------------------------------------------------------
void Hierarchy_Impl::ClearNames()
{
	NamePair_Impl *pData = maNames.First();

	while ( pData )
	{
		delete pData;
		pData = maNames.Next();
	}
}


//------------------------------------------------------------------------
OUString Hierarchy_Impl::SubstituteTargetURL( const OUString& rTargetURL ) const
{
	OUString aTargetURL;

	if ( mbSubstTarget )
	{
		long nStart = rTargetURL.indexOf( mnSubstSource );
		if ( nStart != -1 )
			aTargetURL = rTargetURL.replaceAt( nStart,
											   mnSubstSource.getLength(),
											   mnSubstDest );
		else
			aTargetURL = rTargetURL;
	}
	else
		aTargetURL = rTargetURL;

	return aTargetURL;
}

//------------------------------------------------------------------------
sal_Bool Hierarchy_Impl::CreateHierarchy( USHORT nLangId )
{
	Content		aTemplRoot;
	sal_Bool	bNewRoot;

	LanguageType nLanguage = ConvertLanguage( nLangId );

	if ( ! GetTemplateRoot( aTemplRoot, bNewRoot, nLanguage ) )
		return sal_False;

	if ( !bNewRoot )
		return sal_True;

	ReadFolderList( nLanguage );

	OUString aDirs = GetTemplateDirs( nLangId );

    sal_Int32 nIndex = 0;
    while( nIndex != -1 )
	{
		Content aTemplDir;
		OUString aTplDirURL = aDirs.getToken( 0, C_DELIM, nIndex );

		if ( GetTemplateDir( aTplDirURL, aTemplDir ) )
			GetFolders( aTemplRoot, aTemplDir );
	}

	return sal_True;
}

// -----------------------------------------------------------------------

sal_Bool Hierarchy_Impl::GetTemplateRoot( Content &rTemplRoot,
										  sal_Bool &rNew,
										  LanguageType nLanguage ) const
{
	Reference < XCommandEnvironment > aCmdEnv;
	OUString	aTemplRootURL( RTL_CONSTASCII_USTRINGPARAM( TEMPLATE_ROOT_URL ) );
	OUString	aIsoString;
	OUString	aCountry;
	sal_Bool	bRet;

	bRet = sal_False;
	rNew = sal_False;

	aIsoString = ConvertLanguageToIsoString( nLanguage );
	aTemplRootURL += aIsoString;

	if ( Content::create( aTemplRootURL, aCmdEnv, rTemplRoot ) )
	{
		bRet = sal_True;
	}
	else
	{
		try
		{
			Sequence< OUString > aNames(2);
			OUString* pNames = aNames.getArray();
			pNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
			pNames[1] = OUString( RTL_CONSTASCII_USTRINGPARAM( IS_FOLDER ) );

			Sequence< Any > aValues(2);
			Any* pValues = aValues.getArray();
			pValues[1] = makeAny( sal_Bool( sal_True ) );

			OUString aType( RTL_CONSTASCII_USTRINGPARAM( TYPE_FOLDER ) );
			OUString aLangRootURL( RTL_CONSTASCII_USTRINGPARAM( HIERARCHIE_ROOT_URL ) );
			aLangRootURL += OUString( RTL_CONSTASCII_USTRINGPARAM( TEMPLATE_DIR_NAME ) );

			Content aLangRoot;

			if ( ! Content::create( aLangRootURL, aCmdEnv, aLangRoot ) )
			{
				OUString aHierRootURL( RTL_CONSTASCII_USTRINGPARAM( HIERARCHIE_ROOT_URL ) );
				Content aHierRoot( aHierRootURL, aCmdEnv );

				pValues[0] = makeAny( OUString( RTL_CONSTASCII_USTRINGPARAM( TEMPLATE_DIR_NAME ) ) );
				aHierRoot.insertNewContent( aType, aNames, aValues, aLangRoot );
			}

			pValues[0] = makeAny( aIsoString );

			bRet = aLangRoot.insertNewContent( aType, aNames, aValues, rTemplRoot );
			rNew = sal_True;
		}
		catch( ContentCreationException& )
		{
			DBG_ERRORFILE( "ContentCreationException" );
		}
		catch( Exception& )
        {}
	}

	return bRet;
}

// -----------------------------------------------------------------------

sal_Bool Hierarchy_Impl::GetTemplateDir( const OUString& rTplDirURL,
										 Content &rTemplateDir ) const
{
	INetURLObject	aURL;
	sal_Bool		bRet = sal_True;

	aURL.SetSmartProtocol( INET_PROT_FILE );
	aURL.SetURL( rTplDirURL );

	Reference< XCommandEnvironment > aCmdEnv;

	if ( ! Content::create( aURL.GetMainURL(INetURLObject::NO_DECODE), aCmdEnv, rTemplateDir ) )
	{
		DBG_ERRORFILE( "GetTemplateDir(): Template directory doesn't exist" );
		bRet = sal_False;
	}

	return bRet;
}

// -----------------------------------------------------------------------

OUString Hierarchy_Impl::GetTemplateDirs( USHORT nLangId ) const
{
	// doesn't work right now
//	::utl::ConfigManager aOwnManager(Reference< XMultiServiceFactory>(mxConfig, UNO_QUERY));
//	return SvtPathOptions(aOwnManager).GetTemplatePath();

	OUString aFullPath, aPath;
	INetURLObject aURL;

	// user path comes first ( but this might change in the future )
	aPath = OUString::createFromAscii( mpEnv->GetDestPath().GetBuffer() );
	aURL.SetSmartProtocol( INET_PROT_FILE );
	aURL.SetSmartURL( aPath );
	aURL.insertName( OUString::createFromAscii( "user" ), false,
					  INetURLObject::LAST_SEGMENT, true,
					  INetURLObject::ENCODE_ALL );
	aURL.insertName( OUString::createFromAscii( "template" ), false,
					  INetURLObject::LAST_SEGMENT, true,
					  INetURLObject::ENCODE_ALL );
	aFullPath = aURL.GetMainURL(INetURLObject::NO_DECODE);
	aFullPath += OUString( C_DELIM );

	// the share path comes next
	aPath = OUString::createFromAscii( mpEnv->GetDestPath().GetBuffer() );
	aURL.SetSmartProtocol( INET_PROT_FILE );
	aURL.SetSmartURL( aPath );
	aURL.insertName( OUString::createFromAscii( "share" ), false,
					  INetURLObject::LAST_SEGMENT, true,
					  INetURLObject::ENCODE_ALL );
	aURL.insertName( OUString::createFromAscii( "template" ), true,
					  INetURLObject::LAST_SEGMENT, true,
					  INetURLObject::ENCODE_ALL );

	aPath = aURL.GetMainURL(INetURLObject::NO_DECODE);
	aPath += OUString::createFromAscii( "$(vlang)" );

	aPath = SubstituteVariable( aPath, nLangId );

	aFullPath += aPath;

	return aFullPath;
}

// -----------------------------------------------------------------------

void Hierarchy_Impl::GetFolders( Content& rRoot,
								 Content& rFolder )
{
	Reference< XResultSet > xResultSet;
	Sequence< OUString > aProps(1);
	OUString* pProps = aProps.getArray();
	pProps[0] = OUString::createFromAscii( TITLE );

	AddToStandard( rRoot, rFolder );

	try
	{
		ResultSetInclude eInclude =	INCLUDE_FOLDERS_ONLY;
		xResultSet = rFolder.createCursor( aProps, eInclude );
	}
	catch ( Exception& ) {}

	if ( xResultSet.is() )
	{
		Reference< XCommandEnvironment > aCmdEnv;
		Reference< XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
		Reference< XRow > xRow( xResultSet, UNO_QUERY );

		OUString aFolderURL = rFolder.get()->getIdentifier()->getContentIdentifier();
		OUString aRootURL = rRoot.get()->getIdentifier()->getContentIdentifier();
		aRootURL += OUString( '/' );

		Content aFolder;
		Sequence< OUString > aNames(2);
		OUString* pNames = aNames.getArray();
		pNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
		pNames[1] = OUString( RTL_CONSTASCII_USTRINGPARAM( IS_FOLDER ) );

		Sequence< OUString > aAdditionalProps(1);
		pNames = aAdditionalProps.getArray();
		pNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TARGET_DIR_URL ) );

		Sequence< Any > aValues(2);
		Any* pValues = aValues.getArray();

		OUString aType = OUString( RTL_CONSTASCII_USTRINGPARAM( TYPE_FOLDER ) );

		try
		{
			while ( xResultSet->next() )
			{
				OUString	aTitle( xRow->getString(1) );

				if ( aTitle.compareToAscii( "wizard" ) == 0 )
					continue;
				else if ( aTitle.compareToAscii( "internal" ) == 0 )
					continue;

				aTitle = GetLongName( aTitle );

				INetURLObject aNewFolderObj( aRootURL );
				aNewFolderObj.insertName( aTitle, false,
					  INetURLObject::LAST_SEGMENT, true,
					  INetURLObject::ENCODE_ALL );

				OUString aNewFolderURL = aNewFolderObj.GetMainURL(INetURLObject::NO_DECODE);
				OUString aTargetURL = xContentAccess->queryContentIdentifierString();

				aTargetURL = SubstituteTargetURL( aTargetURL );

				if ( ! Content::create( aNewFolderURL, aCmdEnv, aFolder ) )
				{
					pValues[0] = makeAny( aTitle );
					pValues[1] = makeAny( sal_Bool( sal_True ) );

					try
					{
						rRoot.insertNewContent( aType, aNames, aValues, aFolder );
						Reference< XPropertySetInfo > xPropSet = aFolder.getProperties();
						if ( xPropSet.is() )
						{
							pNames = aAdditionalProps.getArray();

							if ( ! xPropSet->hasPropertyByName( pNames[0] ) )
							{
								Reference< XPropertyContainer > xFolderProp( aFolder.get(), UNO_QUERY );
								if ( xFolderProp.is() )
								{
									try
									{
										xFolderProp->addProperty( pNames[0], PropertyAttribute::MAYBEVOID,
																  makeAny( aTargetURL ) );
									}
									catch( PropertyExistException& ) {}
									catch( IllegalTypeException& ) { DBG_ERRORFILE( "IllegalTypeException" ); }
									catch( IllegalArgumentException& ) { DBG_ERRORFILE( "IllegalArgumentException" ); }
								}
							}

							Sequence< Any > aPropValues(1);
							Any* pPropValues = aPropValues.getArray();

							pPropValues[0] = makeAny( aTargetURL );

							aFolder.setPropertyValues( aAdditionalProps, aPropValues );
						}
					}
					catch( Exception& )
                    {}
				}

				Content aSubFolder( xContentAccess->queryContent(), aCmdEnv );
				GetTemplates( aSubFolder, aFolder );
			}
		}
		catch ( Exception& ) {}
	}
}

// -----------------------------------------------------------------------

void Hierarchy_Impl::AddToStandard( Content& rRoot,
									Content& rFolder )
{
	OUString aTitle( RTL_CONSTASCII_USTRINGPARAM( STANDARD_FOLDER ) );

	aTitle = GetLongName( aTitle );

	OUString aRootURL = rRoot.get()->getIdentifier()->getContentIdentifier();
	OUString aFolderURL = rFolder.get()->getIdentifier()->getContentIdentifier();
	aFolderURL = SubstituteTargetURL( aFolderURL );

	INetURLObject aNewFolderObj( aRootURL );
	aNewFolderObj.insertName( aTitle, false,
		  INetURLObject::LAST_SEGMENT, true,
		  INetURLObject::ENCODE_ALL );
	
	OUString aNewFolderURL = aNewFolderObj.GetMainURL(INetURLObject::NO_DECODE);
	Content aFolder;

	Reference< XCommandEnvironment > aCmdEnv;

	if ( ! Content::create( aNewFolderURL, aCmdEnv, aFolder ) )
	{
		OUString aType = OUString( RTL_CONSTASCII_USTRINGPARAM( TYPE_FOLDER ) );

		Sequence< OUString > aNames(2);
		OUString* pNames = aNames.getArray();
		pNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
		pNames[1] = OUString( RTL_CONSTASCII_USTRINGPARAM( IS_FOLDER ) );

		Sequence< OUString > aAdditionalProps(1);
		pNames = aAdditionalProps.getArray();
		pNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TARGET_DIR_URL ) );

		Sequence< Any > aValues(2);
		Any* pValues = aValues.getArray();

		pValues[0] = makeAny( aTitle );
		pValues[1] = makeAny( sal_Bool( sal_True ) );
			
		try
		{
			rRoot.insertNewContent( aType, aNames, aValues, aFolder );
			Reference< XPropertySetInfo > xPropSet = aFolder.getProperties();
			if ( xPropSet.is() )
			{
				pNames = aAdditionalProps.getArray();

				if ( ! xPropSet->hasPropertyByName( pNames[0] ) )
				{
					Reference< XPropertyContainer > xFolderProp( aFolder.get(), UNO_QUERY );
					if ( xFolderProp.is() )
					{
						try
						{
							xFolderProp->addProperty( pNames[0], PropertyAttribute::MAYBEVOID,
													  makeAny( aFolderURL ) );
						}
						catch( PropertyExistException& ) {}
						catch( IllegalTypeException& ) { DBG_ERRORFILE( "IllegalTypeException" ); }
						catch( IllegalArgumentException& ) { DBG_ERRORFILE( "IllegalArgumentException" ); }
					}
				}

				Sequence< Any > aPropValues(1);
				Any* pPropValues = aPropValues.getArray();

				pPropValues[0] = makeAny( aFolderURL );

				aFolder.setPropertyValues( aAdditionalProps, aPropValues );
			}
		}
		catch( Exception& )
        {}
	}

	GetTemplates( rFolder, aFolder );
}

// -----------------------------------------------------------------------

void Hierarchy_Impl::GetTemplates( Content& rTargetFolder,
								   Content& rParentFolder )
{
	Reference< XResultSet >	xResultSet;
	Sequence< OUString >	aProps(1);
	OUString* pProps = aProps.getArray();

	pProps[0] = OUString::createFromAscii( TITLE );

	try
	{
		ResultSetInclude eInclude =	INCLUDE_DOCUMENTS_ONLY;
		xResultSet = rTargetFolder.createCursor( aProps, eInclude );
	}
	catch ( Exception& ) {}

	if ( xResultSet.is() )
	{
		Reference< XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
		Reference< XRow > xRow( xResultSet, UNO_QUERY );

		try
		{
			while ( xResultSet->next() )
			{
				OUString aTitle( xRow->getString(1) );

				if ( aTitle.compareToAscii( "sfx.tlx" ) == 0 )
					continue;

				OUString aId = xContentAccess->queryContentIdentifierString();
				OUString aFullTitle;
				OUString aType;

				GetTitleFromURL( aId, aFullTitle, aType );

				if ( aFullTitle.getLength() )
					aTitle = aFullTitle;

				AddEntry( rParentFolder, aTitle, aType, aId );
			}
		}
		catch ( Exception& ) {}
	}
}

// -----------------------------------------------------------------------
void Hierarchy_Impl::AddEntry( Content& rParentFolder,
							   const OUString& rTitle,
							   const OUString& rType,
							   const OUString& rTargetURL )
{
	Content aLink;
	Reference< XCommandEnvironment > aCmdEnv;
	OUString aFolderURL = rParentFolder.get()->getIdentifier()->getContentIdentifier();
	INetURLObject aLinkObj( aFolderURL );

	aLinkObj.insertName( rTitle, false,
					  INetURLObject::LAST_SEGMENT, true,
					  INetURLObject::ENCODE_ALL );

	OUString aLinkURL = aLinkObj.GetMainURL(INetURLObject::NO_DECODE);

	if ( ! Content::create( aLinkURL, aCmdEnv, aLink ) )
	{
		OUString aTargetURL = SubstituteTargetURL( rTargetURL );

		Sequence< OUString > aNames(3);
		OUString* pNames = aNames.getArray();
		pNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
		pNames[1] = OUString( RTL_CONSTASCII_USTRINGPARAM( IS_FOLDER ) );
		pNames[2] = OUString( RTL_CONSTASCII_USTRINGPARAM( TARGET_URL ) );

		Sequence< Any > aValues(3);
		Any* pValues = aValues.getArray();
		pValues[0] = makeAny( rTitle );
		pValues[1] = makeAny( sal_Bool( sal_False ) );
		pValues[2] = makeAny( aTargetURL );

		OUString aType( RTL_CONSTASCII_USTRINGPARAM( TYPE_LINK ) );

		try
		{
			rParentFolder.insertNewContent( aType, aNames, aValues, aLink );
			Reference< XPropertySetInfo > xPropSet = aLink.getProperties();

			if ( xPropSet.is() )
			{
				Sequence< OUString > aAdditionalProps(1);
				Sequence< Any > aPropValues(1);

				OUString* pPropNames = aAdditionalProps.getArray();
				Any* pPropValues = aPropValues.getArray();

				pPropNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( PROPERTY_TYPE ) );
				pPropValues[0] = makeAny( rType );

				if ( ! xPropSet->hasPropertyByName( pPropNames[0] ) )
				{
					Reference< XPropertyContainer > xFolderProp( aLink.get(), UNO_QUERY );
					if ( xFolderProp.is() )
					{
						try
						{
							xFolderProp->addProperty( pPropNames[0], PropertyAttribute::MAYBEVOID,
													  makeAny( rType ) );
						}
						catch( PropertyExistException& ) {}
						catch( IllegalTypeException& ) { DBG_ERRORFILE( "IllegalTypeException" ); }
						catch( IllegalArgumentException& ) { DBG_ERRORFILE( "IllegalArgumentException" ); }
					}
				}

				aLink.setPropertyValues( aAdditionalProps, aPropValues );
			}
		}
		catch( Exception& )
        {}
	}
}

// -----------------------------------------------------------------------
void Hierarchy_Impl::ReadFolderList( LanguageType nLanguage )
{
	ByteString	aResFileName("tplx");
	aResFileName += MAKE_NUMSTR( SUPD );

	ByteString aStartPath = mpEnv->GetStartPath();

	ResMgr* pResMgr = GetResourceManager( aResFileName, aStartPath, nLanguage );

	if (!pResMgr)
	{
		nLanguage = LANGUAGE_ENGLISH;
		pResMgr = GetResourceManager( aResFileName, aStartPath, nLanguage );
	}

	if ( ! pResMgr )
	{
		return;
	}
	
	ClearNames();
	
	ResStringArray	aShortNames( ResId( TEMPLATE_SHORT_NAMES_ARY, pResMgr ) );
	ResStringArray	aLongNames( ResId( TEMPLATE_LONG_NAMES_ARY, pResMgr ) );

	NamePair_Impl*	pPair;

	USHORT nCount = Min( aShortNames.Count(), aLongNames.Count() );

	for ( USHORT i=0; i<nCount; i++ )
	{
		pPair = new NamePair_Impl;
		pPair->maShortName	= aShortNames.GetString( i );
		pPair->maLongName	= aLongNames.GetString( i );

		maNames.Insert( pPair, LIST_APPEND );
	}
}

// -----------------------------------------------------------------------
OUString Hierarchy_Impl::GetLongName( const OUString& rShortName )
{
	OUString		 aRet;
	NamePair_Impl	*pPair = maNames.First();

	while ( pPair )
	{
		if ( pPair->maShortName == rShortName )
		{
			aRet = pPair->maLongName;
			break;
		}
		else
			pPair = maNames.Next();
	}

	if ( !aRet.getLength() )
		aRet = rShortName;

	return aRet;
}

// -----------------------------------------------------------------------
BOOL Hierarchy_Impl::GetTitleFromURL( const OUString& rURL,
									  OUString& rTitle,
									  OUString& rType )
{
	BOOL bRet = sal_True;

	if ( mxInfo.is() )
	{
		try
		{
			mxInfo->read( rURL );

			Reference< XPropertySet > aPropSet( mxInfo, UNO_QUERY );
			if ( aPropSet.is() )
			{
				OUString aPropName( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
				Any aValue = aPropSet->getPropertyValue( aPropName );
				aValue >>= rTitle;

				aPropName = OUString( RTL_CONSTASCII_USTRINGPARAM( MIME_TYPE ) );
				aValue = aPropSet->getPropertyValue( aPropName );
				aValue >>= rType;
			}
		}
		catch ( IOException& ) { bRet = sal_False; }
		catch ( UnknownPropertyException& ) { bRet = sal_False; }
		catch ( Exception& ) { bRet = sal_False; }
	}
	else
		 bRet = sal_False; 

	return bRet;
}

// -----------------------------------------------------------------------
ResMgr* Hierarchy_Impl::GetResourceManager( const ByteString resName,
										    const ByteString resPath,
											const LanguageType langType )
{
	ResMgr* pResMgr;
    LanguageType eLangType = langType;

	pResMgr = NULL;
	SiDirEntry resource( resPath );
	resource += SiDirEntry( resName );
	pResMgr	  = ResMgr::SearchCreateResMgr( resource.GetFull().GetBuffer(), eLangType );

	if ( !pResMgr )
	{
		SiDirEntry resource( resPath );
		resource += SiDirEntry( "resource" );
		resource += SiDirEntry( resName );

		pResMgr	  = ResMgr::SearchCreateResMgr( resource.GetFull().GetBuffer(), eLangType );
	}

	return pResMgr;
};

void Hierarchy_Impl::InitializeUCB()
{

	try
	{
		OUString aPath = OUString::createFromAscii( mpEnv->GetDestPath().GetBuffer() );
        OUString aServicesRDB = aPath;
#ifdef UNIX
		aPath += OUString::createFromAscii( "/program/types.rdb" );
        aServicesRDB += OUString::createFromAscii( "/program/services.rdb" );
#else
		aPath += OUString::createFromAscii( "\\program\\types.rdb" );
        aServicesRDB += OUString::createFromAscii( "\\program\\services.rdb" );
#endif
		//////////////////////////////////////////////////////////////////////
		// Bootstrap readonly service factory
		Reference< XMultiServiceFactory > xSMgr( createRegistryServiceFactory( aPath, sal_True ) );

		if ( !xSMgr.is() )
			return;

		//////////////////////////////////////////////////////////////////////
		// set global factory
		setProcessServiceFactory( xSMgr );

		SiEnvironment *pBigEnv = mpEnv->GetBigEnv();

		if( pBigEnv->IsResponsefileMode() && pBigEnv->GetResponseStep() == 2 )
		{
			try
			{
				Config aCfg( UniString( pBigEnv->GetResponseFilename(), osl_getThreadTextEncoding() ) );
				aCfg.SetGroup( "Portal" );
				ByteString aAdminPass = aCfg.ReadKey( "ConfigPasswordUserAdmin" );

				Sequence< Any > aCPArgs(3);
				Any aAny;

				aAny <<= ::rtl::OUString::createFromAscii( "Administrator" );
				PropertyValue aPropVal( ::rtl::OUString::createFromAscii("user"), -1, aAny, PropertyState_DIRECT_VALUE );
				aCPArgs[0] <<= aPropVal;

				aAny <<= ::rtl::OUString::createFromAscii( aAdminPass.GetBuffer() );
				aPropVal = PropertyValue( ::rtl::OUString::createFromAscii("password"), -1, aAny, PropertyState_DIRECT_VALUE );
				aCPArgs[1] <<= aPropVal;

				aAny <<= ::rtl::OUString::createFromAscii( "portal" );
				aPropVal = PropertyValue( ::rtl::OUString::createFromAscii("servertype"), -1, aAny, PropertyState_DIRECT_VALUE );
				aCPArgs[2] <<= aPropVal;

				mxConfig = xSMgr->createInstanceWithArguments( 
					OUString::createFromAscii( "com.sun.star.configuration.AdministrationProvider" ),
					aCPArgs );
			}
			catch(RuntimeException& e) {
				return;
			}
			catch(Exception& e) {
				return;
			}
		}
		else
		{
			// create config provider
			OUString aRegPath = OUString::createFromAscii( mpEnv->GetDestPath().GetBuffer() );
#ifdef UNIX
			aRegPath += OUString::createFromAscii( "/share/config/registry" );
#else
			aRegPath += OUString::createFromAscii( "\\share\\config\\registry" );
#endif
			Sequence< Any > aConfArgs( 2 );
			PropertyValue aProp;
			aProp.Name = OUString::createFromAscii( "servertype" );
			aProp.Value <<= OUString::createFromAscii( "setup" );
			aConfArgs[ 0 ] <<= aProp;

			aProp.Name = OUString::createFromAscii( "sourcepath" );
			aProp.Value <<= aRegPath;
			aConfArgs[ 1 ] <<= aProp;

			mxConfig = xSMgr->createInstanceWithArguments( 
				OUString::createFromAscii( "com.sun.star.configuration.ConfigurationProvider" ),
				aConfArgs );
		}

		// Create unconfigured Ucb:
		Sequence< Any > aArg;
		ucb::ContentBroker::initialize( xSMgr, aArg );
		mxUcb = ucb::ContentBroker::get()->getContentProviderManagerInterface();

		Sequence< Any > aArgs( 1 );
		aArgs[ 0 ] <<= mxConfig;

		Reference< XInterface > xUcbStore =
			xSMgr->createInstanceWithArguments( OUString::createFromAscii( "com.sun.star.ucb.Store" ), aArgs );

		Reference< XContentProvider > xHierProvider
			( xSMgr->createInstanceWithArguments( OUString::createFromAscii( "com.sun.star.ucb.HierarchyContentProvider" ), aArgs ), UNO_QUERY );
		mxUcb->registerContentProvider( xHierProvider, OUString::createFromAscii( "vnd.sun.star.hier" ), sal_True );

		Reference< XContentProvider > xFileProvider
			( xSMgr->createInstance( OUString::createFromAscii( "com.sun.star.ucb.FileContentProvider" ) ), UNO_QUERY );
		mxUcb->registerContentProvider( xFileProvider, OUString::createFromAscii( "file" ), sal_True );

	}
	catch( Exception & rEx)
	{
		DBG_ERROR( ByteString( String( rEx.Message ), RTL_TEXTENCODING_ASCII_US).GetBuffer() )
		throw;
	}
	catch( ... )
	{
		DBG_ERROR( "unknown exception occured" )
		throw;
	}

	// we need the docinfo service, too
	OUString aService( RTL_CONSTASCII_USTRINGPARAM( SERVICENAME_DOCINFO ) );

	mxFactory = ::comphelper::getProcessServiceFactory();
	Reference< XPersist > xInfo( mxFactory->createInstance( aService ), UNO_QUERY );
	mxInfo = xInfo;
}

// -----------------------------------------------------------------------

OUString Hierarchy_Impl::SubstituteVariable( const OUString& rVar,
											 USHORT nLangId ) const
{
	// Don't work at parameter-string directly. Copy it.
	OUString aWorkText = rVar;

	// Search for first occure of "$(...".
	sal_Int32 nPosition	= aWorkText.indexOf( SIGN_STARTVARIABLE );	// = first position of "$(" in string
	sal_Int32 nLength = 0; // = count of letters from "$(" to ")" in string

	// Have we found any variable like "$(...)"?
	if ( nPosition != STRPOS_NOTFOUND )
	{
		// Yes; Get length of found variable.
		// If no ")" was found - nLength is set to 0 by default! see before.
		sal_Int32 nEndPosition = aWorkText.indexOf( SIGN_ENDVARIABLE, nPosition );
		if ( nEndPosition != STRPOS_NOTFOUND )
		{
			nLength = nEndPosition - nPosition;
			nLength++; // First index in string is 0!
		}
	}

	// Is there something for replace ?
	while ( ( nPosition != STRPOS_NOTFOUND ) && ( nLength > 0 ) )
	{
		// YES; Get the next variable for replace.
		OUString aReplacement;
		OUString aSubString = aWorkText.copy( nPosition, nLength );
        aSubString = aSubString.toAsciiLowerCase();
		sal_Int32 nReplaceLength = 0;

		// -------------------------------------------------------------------------------------------------------------------
		// $(vlang) - language dependent directory with english language name as directory name
		if ( SUBSTITUTE_VLANG == aSubString )
		{
			nReplaceLength = REPLACELENGTH_VLANG;
			switch ( nLangId )
			{
				case LANGUAGE_ARABIC				:
				case LANGUAGE_ARABIC_IRAQ			:
				case LANGUAGE_ARABIC_EGYPT			:
				case LANGUAGE_ARABIC_LIBYA			:
				case LANGUAGE_ARABIC_ALGERIA		:
				case LANGUAGE_ARABIC_MOROCCO		:
				case LANGUAGE_ARABIC_TUNISIA		:
				case LANGUAGE_ARABIC_OMAN			:
				case LANGUAGE_ARABIC_YEMEN			:
				case LANGUAGE_ARABIC_SYRIA			:
				case LANGUAGE_ARABIC_JORDAN			:
				case LANGUAGE_ARABIC_LEBANON		:
				case LANGUAGE_ARABIC_KUWAIT			:
				case LANGUAGE_ARABIC_UAE			:
				case LANGUAGE_ARABIC_BAHRAIN		:
				case LANGUAGE_ARABIC_QATAR			:	aReplacement = REPLACEMENT_ARABIC;
														break ;

				case LANGUAGE_CZECH					:	aReplacement = REPLACEMENT_CZECH;
														break ;

				case LANGUAGE_DANISH				:	aReplacement = REPLACEMENT_DANISH;
														break ;

				case LANGUAGE_DUTCH					:
				case LANGUAGE_DUTCH_BELGIAN			:	aReplacement = REPLACEMENT_DUTCH;
														break ;

				case LANGUAGE_ENGLISH				:
				case LANGUAGE_ENGLISH_AUS			:
				case LANGUAGE_ENGLISH_CAN			:
				case LANGUAGE_ENGLISH_NZ			:
				case LANGUAGE_ENGLISH_EIRE			:
				case LANGUAGE_ENGLISH_SAFRICA		:
				case LANGUAGE_ENGLISH_JAMAICA		:
				case LANGUAGE_ENGLISH_CARRIBEAN		:
				case LANGUAGE_ENGLISH_BELIZE		:
				case LANGUAGE_ENGLISH_TRINIDAD		:
				case LANGUAGE_ENGLISH_ZIMBABWE		:
				case LANGUAGE_ENGLISH_PHILIPPINES	:
				case LANGUAGE_ENGLISH_US			:
				case LANGUAGE_ENGLISH_UK			:	aReplacement = REPLACEMENT_ENGLISH;
														break ;
				case LANGUAGE_ESTONIAN				:	aReplacement = REPLACEMENT_ESTONIAN;
														break ;

				case LANGUAGE_FINNISH				:	aReplacement = REPLACEMENT_FINNISH;
														break ;

				case LANGUAGE_FRENCH				:
				case LANGUAGE_FRENCH_BELGIAN		:
				case LANGUAGE_FRENCH_CANADIAN		:
				case LANGUAGE_FRENCH_SWISS			:
				case LANGUAGE_FRENCH_LUXEMBOURG		:
				case LANGUAGE_FRENCH_MONACO			:	aReplacement = REPLACEMENT_FRENCH;
														break ;

				case LANGUAGE_GERMAN				:
				case LANGUAGE_GERMAN_SWISS			:
				case LANGUAGE_GERMAN_AUSTRIAN		:
				case LANGUAGE_GERMAN_LUXEMBOURG		:
				case LANGUAGE_GERMAN_LIECHTENSTEIN	:	aReplacement = REPLACEMENT_GERMAN;
														break ;

				case LANGUAGE_GREEK					:	aReplacement = REPLACEMENT_GREEK;
														break ;

				case LANGUAGE_HEBREW				:	aReplacement = REPLACEMENT_HEBREW;
														break ;

				case LANGUAGE_ITALIAN				:
				case LANGUAGE_ITALIAN_SWISS			:	aReplacement = REPLACEMENT_ITALIAN;
														break ;

				case LANGUAGE_JAPANESE				:	aReplacement = REPLACEMENT_JAPANESE;
														break ;

				case LANGUAGE_KOREAN				:
				case LANGUAGE_KOREAN_JOHAB			:	aReplacement = REPLACEMENT_KOREAN;
														break ;

				case LANGUAGE_POLISH				:	aReplacement = REPLACEMENT_POLISH;
														break ;

				case LANGUAGE_RUSSIAN				:	aReplacement = REPLACEMENT_RUSSIAN;
														break ;

				case LANGUAGE_SLOVAK				:	aReplacement = REPLACEMENT_SLOVAK;
														break ;

				case LANGUAGE_SLOVENIAN				:	aReplacement = REPLACEMENT_SLOVENIAN;
														break ;

				case LANGUAGE_WELSH  				:	aReplacement = REPLACEMENT_WELSH;
														break ;

				case LANGUAGE_SPANISH				:
				case LANGUAGE_SPANISH_MEXICAN		:
				case LANGUAGE_SPANISH_MODERN		:
				case LANGUAGE_SPANISH_GUATEMALA	 	:
				case LANGUAGE_SPANISH_COSTARICA	 	:
				case LANGUAGE_SPANISH_PANAMA		:
				case LANGUAGE_SPANISH_DOMINICAN_REPUBLIC:
				case LANGUAGE_SPANISH_VENEZUELA		:
				case LANGUAGE_SPANISH_COLOMBIA		:
				case LANGUAGE_SPANISH_PERU			:
				case LANGUAGE_SPANISH_ARGENTINA		:
				case LANGUAGE_SPANISH_ECUADOR		:
				case LANGUAGE_SPANISH_CHILE			:
				case LANGUAGE_SPANISH_URUGUAY		:
				case LANGUAGE_SPANISH_PARAGUAY		:
				case LANGUAGE_SPANISH_BOLIVIA		:
				case LANGUAGE_SPANISH_EL_SALVADOR	:
				case LANGUAGE_SPANISH_HONDURAS		:
				case LANGUAGE_SPANISH_NICARAGUA		:
				case LANGUAGE_SPANISH_PUERTO_RICO	:	aReplacement = REPLACEMENT_SPANISH;
														break ;
				case LANGUAGE_GALICIAN	:	aReplacement = REPLACEMENT_GALICIAN;
														break ;
				case LANGUAGE_SWEDISH				:
				case LANGUAGE_SWEDISH_FINLAND		:	aReplacement = REPLACEMENT_SWEDISH;
														break ;

				case LANGUAGE_TURKISH				:	aReplacement = REPLACEMENT_TURKISH;
														break ;

				case LANGUAGE_NORWEGIAN				:
				case LANGUAGE_NORWEGIAN_BOKMAL		:
				case LANGUAGE_NORWEGIAN_NYNORSK		:	aReplacement = REPLACEMENT_NORWEGIAN;
														break ;

				case LANGUAGE_HUNGARIAN				:	aReplacement = REPLACEMENT_HUNGARIAN;
														break ;

				case LANGUAGE_BULGARIAN				:	aReplacement = REPLACEMENT_BULGARIAN;
														break ;

				case LANGUAGE_CHINESE_TRADITIONAL	:	aReplacement = REPLACEMENT_CHINESE_TRADITIONAL;
														break ;

				case LANGUAGE_CHINESE_SIMPLIFIED	:	aReplacement = REPLACEMENT_CHINESE_SIMPLIFIED;
														break ;

				case LANGUAGE_PORTUGUESE			:
				case LANGUAGE_PORTUGUESE_BRAZILIAN	:	aReplacement = REPLACEMENT_PORTUGUESE;
														break ;

                               case LANGUAGE_NORTHERNSOTHO                                :       aReplacement = REPLACEMENT_NORTHERNSOTHO;
                                                                                                               break ;

                               case LANGUAGE_AFRIKAANS                         :       aReplacement = REPLACEMENT_AFRIKAANS;
                                                                                                               break ;

                               case LANGUAGE_ZULU                              :       aReplacement = REPLACEMENT_ZULU;
                                                                                                               break ;

                               case LANGUAGE_TSWANA                              :       aReplacement = REPLACEMENT_TSWANA;
                                                                                                               break ;

                               case LANGUAGE_BASQUE                              :       aReplacement = REPLACEMENT_BASQUE;
                                                                                                               break ;

                               case LANGUAGE_LITHUANIAN                              :       aReplacement = REPLACEMENT_LITHUANIAN;
                                                                                                               break ;
                               case LANGUAGE_KANNADA                              :       aReplacement = REPLACEMENT_KANNADA;
                                                                                                               break ;

				default								:	// no fallback any longer
														DBG_ERRORFILE( "Language unknown." );
														break ;
			}
		}

		// Have we found something to replace?
		if ( nReplaceLength > 0 )
		{
			// Yes ... then do it.
			aWorkText = aWorkText.replaceAt( nPosition, nReplaceLength, aReplacement );
		}
		else
		{
			// Safe impossible cases
			// Unknown variable was found! We have detected "$(...)" but don't know his meaning.
			DBG_ERRORFILE( "Unknown variable was found" );
			// Skip unknown variable.
			nPosition += nLength;
		}

		// Step after replaced text! If no text was replaced (unknown variable!),
		// length of aReplacement is 0 ... and we don't step then.
		nPosition += aReplacement.getLength();

		// We must control index in string before call something at OUString!
		// The OUString-implementation don't do it for us :-( but the result is not defined otherwise.
		if ( nPosition + 1 > aWorkText.getLength() )
		{
			// Position is out of range. Break loop!
			nPosition = STRPOS_NOTFOUND;
			nLength = 0;
		}
		else
		{
			// Else; Position is valid. Search for next variable to replace.
			nPosition = aWorkText.indexOf( SIGN_STARTVARIABLE, nPosition );
			// Have we found any variable like "$(...)"?
			if ( nPosition != STRPOS_NOTFOUND )
			{
				// Yes; Get length of found variable. If no ")" was found - nLength must set to 0!
				nLength	= 0;
				sal_Int32 nEndPosition = aWorkText.indexOf( SIGN_ENDVARIABLE, nPosition );
				if ( nEndPosition != STRPOS_NOTFOUND )
				{
					nLength = nEndPosition - nPosition;
					nLength++;
				}
			}
		}
	}

	// Return text with replaced substrings.
	return aWorkText;
}

// -----------------------------------------------------------------------

void Create_Hierarchy( SiCustomEnvironment* pEnv )
{
	SiEnvironment *pBigEnv = pEnv->GetBigEnv();

	USHORT nStep = pBigEnv->GetResponseStep();

	if ( ( nStep == 0 ) || ( nStep == 2 ) )
	{
		Hierarchy_Impl aHierarchy( pEnv );

		const SiLangCtxList *pLangList = pBigEnv->GetLanguageContext();
		LanguageContext *pLanguage = pLangList->GetObject( 0L );

		USHORT			nLangId = USHRT_MAX;

		for ( ULONG i=0; i<pLangList->Count(); i++ )
		{
			pLanguage = pLangList->GetObject( i );
			if ( pLanguage && pLanguage->isDoc )
			{
				nLangId = pLanguage->nLanguage;
				aHierarchy.CreateHierarchy( nLangId );
			}
		}

		if ( nLangId == USHRT_MAX )
		{
			nLangId = pBigEnv->GetDefLanguage();
			aHierarchy.CreateHierarchy( nLangId );
		}
	}
}

// -----------------------------------------------------------------------

SiSetupFnc aSetupFnc;

const char *	envPath = NULL;
USHORT			nEntriesCount	= 0;
USHORT			nBestEntry		= 0;
BOOL			bHasInstPackage = FALSE;

////////////////////////////////////////////////////////////////////////////////
//
//	EntryPoint
//
extern "C"
{
BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return FALSE;

	pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

	aSetupFnc.nVersion 				= pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup			= pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup			= pSetupFnc->fncShowSetup;
	aSetupFnc.fncGetCodeFilename	= pSetupFnc->fncGetCodeFilename;

	return TRUE;
};
}

////////////////////////////////////////////////////////////////////////////////
//
//	CustomMain
//
BOOL _SV_CALL CustomMain( SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList )
{
	enum { INST_NONE, INST_NEW, INST_PRE, INST_PRE_NONE };

	ULONG		nSelectedEntry		= 0;
	UINT32		nInstallType		= INST_PRE;
	BOOL		bIsSetupMode		= pModuleList != NULL;
	BOOL		bIsWorkstation		= FALSE;


	ByteString		aDestIniName;
	ByteString		aSrcIniName;

	ByteString aSourcePath 	= pEnv->GetSourcePath();
	ByteString aDestPath	= pEnv->GetDestPath();
	ByteString aClassDir;
	ByteString aInstallPackage;
	ByteString aInstallPath;

	Create_Hierarchy( pEnv );

	return TRUE;
}

