/*************************************************************************
 *
 *  $RCSfile: idpool.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#pragma hdrstop

#include "idpool.hxx"

//====================================================================
// locks all ids in the set; returns TRUE if none was locked

BOOL IdPool::Lock( const BitSet& rLockSet )
{
	DBG_MEMTEST();
	// shift the set by offset
	BitSet aLockSet = rLockSet << nOffset;

	// is none of the numbers in the set already locked?
	if ( !(aLockSet & *this) )
	{
		// lock all the numbers in the range
		*this |= aLockSet;

		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------

// creates a pool of unique numbers between nMin and nMax

IdPool::IdPool( USHORT nMin, USHORT nMax ):
	nOffset(nMin),
	nRange(nMax-nMin+1),
	nNextFree(0)
{
	DBG_MEMTEST();

}

//--------------------------------------------------------------------

// gets and locks a unique id

USHORT IdPool::Get()
{
	DBG_MEMTEST();
	// seek the next free number
	while ( Contains(nNextFree) && nNextFree < nRange )
		++nNextFree;

	// was a number available
	if ( nNextFree < nRange )
	{   // lock and return the number found
		*this |= nNextFree;
		return nNextFree + nOffset;
	}
	return 0;
}

//--------------------------------------------------------------------

// frees a unique id for recycling

BOOL IdPool::Put( USHORT nId )
{
	DBG_MEMTEST();
	// is it locked?
	if ( IsLocked(nId) )
	{
		// always store the smallest free number in nNextFree
		nId -= nOffset;
		if ( nNextFree > nId )
			nNextFree = nId;

		// unlock the number and return success
		*this -= nId;
		return TRUE;
	}

	return FALSE;
}

//--------------------------------------------------------------------

// marks a range of ids as used, return FALSE if already used

BOOL IdPool::Lock( const Range& rRange )
{
	DBG_MEMTEST();
	// create a shifted set
	Range aRange(rRange.Min()-nOffset, rRange.Max()-nOffset);
	BitSet aLockSet( aRange );

	// is none of the numbers in the set already locked?
	if ( !(aLockSet & *this) )
	{
		// lock all the numbers in the range
		*this |= aLockSet;

		// adjust the smallest unlocked number in nNextFree
		if ( nNextFree >= aRange.Min() && nNextFree < aRange.Max() )
			nNextFree = aRange.Max()+1;

		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------

// marks a single id as used, return FALSE if already used

BOOL IdPool::Lock( USHORT nId )
{
	DBG_MEMTEST();
	// is the number already locked?
	if ( !IsLocked(nId) )
	{
		// lock the number
		*this |= (nId-nOffset);
		return TRUE;
	}
	return FALSE;
}


