/*************************************************************************
 *
 *  $RCSfile: tbxcust.hxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/15 10:54:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _TBXCUST_HXX
#define _TBXCUST_HXX

// #include *****************************************************************

#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#include <vcl/combobox.hxx>
#include <vcl/button.hxx>
#ifndef _HEADBAR_HXX
#include <svtools/headbar.hxx>
#endif

#include "basedlgs.hxx"
#include "imgmgr.hxx"
#include "childwin.hxx"
#include "sfxresid.hxx"
#include "cfgtreelstbox.hxx"

#include <vector>

namespace rtl { class OUString; }
class Bitmap;
class SfxMacroInfoArr_Impl;
class SfxToolBoxManager;

// **************************************************************************

class SfxCustomizeToolBox : public ToolBox
{
    SfxBindings*    pBindings;
	BOOL			bHelpInitialized;

public:
    SfxCustomizeToolBox( Window* pParent, SfxBindings*, const ResId& );
	virtual void    Customize( const ToolBoxCustomizeEvent& rCEvt );
};

class SfxUserBitmapDialog_Impl;
class SfxTbxControlArr_Impl;

class SfxToolboxCustomizer : public SfxModelessDialog
{
friend class SfxCustomizeToolBox;
friend class SfxUserBitmapDialog_Impl;

	sal_Int16					m_nSymbolSet;
	FixedText					m_aTbFunctionsFT;
	SfxConfigTreeListBox_Impl	m_aTbFunctionsTLB;
	PushButton					m_aTbAddBtn;
	PushButton					m_aTbRemoveBtn;
	FixedText					m_aTbToolbarsFT;
	ListBox						m_aTbToolbarsLB;
	FixedText					m_aTbToolbarFT;
	SfxToolbarTreeListBox_Impl	m_aTbToolbarTLB;
	OKButton					m_aTbOkBtn;
	CancelButton				m_aTbCancelBtn;
	HelpButton					m_aTbHelpBtn;
	PushButton					m_aTbApplyBtn;
	PushButton					m_aTbDefaultBtn;
	PushButton					m_aTbMoveUpBtn;
	PushButton					m_aTbMoveDownBtn;
	PushButton					m_aTbIconsBtn;
	SfxUserBitmapDialog_Impl*	m_pBmpDlg;
	USHORT						m_nCurrTbxPos;

protected:
	void				FillFunctionsListBox();
	void				ClearToolBox();
	virtual BOOL		Close();
	void				CheckButtonsState();
	void				StoreToolBoxes( BOOL bPreserveListener );

public:
						SfxToolboxCustomizer( SfxBindings*, SfxChildWindow*,
							Window *pParent, const ResId& rResId );
						~SfxToolboxCustomizer();
	void            	Init();
	virtual long		Notify( NotifyEvent& );
	virtual void    	FillInfo(SfxChildWinInfo&) const;
	SfxUserBitmapDialog_Impl*
						ConnectUserBitmapDialog_Impl(USHORT nId, ToolBox& rTbx, SfxToolBoxManager* pMgr);
	
	DECL_LINK(			OnTreelistBoxChanged, void* );
	DECL_LINK(			OnToolBarChanged, SfxToolBoxManager* );

	DECL_LINK( 			SelectToolbars, ListBox* );
	DECL_LINK(			SelectToolbar, Control* );
	DECL_LINK(			SelectFunctions, Control* );
	
	DECL_LINK(			ApplyButtonHdl, Button * );
	DECL_LINK(			OkButtonHdl, OKButton * );
	DECL_LINK(			CancelButtonHdl, CancelButton * );

	DECL_LINK( 			MoveUpButtonHdl, Button * );
	DECL_LINK( 			MoveDownButtonHdl, Button * );
	DECL_LINK( 			AddButtonHdl, Button * );
	DECL_LINK( 			RemoveButtonHdl, Button * );

	DECL_LINK( 			IconsButtonHdl, Button * );
	DECL_LINK( 			DefaultButtonHdl, Button * );
    DECL_LINK(          SymbolsetChanged, void* );

	void				SelectToolbar( USHORT nType );
};

class SfxUserBitmapDialog_Impl : public ModalDialog
{
friend class SfxToolboxCustomizer;

	ToolBox         	aSymbolTb;
	FixedText       	aDescLabelFt;
	Edit       			aDescEdit;
	OKButton        	aOKButton;
	CancelButton    	aCancelButton;
	HelpButton      	aHelpBtn;
	PushButton			aDefaultBtn;
    FixedLine           aFunctionGb;
	USHORT          	nFuncId;
	String				aDirName;
    std::vector< rtl::OUString > aBitmapUrls;
	ToolBox*			pToolBox;
	SfxToolBoxManager*	pMgr;
    SfxImageManager*    pImageMgr;
	BOOL				bNoDefaultImage;
	BOOL				bBigImages;
	BmpConversion       nBmpColorConversion;
	USHORT              nBmpColorDepth;

    SfxUserBitmapDialog_Impl(SfxUserBitmapDialog_Impl &); // not implemented
    void operator =(SfxUserBitmapDialog_Impl); // not implemented

    Bitmap createBitmap(rtl::OUString const & rUrl);

	Image				GetDefaultImage( USHORT nId );
	void				ResetToolBoxSelection();

public:

						SfxUserBitmapDialog_Impl(Window *pParent,
										const String& rName,
										ToolBox &rTbx,
                                        USHORT nId, SfxToolBoxManager* pMgr, SfxImageManager* );

						~SfxUserBitmapDialog_Impl();
	DECL_LINK( 			OKHdl, OKButton * );
	DECL_LINK( 			SelectHdl, ToolBox * );
	DECL_LINK( 			DefaultHdl, PushButton * );

	void				SetFunctionId(USHORT nId);
	void				SetToolBox(ToolBox& rTbx);
};

class SfxToolboxCustomWindow : public SfxChildWindow
{
public:
						SfxToolboxCustomWindow(Window *pParent, USHORT nId,
							SfxBindings *pBindings, SfxChildWinInfo *pInfo);
						SFX_DECL_CHILDWINDOW(SfxToolboxCustomWindow);

						void SelectToolbar( USHORT nType );
};

#endif // #ifndef _TBXCUST_HXX


