/*************************************************************************
 *
 *  $RCSfile: tlog.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 16:38:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SOLTOOLS_TESTSHL_TLOG_HXX__
#define _SOLTOOLS_TESTSHL_TLOG_HXX__

#ifndef _OSL_FILE_HXX_
#include    <osl/file.hxx>
#endif

#ifndef _RTL_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#ifndef _SOLTOOLS_TESTSHL_TUTIL_HXX_
#include "tutil.hxx"
#endif

#include <iostream>

using namespace std;

// <namespace_tstutl>
namespace tstutl
{

    // <class_TestLog>
    class TestLog
    {
        // <private_members>
        struct log_impl;
        log_impl* pImpl;
        // </private_members>

        // <private_methods>
        void destroy();
        // </private_methods>

    public:

        // <public_ctors>
        TestLog() : pImpl( 0 ) {}

        TestLog( const sal_Char* name, sal_uInt32 frmt = rtl_tres_Flag_LOG,
                                                        sal_Char* deli = ";" )
        {
            if( name )
                initialize( name, frmt, deli );
            else
                pImpl = 0;
        }
        // </public_ctors>

        // <dtor>
        virtual ~TestLog()
        {
            destroy();
        } // </dtor>

        void initialize( const ::rtl::OString& name , sal_uInt32 frmt,
                                                            sal_Char* delim );

        // <public_methods>
        ::rtl::OUString& getName();
        ::osl::File* getFile();

        // open logfile for overwrite (default) or append
        ::osl::FileBase::RC open( sal_Bool append = sal_False );
        ::osl::FileBase::RC close();

        // write testresult
        ::osl::FileBase::RC writeRes( ::rtl::TestResult& oRes );

        // write methods without (default) or with echo on display
        ::osl::FileBase::RC write( const sal_Char* buf,
                        sal_Bool v = sal_False, sal_Bool skip = sal_False );
        // </public_methods>

    }; // </class_TestLog>

} // </namespace_tstutl>

#endif
