/*************************************************************************
 *
 *  $RCSfile: soagent.cpp,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef SOM_Module_agent_Source
#define SOM_Module_agent_Source
#endif
#define StarOfficeAgent_Class_Source

#include "soagent.xih"

#ifdef StarOfficeAgentMethodDebug
#undef StarOfficeAgentMethodDebug
#endif
#define StarOfficeAgentMethodDebug

#ifdef M_StarOfficeAgentMethodDebug
#undef M_StarOfficeAgentMethodDebug
#endif
#define M_StarOfficeAgentMethodDebug

#include <stdio.h>
#include <stdlib.h>

struct ThreadExitData
{
    PFNTHREAD fnExit;
    ULONG     ulParam;
};

static ThreadExitData *pThreadExitData;

/**************************************************************************************
 *
 * setExitHandler() - set exit handle for running thread
 *
 **************************************************************************************
 */

void setExitHandler(ULONG fnExit, ULONG ulParam)
{
    pThreadExitData->fnExit  = (PFNTHREAD) fnExit;
    pThreadExitData->ulParam = ulParam;
}

/**************************************************************************************
 *
 * ExceptionHandlerFunction() - don't terminate WPS -process on exceptions
 *
 **************************************************************************************
 */

ULONG APIENTRY ExceptionHandlerFunction( PEXCEPTIONREPORTRECORD pERepRec,
                                         PEXCEPTIONREGISTRATIONRECORD pERegRec,
                                         PCONTEXTRECORD pConRec, PVOID pReserved)
{
    /* do nothing if this is a nested call */
    if(0 == (pERepRec->fHandlerFlags & EH_NESTED_CALL))
    {
#if 0
        printf("Exception: %x\n", pERepRec->ExceptionNum);
#endif

        switch (pERepRec->ExceptionNum)
        {
            /* fatal hardware exceptions */
        case XCPT_DATATYPE_MISALIGNMENT:
        case XCPT_BREAKPOINT:
        case XCPT_SINGLE_STEP:
        case XCPT_ACCESS_VIOLATION:
        case XCPT_ILLEGAL_INSTRUCTION:
        case XCPT_FLOAT_DENORMAL_OPERAND:
        case XCPT_FLOAT_DIVIDE_BY_ZERO:
        case XCPT_FLOAT_INEXACT_RESULT:
        case XCPT_FLOAT_INVALID_OPERATION:
        case XCPT_FLOAT_OVERFLOW:
        case XCPT_FLOAT_STACK_CHECK:
        case XCPT_FLOAT_UNDERFLOW:
        case XCPT_INTEGER_DIVIDE_BY_ZERO:
        case XCPT_INTEGER_OVERFLOW:
        case XCPT_PRIVILEGED_INSTRUCTION:

            /* fatal software exceptions */
        case XCPT_IN_PAGE_ERROR:
        case XCPT_NONCONTINUABLE_EXCEPTION:
        case XCPT_INVALID_DISPOSITION:
        case XCPT_INVALID_LOCK_SEQUENCE:
        case XCPT_ARRAY_BOUNDS_EXCEEDED:
        case XCPT_B1NPX_ERRATA_02:

            pERepRec->ExceptionNum = XCPT_PROCESS_TERMINATE;

        case XCPT_PROCESS_TERMINATE:
        case XCPT_ASYNC_PROCESS_TERMINATE:

            /* call exit handler if set */
            if(pThreadExitData->fnExit)
            {
                pThreadExitData->fnExit(pThreadExitData->ulParam);
                pThreadExitData->fnExit = NULL;
            }

            break;

        default:
            break;
        }
    }

    return XCPT_CONTINUE_SEARCH;
}

/**************************************************************************************
 *
 * threadWrapperFunction() - initialize environment for created thread
 *
 **************************************************************************************
 */

static void _Optlink threadWrapperFunction(void * data)
{
    EXCEPTIONREGISTRATIONRECORD ExcptHandler = { 0, ExceptionHandlerFunction };
    StarOfficeAgentData *somThis = (StarOfficeAgentData *) data;

    /* set exception handler for this thread */
    DosSetExceptionHandler(&ExcptHandler);

    /* inizialize PM for this thread */
    HAB hab = WinInitialize(0);
    if (hab)
    {
        /* create message queue for this thread */
        HMQ hmq = WinCreateMsgQueue(hab, 0);
        if (hmq)
        {
            PFNTHREAD pfn = (PFNTHREAD) _fnExit;

            /* allow WM_QUIT events */
            WinCancelShutdown(hmq, TRUE);

            /* prepare data structure */
            _hab    = hab;
            _hmq    = hmq;
            _fnExit = (LHANDLE) setExitHandler;

            /* initialize exit data */
            pThreadExitData->fnExit = NULL;
            pThreadExitData->ulParam = NULL;

            /* start thread function */
            pfn((ULONG) data);

            /* call exit handler if set */
            if(pThreadExitData->fnExit)
            {
                pThreadExitData->fnExit(pThreadExitData->ulParam);
                pThreadExitData->fnExit = NULL;
            }

            /* cleanup */
            WinDestroyMsgQueue(hmq);
            _hab = 0;
        }
        /* free all PM-resources for this thread */
        WinTerminate(hab);
        _hmq = 0;
    }

    /* unset exception handler */
    DosUnsetExceptionHandler(&ExcptHandler);
}

SOM_Scope void  SOMLINK soagent_wpInitData(StarOfficeAgent *somSelf)
{
    StarOfficeAgentData *somThis = StarOfficeAgentGetData(somSelf);
    StarOfficeAgentMethodDebug("StarOfficeAgent","SOAgent_wpInitData");

    StarOfficeAgent_parent_WPTransient_wpInitData(somSelf);
    /* setup data structure */
    _threadID = 0;
    _hModule  = 0;
    _bRun     = TRUE;
}

SOM_Scope void  SOMLINK soagent_wpUnInitData(StarOfficeAgent *somSelf)
{
    StarOfficeAgentData *somThis = StarOfficeAgentGetData(somSelf);
    StarOfficeAgentMethodDebug("StarOfficeAgent","SOAgent_wpUnInitData");

    /* terminate thread if still running */
    if(_threadID) DosKillThread(_threadID);

    /* wait for the end of the thread */
    DosWaitThread(&_threadID, DCWW_WAIT);

    /* destroy the thread's message queue */
    if(_hmq)
        WinDestroyMsgQueue(_hmq);

    /* free all PM-resources for the thread */
    if(_hab)
        WinTerminate(_hab);

    /* release DLL */
    if(_hModule) DosFreeModule(_hModule);
    
    StarOfficeAgent_parent_WPTransient_wpUnInitData(somSelf);
}

SOM_Scope BOOL  SOMLINK soagent_wpSetup(StarOfficeAgent *somSelf,
                                        PSZ pszSetupString)
{
    StarOfficeAgentData *somThis = StarOfficeAgentGetData(somSelf);
    StarOfficeAgentMethodDebug("StarOfficeAgent","SOAgent_wpSetup");

    /* call parent function */
    if(!StarOfficeAgent_parent_WPTransient_wpSetup(somSelf, pszSetupString))
        return FALSE;

    /*
     * If WinSetObjectData() is invoked on this object, it will call wpSetup() to set the new
     * data. In this case, the thread data should not be changed.
     */
    if(_threadID) return TRUE;

    CHAR   szValue[CCHMAXPATHCOMP];
    ULONG  ulValueSize = CCHMAXPATHCOMP;
    ULONG  ulStackSize = 4096;             // minimal stack size for threads
    APIRET rc;

    /* find DLL name in setup string */
    if(!_wpScanSetupString(pszSetupString, WPSETUPKEY_LIBRARY, szValue, &ulValueSize))
        return FALSE;

    /* load module into memory */
    if((rc = DosLoadModule(szValue, CCHMAXPATHCOMP, szValue, &_hModule)))
    {
        CHAR  szString[512];
        ULONG ulSize;

        /* get error message */
        DosGetMessage(NULL, 0, szString, 512, rc, "OSO001.MSG",&ulSize);

        /* append module name */
        sprintf(szString + ulSize, "\"%s\"", szValue);

        /* pop up message box */
        WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, szString, NULL, 0, MB_OK);
        return FALSE;
    }
    
    /* find the name of the main thread-function */
    ulValueSize = CCHMAXPATHCOMP;
    if(!_wpScanSetupString(pszSetupString, WPSETUPKEY_FUNCTION, szValue, &ulValueSize))
        return FALSE;

    /* find the function in the specified DLL */
    PFN pFunction;
    if((rc = DosQueryProcAddr(_hModule, 0, szValue, &pFunction)))
    {
        CHAR  szString[512];
        ULONG ulSize;

        /* get error message */
        DosGetMessage(NULL, 0, szString, 512, rc, "OSO001.MSG",&ulSize);

        /* query module name again */
        DosQueryModuleName(_hModule, CCHMAXPATHCOMP, szValue);

        /* strip path information */
        PSZ pszModuleName = strrchr(szValue, '\\');
        if(!pszModuleName)
            pszModuleName = szValue;
        else
            pszModuleName++;

        /* append module name */
        sprintf(szString + ulSize, "(%s)", pszModuleName);

        /* pop up message box */
        WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, szString, NULL, 0, MB_OK);
        return FALSE;
    }

    /* search for a non default stack-size */
    ulValueSize = CCHMAXPATHCOMP;
    if(_wpScanSetupString(pszSetupString, WPSETUPKEY_STACK, szValue, &ulValueSize))
    {
        ulStackSize = strtoul(szValue, NULL, 10);
        if(ulStackSize < 4096)
            ulStackSize = 4096;
    }

    /* setup thread data */
    _fnExit = (LHANDLE) pFunction;

    /* start thread and share data with it */
    somThis->threadID = (TID) _beginthread(&threadWrapperFunction,    /* worker function */
                                           NULL,                      /* unused parameter */
                                           ulStackSize,               /* stack size */
                                           (void *) somThis           /* parameter of main function */
                                          );
    return TRUE;
}

SOM_Scope void  SOMLINK soagentM_wpclsInitData(M_StarOfficeAgent *somSelf)
{
    /* M_StarOfficeAgentData *somThis = M_StarOfficeAgentGetData(somSelf); */
    M_StarOfficeAgentMethodDebug("M_StarOfficeAgent","soagentM_wpclsInitData");

    M_StarOfficeAgent_parent_M_WPTransient_wpclsInitData(somSelf);

    /* allocate thread local memory for exit data */
    DosAllocThreadLocalMemory( 2, (PULONG *) &pThreadExitData);
}

SOM_Scope void  SOMLINK soagentM_wpclsUnInitData(M_StarOfficeAgent *somSelf)
{
    /* M_StarOfficeAgentData *somThis = M_StarOfficeAgentGetData(somSelf); */
    M_StarOfficeAgentMethodDebug("M_StarOfficeAgent","soagentM_wpclsUnInitData");

    /* free thread local memory */
    DosFreeThreadLocalMemory((PULONG) pThreadExitData);

    M_StarOfficeAgent_parent_M_WPTransient_wpclsUnInitData(somSelf);
}

