/*************************************************************************
 *
 *  $RCSfile: type_traits.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_TYPE_TRAITS_HXX
#define UDM_TYPE_TRAITS_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tplutil.hxx>

namespace udm
{

class Data;

/// Has to be specialised and implemented for each relevant type.
template<class SRC, class RESULT>
RESULT
convert_value_src_2_udm( const SRC & i_rSrc );



template <class XY>
class type_traits
{
  public:
    static const type_traits<XY> &
                        get_();

    DYN Data &          create_data() const
                            { return do_CreateData(); }
    void                dispose_data(
                            DYN Data &          let_drData2Release ) const;

    void                connect_original(
                            Data &              o_rData,
                            const XY &          i_rOriginal ) const
                            { do_ConnectOriginal(o_rData, i_rOriginal); }
    DYN XY *            create_object() const
                            { do_CreateObject(); }

    DYN Data &          create_data_for(
                            const XY &          io_rOriginal ) const;
  private:
    virtual DYN Data &  do_CreateData() const = 0;
    virtual void        do_ConnectOriginal(
                            Data &              o_rData,
                            const XY &          i_rOriginal ) const = 0;
    virtual DYN XY *    do_CreateObject() const = 0;
};

template <class XY>
inline DYN Data &
type_traits<XY>::create_data_for( const XY & io_rOriginal ) const
{
    Data &  ret = create_data();
    connect_original(ret, io_rOriginal);
    return ret;
}


/** Has to be specialized and implemented
    for each yet unknown type accordingly.
*/
template <class XY>
DYN type_traits<XY> &   create_traits(
                            csv::Type2Type<XY> );


template <class XY>
const type_traits<XY> &
type_traits<XY>::get_()
{
 	static const type_traits<XY> &
        rSingleton = create_traits( csv::Type2Type<XY>() );
    return rSingleton;
}


}   // namespace udm


#endif


