/*************************************************************************
 *
 *  $RCSfile: appstat.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: os $ $Date: 2001/07/12 06:07:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#pragma hdrstop

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef _SFX_WHITER_HXX
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXVIEWSH_HXX
#include <sfx2/viewsh.hxx>
#endif

#ifndef _SVX_LANGITEM_HXX
#define ITEMID_LANGUAGE SID_ATTR_LANGUAGE
#include <svx/langitem.hxx>
#endif

#ifndef _UNO_LINGU_HXX
#include <svx/unolingu.hxx>
#endif
#ifndef _LINGU_LNGPROPS_HHX_
#include <linguistic/lngprops.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#include <comphelper/processfactory.hxx>

#include "app.hxx"

#include "sbasltid.hrc"

using namespace comphelper;
using namespace rtl;
using namespace com::sun::star;
using namespace com::sun::star::util;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;


// ------------------------------------------------------------------------

void OfficeApplication::GetState_Impl( SfxItemSet& rState )
{
	SfxWhichIter aIter( rState );
	sal_uInt16 nWhich = aIter.FirstWhich();
	SfxBoolItem aBool;

	while ( nWhich )
	{
		switch ( nWhich )
		{
			case SID_ATTR_LANGUAGE:
			{
				Reference< XPropertySet >  xProp( SvxGetLinguPropertySet() );

				Language nDefaultLang = LANGUAGE_NONE;
				if (xProp.is())
				{
					xProp->getPropertyValue(
								String::CreateFromAscii(UPN_DEFAULT_LANGUAGE) )
							>>= nDefaultLang;
				}
				rState.Put( SvxLanguageItem(nDefaultLang), nWhich );
				nWhich = 0;
			}
			break;
		}

		if ( nWhich )
		{
			aBool.SetWhich( nWhich );
			rState.Put( aBool );
		}
		nWhich = aIter.NextWhich();
	}
}


