/*************************************************************************
 *
 *  $RCSfile: msgmodel.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _OFA_MSGMODEL_HXX
#define _OFA_MSGMODEL_HXX

#ifndef _SMART_COM_SUN_STAR_FRAME_XDISPATCHPROVIDERINTERCEPTOR_HXX_
#include <smart/com/sun/star/frame/XDispatchProviderInterceptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HXX_
#include <smart/com/sun/star/frame/XDispatchProvider.hxx>
#endif

#ifndef _SFX_OBJUNO_HXX //autogen wg. SfxModel
#include <sfx2/objuno.hxx>
#endif
#include <svtools/svstdarr.hxx>

SV_DECL_PTRARR_DEL ( OffPropertyValueList, PropertyValue*, 1, 1 )

class OffMessageDoc_Impl;

class OffMsgDocDispatchInterceptor : public XDispatchProviderInterceptor, public UsrObject
{
private:
    XDispatchProviderRef    xSlave;
    XDispatchProviderRef    xMaster;
	OffMessageDoc_Impl*		_pDoc;					// the implemetation

public:
	OffMsgDocDispatchInterceptor( OffMessageDoc_Impl*);

	virtual void            acquire();
    virtual void            release();
    virtual BOOL            queryInterface( UsrUik aUIK, XInterfaceRef& );
    static XIdlClassRef     getStaticIdlClass();
    virtual Sequence< XIdlClassRef > getIdlClasses();
	virtual void *			getImplementation( Reflection* p );

    // XDispatchProviderInterceptor
    virtual         XDispatchProviderRef getSlaveDispatchProvider(void) THROWS( (UsrSystemException) );
    virtual void    setSlaveDispatchProvider(const XDispatchProviderRef& xNewDispatchProvider) THROWS( (UsrSystemException) );
    virtual         XDispatchProviderRef getMasterDispatchProvider(void) THROWS( (UsrSystemException) );
    virtual void    setMasterDispatchProvider(const XDispatchProviderRef& xNewSupplier) THROWS( (UsrSystemException) );

    // XDispatchProvider
    virtual XDispatchRef queryDispatch(const URL& aURL, const UString& aTargetFrameName, INT32 nSearchFlags) THROWS( (UsrSystemException) );
    virtual Sequence< XDispatchRef > queryDispatches(const Sequence< DispatchDescriptor >& aDescripts) THROWS( (UsrSystemException) );
};


// class OffMessageModel -------------------------------------------------

struct OffMsgModel_Impl;

class OffMessageModel : public SfxModel,			// SuperClass
						public XIdlClassProvider,	//
						public XPropertySet,		// to set seperate items (name)
						public XFastPropertySet,	// to set seperate items (id)
						public XPropertyAccess,		// to set a sequence of items
						public UsrObject
{
private:
	SfxItemPropertySet			_aPropMap;				// map from id to property
	OffPropertyValueList*		_pPropList;				// list of property values
	OffMessageDoc_Impl*			_pDoc;					// the implemetation
	OffMsgModel_Impl*			_pImpl;					// for internal use

	void						updateDocument();

public:
	OffMessageModel( OffMessageDoc_Impl* pDoc );
	~OffMessageModel();

	static XIdlClassRef			getStaticIdlClass();

								// XInterface
	virtual void				acquire()	{ UsrObject::acquire(); }
	virtual void				release()	{ UsrObject::release(); }
	virtual void *				getImplementation( Reflection* p );

	virtual BOOL 				queryInterface( UsrUik aUIK, XInterfaceRef& );
	friend Reflection*			OffMessageModel_getReflection();

									// XIdlClassProvider
	virtual Sequence< XIdlClassRef > getIdlClasses( void );

									// XPropertySet
    virtual XPropertySetInfoRef		getPropertySetInfo( void ) const THROWS( (UsrSystemException) );
    virtual UsrAny					getPropertyValue( const UString& aPropertyName ) const THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
    virtual void					setPropertyValue( const UString& aPropertyName, const UsrAny& aValue ) THROWS( (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, UsrSystemException) );
    virtual void					addPropertyChangeListener( const UString& aPropertyName, const XPropertyChangeListenerRef& xListener ) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
    virtual void					removePropertyChangeListener( const UString& aPropertyName, const XPropertyChangeListenerRef& aListener ) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
    virtual void					addVetoableChangeListener( const UString& PropertyName, const XVetoableChangeListenerRef& aListener ) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
    virtual void					removeVetoableChangeListener( const UString& PropertyName, const XVetoableChangeListenerRef& aListener ) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );

									// XFastPropertySet
    virtual UsrAny					getFastPropertyValue( INT32 nHandle ) const THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) );
    virtual void					setFastPropertyValue( INT32 nHandle, const UsrAny& aValue ) THROWS( (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, UsrSystemException) );

									// XPropertyAccess
    virtual Sequence< PropertyValue > getPropertyValues( void ) const THROWS( (UsrSystemException) );
    virtual void					setPropertyValues( const Sequence< PropertyValue >& aProps ) THROWS( (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, UsrSystemException) );

									// Listener
	virtual void					Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

									// XModifiable
	virtual void					setModified( BOOL bModified );

									// OffMessageModel
	void							setNewProperty( INT32 nHandle, const UsrAny& aValue );
};

#endif


