/*************************************************************************
 *
 *  $RCSfile: red.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 08:32:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef UNX
#include <unistd.h>
#endif
#ifdef WNT
#include <direct.h>
#endif
#include <stdio.h>

// #ifndef _SV_SVAPP_HXX
// #include <vcl/svapp.hxx>
// #endif
// 
// #ifndef _FSYS_HXX
// #include <tools/fsys.hxx>
// #endif
// 
// #ifndef _FSYS_HXX
// #include <tools/fsys.hxx>
// #endif

#include <vector>
#include <rtl/ustring.hxx>
#include <osl/file.hxx>

#include <com/sun/star/io/IOException.hpp>

#include <rtl/crc.h>

// #include "setup2/sifsys.hxx"
// #include "setup2/hashtbl.hxx"

#include "svunzip.h"

#define MAX_BUF_SIZE        32000

rtl::OUString suSourcePathURL;
bool        bTestOnlyMode = false;
bool        bVerboseMode  = false;
bool        bRelativeMode = false;
bool        bConsiderAll  = false;
bool        bWindowsDebugMode = false;

// ============================================================================

void PrintRedundancyEliminatorUsage()
{
    fprintf( stderr, "usage:\n" );
    fprintf( stderr, "\t-s <source path root>\n" );
    fprintf( stderr, "\t-t <test only mode>\n" );
    fprintf( stderr, "\t-v verbose\n" );
    fprintf( stderr, "\t-r try to use relative links\n" );
    fprintf( stderr, "\t-a consider all files, not only f0_* and f_*\n" );
}

// -----------------------------------------------------------------------------
namespace css = com::sun::star;
namespace io = css::io;
using namespace osl;

// StringHelper
inline void operator <<= (rtl::OString& _rAsciiString, const rtl::OUString& _rUnicodeString)
{
	_rAsciiString = rtl::OUStringToOString(_rUnicodeString,RTL_TEXTENCODING_ASCII_US);
}

class Fan
{
public:
    Fan() {}
    
    static void print()
        {
            static char carr[4] = { '-','\\','|','/' };
            static m_cnt = 0;
            fprintf(stdout, "%c\r", carr[m_cnt]);
            fflush(stdout);
            ++ m_cnt;
            if (m_cnt >= 4)
            {
                m_cnt = 0;
            }
        }
    static void printFile(rtl::OUString const& _suFile, sal_Int32 _nMaxChars)
        {
            rtl::OString sFile;
            sFile <<= _suFile;
            if (sFile.getLength() > _nMaxChars)
            {
                sal_Int32 nPos = sFile.getLength() - _nMaxChars;
                sFile = sFile.copy(nPos);
            }
            fprintf(stdout, "%s\r", sFile.getStr());
            fflush(stdout);
        }
    
};

namespace FileHelper
{
    
    //==========================================================================
    //= FileHelper
    //==========================================================================	

    // -----------------------------------------------------------------------------
    // const rtl::OUString& delimiterAsString() 
    // { 
    //     static const rtl::OUString aStringDelimiter( &delimiter,1); 
    //     return aStringDelimiter;
    // }

	// -----------------------------------------------------------------------------
	rtl::OUString createOSLErrorString(FileBase::RC eError)
	{
		rtl::OUString aRet;
		switch(eError)
		{
		case osl_File_E_None:
			break;

		case osl_File_E_PERM:
			aRet = rtl::OUString::createFromAscii("Operation not permitted");
			break;

		case osl_File_E_NOENT:
			aRet = rtl::OUString::createFromAscii("No such file or directory");
			break;

		case osl_File_E_SRCH:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_SRCH");
			break;

		case osl_File_E_INTR:
			aRet = rtl::OUString::createFromAscii("function call was interrupted");
			break;

		case osl_File_E_IO:
			aRet = rtl::OUString::createFromAscii("I/O error");
			break;

		case osl_File_E_NXIO:
			aRet = rtl::OUString::createFromAscii("No such device or address");
			break;

		case osl_File_E_2BIG:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_2BIG");
			break;

		case osl_File_E_NOEXEC:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_NOEXEC");
			break;

		case osl_File_E_BADF:
			aRet = rtl::OUString::createFromAscii("Bad file");
			break;

		case osl_File_E_CHILD:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_CHILD");
			break;

		case osl_File_E_AGAIN:
			aRet = rtl::OUString::createFromAscii("Operation would block");
			break;

		case osl_File_E_NOMEM:
			aRet = rtl::OUString::createFromAscii("not enough memory for allocating structures");
			break;

		case osl_File_E_ACCES:
			aRet = rtl::OUString::createFromAscii("Permission denied");
			break;

		case osl_File_E_FAULT:
			aRet = rtl::OUString::createFromAscii("Bad address");
			break;

		case osl_File_E_BUSY:
			aRet = rtl::OUString::createFromAscii("Text file busy");
			break;

		case osl_File_E_EXIST:
			aRet = rtl::OUString::createFromAscii("File exists");
			break;

		case osl_File_E_XDEV:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_XDEV");
			break;

		case osl_File_E_NODEV:
			aRet = rtl::OUString::createFromAscii("No such device");
			break;

		case osl_File_E_NOTDIR:
			aRet = rtl::OUString::createFromAscii("Not a directory");
			break;

		case osl_File_E_ISDIR:
			aRet = rtl::OUString::createFromAscii("Is a director");
			break;

		case osl_File_E_INVAL:
			aRet = rtl::OUString::createFromAscii("the format of the parameters was not valid");
			break;

		case osl_File_E_NFILE:
			aRet = rtl::OUString::createFromAscii("too many open files in the system");
			break;

		case osl_File_E_MFILE:
			aRet = rtl::OUString::createFromAscii("too many open files used by the process");
			break;

		case osl_File_E_NOTTY:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_NOTTY");
			break;

		case osl_File_E_FBIG:
			aRet = rtl::OUString::createFromAscii("File too large");
			break;

		case osl_File_E_NOSPC:
			aRet = rtl::OUString::createFromAscii("No space left on device");
			break;

		case osl_File_E_SPIPE:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_SPIPE");
			break;

		case osl_File_E_ROFS:
			aRet = rtl::OUString::createFromAscii("Read-only file system");
			break;

		case osl_File_E_MLINK:
			aRet = rtl::OUString::createFromAscii("Too many links");
			break;

		case osl_File_E_PIPE:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_PIPE");
			break;

		case osl_File_E_DOM:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_DOM");
			break;

		case osl_File_E_RANGE:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_RANGE");
			break;

		case osl_File_E_DEADLK:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_DEADLK");
			break;

		case osl_File_E_NAMETOOLONG:
			aRet = rtl::OUString::createFromAscii("File name too long");
			break;

		case osl_File_E_NOLCK:
			aRet = rtl::OUString::createFromAscii("No record locks available");
			break;

		case osl_File_E_NOSYS:
			aRet = rtl::OUString::createFromAscii("Function not implemente");
			break;

		case osl_File_E_NOTEMPTY:
			aRet = rtl::OUString::createFromAscii("Directory not empt");
			break;

		case osl_File_E_LOOP:
			aRet = rtl::OUString::createFromAscii("Too many symbolic links encountered");
			break;

		case osl_File_E_ILSEQ:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_ILSEQ");
			break;

		case osl_File_E_NOLINK:
			aRet = rtl::OUString::createFromAscii("Link has been severed");
			break;

		case osl_File_E_MULTIHOP:
			aRet = rtl::OUString::createFromAscii("Multihop attempted");
			break;

		case osl_File_E_USERS:
			aRet = rtl::OUString::createFromAscii("unknown error: osl_File_E_USERS");
			break;

		case osl_File_E_OVERFLOW:
			aRet = rtl::OUString::createFromAscii("Value too large for defined data type");
			break;

			/* unmapped error: always last entry in enum! */
		case osl_File_E_invalidError:
			aRet = rtl::OUString::createFromAscii("unmapped Error");
			break;
		}
		return aRet;
	}

	// -----------------------------------------------------------------------------
	void removeFile(const rtl::OUString& _aURL) throw (io::IOException)
	{
		FileBase::RC eError = File::remove(_aURL);
		if (eError != osl_File_E_None &&
			eError != osl_File_E_NOENT)
		{
			rtl::OUString sError = rtl::OUString::createFromAscii("tryToRemoveFile: ");
			sError += createOSLErrorString(eError);
			sError += rtl::OUString::createFromAscii("\n with URL: ");
			sError += _aURL;
			OSL_ENSURE(0, rtl::OUStringToOString(sError,RTL_TEXTENCODING_ASCII_US).getStr());
			throw io::IOException(sError, NULL);
		}
	}

	// -----------------------------------------------------------------------------
	void replaceFile(
		const rtl::OUString& _aToURL, const rtl::OUString &_aFromURL) throw (io::IOException)
	{
		removeFile(_aToURL);
		FileBase::RC eError = File::move(_aFromURL, _aToURL);
		if (eError != osl_File_E_None)
		{
			rtl::OUString sError = rtl::OUString::createFromAscii("createBackupAndRemove: ") + createOSLErrorString(eError) + rtl::OUString::createFromAscii("\n with URL: ") + _aFromURL;
			OSL_ENSURE(0, rtl::OUStringToOString(sError,RTL_TEXTENCODING_ASCII_US).getStr());
			throw io::IOException(sError, NULL);
		}
	}

	// -----------------------------------------------------------------------------
	bool fileExists(rtl::OUString const& _sFileURL)
	{
		DirectoryItem aItem;
		return DirectoryItem::get(_sFileURL, aItem) == osl_File_E_None;
	}

	// -----------------------------------------------------------------------------
	bool dirExists(rtl::OUString const& _sDirURL)
	{
		return Directory(_sDirURL).open() == osl_File_E_None;
	}

	// -----------------------------------------------------------------------------
	TimeValue getModifyTime(rtl::OUString const& _sURL)
	{
		TimeValue aTime = {0,0};
		DirectoryItem aItem;
		if (osl::FileBase::E_None == DirectoryItem::get(_sURL, aItem))
		{
			FileStatus aStatus(osl_FileStatus_Mask_ModifyTime|osl_FileStatus_Mask_Type);
			if (osl::FileBase::E_None == aItem.getFileStatus(aStatus) && aStatus.isValid(osl_FileStatus_Mask_ModifyTime))
				aTime = aStatus.getModifyTime();
		}
		return aTime;
	}

	// -----------------------------------------------------------------------------
	sal_uInt64 getFileSize(rtl::OUString const& _sURL)
	{
        sal_uInt64 nSize = 0;
		DirectoryItem aItem;
        FileBase::RC eError = DirectoryItem::get(_sURL, aItem);
		if (osl::FileBase::E_None == eError)
		{
			FileStatus aStatus(osl_FileStatus_Mask_FileSize);
			if (osl::FileBase::E_None == aItem.getFileStatus(aStatus) && aStatus.isValid(osl_FileStatus_Mask_FileSize))
			{
                nSize = aStatus.getFileSize();
            }
            else
            {
                fprintf(stderr, "filesize: Status not valid.\n");
            }
		}
        else
        {
			rtl::OUString sError = rtl::OUString::createFromAscii("getFileSize: ");
			sError += createOSLErrorString(eError);
            fprintf(stderr, "error: %s\n", sError.getStr());
        }
        
		return nSize;
	}

	// -----------------------------------------------------------------------------
    void splitFileUrl(const rtl::OUString& aFileUrl,
                      rtl::OUString& aParentDirectory,
                      rtl::OUString& aFileName) {
		// goto last '/' and cut the rest.
		sal_Int32 nIdx = aFileUrl.lastIndexOf(rtl::OUString::createFromAscii("/"), aFileUrl.getLength());
		if (nIdx > 0) {
			aParentDirectory = aFileUrl.copy(0, nIdx);
            aFileName = aFileUrl.copy(nIdx + 1) ;
        }
        else {
            aParentDirectory = rtl::OUString() ;
            aFileName = aFileUrl ;
        }
	}

	// -----------------------------------------------------------------------------
	rtl::OUString getParentDir(rtl::OUString const& _sURL)
	{
        rtl::OUString parentDirectory ;
        rtl::OUString fileName ;

        splitFileUrl(_sURL, parentDirectory, fileName) ;
        return parentDirectory ;
    }
	// -----------------------------------------------------------------------------
    rtl::OUString getFileName(const rtl::OUString& aFileUrl) {
        rtl::OUString parentDirectory ;
        rtl::OUString fileName ;

        splitFileUrl(aFileUrl, parentDirectory, fileName) ;
        return fileName ;
    }
	// -----------------------------------------------------------------------------
	bool mkdir(rtl::OUString const& _sDirURL)
	{
		// direct create a directory
		osl::FileBase::RC eError = osl::Directory::create(_sDirURL); // try to create the directory
		if (eError == osl::FileBase::E_EXIST ||
			eError == osl::FileBase::E_None ||
			dirExists(_sDirURL)) return true; // Exists or created
		else
			return false;
	}

	// -----------------------------------------------------------------------------
	bool mkdirs(rtl::OUString const& _sDirURL)
	{
		bool bRes = mkdir(_sDirURL);
		if (!bRes)
		{
			rtl::OUString sParentDir = getParentDir(_sDirURL);
			bRes = (sParentDir.getLength() > 0) && mkdirs(sParentDir) && mkdir(_sDirURL);
		}
		return bRes;
	}

    // -----------------------------------------------------------------------------

    void removeRecursive(rtl::OUString const& _suDirURL)
    {
        // remove directory rekursivly
        // Deletes all files and subdirectories under dir.
        // Returns true if all deletions were successful.
        // If a deletion fails, the method stops attempting to delete and returns false.

        {
            osl::Directory aDir(_suDirURL);
            aDir.open();
            if (aDir.isOpen())
            {
                osl::DirectoryItem aItem;
                osl::FileStatus aStatus(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes);
                while (aDir.getNextItem(aItem) == ::osl::FileBase::E_None)
                {
                    if (osl::FileBase::E_None == aItem.getFileStatus(aStatus) && aStatus.isValid(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes))
                    {
                        rtl::OUString suFilename = aStatus.getFileName();
                        rtl::OUString suFullFileURL;
                        suFullFileURL += _suDirURL;
                        suFullFileURL += rtl::OUString::createFromAscii("/");
                        suFullFileURL += suFilename;
                        
                        if (aStatus.getFileType() == osl::FileStatus::Directory)
                        {
                            removeRecursive(suFullFileURL);
                        }
                        else
                        {
                            // consider the name, see about
                            try
                            {
                                removeFile(suFullFileURL);
                            }
                            catch(io::IOException &e)
                            {
                                rtl::OString sMessage;
                                sMessage <<= e.Message;
                                fprintf(stderr, "error: %s\n", sMessage);
                            }
                        }
                    }
                }
                aDir.close();
            }
        }
        osl::Directory::remove(_suDirURL);
    }
    

    // -----------------------------------------------------------------------------

    rtl::OString getSystemPathFromFileURLAsAscii(rtl::OUString const& _suFileURL)
    {
        rtl::OUString suSystemPath;
        osl::FileBase::getSystemPathFromFileURL(_suFileURL, suSystemPath);
        rtl::OString sSystemPath;
        sSystemPath <<= suSystemPath;
        return sSystemPath;
    }


} // namespace FileHelper
// ============================================================================

typedef sal_uInt32 CRCSum;
// -----------------------------------------------------------------------------
class FileEntry
{
    rtl::OUString m_suFileURL;
public:
    CRCSum     nCRC;
    sal_uInt64 nSize;
    bool       bReplaced;

    FileEntry()
            :nCRC(0),
             nSize(0),
             bReplaced(false)
        {}

    rtl::OUString getFilename()
        {
            rtl::OUString suFilename;
            osl::FileBase::getSystemPathFromFileURL(m_suFileURL, suFilename);
            return suFilename;
        }

    rtl::OString getAsciiFilename()
        {
            rtl::OUString suFilename( getFilename() );
            rtl::OString sFilename;
            sFilename <<= suFilename;
            return sFilename;
        }

    void setFileURL(rtl::OUString const& _sFileURL) { m_suFileURL = _sFileURL; }
    rtl::OUString getFileURL() {return m_suFileURL;}
};

// DECLARE_LIST( Filelist, FileEntry* );
// Filelist aFilelist;
typedef std::vector<FileEntry*> Filelist;
Filelist aFilelist;

// ============================================================================
sal_uInt32 createCRC(rtl::OUString const _suFileURL, sal_uInt32 _nCRC = 0)
{
    rtl::OString sFilename = FileHelper::getSystemPathFromFileURLAsAscii(_suFileURL);

    FILE* file = fopen( sFilename.getStr(), "rb" );
    sal_uInt32 nCRC = _nCRC;

    if( file )
    {
        char buf[MAX_BUF_SIZE];
        int num = 0;
        while( ( num = fread( buf, sizeof(char), MAX_BUF_SIZE, file) ) > 0 )
            nCRC = rtl_crc32(nCRC, buf, num);
        fclose( file );
    }
    return nCRC;
}
// ============================================================================

sal_Int32 nTotalBytesWritten = 0;
sal_Int32 nLastBytesWritten = 0;
sal_Int32   nTotalSize = 0;

void __UnzipCallback(long _lBytesWritten)
{
    if ( _lBytesWritten <= nLastBytesWritten )
        nTotalBytesWritten += nLastBytesWritten;

    nLastBytesWritten = _lBytesWritten;

    long nPercent = ( ( nTotalBytesWritten + _lBytesWritten ) / ( nTotalSize / 100 ) );

}

// ============================================================================

rtl::OUString getSystemTempDirURL()
{
    //# static ByteString sTmpDir;
    //#
    //# if (sTmpDir.Len() == 0)
    //# {
    //#     SiDirEntry aTmpDir;
    //#     char* cTmpDir = getenv("TEMP");
    //#     if ( cTmpDir != NULL )
    //#     {
    //#         sTmpDir = ByteString(cTmpDir);
    //#         aTmpDir = sTmpDir;
    //#     }
    //#     if ( (cTmpDir == NULL) || (! aTmpDir.Exists()))
    //#     {
    //#         cTmpDir = getenv("TMP");
    //#         if (cTmpDir != NULL)
    //#         {
    //#             sTmpDir = ByteString(cTmpDir);
    //#             aTmpDir = sTmpDir;
    //#         }
    //#
    //#         if ((cTmpDir != NULL) || (! aTmpDir.Exists()))
    //#         {
    //#             fprintf( stderr, "Error: No tmp directory found, please set TMP or TEMP env variable.\n" );
    //#             PrintRedundancyEliminatorUsage();
    //#             exit( -1 );
    //#         }
    //#     }
    //# }
    rtl::OUString suTmpDirURL;
    osl::FileBase::getTempDirURL(suTmpDirURL);

    return suTmpDirURL;
}

// -----------------------------------------------------------------------------

namespace ThreadHelper
{
    void sleep(sal_Int32 _nMilliSec)
    {
#ifdef WNT
        Sleep(_nMilliSec);
#endif
#ifdef UNX
        usleep(_nMilliSec * 1000);
#endif
    }
}

// -----------------------------------------------------------------------------
CRCSum createCRCFromDir(rtl::OUString const& _aDirURL, CRCSum _nStartCRC = 0)
{
    CRCSum nCRC = _nStartCRC;
    osl::Directory aDir(_aDirURL);
    aDir.open();
    if (aDir.isOpen())
    {
        osl::DirectoryItem aItem;
        osl::FileStatus aStatus(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes);
        while (aDir.getNextItem(aItem) == ::osl::FileBase::E_None)
        {
			if (osl::FileBase::E_None == aItem.getFileStatus(aStatus) && aStatus.isValid(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes))
            {
				// aTime = aStatus.getModifyTime();
                rtl::OUString suFilename = aStatus.getFileName();
                rtl::OUString suFullFileURL;
                suFullFileURL += _aDirURL;
                suFullFileURL += rtl::OUString::createFromAscii("/");
                suFullFileURL += suFilename;

                if (aStatus.getFileType() == osl::FileStatus::Directory)
                {
                    // build crc sum, important is that we also consider the name, because
                    // files which contains the same but have different names, MUST not
                    // link, because we are IN a zip.

                    nCRC = createCRCFromDir(suFullFileURL, nCRC);
                }
                else
                {
                    if (aStatus.getFileType() == osl::FileStatus::Regular)
                    {
                        // consider the name, see about
                        rtl::OString sFilename;
                        sFilename <<= suFilename;
                        
                        nCRC = rtl_crc32(nCRC, sFilename.toAsciiLowerCase().getStr(), sFilename.getLength() );
                        nCRC = createCRC(suFullFileURL, nCRC);
                        
                        // TODO / nice to have :
                        // zip in zip
                    }
                }
            }
        }
        aDir.close();
    }


    //# Dir aDir( _aDirectory, FSYS_KIND_FILE | FSYS_KIND_DIR, FSYS_SORT_ASCENDING | FSYS_SORT_NAME );
    //# ThreadHelper::sleep(1000);
    //# for( USHORT i = 0; i < aDir.Count(); ++i )
    //# {
    //#     SiDirEntry aEntry( aDir[i] );
    //#
    //#     ByteString aName = aEntry.GetName();
    //#     if( aName.CompareIgnoreCaseToAscii(".")  == COMPARE_EQUAL ||
    //#         aName.CompareIgnoreCaseToAscii("..") == COMPARE_EQUAL )
    //#         continue;
    //#     FileStat aStat( aEntry );
    //#     if( aStat.GetKind() == FSYS_KIND_DIR )
    //#     {
    //#         // build crc sum, important is that we also consider the name, because
    //#         // files which contains the same but have different names, MUST not
    //#         // link, because we are IN a zip.
    //#
    //#         nCRC = rtl_crc32(nCRC, aName.ToLowerAscii().GetBuffer(), aName.Len());
    //#         nCRC = createCRCFromDir( aEntry.GetFull(), nCRC );
    //#     }
    //#     else
    //#     {
    //#         // consider the name, see about
    //#         nCRC = rtl_crc32(nCRC, aName.ToLowerAscii().GetBuffer(), aName.Len());
    //#         ByteString aFullname = aEntry.GetFull();
    //#         nCRC = createCRC(aFullname, nCRC);
    //#
    //#         // TODO / nice to have :
    //#         // zip in zip
    //#     }
    //# }
    return nCRC;
}

#ifdef WNT
extern "C"
{
    void _timezone()
    {}

}

#endif

// -----------------------------------------------------------------------------
CRCSum decompressInTempFolder(rtl::OUString const& _suFilename, rtl::OUString const& _suFullPathWithName)
{
    rtl::OUString suTmpDirURL(getSystemTempDirURL());
    rtl::OUString suTmpDirURL2(suTmpDirURL);
//#     DirEntry aDir(sTmpDir);
//#     aDir += ByteString("red");
//# #ifdef UNX
//#     aDir += ByteString::CreateFromInt32(getpid());
//# #endif
//#     aDir += _sFilename;
//#
//#     if (aDir.Exists())
//#     {
//#         aDir.Kill(FSYS_ACTION_RECURSIVE);
//#     }
    suTmpDirURL += rtl::OUString::createFromAscii("/red");
#ifdef UNX
    suTmpDirURL += rtl::OUString::createFromAscii("/");
    suTmpDirURL += rtl::OUString::valueOf(static_cast<sal_Int32>(getpid()));
#endif
    suTmpDirURL += rtl::OUString::createFromAscii("/");
    suTmpDirURL += _suFilename;

    if (FileHelper::dirExists(suTmpDirURL))
    {
        FileHelper::removeRecursive(suTmpDirURL);
    }

    FileHelper::mkdirs(suTmpDirURL);
//#    aDir.SetCWD();
// #ifdef UNX

    CRCSum nCRC = rand();
    rtl::OString sFullPathWithName (FileHelper::getSystemPathFromFileURLAsAscii(_suFullPathWithName));
    FILE *in = fopen(sFullPathWithName.getStr(), "rb");
    if (in)
    {
        // short scan, if the file is really a zip file
        char c1 = fgetc(in);
        char c2 = fgetc(in);
        fclose(in);

        if (c1 == 'P' && c2 == 'K')
        {
            rtl::OString sTmpDirName (FileHelper::getSystemPathFromFileURLAsAscii(suTmpDirURL));
            chdir(sTmpDirName);
            
            ::SVUnzip( sFullPathWithName.getStr(), "*.*", (const char*)"qq", NULL /* (UnzipCallBack*) __UnzipCallback */ );
            nCRC = createCRCFromDir(suTmpDirURL);
        }
        else
        {
            nCRC = createCRC(_suFullPathWithName);
        }
    }
// #endif

    if (FileHelper::dirExists(suTmpDirURL)) // some paranoid
    {
		// set us back to the real tmp dir.
		// maybe the directory can't remove, if we stay in there
        rtl::OString sTmpDirName (FileHelper::getSystemPathFromFileURLAsAscii(suTmpDirURL2));
        chdir(sTmpDirName);
        FileHelper::removeRecursive(suTmpDirURL);
    }
    return nCRC;
}

// -----------------------------------------------------------------------------
sal_Int32 countSource( rtl::OUString const& _suPathURL )
{
    sal_Int32 nCount = 0;
    osl::Directory aDir(_suPathURL);
    aDir.open();
    if (aDir.isOpen())
    {
        osl::DirectoryItem aItem;
        osl::FileStatus aStatus(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes);
        while (aDir.getNextItem(aItem) == ::osl::FileBase::E_None)
        {
			if (osl::FileBase::E_None == aItem.getFileStatus(aStatus) && aStatus.isValid(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes))
            {
				// aTime = aStatus.getModifyTime();
                rtl::OUString suFilename = aStatus.getFileName();
                rtl::OUString suFullFileURL;
                suFullFileURL += _suPathURL;
                suFullFileURL += rtl::OUString::createFromAscii("/");
                suFullFileURL += suFilename;
                
                if (aStatus.getFileType() == osl::FileStatus::Directory)
                {
                    nCount += countSource(suFullFileURL);
                }
                else
                {
                    if (aStatus.getFileType() == osl::FileStatus::Regular)
                    {
                        if (! bConsiderAll)
                            if( suFilename.equalsAsciiL("f0_", 3) != sal_True &&
                                suFilename.equalsAsciiL("f_", 2)  != sal_True )
                                continue;
                        
                        ++nCount;
                    }
                }
            }
        }
        aDir.close();
    }
    return nCount;
}

// -----------------------------------------------------------------------------
static sal_Int32 nRealCount = 0;
static sal_Int32 nCurrentCount = 0;
void ReadSource( rtl::OUString const& _suPathURL )
{
    // Dir aDir( rPath, FSYS_KIND_FILE | FSYS_KIND_DIR, FSYS_SORT_ASCENDING | FSYS_SORT_NAME );
    osl::Directory aDir(_suPathURL);
    aDir.open();
    if (aDir.isOpen())
    {
        osl::DirectoryItem aItem;
        osl::FileStatus aStatus(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes);
        while (aDir.getNextItem(aItem) == ::osl::FileBase::E_None)
        {
			if (osl::FileBase::E_None == aItem.getFileStatus(aStatus) && aStatus.isValid(osl_FileStatus_Mask_FileName | osl_FileStatus_Mask_Attributes))
            {
				// aTime = aStatus.getModifyTime();
                rtl::OUString suFilename = aStatus.getFileName();
                rtl::OUString suFullFileURL;
                suFullFileURL += _suPathURL;
                suFullFileURL += rtl::OUString::createFromAscii("/");
                suFullFileURL += suFilename;

                if (aStatus.getFileType() == osl::FileStatus::Directory)
                {
                    ReadSource(suFullFileURL);
                }
                else
                {
                    if (aStatus.getFileType() == osl::FileStatus::Regular)
                    {
                        if (! bConsiderAll)
                            if( suFilename.equalsAsciiL("f0_", 3) != sal_True &&
                                suFilename.equalsAsciiL("f_", 2)  != sal_True )
                                continue;
                        
                        if ( bVerboseMode )
                        {
                            ++nCurrentCount;
                            sal_Int32 nPercent = nCurrentCount * 100 / nRealCount;
                            fprintf( stdout, "Working at %d%%.\r", nPercent);
                            fflush(stdout);
                            // Fan::print();
                            // Fan::printFile(suFullFileURL, 79);
                            // fprintf( stderr, "." );
                            // if ((++ nCount) >= 79)
                            // {
                            //     nCount = 0;
                            //     fprintf(stderr, "\n");
                            // }
                            
                        }
                        
                        // we only want to check f0_ and f_ files
                        
                        CRCSum nCRC = decompressInTempFolder(suFilename, suFullFileURL);
                        
                        // sal_uInt32 nCRC = createCRC(aFullname);
                        
                        FileEntry* pNew = new FileEntry;
                        pNew->nCRC = nCRC;
                        pNew->nSize = FileHelper::getFileSize(suFullFileURL); /* aStat.GetSize();*/
                        // pNew->aAbsFilename = aEntry.GetFull();
                        pNew->setFileURL(suFullFileURL);
                        pNew->bReplaced = false;
                        
                        // aFilelist.Insert( pNew, LIST_APPEND );
                        aFilelist.push_back(pNew);
                        
                        // rtl::OString sFileURL;
                        // sFileURL <<= suFullFileURL;
                        // printf("File URL: %s\n", sFileURL.getStr());
                    }
                }
            }
        }
        aDir.close();
    }


    //# for( USHORT i = 0; i < aDir.Count(); ++i )
    //# {
    //#     SiDirEntry aEntry( aDir[i] );
    //#
    //#     ByteString aName = aEntry.GetName();
    //#     if( aName.CompareIgnoreCaseToAscii(".")  == COMPARE_EQUAL ||
    //#         aName.CompareIgnoreCaseToAscii("..") == COMPARE_EQUAL )
    //#         continue;
    //#
    //#     FileStat aStat( aEntry );
    //#     if( aStat.GetKind() == FSYS_KIND_DIR )
    //#     {
    //#         ReadSource( aEntry.GetFull() );
    //#     }
    //#     else
    //#     {
    //#         if (! bConsiderAll)
    //#             if( aName.CompareIgnoreCaseToAscii("f0_", 3) != COMPARE_EQUAL &&
    //#                 aName.CompareIgnoreCaseToAscii("f_", 2)  != COMPARE_EQUAL )
    //#                 continue;
    //#
    //#         if ( bVerboseMode )
    //#         {
    //#             fprintf( stderr, "." );
    //#             if ((++ nCount) >= 80)
    //#             {
    //#                 nCount = 0;
    //#                 fprintf(stderr, "\n");
    //#             }
    //#         }
    //#
    //#         // we only want to check f0_ and f_ files
    //#         ByteString aFullname = aEntry.GetFull();
    //#
    //#         CRCSum nCRC = decompressInTempFolder(aName, aFullname);
    //#
    //#         // sal_uInt32 nCRC = createCRC(aFullname);
    //#
    //#         FileEntry* pNew = new FileEntry;
    //#         pNew->nCRC = nCRC;
    //#         pNew->nSize = aStat.GetSize();
    //#         // pNew->aAbsFilename = aEntry.GetFull();
    //#         pNew->setFileURL(aEntry.GetFull());
    //#         pNew->bReplaced = false;
    //#
    //#         // aFilelist.Insert( pNew, LIST_APPEND );
    //#         aFilelist.push_back(pNew);
    //#     }
    //# }
}

// ============================================================================

void verboseFileEntry()
{
    // for( USHORT n = 0; n < aFilelist.Count(); ++n )
    Filelist::const_iterator aItEnd = aFilelist.end();
    for(Filelist::const_iterator it = aFilelist.begin();
        it != aItEnd; ++it)
    {
        // FileEntry* pEntry = *aFilelist.GetObject(n); // do not delete or link this file
        FileEntry* pEntry = *it;
		sal_Int32 nSize = sal_Int32(pEntry->nSize);
        printf("%8x\t%d\t%s\n", pEntry->nCRC, nSize, pEntry->getAsciiFilename().getStr());
    }
}

// -----------------------------------------------------------------------------
class FileEntryHelper
{
    rtl::OUString fs;

    rtl::OUString getTilSlash(rtl::OUString const& _sFile)
        {
            rtl::OUString sTilSlash;
            sal_Int32 nSlash = _sFile.indexOf(fs);
            if (nSlash >= 0)
            {
                sTilSlash = _sFile.copy(0, nSlash);
            }

            return sTilSlash;
        }

    rtl::OUString getFromSlash(rtl::OUString const& _sFile)
        {
            rtl::OUString sTilSlash;
            sal_Int32 nSlash = _sFile.indexOf(fs);
            if (nSlash >= 0)
            {
                sTilSlash = _sFile.copy(nSlash + 1);
            }
            else
            {
                sTilSlash = _sFile;
            }
            return sTilSlash;
        }

public:

    FileEntryHelper()
        {
#ifdef WNT
            fs = rtl::OUString::createFromAscii("\\");
#endif
#ifdef UNX
            fs = rtl::OUString::createFromAscii("/");
#endif
        }

    rtl::OUString makeRelative(rtl::OUString const& _suOrig, rtl::OUString const& _suCouldLink)
        {
            rtl::OUString aOrig( _suOrig );
            rtl::OUString aLink( _suCouldLink );
            rtl::OUString sEqual;

            // first test.
            if (! getTilSlash( aOrig ).equals( getTilSlash( aLink ) ) )
                return aOrig;

            // remove equal directories
            while (getTilSlash( aOrig ).equals( getTilSlash( aLink ) ) )
            {
                aOrig = getFromSlash(aOrig);
                aLink = getFromSlash(aLink);
                if (aOrig.indexOf(fs) < 0)
                {
                    if (aLink.indexOf(fs) >= 0)
					{
                        return rtl::OUString();
                        // this something, we can't work with
						// rtl::OUString aTmp = aOrig;
						// aOrig = aLink;
						// aLink = aTmp;
					}
					else
                    {
                        return aOrig;
                    }
                }
            }
            int nPos = 0;
            while((nPos = aLink.indexOf(fs)) >= 0)
            {
                aLink = getFromSlash(aLink);
                rtl::OUString aOrigBackup(aOrig);

                aOrig = rtl::OUString::createFromAscii("..");
                aOrig += fs;
                aOrig += aOrigBackup;
            }
            // path from copy relative to the original
            return aOrig;
        }

    rtl::OUString filenameOnly(rtl::OUString const& _sFilename)
        {
            int nPos = 0;
            rtl::OUString sFilename = _sFilename;
            nPos = sFilename.lastIndexOf(fs);
            if (nPos >= 0)
            {
                sFilename = sFilename.copy(nPos + 1);
            }
            return sFilename;
        }

};
// -----------------------------------------------------------------------------
sal_uInt64 Eliminate( sal_Int32& _nrCount )
{
    sal_uInt64 nBytes = 0;
    // for( USHORT n = 0; n < aFilelist.Count(); ++n )

    Filelist::const_iterator aItEnd = aFilelist.end();
    for(Filelist::const_iterator it = aFilelist.begin();
        it != aItEnd; ++it)
    {
        // FileEntry* pOrigEntry = *aFilelist.GetObject(n); // do not delete or link this file
        FileEntry* pOrigEntry = *it; // do not delete or link this file

        // start at position n + 1, so we do not need to check kill and link our self.
        // for( USHORT x = n + 1; x < aFilelist.Count(); ++x )
        for(Filelist::const_iterator it2 = it; it2 != aItEnd; ++it2)
        {
            // FileEntry* pCouldLink = aFilelist.GetObject(x);
            FileEntry* pCouldLink = *it2;
            
            if( pCouldLink->bReplaced ||
                pCouldLink == pOrigEntry  )              // paranoid, check to our self
            {
                continue;
            }

            // redundance conditions
            // CRC must not 0
            // CRC must equal between Orig and CouldLink files
            // File size must not 0 and must be equal
            //
            // It's possible that two different files have same size and same CRC
            // but it's very improbably
            
            if( ( pOrigEntry->nCRC != 0 ) &&
                ( pOrigEntry->nCRC  == pCouldLink->nCRC ))
            {
                sal_Int32 nOrigEntrySize = sal_Int32(pOrigEntry->nSize);
                if ( nOrigEntrySize > 0 )
                {
                    sal_Int32 nCouldLinkSize = sal_Int32(pCouldLink->nSize);
                    
                    if ( nOrigEntrySize != nCouldLinkSize )
                    {
                        fprintf(stderr,"size differ. \n");
                        fprintf( stderr, "%d  %s\n",   nCouldLinkSize, pCouldLink->getAsciiFilename().getStr());
                        fprintf( stderr, "%d  %s\n\n", nOrigEntrySize, pOrigEntry->getAsciiFilename().getStr());
                    }
                    else
                    {
                        // both checksums are equal, so we link pCouldLink to pOrigEntry
                        ++_nrCount;
                        
                        // pOrigEntry->bReplaced = true;
                        pCouldLink->bReplaced = true;
                        nBytes += pCouldLink->nSize;
                        
                        if (! bRelativeMode)
                        {
                            if( !bTestOnlyMode )
                            {
#ifdef UNX
                                // SiDirEntry aEntry( pCouldLink->aAbsFilename );
                                // aEntry.Kill();
                                rtl::OUString suCouldLinkURL = pCouldLink->getFileURL();

                                rtl::OUString suPath = FileHelper::getParentDir(pCouldLink->getFileURL());
                                rtl::OString sSystemPath = FileHelper::getSystemPathFromFileURLAsAscii(suPath);
                                
                                FileBase::RC eError = File::remove(suCouldLinkURL);
                                if (eError == osl_File_E_None)
                                {
                                    chdir(sSystemPath.getStr());
                                    symlink( pOrigEntry->getAsciiFilename().getStr(), pCouldLink->getAsciiFilename().getStr() );
                                }
#endif
                            }

                            if( bVerboseMode )
                            {
                                fprintf( stderr, "%s   ==>   %s\n\n", pCouldLink->getAsciiFilename().getStr(), pOrigEntry->getAsciiFilename().getStr() );
                            }
                        }
                        else
                        {
                            // relative mode
                            rtl::OUString sOriginal = pOrigEntry->getFilename();
                            rtl::OUString sLink     = pCouldLink->getFilename();

                            // symlink( pOrigEntry->aAbsFilename.GetBuffer(), pCouldLink->aAbsFilename.GetBuffer() );
                            // printf("SymLink: orig:%s, link:%s", sOld.GetBuffer(), sNew.GetBuffer());

                            // make the link relative to the original
                            FileEntryHelper aHelper;
                            rtl::OUString aRelative = aHelper.makeRelative(sOriginal, sLink);
                            if (aRelative.getLength() > 0)
                            {
                                rtl::OUString suFilename = aHelper.filenameOnly(sLink);
                                if (suFilename.getLength() > 0)
                                {
                                    // change directory to the path, where the link should stay.
                                    // SiDirEntry aEntry( pCouldLink->aAbsFilename );
                                    // SiDirEntry aPath = aEntry.GetPath();
                                    // aPath.SetCWD();
                                    rtl::OUString suPath = FileHelper::getParentDir(pCouldLink->getFileURL());
                                    rtl::OString sSystemPath = FileHelper::getSystemPathFromFileURLAsAscii(suPath);

                                    rtl::OString sFilename;
                                    sFilename <<= suFilename;

                                    rtl::OString sRelative;
                                    sRelative <<= aRelative;
#ifdef UNX
                                    if( !bTestOnlyMode )
                                    {
                                        // aEntry.Kill();
                                        rtl::OUString suCouldLinkURL = pCouldLink->getFileURL();
                                        FileBase::RC eError = File::remove(suCouldLinkURL);

                                        chdir(sSystemPath.getStr());
                                        symlink( sRelative.getStr(), sFilename.getStr() );
                                    }
#else
                                    // ByteString sPath = aPath.GetFull().GetBuffer();
                                    printf("cd %s ; ", sSystemPath.getStr());
                                    printf("symlink(%s, %s)\n", sRelative.getStr(), sFilename.getStr());
#endif

                                    // this is to debug the behavior
                                    if ( bWindowsDebugMode)
                                    {
                                        rtl::OUString suCouldLinkURL = pCouldLink->getFileURL();
                                        FileBase::RC eError = File::remove(suCouldLinkURL);
                                        chdir(sSystemPath.getStr());
                                        
                                        sFilename += ".link";
                                        FILE* out = fopen(sFilename.getStr(), "w");
                                        if (out)
                                        {
                                            fprintf(out, "%s\n", sRelative.getStr());
                                            fclose(out);
                                        }
                                    }
                                    
                                    if( bVerboseMode )
                                    {
                                        fprintf( stderr, "%s   ==>   %s\n\n", sFilename.getStr(), sRelative.getStr() );
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    return nBytes;
}

// ============================================================================

int main( int argv, char** argc )
{
    fprintf( stderr, "\nRedundancy Eliminator 1.2 (c) 2000-2003 Sun Microsystems\n\n" );
    if( argv == 1 )
    {
        PrintRedundancyEliminatorUsage();
        exit( -1 );
    }

    // === evaluate parameter & environment ===================================
    for( sal_Int32 n = 1; n < argv; n++ )
    {
        if( argc[ n ][ 0 ] == '-' )
        {
            switch( argc[ n ][ 1 ] )
            {
            case 's':
            {
                rtl::OUString suSourcePath( rtl::OUString::createFromAscii(argc[ ++n ]) );
                osl::FileBase::getFileURLFromSystemPath(suSourcePath, suSourcePathURL);
            }

            break;
            case 't':
                bTestOnlyMode = true;
                break;
            case 'v':
                bVerboseMode = true;
                break;
            case 'r':
                bRelativeMode = true;
                break;
            case 'a':
                bConsiderAll = true;
                break;
#ifdef WNT
            case 'd':
                bWindowsDebugMode = true;
                break;
#endif
            }
        }
    }

    if( !suSourcePathURL.getLength() )
    {
        fprintf( stderr, "error: no source path root defined\n" );
        PrintRedundancyEliminatorUsage();
        exit( -1 );
    }

    fprintf( stderr, "Wait: Just count files: ");
    fflush( stderr );
    nRealCount = countSource(suSourcePathURL);
    fprintf( stderr, "Found %d files\n", nRealCount );
    fprintf( stderr, "Start file scan, create file checksums, Ctrl-C is safe until 100%% is arrived.\n" );

    // init random generator
    srand(1);
    ReadSource( suSourcePathURL );

    fprintf( stderr, "\n\n%ld files found\nstart eliminating redundances, Ctrl-C is no longer safe!!!\n", aFilelist.size() );

    if (bVerboseMode)
    {
        verboseFileEntry();
    }
    
    sal_Int32 nCnt = 0;
    sal_uInt64 nBytes = Eliminate( nCnt );
    
    sal_Int32 nKBytes = sal_Int32(sal_uInt64(nBytes / 1024));
    sal_Int32 nMBytes = sal_Int32(sal_uInt64((nBytes / 1024) / 1024));

    fprintf( stderr, "eliminates %ld KB or ~%ld MB in %d files\n", nKBytes, nMBytes, nCnt );

    return 0;
}

        
