/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_connpooloptions.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:18:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #ifndef _OFFAPP_CONNPOOLOPTIONS_HXX_
//STRIP001 #include "connpooloptions.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _OFFAPP_CONNPOOLOPTIONS_HRC_
//STRIP001 #include "connpooloptions.hrc"
//STRIP001 #endif
//STRIP001 #ifndef _OFF_RESID_HXX 
//STRIP001 #include "resid.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _OFF_APP_HRC
//STRIP001 #include "app.hrc"
//STRIP001 #endif
//STRIP001 #include <svtools/editbrowsebox.hxx>
//STRIP001 #ifndef _SV_FIELD_HXX 
//STRIP001 #include <vcl/field.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFFAPP_CONNPOOLSETTINGS_HXX_
//STRIP001 #include "connpoolsettings.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _OFF_OFAIDS_HRC
//STRIP001 #include "ofaids.hrc"
//STRIP001 #endif
//STRIP001 #ifndef _SFXENUMITEM_HXX 
//STRIP001 #include <svtools/eitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 //........................................................................
//STRIP001 namespace offapp
//STRIP001 {
//STRIP001 //........................................................................
//STRIP001 
//STRIP001 	//====================================================================
//STRIP001 	//= DriverListControl
//STRIP001 	//====================================================================
//STRIP001 	typedef ::svt::EditBrowseBox DriverListControl_Base;
//STRIP001 	class DriverListControl : public DriverListControl_Base
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		DriverPoolingSettings					m_aSavedSettings;
//STRIP001 		DriverPoolingSettings					m_aSettings;
//STRIP001 		DriverPoolingSettings::const_iterator	m_aSeekRow;
//STRIP001 
//STRIP001 		String									m_sYes;
//STRIP001 		String									m_sNo;
//STRIP001 
//STRIP001 		Link									m_aRowChangeHandler;
//STRIP001 
//STRIP001 	public:
//STRIP001 		DriverListControl( Window* _pParent, const ResId& _rId);
//STRIP001 
//STRIP001 		virtual	void Init();
//STRIP001 				void Update(const DriverPoolingSettings& _rSettings);
//STRIP001 		virtual String GetCellText( long nRow, USHORT nColId ) const;
//STRIP001 
//STRIP001 		// the handler will be called with a DriverPoolingSettings::const_iterator as parameter,
//STRIP001 		// or NULL if no valid current row exists
//STRIP001 		void SetRowChangeHandler(const Link& _rHdl) { m_aRowChangeHandler = _rHdl; }
//STRIP001 		Link GetRowChangeHandler() const { return m_aRowChangeHandler; }
//STRIP001 
//STRIP001 		DriverPoolingSettings::const_iterator	getCurrentRow() const;
//STRIP001 		DriverPoolingSettings::iterator			getCurrentRow();
//STRIP001 		void									updateCurrentRow();
//STRIP001 
//STRIP001 		const DriverPoolingSettings& getSettings() const { return m_aSettings; }
//STRIP001 
//STRIP001 		void		saveValue()				{ m_aSavedSettings = m_aSettings; }
//STRIP001 		sal_Bool	isModified() const;
//STRIP001 
//STRIP001 	protected:
//STRIP001 		virtual void InitController( ::svt::CellControllerRef& rController, long nRow, USHORT nCol );
//STRIP001 		virtual ::svt::CellController* GetController( long nRow, USHORT nCol );
//STRIP001 
//STRIP001 		virtual void PaintCell( OutputDevice& rDev, const Rectangle& rRect, USHORT nColId ) const;
//STRIP001 
//STRIP001 		virtual BOOL SeekRow( long nRow );
//STRIP001 		virtual BOOL SaveModified();
//STRIP001 
//STRIP001 		virtual sal_Bool IsTabAllowed(sal_Bool _bForward) const;
//STRIP001 
//STRIP001 		virtual void StateChanged( StateChangedType nStateChange );
//STRIP001 
//STRIP001 		virtual void CursorMoved();
//STRIP001 
//STRIP001 	protected:
//STRIP001 		virtual ULONG GetTotalCellWidth(long nRow, USHORT nColId);
//STRIP001 		
//STRIP001 
//STRIP001 	private:
//STRIP001 		String implGetCellText(DriverPoolingSettings::const_iterator _rPos, sal_uInt16 _nColId) const;
//STRIP001 	};
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	DriverListControl::DriverListControl( Window* _pParent, const ResId& _rId)
//STRIP001 //		:DriverListControl_Base(_pParent, _rId, DBBF_NOROWPICTURE, BROWSER_AUTO_VSCROLL | BROWSER_AUTO_HSCROLL | BROWSER_COLUMNSELECTION | BROWSER_HLINESFULL | BROWSER_VLINESFULL | BROWSER_HIDESELECT | BROWSER_CURSOR_WO_FOCUS)
//STRIP001 		:DriverListControl_Base(_pParent, _rId, EBBF_NOROWPICTURE, BROWSER_AUTO_VSCROLL | BROWSER_AUTO_HSCROLL | BROWSER_HIDECURSOR | BROWSER_AUTOSIZE_LASTCOL)
//STRIP001 		,m_aSeekRow(m_aSettings.end())
//STRIP001 		,m_sYes(ResId(STR_YES))
//STRIP001 		,m_sNo(ResId(STR_NO))
//STRIP001 	{
//STRIP001 		SetStyle((GetStyle() & ~WB_HSCROLL) | WB_AUTOHSCROLL);
//STRIP001 
//STRIP001 		SetUniqueId(UID_OFA_CONNPOOL_DRIVERLIST_BACK);
//STRIP001 		GetDataWindow().SetHelpId(HID_OFA_CONNPOOL_DRIVERLIST);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	sal_Bool DriverListControl::IsTabAllowed(sal_Bool _bForward) const
//STRIP001 	{
//STRIP001 		// no travinling within the fields via RETURN and TAB
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	sal_Bool DriverListControl::isModified() const
//STRIP001 	{
//STRIP001 		if (m_aSettings.size() != m_aSavedSettings.size())
//STRIP001 			return sal_True;
//STRIP001 
//STRIP001 		DriverPoolingSettings::const_iterator aCurrent = m_aSettings.begin();
//STRIP001 		DriverPoolingSettings::const_iterator aCurrentEnd = m_aSettings.end();
//STRIP001 		DriverPoolingSettings::const_iterator aSaved = m_aSavedSettings.begin();
//STRIP001 		for (;aCurrent != aCurrentEnd; ++aCurrent, ++aSaved)
//STRIP001 		{
//STRIP001 			if (*aCurrent != *aSaved)
//STRIP001 				return sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void DriverListControl::Init()
//STRIP001 	{
//STRIP001 		DriverListControl_Base::Init();
//STRIP001 
//STRIP001 		Size aColWidth = LogicToPixel(Size(160, 0), MAP_APPFONT);
//STRIP001 		InsertDataColumn(1, String(ResId(STR_DRIVER_NAME)), aColWidth.Width());
//STRIP001 		aColWidth = LogicToPixel(Size(30, 0), MAP_APPFONT);
//STRIP001 		InsertDataColumn(2, String(ResId(STR_POOLED_FLAG)), aColWidth.Width());
//STRIP001 		aColWidth = LogicToPixel(Size(60, 0), MAP_APPFONT);
//STRIP001 		InsertDataColumn(3, String(ResId(STR_POOL_TIMEOUT)), aColWidth.Width());
//STRIP001 			// Attention: the resource of the string is local to the resource of the enclosing dialog!
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void DriverListControl::CursorMoved()
//STRIP001 	{
//STRIP001 		DriverListControl_Base::CursorMoved();
//STRIP001 
//STRIP001 		// call the row change handler
//STRIP001 		if (m_aRowChangeHandler.IsSet())
//STRIP001 			m_aRowChangeHandler.Call(getCurrentRow());
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	DriverPoolingSettings::const_iterator DriverListControl::getCurrentRow() const
//STRIP001 	{
//STRIP001 		OSL_ENSURE(GetCurRow() < m_aSettings.size(), "DriverListControl::getCurrentRow: invalid current row!");
//STRIP001 		if (GetCurRow() < m_aSettings.size())
//STRIP001 			return m_aSettings.begin() + GetCurRow();
//STRIP001 
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	DriverPoolingSettings::iterator DriverListControl::getCurrentRow()
//STRIP001 	{
//STRIP001 		OSL_ENSURE(GetCurRow() < m_aSettings.size(), "DriverListControl::getCurrentRow: invalid current row!");
//STRIP001 		if (GetCurRow() < m_aSettings.size())
//STRIP001 			return m_aSettings.begin() + GetCurRow();
//STRIP001 
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void DriverListControl::updateCurrentRow()
//STRIP001 	{
//STRIP001 		Window::Invalidate( GetRowRectPixel( GetCurRow() ), INVALIDATE_UPDATE );
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void DriverListControl::Update(const DriverPoolingSettings& _rSettings)
//STRIP001 	{
//STRIP001 		m_aSettings = _rSettings;
//STRIP001 
//STRIP001 		SetUpdateMode(sal_False);
//STRIP001 		RowRemoved(0, GetRowCount());
//STRIP001 		RowInserted(0, m_aSettings.size());
//STRIP001 		SetUpdateMode(sal_True);
//STRIP001 
//STRIP001 		ActivateCell(1, 0);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ULONG DriverListControl::GetTotalCellWidth(long nRow, USHORT nColId)
//STRIP001 	{
//STRIP001 		return GetDataWindow().GetTextWidth(GetCellText(nRow, nColId));
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	String DriverListControl::implGetCellText(DriverPoolingSettings::const_iterator _rPos, sal_uInt16 _nColId) const
//STRIP001 	{
//STRIP001 		OSL_ENSURE(_rPos < m_aSettings.end(), "DriverListControl::implGetCellText: invalid position!");
//STRIP001 
//STRIP001 		String sReturn;
//STRIP001 		switch (_nColId)
//STRIP001 		{
//STRIP001 			case 1:
//STRIP001 				sReturn = _rPos->sName;
//STRIP001 				break;
//STRIP001 			case 2:
//STRIP001 				sReturn = _rPos->bEnabled ? m_sYes : m_sNo;
//STRIP001 				break;
//STRIP001 			case 3:
//STRIP001 				if (_rPos->bEnabled)
//STRIP001 					sReturn = String::CreateFromInt32(_rPos->nTimeoutSeconds);
//STRIP001 				break;
//STRIP001 			default:
//STRIP001 				OSL_ENSURE(sal_False, "DriverListControl::implGetCellText: invalid column id!");
//STRIP001 		}
//STRIP001 		return sReturn;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void DriverListControl::StateChanged( StateChangedType nStateChange )
//STRIP001 	{
//STRIP001 		if (STATE_CHANGE_ENABLE == nStateChange)
//STRIP001 			Window::Invalidate(INVALIDATE_UPDATE);
//STRIP001 		DriverListControl_Base::StateChanged( nStateChange );
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	String DriverListControl::GetCellText( long nRow, USHORT nColId ) const
//STRIP001 	{
//STRIP001 		String sReturn;
//STRIP001 		if (nRow > m_aSettings.size())
//STRIP001 		{
//STRIP001 			OSL_ENSURE(sal_False, "DriverListControl::GetCellText: don't ask me for such rows!");
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			sReturn = implGetCellText(m_aSettings.begin() + nRow, nColId);
//STRIP001 		}
//STRIP001 		return sReturn;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void DriverListControl::InitController( ::svt::CellControllerRef& rController, long nRow, USHORT nCol )
//STRIP001 	{
//STRIP001 		rController->GetWindow().SetText(GetCellText(nRow, nCol));
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	::svt::CellController* DriverListControl::GetController( long nRow, USHORT nCol )
//STRIP001 	{
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	BOOL DriverListControl::SaveModified()
//STRIP001 	{
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	BOOL DriverListControl::SeekRow( long _nRow )
//STRIP001 	{
//STRIP001 		DriverListControl_Base::SeekRow(_nRow);
//STRIP001 
//STRIP001 		if (_nRow < m_aSettings.size())
//STRIP001 			m_aSeekRow = m_aSettings.begin() + _nRow;
//STRIP001 		else
//STRIP001 			m_aSeekRow = m_aSettings.end();
//STRIP001 
//STRIP001 		return m_aSeekRow != m_aSettings.end();
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void DriverListControl::PaintCell( OutputDevice& rDev, const Rectangle& rRect, USHORT nColId ) const
//STRIP001 	{
//STRIP001 		OSL_ENSURE(m_aSeekRow != m_aSettings.end(), "DriverListControl::PaintCell: invalid row!");
//STRIP001 
//STRIP001 		if (m_aSeekRow != m_aSettings.end())
//STRIP001 		{
//STRIP001 			rDev.SetClipRegion(rRect);
//STRIP001 
//STRIP001 			sal_uInt16 nStyle = TEXT_DRAW_CLIP;
//STRIP001 			if (!IsEnabled())
//STRIP001 				nStyle |= TEXT_DRAW_DISABLE;
//STRIP001 			switch (nColId)
//STRIP001 			{
//STRIP001 				case 1: nStyle |= TEXT_DRAW_LEFT; break;
//STRIP001 				case 2:
//STRIP001 				case 3: nStyle |= TEXT_DRAW_CENTER; break;
//STRIP001 			}
//STRIP001 
//STRIP001 			rDev.DrawText(rRect, implGetCellText(m_aSeekRow, nColId), nStyle);
//STRIP001 
//STRIP001 			rDev.SetClipRegion();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//====================================================================
//STRIP001 	//= ConnectionPoolOptionsPage
//STRIP001 	//====================================================================
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ConnectionPoolOptionsPage::ConnectionPoolOptionsPage(Window* _pParent, const SfxItemSet& _rAttrSet)
//STRIP001 		:SfxTabPage(_pParent, OffResId(RID_OFAPAGE_CONNPOOLOPTIONS), _rAttrSet)
//STRIP001 		,m_aFrame				(this,				ResId(FL_POOLING))
//STRIP001 		,m_aEnablePooling		(this,		ResId(CB_POOL_CONNS))
//STRIP001 		,m_aDriversLabel		(this,		ResId(FT_DRIVERS))
//STRIP001 		,m_pDriverList(new DriverListControl(this, ResId(CTRL_DRIVER_LIST)))
//STRIP001 		,m_aDriverLabel			(this,		ResId(FT_DRIVERLABEL))
//STRIP001 		,m_aDriver				(this,		ResId(FT_DRIVER))
//STRIP001 		,m_aDriverPoolingEnabled(this,		ResId(CB_DRIVERPOOLING))
//STRIP001 		,m_aTimeoutLabel		(this,		ResId(FT_TIMEOUT))
//STRIP001 		,m_aTimeout				(this,		ResId(NF_TIMEOUT))
//STRIP001 	{
//STRIP001 		m_pDriverList->Init();
//STRIP001 		m_pDriverList->Show();
//STRIP001 
//STRIP001 		FreeResource();
//STRIP001 
//STRIP001 		m_aEnablePooling.SetClickHdl( LINK(this, ConnectionPoolOptionsPage, OnEnabledDisabled) );
//STRIP001 		m_aDriverPoolingEnabled.SetClickHdl( LINK(this, ConnectionPoolOptionsPage, OnEnabledDisabled) );
//STRIP001 
//STRIP001 		m_pDriverList->SetRowChangeHandler( LINK(this, ConnectionPoolOptionsPage, OnDriverRowChanged) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	SfxTabPage* ConnectionPoolOptionsPage::Create(Window* _pParent, const SfxItemSet& _rAttrSet)
//STRIP001 	{
//STRIP001 		return new ConnectionPoolOptionsPage(_pParent, _rAttrSet);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	ConnectionPoolOptionsPage::~ConnectionPoolOptionsPage()
//STRIP001 	{
//STRIP001 		delete m_pDriverList;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ConnectionPoolOptionsPage::implInitControls(const SfxItemSet& _rSet, sal_Bool /*_bFromReset*/)
//STRIP001 	{
//STRIP001 		// the enabled flag
//STRIP001 		SFX_ITEMSET_GET( _rSet, pEnabled, SfxBoolItem, SID_SB_POOLING_ENABLED, sal_True );
//STRIP001 		OSL_ENSURE(pEnabled, "ConnectionPoolOptionsPage::implInitControls: missing the Enabled item!");
//STRIP001 		m_aEnablePooling.Check(pEnabled ? pEnabled->GetValue() : sal_True);
//STRIP001 
//STRIP001 		m_aEnablePooling.SaveValue();
//STRIP001 
//STRIP001 		// the settings for the single drivers
//STRIP001 		SFX_ITEMSET_GET( _rSet, pDriverSettings, DriverPoolingSettingsItem, SID_SB_DRIVER_TIMEOUTS, sal_True );
//STRIP001 		if (pDriverSettings)
//STRIP001 			m_pDriverList->Update(pDriverSettings->getSettings());
//STRIP001 		else
//STRIP001 		{
//STRIP001 			OSL_ENSURE(sal_False, "ConnectionPoolOptionsPage::implInitControls: missing the DriverTimeouts item!");
//STRIP001 			m_pDriverList->Update(DriverPoolingSettings());
//STRIP001 		}
//STRIP001 		m_pDriverList->saveValue();
//STRIP001 
//STRIP001 		// reflect the new settings
//STRIP001 		OnEnabledDisabled(&m_aEnablePooling);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	long ConnectionPoolOptionsPage::Notify( NotifyEvent& _rNEvt )
//STRIP001 	{
//STRIP001 		if (EVENT_LOSEFOCUS == _rNEvt.GetType())
//STRIP001 			if (m_aTimeout.IsWindowOrChild(_rNEvt.GetWindow()))
//STRIP001 				::com::mitTimeoutField();
//STRIP001 
//STRIP001 		return SfxTabPage::Notify(_rNEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	BOOL ConnectionPoolOptionsPage::FillItemSet(SfxItemSet& _rSet)
//STRIP001 	{
//STRIP001 		::com::mitTimeoutField();
//STRIP001 
//STRIP001 		sal_Bool bModified = sal_False;
//STRIP001 		// the enabled flag
//STRIP001 		if (m_aEnablePooling.GetSavedValue() != m_aEnablePooling.IsChecked())
//STRIP001 		{
//STRIP001 			_rSet.Put(SfxBoolItem(SID_SB_POOLING_ENABLED, m_aEnablePooling.IsChecked()), SID_SB_POOLING_ENABLED);
//STRIP001 			bModified = sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		// the settings for the single drivers
//STRIP001 		if (m_pDriverList->isModified())
//STRIP001 		{
//STRIP001 			_rSet.Put(DriverPoolingSettingsItem(SID_SB_DRIVER_TIMEOUTS, m_pDriverList->getSettings()), SID_SB_DRIVER_TIMEOUTS);
//STRIP001 			bModified = sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		return bModified;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ConnectionPoolOptionsPage::ActivatePage( const SfxItemSet& _rSet)
//STRIP001 	{
//STRIP001 		SfxTabPage::ActivatePage(_rSet);
//STRIP001 		implInitControls(_rSet, sal_False);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ConnectionPoolOptionsPage::Reset(const SfxItemSet& _rSet)
//STRIP001 	{
//STRIP001 		implInitControls(_rSet, sal_True);
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	IMPL_LINK( ConnectionPoolOptionsPage, OnDriverRowChanged, const void*, _pRowIterator )
//STRIP001 	{
//STRIP001 		sal_Bool bValidRow = (NULL != _pRowIterator);
//STRIP001 		m_aDriverPoolingEnabled.Enable(bValidRow && m_aEnablePooling.IsChecked());
//STRIP001 		m_aTimeoutLabel.Enable(bValidRow);
//STRIP001 		m_aTimeout.Enable(bValidRow);
//STRIP001 
//STRIP001 		if (!bValidRow)
//STRIP001 		{	// positioned on an invalid row
//STRIP001 			m_aDriver.SetText(String());
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DriverPoolingSettings::const_iterator aDriverPos = static_cast<DriverPoolingSettings::const_iterator>(_pRowIterator);
//STRIP001 
//STRIP001 			m_aDriver.SetText(aDriverPos->sName);
//STRIP001 			m_aDriverPoolingEnabled.Check(aDriverPos->bEnabled);
//STRIP001 			m_aTimeout.SetText(String::CreateFromInt32(aDriverPos->nTimeoutSeconds));
//STRIP001 
//STRIP001 			OnEnabledDisabled(&m_aDriverPoolingEnabled);
//STRIP001 		}
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ConnectionPoolOptionsPage::commitTimeoutField()
//STRIP001 	{
//STRIP001 		DriverPoolingSettings::iterator aCurrentDriver = m_pDriverList->getCurrentRow();
//STRIP001 		if (aCurrentDriver)
//STRIP001 		{
//STRIP001 			aCurrentDriver->nTimeoutSeconds = m_aTimeout.GetValue();
//STRIP001 			m_pDriverList->updateCurrentRow();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	IMPL_LINK( ConnectionPoolOptionsPage, OnEnabledDisabled, const CheckBox*, _pCheckBox )
//STRIP001 	{
//STRIP001 		sal_Bool bGloballyEnabled = m_aEnablePooling.IsChecked();
//STRIP001 		sal_Bool bLocalDriverChanged = &m_aDriverPoolingEnabled == _pCheckBox;
//STRIP001 
//STRIP001 		if (&m_aEnablePooling == _pCheckBox)
//STRIP001 		{
//STRIP001 			m_aDriversLabel.Enable(bGloballyEnabled);
//STRIP001 			m_pDriverList->Enable(bGloballyEnabled);
//STRIP001 			m_aDriverLabel.Enable(bGloballyEnabled);
//STRIP001 			m_aDriver.Enable(bGloballyEnabled);
//STRIP001 			m_aDriverPoolingEnabled.Enable(bGloballyEnabled);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			OSL_ENSURE(bLocalDriverChanged, "ConnectionPoolOptionsPage::OnEnabledDisabled: where did this come from?");
//STRIP001 
//STRIP001 		m_aTimeoutLabel.Enable(bGloballyEnabled && m_aDriverPoolingEnabled.IsChecked());
//STRIP001 		m_aTimeout.Enable(bGloballyEnabled && m_aDriverPoolingEnabled.IsChecked());
//STRIP001 
//STRIP001 		if (bLocalDriverChanged)
//STRIP001 		{
//STRIP001 			// update the list
//STRIP001 			m_pDriverList->getCurrentRow()->bEnabled = m_aDriverPoolingEnabled.IsChecked();
//STRIP001 			m_pDriverList->updateCurrentRow();
//STRIP001 		}
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 //........................................................................
//STRIP001 }	// namespace offapp
//STRIP001 //........................................................................


}
