/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: solvrdlg.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:14:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_SOLVRDLG_HXX
#define SC_SOLVRDLG_HXX

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif

#ifndef SC_ANYREFDG_HXX
#include "anyrefdg.hxx"
#endif


#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
namespace binfilter {

//----------------------------------------------------------------------------

enum ScSolverErr
	{
		SOLVERR_NOFORMULA,
		SOLVERR_INVALID_FORMULA,
		SOLVERR_INVALID_VARIABLE,
		SOLVERR_INVALID_TARGETVALUE
	};


//============================================================================

class ScSolverDlg : public ScAnyRefDlg
{
public:
					ScSolverDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
								 ScDocument* pDocument,
								 ScAddress aCursorPos );
					~ScSolverDlg();

	virtual void	SetReference( const ScRange& rRef, ScDocument* pDoc );
    virtual BOOL    IsRefInputMode() const;
	virtual void	SetActive();
	virtual BOOL	Close();

private:
    FixedLine       aFlVariables;
	FixedText		aFtFormulaCell;
	ScRefEdit		aEdFormulaCell;
	ScRefButton		aRBFormulaCell;

	FixedText		aFtTargetVal;
	Edit			aEdTargetVal;

	FixedText		aFtVariableCell;
	ScRefEdit		aEdVariableCell;
	ScRefButton		aRBVariableCell;

	OKButton		aBtnOk;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;

	ScAddress		theFormulaCell;
	ScAddress		theVariableCell;
	String			theTargetValStr;

	ScDocument*		pDoc;
	const USHORT	nCurTab;
	ScRefEdit*		pEdActive;
	BOOL			bDlgLostFocus;
	const String	errMsgInvalidVar;
	const String	errMsgInvalidForm;
	const String	errMsgNoFormula;
	const String	errMsgInvalidVal;


#ifdef _SOLVRDLG_CXX
	void	Init();
	BOOL	CheckTargetValue( String& rStrVal );
	void	RaiseError( ScSolverErr eError );

	DECL_LINK( BtnHdl, PushButton* );
    DECL_LINK( GetFocusHdl, Control* );
    DECL_LINK( LoseFocusHdl, Control* );
#endif	// _SOLVERDLG_CXX
};

} //namespace binfilter
#endif // SC_SOLVRDLG_HXX


