/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridwin4.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:27:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <svtools/colorcfg.hxx>
// auto strip #include <bf_svx/colritem.hxx>
// auto strip #include <bf_svx/editview.hxx>
// auto strip #include <bf_svx/fhgtitem.hxx>
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #include <so3/ipenv.hxx>
#include <bf_sfx2/printer.hxx>

#ifdef MAC
// auto strip #include <bf_svx/brshitem.hxx>
#endif

#include "gridwin.hxx"
// auto strip #include "viewdata.hxx"
#include "output.hxx"
// auto strip #include "document.hxx"
#include "attrib.hxx"
#include "patattr.hxx"			// InvertSimple
// auto strip #include "dbcolect.hxx"
#include "docoptio.hxx"
// auto strip #include "notemark.hxx"
#include "dbfunc.hxx"			// oder GetPageBreakData an die ViewData
#include "scmod.hxx"
#include "inputhdl.hxx"
#include "rfindlst.hxx"
// auto strip #include "hiranges.hxx"
// auto strip #include "pagedata.hxx"
// auto strip #include "docpool.hxx"
#include "globstr.hrc"
#include "docsh.hxx"			// oder GetSfxInPlaceObject
// auto strip #include "cbutton.hxx"
// auto strip #include "invmerge.hxx"
// auto strip #include "editutil.hxx"
#include "inputopt.hxx"
namespace binfilter {

//#include "tabvwsh.hxx"			//! Test !!!!

//------------------------------------------------------------------------

//STRIP001 void lcl_LimitRect( Rectangle& rRect, const Rectangle& rVisible )
//STRIP001 {
//STRIP001 	if ( rRect.Top()    < rVisible.Top()-1 )    rRect.Top()    = rVisible.Top()-1;
//STRIP001 //	if ( rRect.Left()   < rVisible.Left()-1 )   rRect.Left()   = rVisible.Left()-1;
//STRIP001 	if ( rRect.Bottom() > rVisible.Bottom()+1 ) rRect.Bottom() = rVisible.Bottom()+1;
//STRIP001 //	if ( rRect.Right()  > rVisible.Right()+1 )  rRect.Right()  = rVisible.Right()+1;
//STRIP001 
//STRIP001 	// #51122# auch wenn das inner-Rectangle nicht sichtbar ist, muss evtl.
//STRIP001 	// die Titelzeile gezeichnet werden, darum kein Rueckgabewert mehr.
//STRIP001 	// Wenn's weit daneben liegt, wird lcl_DrawOneFrame erst gar nicht gerufen.
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_DrawOneFrame( OutputDevice* pDev, const Rectangle& rInnerPixel,
//STRIP001 						const String& rTitle, const Color& rColor, BOOL bTextBelow,
//STRIP001 						double nPPTX, double nPPTY, const Fraction& rZoomY,
//STRIP001 						ScDocument* pDoc, ScViewData* pButtonViewData )
//STRIP001 {
//STRIP001 	//	pButtonViewData wird nur benutzt, um die Button-Groesse zu setzen,
//STRIP001 	//	darf ansonsten NULL sein!
//STRIP001 
//STRIP001 	Rectangle aInner = rInnerPixel;
//STRIP001 	Rectangle aVisible( Point(0,0), pDev->GetOutputSizePixel() );
//STRIP001 	lcl_LimitRect( aInner, aVisible );
//STRIP001 
//STRIP001 	Rectangle aOuter = aInner;
//STRIP001 	long nHor = (long) ( SC_SCENARIO_HSPACE * nPPTX );
//STRIP001 	long nVer = (long) ( SC_SCENARIO_VSPACE * nPPTY );
//STRIP001 	aOuter.Left()	-= nHor;
//STRIP001 	aOuter.Right()	+= nHor;
//STRIP001 	aOuter.Top()	-= nVer;
//STRIP001 	aOuter.Bottom()	+= nVer;
//STRIP001 
//STRIP001 	//	use ScPatternAttr::GetFont only for font size
//STRIP001 	Font aAttrFont;
//STRIP001 	((const ScPatternAttr&)pDoc->GetPool()->GetDefaultItem(ATTR_PATTERN)).
//STRIP001 									GetFont(aAttrFont,SC_AUTOCOL_BLACK,pDev,&rZoomY);
//STRIP001 
//STRIP001 	//	everything else from application font
//STRIP001 	Font aAppFont = pDev->GetSettings().GetStyleSettings().GetAppFont();
//STRIP001 	aAppFont.SetSize( aAttrFont.GetSize() );
//STRIP001 
//STRIP001 	aAppFont.SetAlign( ALIGN_TOP );
//STRIP001 	pDev->SetFont( aAppFont );
//STRIP001 
//STRIP001 	Size aTextSize( pDev->GetTextWidth( rTitle ), pDev->GetTextHeight() );
//STRIP001 
//STRIP001 	if ( bTextBelow )
//STRIP001 		aOuter.Bottom() += aTextSize.Height();
//STRIP001 	else
//STRIP001 		aOuter.Top()    -= aTextSize.Height();
//STRIP001 
//STRIP001 	pDev->SetLineColor();
//STRIP001 	pDev->SetFillColor( rColor );
//STRIP001 	//	links, oben, rechts, unten
//STRIP001 	pDev->DrawRect( Rectangle( aOuter.Left(),  aOuter.Top(),    aInner.Left(),  aOuter.Bottom() ) );
//STRIP001 	pDev->DrawRect( Rectangle( aOuter.Left(),  aOuter.Top(),    aOuter.Right(), aInner.Top()    ) );
//STRIP001 	pDev->DrawRect( Rectangle( aInner.Right(), aOuter.Top(),    aOuter.Right(), aOuter.Bottom() ) );
//STRIP001 	pDev->DrawRect( Rectangle( aOuter.Left(),  aInner.Bottom(), aOuter.Right(), aOuter.Bottom() ) );
//STRIP001 
//STRIP001 	long nButtonY = bTextBelow ? aInner.Bottom() : aOuter.Top();
//STRIP001 
//STRIP001 	ScDDComboBoxButton aComboButton((Window*)pDev);
//STRIP001 	aComboButton.SetOptSizePixel();
//STRIP001 	long nBWidth  = ( aComboButton.GetSizePixel().Width() * rZoomY.GetNumerator() )
//STRIP001 						/ rZoomY.GetDenominator();
//STRIP001 	long nBHeight = nVer + aTextSize.Height() + 1;
//STRIP001 	Size aButSize( nBWidth, nBHeight );
//STRIP001     aComboButton.Draw( Point(aOuter.Right()-nBWidth+1, nButtonY), aButSize, false );
//STRIP001 	if (pButtonViewData)
//STRIP001 		pButtonViewData->SetScenButSize( aButSize );
//STRIP001 
//STRIP001 	BOOL bWasClip = FALSE;
//STRIP001 	Region aOldClip;
//STRIP001 	BOOL bClip = ( aTextSize.Width() > aOuter.Right() - nBWidth - aInner.Left() );
//STRIP001 	if ( bClip )
//STRIP001 	{
//STRIP001 		if (pDev->IsClipRegion())
//STRIP001 		{
//STRIP001 			bWasClip = TRUE;
//STRIP001 			aOldClip = pDev->GetActiveClipRegion();
//STRIP001 		}
//STRIP001 		pDev->SetClipRegion( Rectangle( aInner.Left(), nButtonY + nVer/2,
//STRIP001 						aOuter.Right() - nBWidth, nButtonY + nVer/2 + aTextSize.Height() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDev->DrawText( Point( aInner.Left(), nButtonY + nVer/2 ), rTitle );
//STRIP001 
//STRIP001 	if ( bClip )
//STRIP001 	{
//STRIP001 		if ( bWasClip )
//STRIP001 			pDev->SetClipRegion(aOldClip);
//STRIP001 		else
//STRIP001 			pDev->SetClipRegion();
//STRIP001 	}
//STRIP001 
//STRIP001 	pDev->SetFillColor();
//STRIP001 	pDev->SetLineColor( COL_BLACK );
//STRIP001 	pDev->DrawRect( aInner );
//STRIP001 	pDev->DrawRect( aOuter );
//STRIP001 }

//STRIP001 void lcl_DrawScenarioFrames( OutputDevice* pDev, ScViewData* pViewData, ScSplitPos eWhich,
//STRIP001 							USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2 )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	if ( nTab+1<nTabCount && pDoc->IsScenario(nTab+1) && !pDoc->IsScenario(nTab) )
//STRIP001 	{
//STRIP001 		if ( nX1 ) --nX1;
//STRIP001 		if ( nY1>=2 ) nY1 -= 2;				// Hack: Titelzeile beruehrt zwei Zellen
//STRIP001 		else if ( nY1 ) --nY1;
//STRIP001 		if ( nX2 < MAXCOL ) ++nX2;
//STRIP001 		if ( nY2 < MAXROW-1 ) nY2 += 2;		// Hack: Titelzeile beruehrt zwei Zellen
//STRIP001 		else if ( nY2 < MAXROW ) ++nY2;
//STRIP001 		ScRange aViewRange( nX1,nY1,nTab, nX2,nY2,nTab );
//STRIP001 
//STRIP001 		//!	Ranges an der Table cachen!!!!
//STRIP001 
//STRIP001 		USHORT i;
//STRIP001 		ScMarkData aMarks;
//STRIP001 		for (i=nTab+1; i<nTabCount && pDoc->IsScenario(i); i++)
//STRIP001 			pDoc->MarkScenario( i, nTab, aMarks, FALSE, SC_SCENARIO_SHOWFRAME );
//STRIP001 		ScRangeListRef xRanges = new ScRangeList;
//STRIP001 		aMarks.FillRangeListWithMarks( xRanges, FALSE );
//STRIP001 
//STRIP001 		USHORT nRangeCount = (USHORT)xRanges->Count();
//STRIP001 		for (i=0; i<nRangeCount; i++)
//STRIP001 		{
//STRIP001 			ScRange aRange = *xRanges->GetObject(i);
//STRIP001 			//	Szenario-Rahmen immer dann auf zusammengefasste Zellen erweitern, wenn
//STRIP001 			//	dadurch keine neuen nicht-ueberdeckten Zellen mit umrandet werden
//STRIP001 			pDoc->ExtendTotalMerge( aRange );
//STRIP001 
//STRIP001 			//!	-> Repaint beim Zusammenfassen erweitern !!!
//STRIP001 
//STRIP001 			if ( aRange.Intersects( aViewRange ) )			//! Platz fuer Text/Button?
//STRIP001 			{
//STRIP001 				Point aStartPos = pViewData->GetScrPos(
//STRIP001 									aRange.aStart.Col(), aRange.aStart.Row(), eWhich, TRUE );
//STRIP001 				Point aEndPos = pViewData->GetScrPos(
//STRIP001 									aRange.aEnd.Col()+1, aRange.aEnd.Row()+1, eWhich, TRUE );
//STRIP001 				//	auf dem Gitter:
//STRIP001 				aStartPos.X() -= 1;
//STRIP001 				aStartPos.Y() -= 1;
//STRIP001 				aEndPos.X() -= 1;
//STRIP001 				aEndPos.Y() -= 1;
//STRIP001 
//STRIP001 				BOOL bTextBelow = ( aRange.aStart.Row() == 0 );
//STRIP001 
//STRIP001 				String aCurrent;
//STRIP001 				Color aColor( COL_LIGHTGRAY );
//STRIP001 				for (USHORT nAct=nTab+1; nAct<nTabCount && pDoc->IsScenario(nAct); nAct++)
//STRIP001 					if ( pDoc->IsActiveScenario(nAct) && pDoc->HasScenarioRange(nAct,aRange) )
//STRIP001 					{
//STRIP001 						String aDummyComment;
//STRIP001 						USHORT nDummyFlags;
//STRIP001 						pDoc->GetName( nAct, aCurrent );
//STRIP001 						pDoc->GetScenarioData( nAct, aDummyComment, aColor, nDummyFlags );
//STRIP001 					}
//STRIP001 
//STRIP001 				if (!aCurrent.Len())
//STRIP001 					aCurrent = ScGlobal::GetRscString( STR_EMPTYDATA );
//STRIP001 
//STRIP001 				//!	eigener Text "(keins)" statt "(leer)" ???
//STRIP001 
//STRIP001 				lcl_DrawOneFrame( pDev, Rectangle( aStartPos, aEndPos ),
//STRIP001 									aCurrent, aColor, bTextBelow,
//STRIP001 									pViewData->GetPPTX(), pViewData->GetPPTY(), pViewData->GetZoomY(),
//STRIP001 									pDoc, pViewData );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void lcl_DrawHighlight( ScOutputData& rOutputData, ScViewData* pViewData,
//STRIP001 						ScHighlightRanges& rHighlightRanges )
//STRIP001 {
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	ULONG nCount = rHighlightRanges.Count();
//STRIP001 	for (ULONG i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		ScHighlightEntry* pEntry = rHighlightRanges.GetObject( i );
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			ScRange aRange = pEntry->aRef;
//STRIP001 			if ( nTab >= aRange.aStart.Tab() && nTab <= aRange.aEnd.Tab() )
//STRIP001 			{
//STRIP001 				rOutputData.DrawRefMark(
//STRIP001 									aRange.aStart.Col(), aRange.aStart.Row(),
//STRIP001 									aRange.aEnd.Col(), aRange.aEnd.Row(),
//STRIP001 									pEntry->aColor, FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScGridWindow::DoInvertRect( const Rectangle& rPixel )
//STRIP001 {
//STRIP001 	Invert( PixelToLogic(rPixel) );
//STRIP001 
//STRIP001 	if ( rPixel == aInvertRect )
//STRIP001 		aInvertRect = Rectangle();		// aufheben
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT( aInvertRect.IsEmpty(), "DoInvertRect nicht paarig" );
//STRIP001 
//STRIP001 		aInvertRect = rPixel;			// neues Rechteck merken
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ScGridWindow::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 	SvInPlaceEnvironment* pEnv = pDocSh->GetIPEnv();
//STRIP001 	if (pEnv && pEnv->GetRectsChangedLockCount())
//STRIP001 	{
//STRIP001 		Invalidate(rRect);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	if ( pDoc->IsInInterpreter() )
//STRIP001 	{
//STRIP001 		//	via Reschedule, interpretierende Zellen nicht nochmal anstossen
//STRIP001 		//	hier kein Invalidate, sonst kommt z.B. eine Error-Box nie an die Reihe
//STRIP001 		//	(Bug 36381). Durch bNeedsRepaint wird spaeter alles nochmal gemalt.
//STRIP001 
//STRIP001 		if ( bNeedsRepaint )
//STRIP001 		{
//STRIP001 			//!	Rechtecke zusammenfassen?
//STRIP001 			aRepaintPixel = Rectangle();			// mehrfach -> alles painten
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bNeedsRepaint = TRUE;
//STRIP001 			aRepaintPixel = LogicToPixel(rRect);	// nur betroffenen Bereich
//STRIP001 		}
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bIsInPaint)
//STRIP001 		return;
//STRIP001 
//STRIP001 	bIsInPaint = TRUE;
//STRIP001 
//STRIP001 	Rectangle aPixRect = LogicToPixel( rRect );
//STRIP001 
//STRIP001 	USHORT nX1 = pViewData->GetPosX(eHWhich);
//STRIP001 	USHORT nY1 = pViewData->GetPosY(eVWhich);
//STRIP001 
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 	double nPPTX = pViewData->GetPPTX();
//STRIP001 	double nPPTY = pViewData->GetPPTY();
//STRIP001 
//STRIP001 	long nScrX = ScViewData::ToPixel( pDoc->GetColWidth( nX1, nTab ), nPPTX );
//STRIP001 	while ( nScrX <= aPixRect.Left() && nX1 < MAXCOL )
//STRIP001 	{
//STRIP001 		++nX1;
//STRIP001 		nScrX += ScViewData::ToPixel( pDoc->GetColWidth( nX1, nTab ), nPPTX );
//STRIP001 	}
//STRIP001 	USHORT nX2 = nX1;
//STRIP001 	while ( nScrX <= aPixRect.Right() && nX2 < MAXCOL )
//STRIP001 	{
//STRIP001 		++nX2;
//STRIP001 		nScrX += ScViewData::ToPixel( pDoc->GetColWidth( nX2, nTab ), nPPTX );
//STRIP001 	}
//STRIP001 
//STRIP001 	long nScrY = ScViewData::ToPixel( pDoc->GetRowHeight( nY1, nTab ), nPPTY );
//STRIP001 	while ( nScrY <= aPixRect.Top() && nY1 < MAXROW )
//STRIP001 	{
//STRIP001 		++nY1;
//STRIP001 		nScrY += ScViewData::ToPixel( pDoc->GetRowHeight( nY1, nTab ), nPPTY );
//STRIP001 	}
//STRIP001 	USHORT nY2 = nY1;
//STRIP001 	while ( nScrY <= aPixRect.Bottom() && nY2 < MAXROW )
//STRIP001 	{
//STRIP001 		++nY2;
//STRIP001 		nScrY += ScViewData::ToPixel( pDoc->GetRowHeight( nY2, nTab ), nPPTY );
//STRIP001 	}
//STRIP001 
//STRIP001 	Draw( nX1,nY1,nX2,nY2, SC_UPDATE_MARKS );			// nicht weiterzeichnen
//STRIP001 
//STRIP001 	OutlinerViewPaint( rRect );
//STRIP001 
//STRIP001 	if (!aInvertRect.IsEmpty())
//STRIP001 		Invert( PixelToLogic(aInvertRect) );	// auf das Clipping verlassen...
//STRIP001 
//STRIP001 	bIsInPaint = FALSE;
//STRIP001 }

//
// 	Draw  ----------------------------------------------------------------
//

/*N*/ void ScGridWindow::Draw( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2, ScUpdateMode eMode )
/*N*/ {
/*N*/ 	ScModule* pScMod = SC_MOD();
/*N*/ 	BOOL bTextWysiwyg = pScMod->GetInputOptions().GetTextWysiwyg();
/*N*/ 	BOOL bGridFirst = TRUE;		//! entscheiden!!!
/*N*/ 
/*N*/ 	if (pViewData->IsMinimized())
/*N*/ 		return;
/*N*/ 
/*N*/ 	PutInOrder( nX1, nX2 );
/*N*/ 	PutInOrder( nY1, nY2 );
/*N*/ 	USHORT i;
/*N*/ 
/*N*/ 	DBG_ASSERT( nX2<=MAXCOL && nY2<=MAXROW, "GridWin Draw Bereich zu gross" );
/*N*/ 
/*N*/ 	USHORT nPosX = pViewData->GetPosX( eHWhich );
/*N*/ 	USHORT nPosY = pViewData->GetPosY( eVWhich );
/*N*/ 	if (nX2 < nPosX || nY2 < nPosY)
/*N*/ 		return;											// unsichtbar
/*N*/ 	if (nX1 < nPosX) nX1 = nPosX;
/*N*/ 	if (nY1 < nPosY) nY1 = nPosY;
/*N*/ 
/*N*/ 	USHORT nXRight = nPosX + pViewData->VisibleCellsX(eHWhich);
/*N*/ 	if (nXRight > MAXCOL) nXRight = MAXCOL;
/*N*/ 	USHORT nYBottom = nPosY + pViewData->VisibleCellsY(eVWhich);
/*N*/ 	if (nYBottom > MAXROW) nYBottom = MAXROW;
/*N*/ 
/*N*/ 	if (nX1 > nXRight || nY1 > nYBottom)
/*N*/ 		return;											// unsichtbar
/*N*/ 	if (nX2 > nXRight) nX2 = nXRight;
/*N*/ 	if (nY2 > nYBottom) nY2 = nYBottom;
/*N*/ 
/*N*/ 	if ( eMode != SC_UPDATE_MARKS )
/*N*/ 		if (nX2 < nXRight)
/*N*/ 			nX2 = nXRight;								// zum Weiterzeichnen
/*N*/ 
/*N*/ 		//	ab hier kein return mehr
/*N*/ 
/*N*/ 	++nPaintCount;					// merken, dass gemalt wird (wichtig beim Invertieren)
/*N*/ 
/*N*/ 	ScDocShell* pDocSh = pViewData->GetDocShell();
/*N*/ 	ScDocument* pDoc = pDocSh->GetDocument();
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 
/*N*/ 	pDoc->ExtendHidden( nX1, nY1, nX2, nY2, nTab );
/*N*/ 
/*N*/ 	Point aScrPos = pViewData->GetScrPos( nX1, nY1, eWhich );
/*N*/ 	USHORT nScrX = (USHORT) aScrPos.X();
/*N*/ 	USHORT nScrY = (USHORT) aScrPos.Y();
/*N*/ 
/*N*/ 	USHORT nCurX = pViewData->GetCurX();
/*N*/ 	USHORT nCurY = pViewData->GetCurY();
/*N*/ 	USHORT nCurEndX = nCurX;
/*N*/ 	USHORT nCurEndY = nCurY;
/*N*/ 	pDoc->ExtendMerge( nCurX, nCurY, nCurEndX, nCurEndY, nTab );
/*N*/ 	BOOL bCurVis = nCursorHideCount==0 &&
/*N*/ 					( nCurEndX+1 >= nX1 && nCurX <= nX2+1 && nCurEndY+1 >= nY1 && nCurY <= nY2+1 );
/*N*/ 
/*N*/ 	//	AutoFill-Anfasser
/*N*/ 	if ( !bCurVis && nCursorHideCount==0 && bAutoMarkVisible && aAutoMarkPos.Tab() == nTab &&
/*N*/ 			( aAutoMarkPos.Col() != nCurX || aAutoMarkPos.Row() != nCurY ) )
/*N*/ 	{
/*?*/ 		USHORT nHdlX = aAutoMarkPos.Col();
/*?*/ 		USHORT nHdlY = aAutoMarkPos.Row();
/*?*/ 		pDoc->ExtendMerge( nHdlX, nHdlY, nHdlX, nHdlY, nTab );
/*?*/ 		bCurVis = ( nHdlX+1 >= nX1 && nHdlX <= nX2 && nHdlY+1 >= nY1 && nHdlY <= nY2 );
/*?*/ 		//	links und oben ist nicht betroffen
/*?*/ 
/*?*/ 		//!	AutoFill-Anfasser alleine (ohne Cursor) zeichnen ???
/*N*/ 	}
/*N*/ 
/*N*/ 	double nPPTX = pViewData->GetPPTX();
/*N*/ 	double nPPTY = pViewData->GetPPTY();
/*N*/ 
/*N*/ 	const ScViewOptions& rOpts = pViewData->GetOptions();
/*N*/ 	BOOL bFormulaMode = rOpts.GetOption( VOPT_FORMULAS );
/*N*/ 	BOOL bMarkClipped = rOpts.GetOption( VOPT_CLIPMARKS );
/*N*/ 
/*N*/ 		// Datenblock
/*N*/ 
/*N*/ 	RowInfo* pRowInfo = new RowInfo[ROWINFO_MAX];
/*N*/ 	USHORT nArrCount = pDoc->FillInfo( pRowInfo, nX1, nY1, nX2, nY2, nTab,
/*N*/ 										nPPTX, nPPTY, FALSE, bFormulaMode,
/*N*/ 										&pViewData->GetMarkData() );
/*N*/ 
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 
/*N*/ 	Fraction aZoomX = pViewData->GetZoomX();
/*N*/ 	Fraction aZoomY = pViewData->GetZoomY();
/*N*/ 	ScOutputData aOutputData( this, OUTTYPE_WINDOW, pRowInfo, nArrCount, pDoc, nTab,
/*N*/ 								nScrX, nScrY, nX1, nY1, nX2, nY2, nPPTX, nPPTY,
/*N*/ 								&aZoomX, &aZoomY );
/*N*/ 
/*N*/ 	if ( bTextWysiwyg )
/*N*/ 	{
/*N*/ 		//	use printer for text formatting
/*N*/ 
/*N*/ 		OutputDevice* pFmtDev = pDoc->GetPrinter();
/*N*/ 		pFmtDev->SetMapMode( pViewData->GetLogicMode(eWhich) );
/*N*/ 		aOutputData.SetFmtDevice( pFmtDev );
/*N*/ 	}
/*N*/ 
/*N*/     const svtools::ColorConfig& rColorCfg = pScMod->GetColorConfig();
/*N*/     Color aGridColor( rColorCfg.GetColorValue( svtools::CALCGRID, FALSE ).nColor );
/*N*/ 	if ( aGridColor.GetColor() == COL_TRANSPARENT )
/*N*/ 	{
/*N*/ 		//	use view options' grid color only if color config has "automatic" color
/*N*/ 		aGridColor = rOpts.GetGridColor();
/*N*/ 	}
/*N*/ 
/*N*/ 	aOutputData.SetSyntaxMode		( pViewData->IsSyntaxMode() );
/*N*/ 	aOutputData.SetGridColor		( aGridColor );
/*N*/ 	aOutputData.SetShowNullValues	( rOpts.GetOption( VOPT_NULLVALS ) );
/*N*/ 	aOutputData.SetShowFormulas		( bFormulaMode );
/*N*/ 	aOutputData.SetShowSpellErrors	( !rOpts.IsHideAutoSpell() &&
/*N*/ 										pDoc->GetDocOptions().IsAutoSpell() );
/*N*/ 	aOutputData.SetMarkClipped		( bMarkClipped );
/*N*/ 
/*N*/ 	aOutputData.SetUseStyleColor( TRUE );		// always set in table view
/*N*/ 
/*N*/ 	aOutputData.SetEditObject( GetEditObject() );
/*N*/ 	aOutputData.SetViewShell( pViewData->GetViewShell() );
/*N*/ 
/*N*/ 	BOOL bGrid = rOpts.GetOption( VOPT_GRID );
/*N*/ 	BOOL bPage = rOpts.GetOption( VOPT_PAGEBREAKS );
/*N*/ 
/*N*/ 	if ( eMode == SC_UPDATE_CHANGED )
/*N*/ 	{
/*N*/ 		aOutputData.FindChanged();
/*N*/ 		aOutputData.SetSingleGrid(TRUE);
/*N*/ 	}
/*N*/ 
/*N*/ 	BOOL bPageMode = pViewData->IsPagebreakMode();
/*N*/ 	if (bPageMode)										// nach FindChanged
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		// SetPagebreakMode initialisiert auch bPrinted Flags
//STRIP001 /*?*/ 		aOutputData.SetPagebreakMode( pViewData->GetView()->GetPageBreakData() );
/*N*/ 	}
/*N*/ 
/*N*/ 	EditView*	pEditView = NULL;
/*N*/ 	BOOL		bEditMode = pViewData->HasEditView(eWhich);
/*N*/ 	if ( bEditMode && pViewData->GetRefTabNo() == nTab )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		USHORT nEditCol;
//STRIP001 /*?*/ 		USHORT nEditRow;
//STRIP001 /*?*/ 		pViewData->GetEditView( eWhich, pEditView, nEditCol, nEditRow );
//STRIP001 /*?*/ 		USHORT nEditEndCol = pViewData->GetEditEndCol();
//STRIP001 /*?*/ 		USHORT nEditEndRow = pViewData->GetEditEndRow();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( nEditEndCol >= nX1 && nEditCol <= nX2 && nEditEndRow >= nY1 && nEditRow <= nY2 )
//STRIP001 /*?*/ 			aOutputData.SetEditCell( nEditCol, nEditRow );
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			bEditMode = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		//	nur Edit-Area zu zeichnen?
//STRIP001 /*?*/ 		//!	dann muss trotzdem noch der Rand / das Gitter gemalt werden!
//STRIP001 /*?*/ 
//STRIP001 /*?*/ //		if ( nEditCol <= nX1 && nEditEndCol >= nX2 && nEditRow <= nY1 && nEditEndRow >= nY2 )
//STRIP001 /*?*/ //			bOnlyEdit = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	MapMode aDrawMode = GetDrawMapMode();
/*N*/ 	Rectangle aDrawingRect = PixelToLogic( Rectangle( Point( nScrX, nScrY ),
/*N*/ 										Size( aOutputData.GetScrW(), aOutputData.GetScrH() ) ),
/*N*/ 										aDrawMode );
/*N*/ 
/*N*/ 	if (bCurVis)
/*N*/ 		HideCursor();
/*N*/ 
/*N*/ 	if ( pDoc->HasBackgroundDraw( nTab, aDrawingRect ) )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		SetMapMode(MAP_PIXEL);
//STRIP001 /*?*/ 		aOutputData.DrawClear();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// Drawing Hintergrund
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		SetMapMode(aDrawMode);
//STRIP001 /*?*/ 		DrawRedraw( aOutputData, aDrawingRect, eMode, SC_LAYER_BACK );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		aOutputData.SetSolidBackground(TRUE);
/*N*/ 
/*N*/ 	SetMapMode(MAP_PIXEL);
/*N*/ 	aOutputData.DrawBackground();
/*N*/ 	if ( bGridFirst && ( bGrid || bPage ) )
/*N*/ 		aOutputData.DrawGrid( bGrid, bPage );
/*N*/ 	if ( bPageMode )
/*N*/ 	{
/*?*/ 		// #87655# DrawPagePreview draws complete lines/page numbers, must always be clipped
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( aOutputData.SetChangedClip() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			DrawPagePreview(nX1,nY1,nX2,nY2);
//STRIP001 /*?*/ 			SetClipRegion();
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 	aOutputData.DrawShadow();
/*N*/ 	aOutputData.DrawFrame();
/*N*/ 	if ( !bTextWysiwyg )
/*?*/ 		aOutputData.DrawStrings(FALSE);		// in pixel MapMode
/*N*/ 
/*N*/ 		// Autofilter- und Pivot-Buttons
/*N*/ 
/*N*/ 	DrawButtons( nX1, nY1, nX2, nY2, pRowInfo, nArrCount );			// Pixel
/*N*/ 
/*N*/ 		// Notiz-Anzeiger
/*N*/ 
/*N*/ 	if ( rOpts.GetOption( VOPT_NOTES ) )
/*N*/ 		aOutputData.DrawNoteMarks();
/*N*/ 
/*N*/ 		// Edit-Zellen
/*N*/ 
/*N*/ 	SetMapMode(pViewData->GetLogicMode(eWhich));
/*N*/ 	if ( bTextWysiwyg )
/*N*/ 		aOutputData.DrawStrings(TRUE);		// in logic MapMode if bTextWysiwyg is set
/*N*/ 	aOutputData.DrawEdit(TRUE);
/*N*/ 
/*N*/ 	SetMapMode(MAP_PIXEL);
/*N*/ 	if ( !bGridFirst && ( bGrid || bPage ) )
/*N*/ 	{
/*?*/ //		SetMapMode(MAP_PIXEL);
/*?*/ 		aOutputData.DrawGrid( bGrid, bPage );
/*N*/ 	}
/*N*/ 	aOutputData.DrawClipMarks();
/*N*/ 
/*N*/ 	//	Szenario / ChangeTracking muss auf jeden Fall nach DrawGrid sein, auch bei !bGridFirst
/*N*/ 
/*N*/ 	//!	Test, ob ChangeTrack-Anzeige aktiv ist
/*N*/ 	//!	Szenario-Rahmen per View-Optionen abschaltbar?
/*N*/ 
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	ScHighlightRanges* pHigh = pViewData->GetView()->GetHighlightRanges();
/*N*/ 	BOOL bHasScenario = ( nTab+1<nTabCount && pDoc->IsScenario(nTab+1) && !pDoc->IsScenario(nTab) );
/*N*/ 	BOOL bHasChange = ( pDoc->GetChangeTrack() != NULL );
/*N*/ 
/*N*/ 	if ( bHasChange || bHasScenario || pHigh != NULL )
/*N*/ 	{
/*?*/ //		SetMapMode(MAP_PIXEL);
/*?*/ 
/*?*/ 		//! SetChangedClip() mit DrawMarks() zusammenfassen?? (anderer MapMode!)
/*?*/ 
/*?*/ 		BOOL bAny = TRUE;
/*?*/ 		if (eMode == SC_UPDATE_CHANGED)
				bAny = aOutputData.SetChangedClip();
/*?*/ 		if (bAny)
/*?*/ 		{
/*?*/ 			if ( bHasChange )
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				aOutputData.DrawChangeTrack();
/*?*/ 
/*?*/ 			if ( bHasScenario )
						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				lcl_DrawScenarioFrames( this, pViewData, eWhich, nX1,nY1,nX2,nY2 );
/*?*/ 
/*?*/ 			if ( pHigh )
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				lcl_DrawHighlight( aOutputData, pViewData, *pHigh );
/*?*/ 
/*?*/ 			if (eMode == SC_UPDATE_CHANGED)
/*?*/ 				SetClipRegion();
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 		// Drawing Vordergrund
/*N*/ 
/*N*/ 	SetMapMode(aDrawMode);
/*N*/ 	DrawRedraw( aOutputData, aDrawingRect, eMode, SC_LAYER_FRONT );
/*N*/ 	DrawRedraw( aOutputData, aDrawingRect, eMode, SC_LAYER_INTERN );
/*N*/ 	DrawRedraw( aOutputData, aDrawingRect, eMode, SC_LAYER_CONTROLS );	// als letztes
/*N*/ 	DrawSdrGrid( aDrawingRect );
/*N*/ 
/*N*/ 	if (!bIsInScroll)								// Drawing Markierungen
/*N*/ 	{
/*N*/ 		BOOL bDraw = TRUE;
/*N*/ 		if (eMode == SC_UPDATE_CHANGED)
/*N*/ 			bDraw = NeedDrawMarks() && aOutputData.SetChangedClip();
/*N*/ 		if (bDraw)
/*N*/ 		{ 
/*N*/ 			DrawMarks();
/*N*/ 			if (eMode == SC_UPDATE_CHANGED)
/*N*/ 				SetClipRegion();
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SetMapMode(MAP_PIXEL);
/*N*/ 							//	InPlace Edit-View
/*N*/ 							//! gleich beim Zeichnen leer lassen !!!
/*N*/ 	if ( bEditMode && (pViewData->GetRefTabNo() == pViewData->GetTabNo()) )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 USHORT nCol1 = pViewData->GetEditViewCol();
//STRIP001 /*?*/ 		USHORT nRow1 = pViewData->GetEditViewRow();
//STRIP001 /*?*/ 		USHORT nCol2 = pViewData->GetEditEndCol();
//STRIP001 /*?*/ 		USHORT nRow2 = pViewData->GetEditEndRow();
//STRIP001 /*?*/ 		SetLineColor();
//STRIP001 /*?*/ 		SetFillColor( pEditView->GetBackgroundColor() );
//STRIP001 /*?*/ 		Point aStart = pViewData->GetScrPos( nCol1, nRow1, eWhich );
//STRIP001 /*?*/ 		Point aEnd = pViewData->GetScrPos( nCol2+1, nRow2+1, eWhich );
//STRIP001 /*?*/ 		aEnd.X() -= 2;		// Gitter nicht ueberschreiben
//STRIP001 /*?*/ 		aEnd.Y() -= 2;
//STRIP001 /*?*/ 		DrawRect( Rectangle( aStart,aEnd ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		SetMapMode(pViewData->GetLogicMode());
//STRIP001 /*?*/ 		pEditView->Paint( PixelToLogic( Rectangle( Point( nScrX, nScrY ),
//STRIP001 /*?*/ 							Size( aOutputData.GetScrW(), aOutputData.GetScrH() ) ) ) );
//STRIP001 /*?*/ 		SetMapMode(MAP_PIXEL);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pViewData->IsActive())
/*N*/ 		aOutputData.DrawMark( this );
/*N*/ 
/*N*/ 	if ( pViewData->IsRefMode() && nTab >= pViewData->GetRefStartZ() && nTab <= pViewData->GetRefEndZ() )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		//	Schraffur beim Loeschen per AutoFill
//STRIP001 /*?*/ 		if ( pViewData->GetRefType() == SC_REFTYPE_FILL )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			ScRange aRange;
//STRIP001 /*?*/ 			if ( pViewData->GetDelMark( aRange ) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if ( aRange.aStart.Col() < nX1 ) aRange.aStart.SetCol(nX1);
//STRIP001 /*?*/ 				if ( aRange.aEnd.Col() > nX2 )	 aRange.aEnd.SetCol(nX2);
//STRIP001 /*?*/ 				if ( aRange.aStart.Row() < nY1 ) aRange.aStart.SetRow(nY1);
//STRIP001 /*?*/ 				if ( aRange.aEnd.Row() > nY2 )	 aRange.aEnd.SetRow(nY2);
//STRIP001 /*?*/ 				if ( aRange.aStart.Col() <= aRange.aEnd.Col() &&
//STRIP001 /*?*/ 					 aRange.aStart.Row() <= aRange.aEnd.Row() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					Point aStart = pViewData->GetScrPos( aRange.aStart.Col(),
//STRIP001 /*?*/ 														 aRange.aStart.Row(), eWhich );
//STRIP001 /*?*/ 					Point aEnd = pViewData->GetScrPos( aRange.aEnd.Col()+1,
//STRIP001 /*?*/ 													   aRange.aEnd.Row()+1, eWhich );
//STRIP001 /*?*/ 					aEnd.X() -= 1;
//STRIP001 /*?*/ 					aEnd.Y() -= 1;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					//	Markierung aufheben - roter Rahmen bleibt stehen
//STRIP001 /*?*/ 					Rectangle aRect( aStart,aEnd );
//STRIP001 /*?*/ 					Invert( aRect, INVERT_HIGHLIGHT );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					//!	Delete-Bereich extra kennzeichnen?!?!?
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/         Color aRefColor( rColorCfg.GetColorValue(svtools::CALCREFERENCE).nColor );
//STRIP001 /*?*/ 		aOutputData.DrawRefMark( pViewData->GetRefStartX(), pViewData->GetRefStartY(),
//STRIP001 /*?*/ 								 pViewData->GetRefEndX(), pViewData->GetRefEndY(),
//STRIP001 /*?*/ 								 aRefColor, FALSE );
/*N*/ 	}
/*N*/ 
/*N*/ 		//	Range-Finder
/*N*/ 
/*N*/ 	ScInputHandler* pHdl = pScMod->GetInputHdl( pViewData->GetViewShell() );
/*N*/ 	if (pHdl)
/*N*/ 	{
/*N*/ 		ScRangeFindList* pRangeFinder = pHdl->GetRangeFindList();
/*N*/ 		if ( pRangeFinder && !pRangeFinder->IsHidden() &&
/*N*/ 				pRangeFinder->GetDocName() == pDocSh->GetTitle() )
/*N*/ 		{
/*?*/ 			USHORT nCount = (USHORT)pRangeFinder->Count();
/*?*/ 			for (USHORT i=0; i<nCount; i++)
/*?*/ 			{
/*?*/ 				ScRangeFindData* pData = pRangeFinder->GetObject(i);
/*?*/ 				if (pData)
/*?*/ 				{
/*?*/ 					ScRange aRef = pData->aRef;
/*?*/ 					aRef.Justify();
/*?*/ 					if ( aRef.aStart.Tab() >= nTab && aRef.aEnd.Tab() <= nTab )
							{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 						aOutputData.DrawRefMark( aRef.aStart.Col(), aRef.aStart.Row(),
//STRIP001 /*?*/ 												aRef.aEnd.Col(), aRef.aEnd.Row(),
//STRIP001 /*?*/ 												Color( ScRangeFindList::GetColorName( i ) ),
//STRIP001 /*?*/ 												TRUE );
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 		//	Rand (Pixel)
/*N*/ 
/*N*/ 	if ( nX2==MAXCOL || nY2==MAXROW )
/*N*/ 	{
/*?*/ 		Rectangle aPixRect = Rectangle( Point(), GetOutputSizePixel() );
/*?*/         SetFillColor( rColorCfg.GetColorValue(svtools::APPBACKGROUND).nColor );
/*?*/ 		SetLineColor();
/*?*/ 		if ( nX2==MAXCOL )
/*?*/ 		{
/*?*/ 			Rectangle aDrawRect( aPixRect );
/*?*/ 			aDrawRect.Left() = nScrX + aOutputData.GetScrW();
/*?*/ 			if (aDrawRect.Right() >= aDrawRect.Left())
/*?*/ 				DrawRect( aDrawRect );
/*?*/ 		}
/*?*/ 		if ( nY2==MAXROW )
/*?*/ 		{
/*?*/ 			Rectangle aDrawRect( aPixRect );
/*?*/ 			aDrawRect.Top() = nScrY + aOutputData.GetScrH();
/*?*/ 			if ( nX2==MAXCOL )
/*?*/ 				aDrawRect.Right() = nScrX + aOutputData.GetScrW() - 1;		// Ecke nicht doppelt
/*?*/ 			if (aDrawRect.Bottom() >= aDrawRect.Top())
/*?*/ 				DrawRect( aDrawRect );
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bCurVis)
/*N*/ 		ShowCursor();
/*N*/ 
/*N*/ 	for (i=0; i<nArrCount; i++)
/*N*/ 		delete[] pRowInfo[i].pCellInfo;
/*N*/ 	delete[] pRowInfo;
/*N*/ 
/*N*/ 	if (pViewData->HasEditView(eWhich))
/*?*/ 		SetMapMode(pViewData->GetLogicMode());
/*N*/ 	else
/*N*/ 		SetMapMode(aDrawMode);
/*N*/ 
/*N*/ 	if ( pNoteMarker )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		pNoteMarker->Draw();		// ueber den Cursor, im Drawing-MapMode
/*N*/ 
/*N*/ 	DrawStartTimer();				// fuer bunte Handles ohne System-Clipping
/*N*/ 
/*N*/ 	//
/*N*/ 	//	Wenn waehrend des Paint etwas invertiert wurde (Selektion geaendert aus Basic-Macro),
/*N*/ 	//	ist das jetzt durcheinandergekommen und es muss neu gemalt werden
/*N*/ 	//
/*N*/ 
/*N*/ 	DBG_ASSERT(nPaintCount, "nPaintCount falsch");
/*N*/ 	--nPaintCount;
/*N*/ 	if (!nPaintCount)
/*N*/ 		CheckNeedsRepaint();
/*N*/ }

/*N*/ void ScGridWindow::CheckNeedsRepaint()
/*N*/ {
/*N*/ 	//	called at the end of painting, and from timer after background text width calculation
/*N*/ 
/*N*/ 	if (bNeedsRepaint)
/*N*/ 	{
/*?*/ 		bNeedsRepaint = FALSE;
/*?*/ 		if (aRepaintPixel.IsEmpty())
/*?*/ 			Invalidate();
/*?*/ 		else
/*?*/ 			Invalidate(PixelToLogic(aRepaintPixel));
/*?*/ 		aRepaintPixel = Rectangle();
/*N*/ 	}
/*N*/ }

//STRIP001 void ScGridWindow::DrawPagePreview( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2 )
//STRIP001 {
//STRIP001 	ScPageBreakData* pPageData = pViewData->GetView()->GetPageBreakData();
//STRIP001 	if (pPageData)
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 		Size aWinSize = GetOutputSizePixel();
//STRIP001         const svtools::ColorConfig& rColorCfg = SC_MOD()->GetColorConfig();
//STRIP001         Color aManual( rColorCfg.GetColorValue(svtools::CALCPAGEBREAKMANUAL).nColor );
//STRIP001         Color aAutomatic( rColorCfg.GetColorValue(svtools::CALCPAGEBREAK).nColor );
//STRIP001 
//STRIP001 		String aPageText = ScGlobal::GetRscString( STR_PAGE );
//STRIP001 		if ( nPageScript == 0 )
//STRIP001 		{
//STRIP001 			//	get script type of translated "Page" string only once
//STRIP001 			nPageScript = pDoc->GetStringScriptType( aPageText );
//STRIP001 			if (nPageScript == 0)
//STRIP001 				nPageScript = ScGlobal::GetDefaultScriptType();
//STRIP001 		}
//STRIP001 		aPageText += ' ';
//STRIP001 
//STRIP001 		Font aFont;
//STRIP001 		ScEditEngineDefaulter* pEditEng = NULL;
//STRIP001 		const ScPatternAttr& rDefPattern = ((const ScPatternAttr&)pDoc->GetPool()->GetDefaultItem(ATTR_PATTERN));
//STRIP001 		if ( nPageScript == SCRIPTTYPE_LATIN )
//STRIP001 		{
//STRIP001 			//	use single font and call DrawText directly
//STRIP001 			rDefPattern.GetFont( aFont, SC_AUTOCOL_BLACK );
//STRIP001 			aFont.SetColor( Color( COL_LIGHTGRAY ) );
//STRIP001 			//	font size is set as needed
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//	use EditEngine to draw mixed-script string
//STRIP001 			pEditEng = new ScEditEngineDefaulter( EditEngine::CreatePool(), TRUE );
//STRIP001 			pEditEng->SetRefMapMode( GetMapMode() );
//STRIP001 			SfxItemSet* pEditDefaults = new SfxItemSet( pEditEng->GetEmptyItemSet() );
//STRIP001 			rDefPattern.FillEditItemSet( pEditDefaults );
//STRIP001 			pEditDefaults->Put( SvxColorItem( Color( COL_LIGHTGRAY ), EE_CHAR_COLOR ) );
//STRIP001 			pEditEng->SetDefaults( pEditDefaults );
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nCount = pPageData->GetCount();
//STRIP001 		for (USHORT nPos=0; nPos<nCount; nPos++)
//STRIP001 		{
//STRIP001 			ScPrintRangeData& rData = pPageData->GetData(nPos);
//STRIP001 			ScRange aRange = rData.GetPrintRange();
//STRIP001 			if ( aRange.aStart.Col() <= nX2+1  && aRange.aEnd.Col()+1 >= nX1 &&
//STRIP001 				 aRange.aStart.Row() <= nY2+1 && aRange.aEnd.Row()+1 >= nY1 )
//STRIP001 			{
//STRIP001 				//	3 Pixel Rahmen um den Druckbereich
//STRIP001 				//	(mittlerer Pixel auf den Gitterlinien)
//STRIP001 
//STRIP001 				SetLineColor();
//STRIP001 				if (rData.IsAutomatic())
//STRIP001 					SetFillColor( aAutomatic );
//STRIP001 				else
//STRIP001 					SetFillColor( aManual );
//STRIP001 
//STRIP001 				Point aStart = pViewData->GetScrPos(
//STRIP001 									aRange.aStart.Col(), aRange.aStart.Row(), eWhich, TRUE );
//STRIP001 				Point aEnd = pViewData->GetScrPos(
//STRIP001 									aRange.aEnd.Col() + 1, aRange.aEnd.Row() + 1, eWhich, TRUE );
//STRIP001 				aStart.X() -= 2;
//STRIP001 				aStart.Y() -= 2;
//STRIP001 
//STRIP001 				//	Ueberlaeufe verhindern:
//STRIP001 				if ( aStart.X() < -10 )	aStart.X() = -10;
//STRIP001 				if ( aStart.Y() < -10 )	aStart.Y() = -10;
//STRIP001 				if ( aEnd.X() > aWinSize.Width() + 10 )
//STRIP001 					aEnd.X() = aWinSize.Width() + 10;
//STRIP001 				if ( aEnd.Y() > aWinSize.Height() + 10 )
//STRIP001 					aEnd.Y() = aWinSize.Height() + 10;
//STRIP001 
//STRIP001 				DrawRect( Rectangle( aStart, Point(aEnd.X(),aStart.Y()+2) ) );
//STRIP001 				DrawRect( Rectangle( aStart, Point(aStart.X()+2,aEnd.Y()) ) );
//STRIP001 				DrawRect( Rectangle( Point(aStart.X(),aEnd.Y()-2), aEnd ) );
//STRIP001 				DrawRect( Rectangle( Point(aEnd.X()-2,aStart.Y()), aEnd ) );
//STRIP001 
//STRIP001 				//	Seitenumbrueche
//STRIP001 				//!	anders darstellen (gestrichelt ????)
//STRIP001 
//STRIP001 				USHORT nColBreaks = rData.GetPagesX();
//STRIP001 				const USHORT* pColEnd = rData.GetPageEndX();
//STRIP001 				USHORT nColPos;
//STRIP001 				for (nColPos=0; nColPos+1<nColBreaks; nColPos++)
//STRIP001 				{
//STRIP001 					USHORT nBreak = pColEnd[nColPos]+1;
//STRIP001 					if ( nBreak >= nX1 && nBreak <= nX2+1 )
//STRIP001 					{
//STRIP001 						//! hidden suchen
//STRIP001 						if ( pDoc->GetColFlags( nBreak, nTab ) & CR_MANUALBREAK )
//STRIP001 							SetFillColor( aManual );
//STRIP001 						else
//STRIP001 							SetFillColor( aAutomatic );
//STRIP001 						Point aBreak = pViewData->GetScrPos(
//STRIP001 										nBreak, aRange.aStart.Row(), eWhich, TRUE );
//STRIP001 						DrawRect( Rectangle( aBreak.X()-1, aStart.Y(), aBreak.X(), aEnd.Y() ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				USHORT nRowBreaks = rData.GetPagesY();
//STRIP001 				const USHORT* pRowEnd = rData.GetPageEndY();
//STRIP001 				USHORT nRowPos;
//STRIP001 				for (nRowPos=0; nRowPos+1<nRowBreaks; nRowPos++)
//STRIP001 				{
//STRIP001 					USHORT nBreak = pRowEnd[nRowPos]+1;
//STRIP001 					if ( nBreak >= nY1 && nBreak <= nY2+1 )
//STRIP001 					{
//STRIP001 						//! hidden suchen
//STRIP001 						if ( pDoc->GetRowFlags( nBreak, nTab ) & CR_MANUALBREAK )
//STRIP001 							SetFillColor( aManual );
//STRIP001 						else
//STRIP001 							SetFillColor( aAutomatic );
//STRIP001 						Point aBreak = pViewData->GetScrPos(
//STRIP001 										aRange.aStart.Col(), nBreak, eWhich, TRUE );
//STRIP001 						DrawRect( Rectangle( aStart.X(), aBreak.Y()-1, aEnd.X(), aBreak.Y() ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				//	Seitenzahlen
//STRIP001 
//STRIP001 				USHORT nPrStartY = aRange.aStart.Row();
//STRIP001 				for (nRowPos=0; nRowPos<nRowBreaks; nRowPos++)
//STRIP001 				{
//STRIP001 					USHORT nPrEndY = pRowEnd[nRowPos];
//STRIP001 					if ( nPrEndY >= nY1 && nPrStartY <= nY2 )
//STRIP001 					{
//STRIP001 						USHORT nPrStartX = aRange.aStart.Col();
//STRIP001 						for (nColPos=0; nColPos<nColBreaks; nColPos++)
//STRIP001 						{
//STRIP001 							USHORT nPrEndX = pColEnd[nColPos];
//STRIP001 							if ( nPrEndX >= nX1 && nPrStartX <= nX2 )
//STRIP001 							{
//STRIP001 								Point aPageStart = pViewData->GetScrPos(
//STRIP001 														nPrStartX, nPrStartY, eWhich, TRUE );
//STRIP001 								Point aPageEnd = pViewData->GetScrPos(
//STRIP001 														nPrEndX+1,nPrEndY+1, eWhich, TRUE );
//STRIP001 
//STRIP001 								long nPageNo = rData.GetFirstPage();
//STRIP001 								if ( rData.IsTopDown() )
//STRIP001 									nPageNo += ((long)nColPos)*nRowBreaks+nRowPos;
//STRIP001 								else
//STRIP001 									nPageNo += ((long)nRowPos)*nColBreaks+nColPos;
//STRIP001 								String aPageStr = aPageText;
//STRIP001 								aPageStr += String::CreateFromInt32(nPageNo);
//STRIP001 
//STRIP001 								if ( pEditEng )
//STRIP001 								{
//STRIP001 									//	find right font size with EditEngine
//STRIP001 									long nHeight = 100;
//STRIP001 									pEditEng->SetDefaultItem( SvxFontHeightItem( nHeight, 100, EE_CHAR_FONTHEIGHT ) );
//STRIP001 									pEditEng->SetDefaultItem( SvxFontHeightItem( nHeight, 100, EE_CHAR_FONTHEIGHT_CJK ) );
//STRIP001 									pEditEng->SetDefaultItem( SvxFontHeightItem( nHeight, 100, EE_CHAR_FONTHEIGHT_CTL ) );
//STRIP001 									pEditEng->SetText( aPageStr );
//STRIP001 									Size aSize100( pEditEng->CalcTextWidth(), pEditEng->GetTextHeight() );
//STRIP001 
//STRIP001 									//	40% of width or 60% of height
//STRIP001 									long nSizeX = 40 * ( aPageEnd.X() - aPageStart.X() ) / aSize100.Width();
//STRIP001 									long nSizeY = 60 * ( aPageEnd.Y() - aPageStart.Y() ) / aSize100.Height();
//STRIP001 									nHeight = Min(nSizeX,nSizeY);
//STRIP001 									pEditEng->SetDefaultItem( SvxFontHeightItem( nHeight, 100, EE_CHAR_FONTHEIGHT ) );
//STRIP001 									pEditEng->SetDefaultItem( SvxFontHeightItem( nHeight, 100, EE_CHAR_FONTHEIGHT_CJK ) );
//STRIP001 									pEditEng->SetDefaultItem( SvxFontHeightItem( nHeight, 100, EE_CHAR_FONTHEIGHT_CTL ) );
//STRIP001 
//STRIP001 									//	centered output with EditEngine
//STRIP001 									Size aTextSize( pEditEng->CalcTextWidth(), pEditEng->GetTextHeight() );
//STRIP001 									Point aPos( (aPageStart.X()+aPageEnd.X()-aTextSize.Width())/2,
//STRIP001 												(aPageStart.Y()+aPageEnd.Y()-aTextSize.Height())/2 );
//STRIP001 									pEditEng->Draw( this, aPos );
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									//	find right font size for DrawText
//STRIP001 									aFont.SetSize( Size( 0,100 ) );
//STRIP001 									SetFont( aFont );
//STRIP001 									Size aSize100( GetTextWidth( aPageStr ), GetTextHeight() );
//STRIP001 
//STRIP001 									//	40% of width or 60% of height
//STRIP001 									long nSizeX = 40 * ( aPageEnd.X() - aPageStart.X() ) / aSize100.Width();
//STRIP001 									long nSizeY = 60 * ( aPageEnd.Y() - aPageStart.Y() ) / aSize100.Height();
//STRIP001 									aFont.SetSize( Size( 0,Min(nSizeX,nSizeY) ) );
//STRIP001 									SetFont( aFont );
//STRIP001 
//STRIP001 									//	centered output with DrawText
//STRIP001 									Size aTextSize( GetTextWidth( aPageStr ), GetTextHeight() );
//STRIP001 									Point aPos( (aPageStart.X()+aPageEnd.X()-aTextSize.Width())/2,
//STRIP001 												(aPageStart.Y()+aPageEnd.Y()-aTextSize.Height())/2 );
//STRIP001 									DrawText( aPos, aPageStr );
//STRIP001 								}
//STRIP001 							}
//STRIP001 							nPrStartX = nPrEndX + 1;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					nPrStartY = nPrEndY + 1;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pEditEng;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScGridWindow::DrawRefMark( USHORT nRefStartX, USHORT nRefStartY,
//STRIP001 									USHORT nRefEndX, USHORT nRefEndY,
//STRIP001 									const Color& rColor, BOOL bHandle )
//STRIP001 {
//STRIP001 	PutInOrder( nRefStartX, nRefEndX );
//STRIP001 	PutInOrder( nRefStartY, nRefEndY );
//STRIP001 
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	if ( nRefStartX == nRefEndX && nRefStartY == nRefEndY )
//STRIP001 		pDoc->ExtendMerge( nRefStartX, nRefStartY, nRefEndX, nRefEndY, nTab );
//STRIP001 
//STRIP001 	MapMode aOld = GetMapMode();
//STRIP001 	SetMapMode(MAP_PIXEL);
//STRIP001 
//STRIP001 	USHORT nCurX = pViewData->GetCurX();
//STRIP001 	USHORT nCurY = pViewData->GetCurY();
//STRIP001 	BOOL bHide = ( nCurX+1 >= nRefStartX && nCurX <= nRefEndX+1 &&
//STRIP001 				   nCurY+1 >= nRefStartY && nCurY <= nRefEndY+1 );
//STRIP001 
//STRIP001 	Point aStartPos = pViewData->GetScrPos( nRefStartX, nRefStartY, eWhich, TRUE );
//STRIP001 	Point aEndPos = pViewData->GetScrPos( nRefEndX+1, nRefEndY+1, eWhich, TRUE );
//STRIP001 	aEndPos.X() -= 2;
//STRIP001 	aEndPos.Y() -= 2;	// nicht ueber das Gitter
//STRIP001 
//STRIP001 	//	begrenzen um Ueberlaeufe mit Paint-Fehlern zu vermeiden
//STRIP001 	long nMinY = -10;
//STRIP001 	long nMaxY = GetOutputSizePixel().Height() + 10;	// mit Abstand fuer Handle
//STRIP001 	if (aStartPos.Y() < nMinY) aStartPos.Y() = nMinY;
//STRIP001 	if (aStartPos.Y() > nMaxY) aStartPos.Y() = nMaxY;
//STRIP001 	if (aEndPos.Y() > nMaxY) aEndPos.Y() = nMaxY;
//STRIP001 	if (aEndPos.Y() < nMinY) aEndPos.Y() = nMinY;
//STRIP001 
//STRIP001 	if (bHide)
//STRIP001 		HideCursor();
//STRIP001 
//STRIP001 	SetLineColor( rColor );
//STRIP001 	SetFillColor();
//STRIP001 	DrawRect( Rectangle( aStartPos, aEndPos ) );
//STRIP001 
//STRIP001 	if ( bHandle )
//STRIP001 	{
//STRIP001 		SetLineColor();
//STRIP001 		SetFillColor( rColor );
//STRIP001 		DrawRect( Rectangle( aEndPos.X()-3, aEndPos.Y()-3,
//STRIP001 								aEndPos.X()+1, aEndPos.Y()+1 ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bHide)
//STRIP001 		ShowCursor();
//STRIP001 
//STRIP001 	SetMapMode(aOld);
//STRIP001 }

/*N*/ void ScGridWindow::DrawButtons( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2,
/*N*/ 									RowInfo* pRowInfo, USHORT nArrCount )
/*N*/ {
/*N*/ 	USHORT			nCol, nRow, nArrY, nQuery;
/*N*/ 	USHORT			nTab = pViewData->GetTabNo();
/*N*/ 	ScDocument*		pDoc = pViewData->GetDocument();
/*N*/ 	ScDBData*		pDBData = NULL;
/*N*/ 	ScQueryParam*	pQueryParam = NULL;
/*N*/ 
/*N*/ 	Point aOldPos  = aComboButton.GetPosPixel();	// Zustand fuer MouseDown/Up
/*N*/ 	Size  aOldSize = aComboButton.GetSizePixel();   // merken
/*N*/ 
/*N*/ 	for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		if ( pRowInfo[nArrY].bAutoFilter && pRowInfo[nArrY].bChanged )
/*N*/ 		{
/*?*/ 			RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*?*/ 
/*?*/ 			nRow = pThisRowInfo->nRowNo;
/*?*/ 
/*?*/ 
/*?*/ 			for (nCol=nX1; nCol<=nX2; nCol++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nCol+1];
/*?*/ 				if ( pInfo->bAutoFilter && !pInfo->bHOverlapped && !pInfo->bVOverlapped )
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 					if (!pQueryParam)
//STRIP001 /*?*/ 						pQueryParam = new ScQueryParam;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					BOOL bNewData = TRUE;
//STRIP001 /*?*/ 					if (pDBData)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						USHORT nStartCol;
//STRIP001 /*?*/ 						USHORT nStartRow;
//STRIP001 /*?*/ 						USHORT nEndCol;
//STRIP001 /*?*/ 						USHORT nEndRow;
//STRIP001 /*?*/ 						USHORT nAreaTab;
//STRIP001 /*?*/ 						pDBData->GetArea( nAreaTab, nStartCol, nStartRow, nEndCol, nEndRow );
//STRIP001 /*?*/ 						if ( nCol >= nStartCol && nCol <= nEndCol &&
//STRIP001 /*?*/ 							 nRow >= nStartRow && nRow <= nEndRow )
//STRIP001 /*?*/ 							bNewData = FALSE;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					if (bNewData)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pDBData = pDoc->GetDBAtCursor( nCol, nRow, nTab );
//STRIP001 /*?*/ 						if (pDBData)
//STRIP001 /*?*/ 							pDBData->GetQueryParam( *pQueryParam );
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							DBG_ERROR("Auto-Filter-Button ohne DBData");
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					//	pQueryParam kann nur MAXQUERY Eintraege enthalten
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					BOOL bSimpleQuery = TRUE;
//STRIP001 /*?*/ 					BOOL bColumnFound = FALSE;
//STRIP001 /*?*/ 					if (!pQueryParam->bInplace)
//STRIP001 /*?*/ 						bSimpleQuery = FALSE;
//STRIP001 /*?*/ 					for (nQuery=0; nQuery<MAXQUERY && bSimpleQuery; nQuery++)
//STRIP001 /*?*/ 						if (pQueryParam->GetEntry(nQuery).bDoQuery)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							//	hier nicht auf EQUAL beschraenken
//STRIP001 /*?*/ 							//	(auch bei ">1" soll der Spaltenkopf blau werden)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (pQueryParam->GetEntry(nQuery).nField == nCol)
//STRIP001 /*?*/ 								bColumnFound = TRUE;
//STRIP001 /*?*/ 							if (nQuery > 0)
//STRIP001 /*?*/ 								if (pQueryParam->GetEntry(nQuery).eConnect != SC_AND)
//STRIP001 /*?*/ 									bSimpleQuery = FALSE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/                     bool bArrowState = bSimpleQuery && bColumnFound;
//STRIP001 /*?*/ 					long	nSizeX;
//STRIP001 /*?*/ 					long	nSizeY;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					pViewData->GetMergeSizePixel( nCol, nRow, nSizeX, nSizeY );
//STRIP001 /*?*/ 					aComboButton.SetOptSizePixel();
//STRIP001 /*?*/ 					DrawComboButton( pViewData->GetScrPos( nCol, nRow, eWhich ),
//STRIP001 /*?*/                                      nSizeX, nSizeY, bArrowState );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					aComboButton.SetPosPixel( aOldPos );	// alten Zustand
//STRIP001 /*?*/ 					aComboButton.SetSizePixel( aOldSize );	// fuer MouseUp/Down
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pRowInfo[nArrY].bPushButton && pRowInfo[nArrY].bChanged )
/*N*/ 		{
/*?*/ 			RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*?*/ 			nRow = pThisRowInfo->nRowNo;
/*?*/ 			for (nCol=nX1; nCol<=nX2; nCol++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nCol+1];
/*?*/ 				if ( pInfo->bPushButton && !pInfo->bHOverlapped && !pInfo->bVOverlapped )
/*?*/ 				{
/*?*/ 					Point aScrPos = pViewData->GetScrPos( nCol, nRow, eWhich );
/*?*/ 					long nSizeX;
/*?*/ 					long nSizeY;
/*?*/ 					pViewData->GetMergeSizePixel( nCol, nRow, nSizeX, nSizeY );
/*?*/ 					long nPosX = aScrPos.X();
/*?*/ 					long nPosY = aScrPos.Y();
/*?*/ 
/*?*/                     SetLineColor( GetSettings().GetStyleSettings().GetLightColor() );
/*?*/ 					DrawLine( Point(nPosX,nPosY), Point(nPosX,nPosY+nSizeY-1) );
/*?*/ 					DrawLine( Point(nPosX,nPosY), Point(nPosX+nSizeX-1,nPosY) );
/*?*/                     SetLineColor( GetSettings().GetStyleSettings().GetDarkShadowColor() );
/*?*/ 					DrawLine( Point(nPosX,nPosY+nSizeY-1), Point(nPosX+nSizeX-1,nPosY+nSizeY-1) );
/*?*/ 					DrawLine( Point(nPosX+nSizeX-1,nPosY), Point(nPosX+nSizeX-1,nPosY+nSizeY-1) );
/*?*/ 					SetLineColor( COL_BLACK );
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pQueryParam;
/*N*/ }

//STRIP001 BOOL ScGridWindow::IsAutoFilterActive( USHORT nCol, USHORT nRow, USHORT nTab )
//STRIP001 {
//STRIP001 	ScDocument*		pDoc	= pViewData->GetDocument();
//STRIP001 	ScDBData*		pDBData = pDoc->GetDBAtCursor( nCol, nRow, nTab );
//STRIP001 	ScQueryParam	aQueryParam;
//STRIP001 
//STRIP001 	if ( pDBData )
//STRIP001 		pDBData->GetQueryParam( aQueryParam );
//STRIP001 	else
//STRIP001 		DBG_ERROR("Auto-Filter-Button ohne DBData");
//STRIP001 
//STRIP001 	BOOL	bSimpleQuery = TRUE;
//STRIP001 	BOOL	bColumnFound = FALSE;
//STRIP001 	USHORT	nQuery;
//STRIP001 
//STRIP001 	if ( !aQueryParam.bInplace )
//STRIP001 		bSimpleQuery = FALSE;
//STRIP001 
//STRIP001 	//	aQueryParam kann nur MAXQUERY Eintraege enthalten
//STRIP001 
//STRIP001 	for ( nQuery=0; nQuery<MAXQUERY && bSimpleQuery; nQuery++ )
//STRIP001 		if ( aQueryParam.GetEntry(nQuery).bDoQuery )
//STRIP001 		{
//STRIP001 			if (aQueryParam.GetEntry(nQuery).nField == nCol)
//STRIP001 				bColumnFound = TRUE;
//STRIP001 
//STRIP001 			if (nQuery > 0)
//STRIP001 				if (aQueryParam.GetEntry(nQuery).eConnect != SC_AND)
//STRIP001 					bSimpleQuery = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 	return ( bSimpleQuery && bColumnFound );
//STRIP001 }

//STRIP001 void ScGridWindow::DrawComboButton( const Point&	rCellPos,
//STRIP001 									long			nCellSizeX,
//STRIP001 									long			nCellSizeY,
//STRIP001                                     BOOL            bArrowState,
//STRIP001 									BOOL			bBtnIn )
//STRIP001 {
//STRIP001 	Point	aScrPos	 = rCellPos;
//STRIP001 	Size	aBtnSize = aComboButton.GetSizePixel();
//STRIP001 
//STRIP001 	if ( nCellSizeX < aBtnSize.Width() || nCellSizeY < aBtnSize.Height() )
//STRIP001 	{
//STRIP001 		if ( nCellSizeX < aBtnSize.Width() )
//STRIP001 			aBtnSize.Width() = nCellSizeX;
//STRIP001 
//STRIP001 		if ( nCellSizeY < aBtnSize.Height() )
//STRIP001 			aBtnSize.Height() = nCellSizeY;
//STRIP001 
//STRIP001 		aComboButton.SetSizePixel( aBtnSize );
//STRIP001 	}
//STRIP001 
//STRIP001 	aScrPos.X() += nCellSizeX - aBtnSize.Width();
//STRIP001 	aScrPos.Y() += nCellSizeY - aBtnSize.Height();
//STRIP001 
//STRIP001 	aComboButton.SetPosPixel( aScrPos );
//STRIP001 
//STRIP001 	HideCursor();
//STRIP001     aComboButton.Draw( bArrowState, bBtnIn );
//STRIP001 	ShowCursor();
//STRIP001 }

//STRIP001 void ScGridWindow::InvertSimple( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2,
//STRIP001 									BOOL bTestMerge, BOOL bRepeat )
//STRIP001 {
//STRIP001 	//!	if INVERT_HIGHLIGHT swaps foreground and background (like on Mac),
//STRIP001 	//!	use INVERT_HIGHLIGHT only for cells that have no background color set
//STRIP001 	//!	(here and in ScOutputData::DrawMark)
//STRIP001 
//STRIP001 	PutInOrder( nX1, nX2 );
//STRIP001 	PutInOrder( nY1, nY2 );
//STRIP001 
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 	USHORT nTestX2 = nX2;
//STRIP001 	USHORT nTestY2 = nY2;
//STRIP001 	if (bTestMerge)
//STRIP001 		pDoc->ExtendMerge( nX1,nY1, nTestX2,nTestY2, nTab );
//STRIP001 
//STRIP001 	USHORT nPosX = pViewData->GetPosX( eHWhich );
//STRIP001 	USHORT nPosY = pViewData->GetPosY( eVWhich );
//STRIP001 	if (nTestX2 < nPosX || nTestY2 < nPosY)
//STRIP001 		return;											// unsichtbar
//STRIP001 	USHORT nRealX1 = nX1;
//STRIP001 	if (nX1 < nPosX)
//STRIP001 		nX1 = nPosX;
//STRIP001 	if (nY1 < nPosY)
//STRIP001 		nY1 = nPosY;
//STRIP001 
//STRIP001 	USHORT nXRight = nPosX + pViewData->VisibleCellsX(eHWhich);
//STRIP001 	if (nXRight > MAXCOL) nXRight = MAXCOL;
//STRIP001 	USHORT nYBottom = nPosY + pViewData->VisibleCellsY(eVWhich);
//STRIP001 	if (nYBottom > MAXROW) nYBottom = MAXROW;
//STRIP001 
//STRIP001 	if (nX1 > nXRight || nY1 > nYBottom)
//STRIP001 		return;											// unsichtbar
//STRIP001 	if (nX2 > nXRight) nX2 = nXRight;
//STRIP001 	if (nY2 > nYBottom) nY2 = nYBottom;
//STRIP001 
//STRIP001 	MapMode aOld = GetMapMode(); SetMapMode(MAP_PIXEL);		// erst nach den return's !!!
//STRIP001 
//STRIP001 	double nPPTX = pViewData->GetPPTX();
//STRIP001 	double nPPTY = pViewData->GetPPTY();
//STRIP001 
//STRIP001 	ScInvertMerger aInvert( this );
//STRIP001 
//STRIP001 	Point aScrPos = pViewData->GetScrPos( nX1, nY1, eWhich );
//STRIP001 	USHORT nScrY = (USHORT) aScrPos.Y();
//STRIP001 	BOOL bWasHidden = FALSE;
//STRIP001 	for (USHORT nY=nY1; nY<=nY2; nY++)
//STRIP001 	{
//STRIP001 		BOOL bFirstRow = ( nY == nPosY );						// first visible row?
//STRIP001 		BOOL bDoHidden = FALSE;									// versteckte nachholen ?
//STRIP001 		USHORT nHeightTwips = pDoc->GetRowHeight( nY,nTab );
//STRIP001 		BOOL bDoRow = ( nHeightTwips != 0 );
//STRIP001 		if (bDoRow)
//STRIP001 		{
//STRIP001 			if (bTestMerge)
//STRIP001 				if (bWasHidden)					// auf versteckte zusammengefasste testen
//STRIP001 				{
//STRIP001 //					--nY;						// nY geaendert -> vorherige zeichnen
//STRIP001 					bDoHidden = TRUE;
//STRIP001 					bDoRow = TRUE;
//STRIP001 				}
//STRIP001 
//STRIP001 			bWasHidden = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bWasHidden = TRUE;
//STRIP001 			if (bTestMerge)
//STRIP001 				if (nY==nY2)
//STRIP001 					bDoRow = TRUE;				// letzte Zeile aus Block
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bDoRow )
//STRIP001 		{
//STRIP001 			USHORT nLoopEndX = nX2;
//STRIP001 			if (nX2 < nX1)						// Rest von zusammengefasst
//STRIP001 			{
//STRIP001 				USHORT nStartX = nX1;
//STRIP001 				while ( ((const ScMergeFlagAttr*)pDoc->
//STRIP001 							GetAttr(nStartX,nY,nTab,ATTR_MERGE_FLAG))->IsHorOverlapped() )
//STRIP001 					--nStartX;
//STRIP001 				if (nStartX <= nX2)
//STRIP001 					nLoopEndX = nX1;
//STRIP001 			}
//STRIP001 
//STRIP001 			USHORT nEndY = nScrY + (USHORT) ScViewData::ToPixel( nHeightTwips, nPPTY ) - 1;
//STRIP001 			USHORT nScrX = (USHORT) aScrPos.X();
//STRIP001 			for (USHORT nX=nX1; nX<=nLoopEndX; nX++)
//STRIP001 			{
//STRIP001 				USHORT nWidth = (USHORT) ScViewData::ToPixel( pDoc->GetColWidth( nX,nTab ), nPPTX );
//STRIP001 				if ( nWidth > 0 )
//STRIP001 				{
//STRIP001 					USHORT nEndX = nScrX + nWidth - 1;
//STRIP001 					if (bTestMerge)
//STRIP001 					{
//STRIP001 						USHORT nThisY = nY;
//STRIP001 						const ScPatternAttr* pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 						const ScMergeFlagAttr* pMergeFlag = (const ScMergeFlagAttr*) &pPattern->
//STRIP001 																		GetItem(ATTR_MERGE_FLAG);
//STRIP001 						if ( pMergeFlag->IsVerOverlapped() && ( bDoHidden || bFirstRow ) )
//STRIP001 						{
//STRIP001 							while ( pMergeFlag->IsVerOverlapped() && nThisY > 0 &&
//STRIP001 										( (pDoc->GetRowFlags( nThisY-1, nTab ) & CR_HIDDEN) || bFirstRow ) )
//STRIP001 							{
//STRIP001 								--nThisY;
//STRIP001 								pPattern = pDoc->GetPattern( nX, nThisY, nTab );
//STRIP001 								pMergeFlag = (const ScMergeFlagAttr*) &pPattern->GetItem(ATTR_MERGE_FLAG);
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						// nur Rest von zusammengefasster zu sehen ?
//STRIP001 						USHORT nThisX = nX;
//STRIP001 						if ( pMergeFlag->IsHorOverlapped() && nX == nPosX && nX > nRealX1 )
//STRIP001 						{
//STRIP001 							while ( pMergeFlag->IsHorOverlapped() )
//STRIP001 							{
//STRIP001 								--nThisX;
//STRIP001 								pPattern = pDoc->GetPattern( nThisX, nThisY, nTab );
//STRIP001 								pMergeFlag = (const ScMergeFlagAttr*) &pPattern->GetItem(ATTR_MERGE_FLAG);
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						if ( rMark.IsCellMarked( nThisX, nThisY, TRUE ) == bRepeat )
//STRIP001 						{
//STRIP001 							if ( !pMergeFlag->IsOverlapped() )
//STRIP001 							{
//STRIP001 								ScMergeAttr* pMerge = (ScMergeAttr*)&pPattern->GetItem(ATTR_MERGE);
//STRIP001 								if (pMerge->GetColMerge() || pMerge->GetRowMerge())
//STRIP001 								{
//STRIP001 									Point aEndPos = pViewData->GetScrPos(
//STRIP001 											nThisX + pMerge->GetColMerge(),
//STRIP001 											nThisY + pMerge->GetRowMerge(), eWhich );
//STRIP001 									if ( aEndPos.X() > nScrX && aEndPos.Y() > nScrY )
//STRIP001 									{
//STRIP001 										aInvert.AddRect( Rectangle( nScrX,nScrY,aEndPos.X()-1,aEndPos.Y()-1 ) );
//STRIP001 									}
//STRIP001 								}
//STRIP001 								else if ( nEndX >= nScrX && nEndY >= nScrY )
//STRIP001 								{
//STRIP001 									aInvert.AddRect( Rectangle( nScrX,nScrY,nEndX,nEndY ) );
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else		// !bTestMerge
//STRIP001 					{
//STRIP001 						if ( rMark.IsCellMarked( nX, nY, TRUE ) == bRepeat &&
//STRIP001 												nEndX >= nScrX && nEndY >= nScrY )
//STRIP001 						{
//STRIP001 							aInvert.AddRect( Rectangle( nScrX,nScrY,nEndX,nEndY ) );
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					nScrX = nEndX + 1;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			nScrY = nEndY + 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aInvert.Flush();		// before restoring MapMode
//STRIP001 
//STRIP001 	SetMapMode(aOld);
//STRIP001 
//STRIP001 	CheckInverted();
//STRIP001 }

// -------------------------------------------------------------------------

//STRIP001 void ScGridWindow::DrawDragRect( USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2,
//STRIP001 									BOOL bMarkDrop )
//STRIP001 {
//STRIP001 	if ( nX2 < pViewData->GetPosX(eHWhich) || nY2 < pViewData->GetPosY(eVWhich) )
//STRIP001 		return;
//STRIP001 
//STRIP001 	//	Nur auf dem Mac wird bei Drag&Drop nur die Einfuegeposition markiert
//STRIP001 #ifndef MAC
//STRIP001 	bMarkDrop = FALSE;
//STRIP001 #endif
//STRIP001 
//STRIP001 	if (bMarkDrop)
//STRIP001 		nY2 = nY1;		// nur 1 Zeile
//STRIP001 
//STRIP001 	Update();			// wegen XOR
//STRIP001 
//STRIP001 	MapMode aOld = GetMapMode(); SetMapMode(MAP_PIXEL);
//STRIP001 
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 	USHORT nPosX = pViewData->GetPosX(WhichH(eWhich));
//STRIP001 	USHORT nPosY = pViewData->GetPosY(WhichV(eWhich));
//STRIP001 	if (nX1 < nPosX) nX1 = nPosX;
//STRIP001 	if (nX2 < nPosX) nX2 = nPosX;
//STRIP001 	if (nY1 < nPosY) nY1 = nPosY;
//STRIP001 	if (nY2 < nPosY) nY2 = nPosY;
//STRIP001 
//STRIP001 	Point aScrPos( pViewData->GetScrPos( nX1, nY1, eWhich ) );
//STRIP001 
//STRIP001 	long nSizeXPix=0;
//STRIP001 	long nSizeYPix=0;
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	double nPPTX = pViewData->GetPPTX();
//STRIP001 	double nPPTY = pViewData->GetPPTY();
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	if (bMarkDrop)
//STRIP001 	{
//STRIP001 		aScrPos.X() -= 1;			// nur die Position markieren
//STRIP001 		nSizeXPix   += 2;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (nX2<=MAXCOL && nX2>=nX1)
//STRIP001 			for (i=nX1; i<=nX2; i++)
//STRIP001 				nSizeXPix += ScViewData::ToPixel( pDoc->GetColWidth( i, nTab ), nPPTX );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aScrPos.X() -= 1;
//STRIP001 			nSizeXPix   += 2;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nY2<=MAXROW && nY2>=nY1)
//STRIP001 		for (i=nY1; i<=nY2; i++)
//STRIP001 			nSizeYPix += ScViewData::ToPixel( pDoc->GetRowHeight( i, nTab ), nPPTY );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aScrPos.Y() -= 1;
//STRIP001 		nSizeYPix   += 2;
//STRIP001 	}
//STRIP001 
//STRIP001 	aScrPos.X() -= 2;
//STRIP001 	aScrPos.Y() -= 2;
//STRIP001 	Rectangle aRect( aScrPos, Size( nSizeXPix + 3, nSizeYPix + 3 ) );
//STRIP001 
//STRIP001 	Invert(Rectangle( aRect.Left(), aRect.Top(), aRect.Left()+2, aRect.Bottom() ));
//STRIP001 	Invert(Rectangle( aRect.Right()-2, aRect.Top(), aRect.Right(), aRect.Bottom() ));
//STRIP001 	Invert(Rectangle( aRect.Left()+3, aRect.Top(), aRect.Right()-3, aRect.Top()+2 ));
//STRIP001 	Invert(Rectangle( aRect.Left()+3, aRect.Bottom()-2, aRect.Right()-3, aRect.Bottom() ));
//STRIP001 
//STRIP001 	SetMapMode(aOld);
//STRIP001 }

// -------------------------------------------------------------------------

/*N*/ void ScGridWindow::DrawCursor()
/*N*/ {
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 	USHORT nX = pViewData->GetCurX();
/*N*/ 	USHORT nY = pViewData->GetCurY();
/*N*/ 
/*N*/ 	//	in verdeckten Zellen nicht zeichnen
/*N*/ 
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	const ScPatternAttr* pPattern = pDoc->GetPattern(nX,nY,nTab);
/*N*/ 	const ScMergeFlagAttr& rMerge = (const ScMergeFlagAttr&) pPattern->GetItem(ATTR_MERGE_FLAG);
/*N*/ 	if (rMerge.IsOverlapped())
/*N*/ 		return;
/*N*/ 
/*N*/ 	//	links/oben ausserhalb des Bildschirms ?
/*N*/ 
/*N*/ 	BOOL bVis = ( nX>=pViewData->GetPosX(eHWhich) && nY>=pViewData->GetPosY(eVWhich) );
/*N*/ 	if (!bVis)
/*N*/ 	{
/*?*/ 		USHORT nEndX = nX;
/*?*/ 		USHORT nEndY = nY;
/*?*/ 		ScDocument* pDoc = pViewData->GetDocument();
/*?*/ 		const ScMergeAttr& rMerge = (const ScMergeAttr&) pPattern->GetItem(ATTR_MERGE);
/*?*/ 		if (rMerge.GetColMerge() > 1)
/*?*/ 			nEndX += rMerge.GetColMerge()-1;
/*?*/ 		if (rMerge.GetRowMerge() > 1)
/*?*/ 			nEndX += rMerge.GetRowMerge()-1;
/*?*/ 		bVis = ( nEndX>=pViewData->GetPosX(eHWhich) && nEndY>=pViewData->GetPosY(eVWhich) );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bVis )
/*N*/ 	{
/*N*/ 		//	hier kein Update, da aus Paint gerufen und laut Zaehler Cursor schon da
/*N*/ 		//	wenn Update noetig, dann bei Hide/Showcursor vor dem Hoch-/Runterzaehlen
/*N*/ 
/*N*/ 		MapMode aOld = GetMapMode(); SetMapMode(MAP_PIXEL);
/*N*/ 
/*N*/ 		Point aScrPos = pViewData->GetScrPos( nX, nY, eWhich, TRUE );
/*N*/ 
/*N*/ 		//	rechts/unten ausserhalb des Bildschirms ?
/*N*/ 
/*N*/ 		Size aOutSize = GetOutputSizePixel();
/*N*/ 		if ( aScrPos.X() <= aOutSize.Width() + 2 && aScrPos.Y() <= aOutSize.Height() + 2 )
/*N*/ 		{
/*N*/ 			long nSizeXPix;
/*N*/ 			long nSizeYPix;
/*N*/ 			pViewData->GetMergeSizePixel( nX, nY, nSizeXPix, nSizeYPix );
/*N*/ 
/*N*/ 			BOOL bFix = ( pViewData->GetHSplitMode() == SC_SPLIT_FIX ||
/*N*/ 							pViewData->GetVSplitMode() == SC_SPLIT_FIX );
/*N*/ 			if ( pViewData->GetActivePart()==eWhich || bFix )
/*N*/ 			{
/*N*/ 				//	old UNX version with two Invert calls causes flicker.
/*N*/ 				//	if optimization is needed, a new flag should be added
/*N*/ 				//	to InvertTracking
/*N*/ 
/*N*/ 				aScrPos.X() -= 2;
/*N*/ 				aScrPos.Y() -= 2;
/*N*/ 				Rectangle aRect( aScrPos, Size( nSizeXPix + 3, nSizeYPix + 3 ) );
/*N*/ 
/*N*/ 				Invert(Rectangle( aRect.Left(), aRect.Top(), aRect.Left()+2, aRect.Bottom() ));
/*N*/ 				Invert(Rectangle( aRect.Right()-2, aRect.Top(), aRect.Right(), aRect.Bottom() ));
/*N*/ 				Invert(Rectangle( aRect.Left()+3, aRect.Top(), aRect.Right()-3, aRect.Top()+2 ));
/*N*/ 				Invert(Rectangle( aRect.Left()+3, aRect.Bottom()-2, aRect.Right()-3, aRect.Bottom() ));
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*?*/ 				Rectangle aRect( aScrPos, Size( nSizeXPix - 1, nSizeYPix - 1 ) );
/*?*/ 				Invert( aRect );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SetMapMode(aOld);
/*N*/ 	}
/*N*/ }

	//	AutoFill-Anfasser:

/*N*/ void ScGridWindow::DrawAutoFillMark()
/*N*/ {
/*N*/ 	if ( bAutoMarkVisible && aAutoMarkPos.Tab() == pViewData->GetTabNo() )
/*N*/ 	{
/*N*/ 		USHORT nX = aAutoMarkPos.Col();
/*N*/ 		USHORT nY = aAutoMarkPos.Row();
/*N*/ 
/*N*/ 		Point aFillPos = pViewData->GetScrPos( nX, nY, eWhich, TRUE );
/*N*/ 		long nSizeXPix;
/*N*/ 		long nSizeYPix;
/*N*/ 		pViewData->GetMergeSizePixel( nX, nY, nSizeXPix, nSizeYPix );
/*N*/ 		aFillPos.X() += nSizeXPix;
/*N*/ 		aFillPos.Y() += nSizeYPix;
/*N*/ 
/*N*/ 		aFillPos.X() -= 2;
/*N*/ 		aFillPos.Y() -= 2;
/*N*/ 		Rectangle aFillRect( aFillPos, Size(6,6) );
/*N*/ 		//	Anfasser von Zeichenobjekten sind 7*7
/*N*/ 
/*N*/ 		MapMode aOld = GetMapMode(); SetMapMode(MAP_PIXEL);
/*N*/ 		Invert( aFillRect );
/*N*/ 		SetMapMode(aOld);
/*N*/ 	}
/*N*/ }

// -------------------------------------------------------------------------

//STRIP001 void ScGridWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged(rDCEvt);
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_PRINTER) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTS) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) ||
//STRIP001 		 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 		  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
//STRIP001 	{
//STRIP001 		if ( rDCEvt.GetType() == DATACHANGED_FONTS && eWhich == pViewData->GetActivePart() )
//STRIP001 			pViewData->GetDocShell()->UpdateFontList();
//STRIP001 
//STRIP001 		if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 			 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 		{
//STRIP001 			if ( eWhich == pViewData->GetActivePart() )		// only once for the view
//STRIP001 			{
//STRIP001 				ScTabView* pView = pViewData->GetView();
//STRIP001 
//STRIP001 				//	update scale in case the UI ScreenZoom has changed
//STRIP001 				ScGlobal::UpdatePPT(this);
//STRIP001 				pView->RecalcPPT();
//STRIP001 
//STRIP001 				//	RepeatResize in case scroll bar sizes have changed
//STRIP001 				pView->RepeatResize();
//STRIP001 
//STRIP001 				//	invalidate cell attribs in input handler, in case the
//STRIP001 				//	EditEngine BackgroundColor has to be changed
//STRIP001 				if ( pViewData->IsActive() )
//STRIP001 				{
//STRIP001 					ScInputHandler* pHdl = SC_MOD()->GetInputHdl();
//STRIP001 					if (pHdl)
//STRIP001 						pHdl->ForgetLastPattern();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }




}
