/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: galmisc.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:52:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_GALMISC_HXX_
#define _SVX_GALMISC_HXX_

// auto strip #include <tools/urlobj.hxx>
#include <svtools/imap.hxx>
#include <svtools/hint.hxx>
// auto strip #include <svtools/transfer.hxx>
#include "svdio.hxx"
#include "svdobj.hxx"
// auto strip #include "galobj.hxx"
#include "so3/staticbaseurl.hxx"

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XPROGRESSMONITOR_HPP
// auto strip #include <com/sun/star/awt/XProgressMonitor.hpp>
// auto strip #endif
class ResMgr;
class String;
class SvStream;
class Graphic;
class ImageMap;
class GraphicFilter;
class GraphicObject;
namespace binfilter {

// -----------
// - Defines -
// -----------

#define IV_IMAPINFO			    (UINT32('S')*0x00000001+UINT32('D')*0x00000100+UINT32('U')*0x00010000+UINT32('D')*0x01000000)
#define	ID_IMAPINFO			    2
                                
#define USERDATA_HDL()		    (LINK(this,SgaUserDataFactory,MakeUserData))
                                
#define GAL_RESID( nId )	    ResId( nId, GetGalleryResMgr() )
#define STREAMBUF_SIZE		    16384L
                                
#define	SGA_IMPORT_NONE		    0x0000
#define	SGA_IMPORT_FILE		    0x0001
#define	SGA_IMPORT_INET		    0x0002

#define GALLERY_PROGRESS_RANGE  10000

#define GALLERY_FG_COLOR        Application::GetSettings().GetStyleSettings().GetWindowTextColor()
#define GALLERY_BG_COLOR        Application::GetSettings().GetStyleSettings().GetWindowColor()
#define GALLERY_DLG_COLOR       Application::GetSettings().GetStyleSettings().GetDialogColor()

// -------------
// - Functions -
// -------------

class FmFormModel;
class Gallery;

//STRIP001 ResMgr*			GetGalleryResMgr();
//STRIP001 USHORT			GalleryGraphicImport( const INetURLObject& rURL, Graphic& rGraphic, String& rFilterName, BOOL bShowProgress = FALSE );
//STRIP001 BOOL			GallerySvDrawImport( SvStream& rIStm, FmFormModel& rModel );
//STRIP001 BOOL			GalleryIsSoundFile( const INetURLObject& rURL );
//STRIP001 BOOL			CreateIMapGraphic( const FmFormModel& rModel, Graphic& rGraphic, ImageMap& rImageMap );
//STRIP001 String			GetReducedString( const INetURLObject& rURL, ULONG nMaxLen );
//STRIP001 String			GetSvDrawStreamNameFromURL( const INetURLObject& rSvDrawObjURL );

//STRIP001 BOOL			FileExists( const INetURLObject& rURL );
//STRIP001 BOOL			CreateDir(  const INetURLObject& rURL );
//STRIP001 BOOL			CopyFile(  const INetURLObject& rSrcURL, const INetURLObject& rDstURL );
//STRIP001 BOOL			KillFile( const INetURLObject& rURL );

// ---------------
// - SgaIMapInfo -
// ---------------

class SgaIMapInfo : public SdrObjUserData, public SfxListener
{
	ImageMap				aImageMap;

public:
							SgaIMapInfo() : SdrObjUserData( IV_IMAPINFO, ID_IMAPINFO, 0 ) {};

							SgaIMapInfo( const ImageMap& rImageMap) :
								SdrObjUserData( IV_IMAPINFO, ID_IMAPINFO, 0 ),
								aImageMap( rImageMap ) {};

	virtual 				~SgaIMapInfo() {};

	virtual SdrObjUserData* Clone( SdrObject* pObj ) const
							{
								SgaIMapInfo* pInfo = new SgaIMapInfo;
								pInfo->aImageMap = aImageMap;
								return pInfo;
							}

	virtual void			ReadData( SvStream& rIStm )
							{
								SdrObjUserData::ReadData( rIStm );
								SdrDownCompat	aIO( rIStm, STREAM_READ, TRUE );
								UINT16			nVer;
								rIStm >> nVer;
								aImageMap.Read(
                                    rIStm,
                                    so3::StaticBaseUrl::GetBaseURL(
                                        INetURLObject::NO_DECODE));
							}

	virtual void			WriteData( SvStream& rOStm )
							{
								SdrObjUserData::WriteData( rOStm );
								SdrDownCompat	aIO( rOStm, STREAM_WRITE, TRUE );
								const UINT16	nVer = 1;
								rOStm << nVer;
								aImageMap.Write(
                                    rOStm,
                                    so3::StaticBaseUrl::GetBaseURL(
                                        INetURLObject::NO_DECODE));
							}

	const ImageMap&			GetImageMap() const { return aImageMap; }
};

// ----------------------
// - SgaUserDataFactory -
// ----------------------

//STRIP001 class SgaUserDataFactory
//STRIP001 {
//STRIP001 public:
//STRIP001 		SgaUserDataFactory() { SdrObjFactory::InsertMakeUserDataHdl( USERDATA_HDL() ); }
//STRIP001 		~SgaUserDataFactory() { SdrObjFactory::RemoveMakeUserDataHdl( USERDATA_HDL() ); }
//STRIP001 
//STRIP001 		DECL_LINK( MakeUserData, SdrObjFactory* );
//STRIP001 };

// -------------------
// - GalleryProgress -
// -------------------


//STRIP001 class GalleryProgress
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XProgressBar >	mxProgressBar;
//STRIP001 	GraphicFilter*															mpFilter;
//STRIP001 
//STRIP001 									DECL_LINK( Update, GraphicFilter * );
//STRIP001 
//STRIP001 	public:
//STRIP001 							
//STRIP001 									GalleryProgress( GraphicFilter* pFilter = NULL );
//STRIP001 									~GalleryProgress();
//STRIP001 
//STRIP001 	void							Update( ULONG nVal, ULONG nMaxVal );
//STRIP001 };

// -----------------------
// - GalleryTransferable -
// -----------------------

class Gallery;
class GalleryTheme;

//STRIP001 class GalleryTransferable : public TransferableHelper
//STRIP001 {
//STRIP001 friend class GalleryTheme;
//STRIP001 
//STRIP001 private:
//STRIP001 
//STRIP001 	GalleryTheme*					mpTheme;
//STRIP001 	SgaObjKind						meObjectKind;
//STRIP001 	sal_uInt32						mnObjectPos;
//STRIP001     SotStorageStreamRef             mxModelStream;
//STRIP001 	GraphicObject*					mpGraphicObject;
//STRIP001 	ImageMap*						mpImageMap;
//STRIP001 	INetURLObject*					mpURL;
//STRIP001 	sal_Bool						mbInitialized;
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 									GalleryTransferable( GalleryTheme* pTheme, ULONG nObjectPos );
//STRIP001 									~GalleryTransferable();
//STRIP001 
//STRIP001 	void							InitData();
//STRIP001 
//STRIP001 	// TransferableHelper
//STRIP001 	virtual void					AddSupportedFormats();
//STRIP001 	virtual sal_Bool				GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor );
//STRIP001 	virtual sal_Bool				WriteObject( SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId, const ::com::sun::star::datatransfer::DataFlavor& rFlavor );
//STRIP001 	virtual void					DragFinished( sal_Int8 nDropAction );
//STRIP001 	virtual void					ObjectReleased();
//STRIP001 
//STRIP001 	void							CopyToClipboard( Window* pWindow );
//STRIP001 	void							StartDrag( Window* pWindow, sal_Int8 nDragSourceActions,
//STRIP001 											   sal_Int32 nDragPointer = DND_POINTER_NONE,
//STRIP001 											   sal_Int32 nDragImage = DND_IMAGE_NONE );
//STRIP001 };

// ---------------
// - GalleryHint -
// ---------------

#define GALLERY_HINT_NONE				0x00000000
#define GALLERY_HINT_CLOSE_THEME		0x00000001
#define GALLERY_HINT_THEME_REMOVED		0x00000002
#define GALLERY_HINT_THEME_RENAMED		0x00000004
#define GALLERY_HINT_THEME_CREATED		0x00000008
#define GALLERY_HINT_THEME_UPDATEVIEW	0x00000010

// -----------------------------------------------------------------------------

class GalleryHint : public SfxHint
{
private:

	ULONG			mnType;
	String			maThemeName;
	String			maStringData;
	ULONG			mnData1;
	ULONG			mnData2;

public:
		
					GalleryHint( ULONG nType, const String& rThemeName, ULONG nData1 = 0UL, ULONG nData2 = 0UL ) :
						mnType( nType ), maThemeName( rThemeName ), mnData1( nData1 ), mnData2( nData2 ) {}
					
					GalleryHint( ULONG nType, const String& rThemeName, const String& rStringData, ULONG nData1 = 0UL, ULONG nData2 = 0UL ) :
						mnType( nType ), maThemeName( rThemeName ), maStringData( rStringData ), mnData1( nData1 ), mnData2( nData2 ) {}

	ULONG			GetType() const { return mnType; }
	const String&	GetThemeName() const { return maThemeName; }
	const String&	GetStringData() const { return maStringData; }
	ULONG			GetData1() const { return mnData1; }
	ULONG			GetData2() const { return mnData2; }
};
}//end of namespace binfilter
#endif
