/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_verttexttbxctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:19:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #include "dialmgr.hxx"
#include "dialogs.hrc"

#ifndef _SVX_VERT_TEXT_TBXCTRL_HXX
#include <verttexttbxctrl.hxx>
#endif
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
namespace binfilter {

/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SvxCTLTextTbxCtrl, SfxBoolItem);
/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SvxVertTextTbxCtrl, SfxBoolItem);
/* -----------------------------27.04.01 15:50--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ SvxVertCTLTextTbxCtrl::SvxVertCTLTextTbxCtrl( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings ) :
/*N*/     SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/     bCheckVertical(sal_True)
/*N*/ {
/*N*/ }
/* -----------------------------27.04.01 15:53--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ SvxVertCTLTextTbxCtrl::~SvxVertCTLTextTbxCtrl( )
/*N*/ {
/*N*/ }
/* -----------------------------27.04.01 15:50--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void SvxVertCTLTextTbxCtrl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 								  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	SvtLanguageOptions aLangOptions;
/*N*/     BOOL bCalc = sal_False;
/*N*/     BOOL bVisible = GetToolBox().IsItemVisible(GetId());
/*N*/ 	sal_Bool bEnabled = sal_False;
/*N*/ 	if ( nSID == SID_VERTICALTEXT_STATE )
/*N*/ 		bEnabled = aLangOptions.IsVerticalTextEnabled();
/*N*/ 	else if ( nSID == SID_CTLFONT_STATE )
/*N*/ 		bEnabled = aLangOptions.IsCTLFontEnabled();
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SfxToolBoxControl::StateChanged(nSID, eState, pState);
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/     if(bEnabled)
/*N*/     {
/*?*/         if(!bVisible)
/*?*/         {
/*?*/             GetToolBox().ShowItem( GetId(), TRUE );
/*?*/             bCalc = sal_True;
/*N*/         }
/*N*/     }
/*N*/     else if(bVisible)
/*N*/     {
/*?*/         GetToolBox().HideItem( GetId() );
/*?*/         bCalc = sal_True;
/*N*/     }
/*N*/     if(bCalc)
/*N*/     {
/*?*/         ToolBox& rTbx = GetToolBox();
/*?*/ 		Window* pParent = rTbx.GetParent();
/*?*/ 		WindowType nWinType = pParent->GetType();
/*?*/         if(WINDOW_FLOATINGWINDOW == nWinType)
/*?*/ 		{
/*?*/ 			Size aSize(rTbx.CalcWindowSizePixel());
/*?*/ 			rTbx.SetPosSizePixel( Point(), aSize );
/*?*/             pParent->SetOutputSizePixel( aSize );
/*?*/ 		}
/*N*/     }
/*N*/ }
/* -----------------------------27.04.01 15:50--------------------------------

 ---------------------------------------------------------------------------*/

}
