/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_xtabgrdt.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:43:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef SVX_LIGHT

// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_ 
// auto strip #include <com/sun/star/container/XNameContainer.hpp>
// auto strip #endif
#ifndef _SVX_XPROPERTYTABLE_HXX
#include "XPropertyTable.hxx"
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX 
#include <unotools/ucbstreamhelper.hxx>
#endif

// auto strip #include "xmlxtexp.hxx"
#include "xmlxtimp.hxx"

#endif

#include <tools/urlobj.hxx>
#include <vcl/virdev.hxx>
#include <svtools/itemset.hxx>
#include <bf_sfx2/docfile.hxx>
#include "dialogs.hrc"
#include "dialmgr.hxx"
#include "xtable.hxx"
#include "xiocomp.hxx"
#include "xpool.hxx"
#include "xoutx.hxx"

#ifndef SVX_XFILLIT0_HXX //autogen
#include <xfillit0.hxx>
#endif

#ifndef _SVX_XFLGRIT_HXX //autogen
#include <xflgrit.hxx>
#endif
namespace binfilter {

#define GLOBALOVERFLOW

using namespace ::com::sun::star;
using namespace rtl;

sal_Unicode const pszExtGradient[]	= {'s','o','g'};

char const aChckGradient[]  = { 0x04, 0x00, 'S','O','G','L'};	// < 5.2
char const aChckGradient0[] = { 0x04, 0x00, 'S','O','G','0'};	// = 5.2
char const aChckXML[]       = { '<', '?', 'x', 'm', 'l' };		// = 6.0

// ---------------------
// class XGradientTable
// ---------------------

/*************************************************************************
|*
|* XGradientTable::XGradientTable()
|*
*************************************************************************/

/*N*/ XGradientTable::XGradientTable( const String& rPath,
/*N*/ 							XOutdevItemPool* pInPool,
/*N*/ 							USHORT nInitSize, USHORT nReSize ) :
/*N*/ 				XPropertyTable( rPath, pInPool, nInitSize, nReSize)
/*N*/ {
/*N*/ 	pBmpTable = new Table( nInitSize, nReSize );
/*N*/ }

/************************************************************************/

/*N*/ XGradientTable::~XGradientTable()
/*N*/ {
/*N*/ }

/************************************************************************/

/*N*/ XGradientEntry* XGradientTable::Replace(long nIndex, XGradientEntry* pEntry )
/*N*/ {
/*N*/ 	return (XGradientEntry*) XPropertyTable::Replace(nIndex, pEntry);
/*N*/ }

/************************************************************************/

/*N*/ XGradientEntry* XGradientTable::Remove(long nIndex)
/*N*/ {
/*N*/ 	return (XGradientEntry*) XPropertyTable::Remove(nIndex, 0);
/*N*/ }

/************************************************************************/

/*N*/ XGradientEntry* XGradientTable::Get(long nIndex) const
/*N*/ {
/*N*/ 	return (XGradientEntry*) XPropertyTable::Get(nIndex, 0);
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientTable::Load()
/*N*/ {
/*N*/ 	return( FALSE );
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientTable::Save()
/*N*/ {
/*N*/ 	return( FALSE );
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientTable::Create()
/*N*/ {
/*N*/ 	return( FALSE );
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientTable::CreateBitmapsForUI()
/*N*/ {
/*N*/ 	return( FALSE );
/*N*/ }

/************************************************************************/

/*N*/ Bitmap* XGradientTable::CreateBitmapForUI( long nIndex, BOOL bDelete )
/*N*/ {
/*N*/ 	return( NULL );
/*N*/ }

/************************************************************************/

/*N*/ SvStream& XGradientTable::ImpStore( SvStream& rOut )
/*N*/ {
/*N*/ 	// Schreiben
/*N*/ 	rOut.SetStreamCharSet( gsl_getSystemTextEncoding() );
/*N*/ 
/*N*/ 	// Tabellentyp schreiben (0 = gesamte Tabelle)
/*N*/ 	rOut << (long)0;
/*N*/ 
/*N*/ 	// Anzahl der Eintraege
/*N*/ 	rOut << (long)Count();
/*N*/ 
/*N*/ 	// die Eintraege
/*N*/ 	XGradientEntry* pEntry = (XGradientEntry*)aTable.First();
/*N*/ 
/*N*/ 	for (long nIndex = 0; nIndex < Count(); nIndex++)
/*N*/ 	{
/*N*/ 		rOut << (long)aTable.GetCurKey();
/*N*/ 
/*N*/ 		// UNICODE: rOut << pEntry->GetName();
/*N*/ 		rOut.WriteByteString(pEntry->GetName());
/*N*/ 
/*N*/ 		XGradient& rGradient = pEntry->GetGradient();
/*N*/ 		rOut << (long)rGradient.GetGradientStyle();
/*N*/ 		rOut << rGradient.GetStartColor().GetRed();
/*N*/ 		rOut << rGradient.GetStartColor().GetGreen();
/*N*/ 		rOut << rGradient.GetStartColor().GetBlue();
/*N*/ 		rOut << rGradient.GetEndColor().GetRed();
/*N*/ 		rOut << rGradient.GetEndColor().GetGreen();
/*N*/ 		rOut << rGradient.GetEndColor().GetBlue();
/*N*/ 		rOut << rGradient.GetAngle();
/*N*/ 		rOut << (ULONG)rGradient.GetBorder();
/*N*/ 		rOut << (ULONG)rGradient.GetXOffset();
/*N*/ 		rOut << (ULONG)rGradient.GetYOffset();
/*N*/ 		pEntry = (XGradientEntry*)aTable.Next();
/*N*/ 	}
/*N*/ 
/*N*/ 	return rOut;
/*N*/ }

/************************************************************************/

/*N*/ SvStream& XGradientTable::ImpRead( SvStream& rIn )
/*N*/ {
/*N*/ 	// Lesen
/*N*/ 	rIn.SetStreamCharSet( RTL_TEXTENCODING_IBM_850 );
/*N*/ 
/*N*/ 	delete pBmpTable;
/*N*/ 	pBmpTable = new Table( 16, 16 );
/*N*/ 
/*N*/ 	XGradientEntry* pEntry = NULL;
/*N*/ 	long		nType;
/*N*/ 	long		nCount;
/*N*/ 	long		nIndex;
/*N*/ 	XubString		aName;
/*N*/ 
/*N*/ 	long	nStyle;
/*N*/ 	USHORT	nRed;
/*N*/ 	USHORT	nGreen;
/*N*/ 	USHORT	nBlue;
/*N*/ 	Color	aStart;
/*N*/ 	Color	aEnd;
/*N*/ 	long	nAngle;
/*N*/ 	ULONG	nBorder;
/*N*/ 	ULONG	nXOfs;
/*N*/ 	ULONG	nYOfs;
/*N*/ 
/*N*/ 	rIn >> nType;
/*N*/ 
/*N*/ 	// gesamte Tabelle?
/*N*/ 	if (nType == 0)
/*N*/ 	{
/*N*/ 		rIn >> nCount;
/*N*/ 		for (long nI = 0; nI < nCount; nI++)
/*N*/ 		{
/*N*/ 			rIn >> nIndex;
/*N*/ 
/*N*/ 			// UNICODE: rIn >> aName;
/*N*/ 			rIn.ReadByteString(aName);
/*N*/ 
/*N*/ 			rIn >> nStyle;
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 
/*N*/ 			aStart = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 
/*N*/ 			aEnd = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 
/*N*/ 			rIn >> nAngle;
/*N*/ 			rIn >> nBorder;
/*N*/ 			rIn >> nXOfs;
/*N*/ 			rIn >> nYOfs;
/*N*/ 
/*N*/ 			XGradient aGradient(aStart, aEnd, (XGradientStyle)nStyle, nAngle,
/*N*/ 								(USHORT)nXOfs, (USHORT)nYOfs, (USHORT)nBorder);
/*N*/ 			pEntry = new XGradientEntry (aGradient, aName);
/*N*/ 			Insert (nIndex, pEntry);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return( rIn );
/*N*/ }

// --------------------
// class XGradientList
// --------------------

/*************************************************************************
|*
|* XGradientList::XGradientList()
|*
*************************************************************************/

/*N*/ XGradientList::XGradientList( const String& rPath,
/*N*/ 							XOutdevItemPool* pInPool,
/*N*/ 							USHORT nInitSize, USHORT nReSize ) :
/*N*/ 				XPropertyList	( rPath, pInPool, nInitSize, nReSize),
/*N*/ 				pVD				( NULL ),
/*N*/ 				pXOut			( NULL ),
/*N*/ 				pXFSet			( NULL )
/*N*/ {
/*N*/ 	pBmpList = new List( nInitSize, nReSize );
/*N*/ }

/************************************************************************/

/*N*/ XGradientList::~XGradientList()
/*N*/ {
/*N*/ 	if( pVD )    delete pVD;
/*N*/ 	if( pXOut )  delete pXOut;
/*N*/ 	if( pXFSet ) delete pXFSet;
/*N*/ }

/************************************************************************/

/*N*/ XGradientEntry* XGradientList::Replace(XGradientEntry* pEntry, long nIndex )
/*N*/ {
/*N*/ 	return( (XGradientEntry*) XPropertyList::Replace( pEntry, nIndex ) );
/*N*/ }

/************************************************************************/

/*N*/ XGradientEntry* XGradientList::Remove(long nIndex)
/*N*/ {
/*N*/ 	return( (XGradientEntry*) XPropertyList::Remove( nIndex, 0 ) );
/*N*/ }

/************************************************************************/

/*N*/ XGradientEntry* XGradientList::Get(long nIndex) const
/*N*/ {
/*N*/ 	return( (XGradientEntry*) XPropertyList::Get( nIndex, 0 ) );
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientList::Load()
/*N*/ {
/*N*/ #ifndef SVX_LIGHT
/*N*/ 	if( bListDirty )
/*N*/ 	{
/*N*/ 		bListDirty = FALSE;
/*N*/ 
/*N*/ 		INetURLObject aURL( aPath );
/*N*/ 
/*N*/ 		if( INET_PROT_NOT_VALID == aURL.GetProtocol() )
/*N*/ 		{
/*N*/ 			DBG_ASSERT( !aPath.Len(), "invalid URL" );
/*N*/ 			return FALSE;
/*N*/ 		}
/*N*/ 
/*N*/ 		aURL.Append( aName );
/*N*/ 
/*N*/ 		if( !aURL.getExtension().getLength() )
/*N*/ 			aURL.setExtension( rtl::OUString( pszExtGradient, 3 ) );
/*N*/ 
/*N*/ 		// check if file exists, SfxMedium shows an errorbox else
/*N*/ 		{
/*N*/ 			::com::sun::star::uno::Reference < ::com::sun::star::task::XInteractionHandler > xHandler;
/*N*/ 			SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ, xHandler );
/*N*/ 
/*N*/ 			sal_Bool bOk = pIStm && ( pIStm->GetError() == 0);
/*N*/ 
/*N*/ 			if( pIStm )
/*N*/ 				delete pIStm;
/*N*/ 
/*N*/ 			if( !bOk )
/*N*/ 				return sal_False;
/*N*/ 		}
/*N*/ 
/*N*/ 		{
/*N*/ 			SfxMedium aMedium( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ | STREAM_NOCREATE, TRUE );
/*N*/ 			SvStream* pStream = aMedium.GetInStream();
/*N*/ 			if( !pStream )
/*N*/ 				return( FALSE );
/*N*/ 
/*N*/ 			char aCheck[6];
/*N*/ 			pStream->Read( aCheck, 6 );
/*N*/ 
/*N*/ 			// Handelt es sich um die gew"unschte Tabelle?
/*N*/ 			if( memcmp( aCheck, aChckGradient, sizeof( aChckGradient ) ) == 0 ||
/*N*/ 				memcmp( aCheck, aChckGradient0, sizeof( aChckGradient0 ) ) == 0 )
/*N*/ 			{
/*N*/ 				ImpRead( *pStream );
/*N*/ 				return( pStream->GetError() == SVSTREAM_OK );
/*N*/ 			}
/*N*/ 			else if( memcmp( aCheck, aChckXML, sizeof( aChckXML ) ) != 0 )
/*N*/ 			{
/*N*/ 				return FALSE;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		uno::Reference< container::XNameContainer > xTable( SvxUnoXGradientTable_createInstance( this ), uno::UNO_QUERY );
/*N*/ 		return SvxXMLXTableImport::load( aURL.GetMainURL( INetURLObject::NO_DECODE ), xTable );
/*N*/ 
/*N*/ 	}
/*N*/ #endif
/*N*/ 	return( FALSE );
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientList::Save()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return false;
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 	INetURLObject aURL( aPath );
//STRIP001 
//STRIP001 	if( INET_PROT_NOT_VALID == aURL.GetProtocol() )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( !aPath.Len(), "invalid URL" );
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	aURL.Append( aName );
//STRIP001 
//STRIP001 	if( !aURL.getExtension().Len() )
//STRIP001 		aURL.setExtension( String( pszExtGradient, 3 ) );
//STRIP001 
//STRIP001 	uno::Reference< container::XNameContainer > xTable( SvxUnoXGradientTable_createInstance( this ), uno::UNO_QUERY );
//STRIP001 	return SvxXMLXTableExportComponent::save( aURL.GetMainURL( INetURLObject::NO_DECODE ), xTable );

/*
	SfxMedium aMedium( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_TRUNC, TRUE );
	aMedium.IsRemote();

	SvStream* pStream = aMedium.GetOutStream();
	if( !pStream )
		return( FALSE );

	// UNICODE: *pStream << String( pszChckGradient0, 4 );
	pStream->WriteByteString(String( pszChckGradient0, 4 ));

	ImpStore( *pStream );

	aMedium.Close();
	aMedium.Commit();

	return( aMedium.GetError() == 0 );
*/
//STRIP001 #else
//STRIP001 	return FALSE;
//STRIP001 #endif
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientList::Create()
/*N*/ {
/*N*/ 	XubString aStr( SVX_RES( RID_SVXSTR_GRADIENT ) );
/*N*/ 	xub_StrLen nLen;
/*N*/ 
/*N*/ 	aStr.AppendAscii(" 1");
/*N*/ 	nLen = aStr.Len() - 1;
/*N*/ 	Insert(new XGradientEntry(XGradient(RGB_Color(COL_BLACK  ),RGB_Color(COL_WHITE	),XGRAD_LINEAR	  ,    0,10,10, 0,100,100),aStr));
/*N*/ 	aStr.SetChar(nLen, sal_Unicode('2'));
/*N*/ 	Insert(new XGradientEntry(XGradient(RGB_Color(COL_BLUE	 ),RGB_Color(COL_RED	),XGRAD_AXIAL	  ,  300,20,20,10,100,100),aStr));
/*N*/ 	aStr.SetChar(nLen, sal_Unicode('3'));
/*N*/ 	Insert(new XGradientEntry(XGradient(RGB_Color(COL_RED	 ),RGB_Color(COL_YELLOW ),XGRAD_RADIAL	  ,  600,30,30,20,100,100),aStr));
/*N*/ 	aStr.SetChar(nLen, sal_Unicode('4'));
/*N*/ 	Insert(new XGradientEntry(XGradient(RGB_Color(COL_YELLOW ),RGB_Color(COL_GREEN	),XGRAD_ELLIPTICAL,  900,40,40,30,100,100),aStr));
/*N*/ 	aStr.SetChar(nLen, sal_Unicode('5'));
/*N*/ 	Insert(new XGradientEntry(XGradient(RGB_Color(COL_GREEN  ),RGB_Color(COL_MAGENTA),XGRAD_SQUARE	  , 1200,50,50,40,100,100),aStr));
/*N*/ 	aStr.SetChar(nLen, sal_Unicode('6'));
/*N*/ 	Insert(new XGradientEntry(XGradient(RGB_Color(COL_MAGENTA),RGB_Color(COL_YELLOW ),XGRAD_RECT	  , 1900,60,60,50,100,100),aStr));
/*N*/ 
/*N*/ 	return( TRUE );
/*N*/ }

/************************************************************************/

/*N*/ BOOL XGradientList::CreateBitmapsForUI()
/*N*/ {
/*N*/ 	for( long i = 0; i < Count(); i++)
/*N*/ 	{
/*N*/ 		Bitmap* pBmp = CreateBitmapForUI( i, FALSE );
/*N*/ 		DBG_ASSERT( pBmp, "XGradientList: Bitmap(UI) konnte nicht erzeugt werden!" );
/*N*/ 
/*N*/ 		if( pBmp )
/*N*/ 			pBmpList->Insert( pBmp, i );
/*N*/ 	}
/*N*/ 	// Loeschen, da JOE den Pool vorm Dtor entfernt!
/*N*/ 	if( pVD )	{ delete pVD;	pVD = NULL;     }
/*N*/ 	if( pXOut ) { delete pXOut;	pXOut = NULL;   }
/*N*/ 	if( pXFSet ){ delete pXFSet; pXFSet = NULL; }
/*N*/ 
/*N*/ 	return( FALSE );
/*N*/ }

/************************************************************************/

/*N*/ Bitmap* XGradientList::CreateBitmapForUI( long nIndex, BOOL bDelete )
/*N*/ {
/*N*/ 	if( !pVD ) // und pXOut und pXFSet
/*N*/ 	{
/*N*/ 		pVD = new VirtualDevice;
/*N*/ 		DBG_ASSERT( pVD, "XGradientList: Konnte kein VirtualDevice erzeugen!" );
/*N*/ 		pVD->SetOutputSizePixel( Size( BITMAP_WIDTH, BITMAP_HEIGHT ) );
/*N*/ 
/*N*/ 		pXOut = new XOutputDevice( pVD );
/*N*/ 		DBG_ASSERT( pVD, "XGradientList: Konnte kein XOutDevice erzeugen!" );
/*N*/ 
/*N*/ 		pXFSet = new XFillAttrSetItem( pXPool );
/*N*/ 		DBG_ASSERT( pVD, "XGradientList: Konnte kein XFillAttrSetItem erzeugen!" );
/*N*/ 		pXFSet->GetItemSet().Put( XFillStyleItem( XFILL_GRADIENT ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	pXFSet->GetItemSet().Put(
/*N*/ 		XFillGradientItem( pXPool, Get( nIndex )->GetGradient() ) );
/*N*/ //-/	pXOut->SetFillAttr( *pXFSet );
/*N*/ 	pXOut->SetFillAttr( pXFSet->GetItemSet() );
/*N*/ 
/*N*/ 	// #73550#
/*N*/ 	pXOut->OverrideLineColor( Color( COL_BLACK ) );
/*N*/ 
/*N*/ 	Size aVDSize = pVD->GetOutputSizePixel();
/*N*/ 	pXOut->DrawRect( Rectangle( Point(), aVDSize ) );
/*N*/ 	Bitmap* pBitmap = new Bitmap( pVD->GetBitmap( Point(), aVDSize ) );
/*N*/ 
/*N*/ 	// Loeschen, da JOE den Pool vorm Dtor entfernt!
/*N*/ 	if( bDelete )
/*N*/ 	{
/*N*/ 		if( pVD )	{ delete pVD;	pVD = NULL;     }
/*N*/ 		if( pXOut ) { delete pXOut;	pXOut = NULL;   }
/*N*/ 		if( pXFSet ){ delete pXFSet; pXFSet = NULL; }
/*N*/ 	}
/*N*/ 	return( pBitmap );
/*N*/ }

/************************************************************************/

/*N*/ SvStream& XGradientList::ImpStore( SvStream& rOut )
/*N*/ {
/*N*/ 	// Schreiben
/*N*/ 	rOut.SetStreamCharSet( gsl_getSystemTextEncoding() );
/*N*/ 
/*N*/ 	XGradientEntry* pEntry = NULL;
/*N*/ 
/*N*/ 	// Kennung
/*N*/ 	rOut << (long) -2;
/*N*/ 
/*N*/ 	// Anzahl der Eintraege
/*N*/ 	rOut << (long)Count();
/*N*/ 
/*N*/ 	for (long nIndex = 0; nIndex < Count(); nIndex++)
/*N*/ 	{
/*N*/ 		// Versionsverwaltung: Version 0
/*N*/ 		XIOCompat aIOC( rOut, STREAM_WRITE, 0 );
/*N*/ 
/*N*/ 		pEntry = Get(nIndex);
/*N*/ 
/*N*/ 		// UNICODE: rOut << pEntry->GetName();
/*N*/ 		rOut.WriteByteString(pEntry->GetName());
/*N*/ 
/*N*/ 		XGradient& rGradient = pEntry->GetGradient();
/*N*/ 		rOut << (long)rGradient.GetGradientStyle();
/*N*/ 
/*N*/ 		USHORT nCol = rGradient.GetStartColor().GetRed();
/*N*/ 		nCol = nCol << 8;
/*N*/ 		rOut << nCol;
/*N*/ 		nCol = rGradient.GetStartColor().GetGreen();
/*N*/ 		nCol = nCol << 8;
/*N*/ 		rOut << nCol;
/*N*/ 		nCol = rGradient.GetStartColor().GetBlue();
/*N*/ 		nCol = nCol << 8;
/*N*/ 		rOut << nCol;
/*N*/ 
/*N*/ 		nCol = rGradient.GetEndColor().GetRed();
/*N*/ 		nCol = nCol << 8;
/*N*/ 		rOut << nCol;
/*N*/ 		nCol = rGradient.GetEndColor().GetGreen();
/*N*/ 		nCol = nCol << 8;
/*N*/ 		rOut << nCol;
/*N*/ 		nCol = rGradient.GetEndColor().GetBlue();
/*N*/ 		nCol = nCol << 8;
/*N*/ 		rOut << nCol;
/*N*/ 		rOut << rGradient.GetAngle();
/*N*/ 		rOut << (ULONG)rGradient.GetBorder();
/*N*/ 		rOut << (ULONG)rGradient.GetXOffset();
/*N*/ 		rOut << (ULONG)rGradient.GetYOffset();
/*N*/ 		rOut << (ULONG)rGradient.GetStartIntens();
/*N*/ 		rOut << (ULONG)rGradient.GetEndIntens();
/*N*/ 	}
/*N*/ 
/*N*/ 	return rOut;
/*N*/ }

/************************************************************************/

/*N*/ XubString& XGradientList::ConvertName( XubString& rStrName )
/*N*/ {
/*N*/ 	BOOL bFound = FALSE;
/*N*/ 
/*N*/ 	for( USHORT i=0; i<(RID_SVXSTR_GRDT_DEF_END-RID_SVXSTR_GRDT_DEF_START+1) && !bFound; i++ )
/*N*/ 	{
/*N*/ 		XubString aStrDefName =	SVX_RESSTR( RID_SVXSTR_GRDT_DEF_START + i );
/*N*/ 		if( rStrName.Search( aStrDefName ) == 0 )
/*N*/ 		{
/*N*/ 			rStrName.Replace( 0, aStrDefName.Len(),	SVX_RESSTR( RID_SVXSTR_GRDT_START + i ) );
/*N*/ 			bFound = TRUE;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return rStrName;
/*N*/ }

/************************************************************************/

/*N*/ SvStream& XGradientList::ImpRead( SvStream& rIn )
/*N*/ {
/*N*/ 	// Lesen
/*N*/ 	rIn.SetStreamCharSet( RTL_TEXTENCODING_IBM_850 );
/*N*/ 
/*N*/ 	delete pBmpList;
/*N*/ 	pBmpList = new List( 16, 16 );
/*N*/ 
/*N*/ 	XGradientEntry* pEntry = NULL;
/*N*/ 	long		nCheck;
/*N*/ 	long		nCount;
/*N*/ 	XubString		aName;
/*N*/ 
/*N*/ 	long	nStyle;
/*N*/ 	USHORT	nRed;
/*N*/ 	USHORT	nGreen;
/*N*/ 	USHORT	nBlue;
/*N*/ 	Color	aStart;
/*N*/ 	Color	aEnd;
/*N*/ 	long	nAngle;
/*N*/ 	ULONG	nBorder;
/*N*/ 	ULONG	nXOfs;
/*N*/ 	ULONG	nYOfs;
/*N*/ 	ULONG	nStartIntens;
/*N*/ 	ULONG	nEndIntens;
/*N*/ 
/*N*/ 	// Kennung oder Anzahl
/*N*/ 	rIn >> nCheck;
/*N*/ 
/*N*/ 	if( nCheck >= 0 )
/*N*/ 	{
/*N*/ 		nCount = nCheck;
/*N*/ 
/*N*/ 		for (long nIndex = 0; nIndex < nCount; nIndex++)
/*N*/ 		{
/*N*/ 			// UNICODE: rIn >> aName;
/*N*/ 			rIn.ReadByteString(aName);
/*N*/ 
/*N*/ 			aName = ConvertName( aName );
/*N*/ 			rIn >> nStyle;
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 			aStart = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 			aEnd = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 
/*N*/ 			rIn >> nAngle;
/*N*/ 			rIn >> nBorder;
/*N*/ 			rIn >> nXOfs;
/*N*/ 			rIn >> nYOfs;
/*N*/ 
/*N*/ 			nStartIntens = 100L;
/*N*/ 			nEndIntens = 100L;
/*N*/ 
/*N*/ 			XGradient aGradient( aStart, aEnd, (XGradientStyle)nStyle, nAngle,
/*N*/ 								 (USHORT) nXOfs, (USHORT) nYOfs, (USHORT) nBorder,
/*N*/ 								 (USHORT) nStartIntens, (USHORT) nEndIntens );
/*N*/ 			pEntry = new XGradientEntry (aGradient, aName);
/*N*/ 			Insert (pEntry, nIndex);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if( nCheck == -1L )
/*N*/ 	{
/*N*/ 		rIn >> nCount;
/*N*/ 		for (long nIndex = 0; nIndex < nCount; nIndex++)
/*N*/ 		{
/*N*/ 			// UNICODE: rIn >> aName;
/*N*/ 			rIn.ReadByteString(aName);
/*N*/ 
/*N*/ 			aName = ConvertName( aName );
/*N*/ 			rIn >> nStyle;
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 			aStart = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 			aEnd = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 
/*N*/ 			rIn >> nAngle;
/*N*/ 			rIn >> nBorder;
/*N*/ 			rIn >> nXOfs;
/*N*/ 			rIn >> nYOfs;
/*N*/ 
/*N*/ 			rIn >> nStartIntens;
/*N*/ 			rIn >> nEndIntens;
/*N*/ 
/*N*/ 			XGradient aGradient( aStart, aEnd, (XGradientStyle)nStyle, nAngle,
/*N*/ 								 (USHORT) nXOfs, (USHORT) nYOfs, (USHORT) nBorder,
/*N*/ 								 (USHORT) nStartIntens, (USHORT) nEndIntens );
/*N*/ 			pEntry = new XGradientEntry (aGradient, aName);
/*N*/ 			Insert (pEntry, nIndex);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else // ab 3.00a
/*N*/ 	{
/*N*/ 		rIn >> nCount;
/*N*/ 		for (long nIndex = 0; nIndex < nCount; nIndex++)
/*N*/ 		{
/*N*/ 			// Versionsverwaltung
/*N*/ 			XIOCompat aIOC( rIn, STREAM_READ );
/*N*/ 
/*N*/ 			// UNICODE: rIn >> aName;
/*N*/ 			rIn.ReadByteString(aName);
/*N*/ 
/*N*/ 			aName = ConvertName( aName );
/*N*/ 			rIn >> nStyle;
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 			aStart = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 			rIn >> nRed;
/*N*/ 			rIn >> nGreen;
/*N*/ 			rIn >> nBlue;
/*N*/ 			aEnd = Color( (BYTE) ( nRed   >> 8 ),
/*N*/ 							(BYTE) ( nGreen >> 8 ),
/*N*/ 							(BYTE) ( nBlue  >> 8 ) );
/*N*/ 
/*N*/ 			rIn >> nAngle;
/*N*/ 			rIn >> nBorder;
/*N*/ 			rIn >> nXOfs;
/*N*/ 			rIn >> nYOfs;
/*N*/ 
/*N*/ 			rIn >> nStartIntens;
/*N*/ 			rIn >> nEndIntens;
/*N*/ 
/*N*/ 			if (aIOC.GetVersion() > 0)
/*N*/ 			{
/*N*/ 				// lesen neuer Daten ...
/*N*/ 			}
/*N*/ 
/*N*/ 			XGradient aGradient( aStart, aEnd, (XGradientStyle)nStyle, nAngle,
/*N*/ 								 (USHORT) nXOfs, (USHORT) nYOfs, (USHORT) nBorder,
/*N*/ 								 (USHORT) nStartIntens, (USHORT) nEndIntens );
/*N*/ 			pEntry = new XGradientEntry (aGradient, aName);
/*N*/ 			Insert (pEntry, nIndex);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return( rIn );
/*N*/ }


}
