/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dbobj.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:46:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_DBOBJ_HXX
#define _SBA_DBOBJ_HXX


#ifndef _SBA_DBOBJENU_HXX
#include "dbobjenu.hxx"
#endif

#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif

#ifndef _RTTI_HXX //autogen
#include <tools/rtti.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#ifndef _LANG_HXX
#include <tools/lang.hxx>
#endif

#ifndef _SDB_SDBOBJ_HXX
#include <sdb/sdbobj.hxx>
#endif
namespace binfilter {

//==================================================================
// Forward
//==================================================================
class SbaDatabase;

//==================================================================
// SbaDBObj
//==================================================================
class SbaDBObj : public SdbObj
{
protected:
	String					aName;				// Name des Dataobjects
	BOOL					bShowError;			// Anzeigen von Fehlermeldungen

public:
	TYPEINFO();
	virtual SbaDatabase* GetDatabase() const = 0;

	// Standardfunkionalitaet
	virtual String ToURL() const;
	const String& Name() const {return aName;}

protected:
	SbaDBObj(SdbObj* pDB,
			 const String& rName,
			 BOOL bPersist,
			 BOOL bShowErr = TRUE);

public:	 // Zusatzfunktionen
	void ShowError(DBErrorContext eContext);
	void BeginDBAction();
	void EndDBAction();
	void CancelDBAction();

	// this is only temporary : we have hundreds of places where we want to compare two identifiers ignoring
	// their case, but unfortunally the UniString class doesn't allow that.
	// So for the moment all these places use the folowing function to control the use cases.
	// But we need a mechanism to decide which Locale (LanguageType) should be used for comparing, this
	// LANGUAGE_SYSTEM used here is wrong ....
	static sal_Bool EqualNamesInsensitive(const String& rLHS, const String& rRHS, LanguageType eLanguage = LANGUAGE_SYSTEM);
};

SV_DECL_IMPL_REF(SbaDBObj);

#if _SOLAR__PRIVATE
	#define SBA_CHK_OPEN()						\
			aStatus.Clear();					\
			if (!IsOpen())						\
			{									\
				aStatus.SetConnectionLost();	\
				return;							\
			}

	#define SBA_CHK_OPEN_BOOL()					\
			aStatus.Clear();					\
			if (!IsOpen())						\
			{									\
				aStatus.SetConnectionLost();	\
				return FALSE;					\
			}

	#define SBA_CHK_OPEN_NULL()					\
			aStatus.Clear();					\
			if (!IsOpen())						\
			{									\
				aStatus.SetConnectionLost();	\
				return NULL;					\
			}

	#define SBA_CHK_OPEN_STRING()				\
			aStatus.Clear();					\
			if (!IsOpen())						\
			{									\
				aStatus.SetConnectionLost();	\
				return String();				\
			}
#endif

} //namespace binfilter
#endif


