/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ParseContext.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2005/09/23 12:42:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_QUERYDESIGNCONTEXT_HXX
#include "ParseContext.hxx"
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef _DBU_QRY_HRC_
#include "dbu_qry.hrc"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
#include <svtools/syslocale.hxx>
#endif

using namespace dbaui;
using namespace ::connectivity;
//==========================================================================
//= OSystemParseContext
//==========================================================================
DBG_NAME(OSystemParseContext);
//-----------------------------------------------------------------------------
OSystemParseContext::OSystemParseContext() : OParseContext()
{
	DBG_CTOR(OSystemParseContext,NULL);
	m_aSQLInternationals = ByteString(ModuleRes(STR_SVT_SQL_INTERNATIONAL),RTL_TEXTENCODING_ASCII_US);
}

//-----------------------------------------------------------------------------
OSystemParseContext::~OSystemParseContext()
{
	DBG_DTOR(OSystemParseContext,NULL);
}

//-----------------------------------------------------------------------------
::com::sun::star::lang::Locale OSystemParseContext::getPreferredLocale( ) const
{
	return SvtSysLocale().GetLocaleData().getLocale();
}

//-----------------------------------------------------------------------------
::rtl::OUString OSystemParseContext::getErrorMessage(ErrorCode _eCode) const
{
	String aMsg;
	switch (_eCode)
	{
		case ERROR_GENERAL:					aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_ERROR); break;
		case ERROR_GENERAL_HINT:			aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_ERROR_BEFORE); break;
		case ERROR_VALUE_NO_LIKE:			aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_VALUE_NO_LIKE); break;
		case ERROR_FIELD_NO_LIKE:			aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_FIELD_NO_LIKE); break;
		case ERROR_INVALID_COMPARE:			aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_CRIT_NO_COMPARE); break;
		case ERROR_INVALID_INT_COMPARE:		aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_INT_NO_VALID); break;
		case ERROR_INVALID_STRING_COMPARE:	aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_NO_NUM); break;
		case ERROR_INVALID_DATE_COMPARE:	aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_ACCESS_DAT_NO_VALID); break;
		case ERROR_INVALID_REAL_COMPARE:	aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_REAL_NO_VALID); break;
		case ERROR_INVALID_TABLE:			aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_TABLE); break;
		case ERROR_INVALID_COLUMN:			aMsg = ModuleRes(STR_SVT_SQL_SYNTAX_COLUMN); break;
	}
	return aMsg;
}

//-----------------------------------------------------------------------------
::rtl::OString OSystemParseContext::getIntlKeywordAscii(InternationalKeyCode _eKey) const
{
	ByteString aKeyword;
	switch (_eKey)
	{
		case KEY_LIKE:		aKeyword = m_aSQLInternationals.GetToken(0); break;
		case KEY_NOT:		aKeyword = m_aSQLInternationals.GetToken(1); break;
		case KEY_NULL:		aKeyword = m_aSQLInternationals.GetToken(2); break;
		case KEY_TRUE:		aKeyword = m_aSQLInternationals.GetToken(3); break;
		case KEY_FALSE:		aKeyword = m_aSQLInternationals.GetToken(4); break;
		case KEY_IS:		aKeyword = m_aSQLInternationals.GetToken(5); break;
		case KEY_BETWEEN:	aKeyword = m_aSQLInternationals.GetToken(6); break;
		case KEY_OR:		aKeyword = m_aSQLInternationals.GetToken(7); break;
		case KEY_AND:		aKeyword = m_aSQLInternationals.GetToken(8); break;
		case KEY_AVG:		aKeyword = m_aSQLInternationals.GetToken(9); break;
		case KEY_COUNT:		aKeyword = m_aSQLInternationals.GetToken(10); break;
		case KEY_MAX:		aKeyword = m_aSQLInternationals.GetToken(11); break;
		case KEY_MIN:		aKeyword = m_aSQLInternationals.GetToken(12); break;
		case KEY_SUM:		aKeyword = m_aSQLInternationals.GetToken(13); break;
	}
	return aKeyword;
}

//-----------------------------------------------------------------------------
static sal_Unicode lcl_getSeparatorChar( const String& _rSeparator, sal_Unicode _nFallback )
{
	DBG_ASSERT( 0 < _rSeparator.Len(), "::lcl_getSeparatorChar: invalid decimal separator!" );

	sal_Unicode nReturn( _nFallback );
	if ( _rSeparator.Len() )
		nReturn = static_cast< sal_Char >( _rSeparator.GetBuffer( )[0] );
	return nReturn;
}

//-----------------------------------------------------------------------------
sal_Unicode OSystemParseContext::getNumDecimalSep( ) const
{
	return lcl_getSeparatorChar( SvtSysLocale().GetLocaleData().getNumDecimalSep(), '.' );
}

//-----------------------------------------------------------------------------
sal_Unicode OSystemParseContext::getNumThousandSep( ) const
{
	return lcl_getSeparatorChar( SvtSysLocale().GetLocaleData().getNumThousandSep(), ',' );
}

// =============================================================================
// =============================================================================
::osl::Mutex			OParseContextClient::s_aSafety;
oslInterlockedCount		OParseContextClient::s_nCounter;
OSystemParseContext*	OParseContextClient::s_pSharedContext;
DBG_NAME(OParseContextClient)
// -----------------------------------------------------------------------------
OParseContextClient::OParseContextClient()
{
    DBG_CTOR(OParseContextClient,NULL);

	::osl::MutexGuard aGuard( s_aSafety );
	if ( 1 == osl_incrementInterlockedCount( &s_nCounter ) )
	{	// first instance
		s_pSharedContext = new OSystemParseContext;
	}
}

// -----------------------------------------------------------------------------
OParseContextClient::~OParseContextClient()
{
	{
		::osl::MutexGuard aGuard( s_aSafety );
		if ( 0 == osl_decrementInterlockedCount( &s_nCounter ) )
		{
			delete s_pSharedContext;
			s_pSharedContext = NULL;
		}
	}

    DBG_DTOR(OParseContextClient,NULL);
}




