/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TableDescWin.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2005/09/23 12:46:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_TABLEDESCRIPTIONWINDOW_HXX
#include "TableDescWin.hxx"
#endif
#ifndef _SVEDIT_HXX 
#include <svtools/svmedit.hxx>
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef _DBA_DBACCESS_HELPID_HRC_
#include "dbaccess_helpid.hrc"
#endif
#ifndef _DBU_TBL_HRC_
#include "dbu_tbl.hrc"
#endif
#ifndef DBAUI_TABLEDESIGNVIEW_HXX
#include "TableDesignView.hxx"
#endif
#ifndef _SV_FIXED_HXX 
#include <vcl/fixed.hxx>
#endif
#ifndef DBACCESS_UI_BROWSER_ID_HXX
#include "browserids.hxx"
#endif
//#ifndef DBUI_TABLECONTROLLER_HXX
//#include "TableController.hxx"
//#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif


#define DETAILS_HEADER_HEIGHT			25
#define STANDARD_MARGIN					 6

using namespace dbaui;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//==================================================================
// class OTableDescWin
//==================================================================
DBG_NAME(OTableDescWin)
//------------------------------------------------------------------------------
OTableDescWin::OTableDescWin( Window* pParent)
	:TabPage(pParent, WB_3DLOOK)
	,m_bModified(sal_False)
	,m_pHeader(NULL)
{
    DBG_CTOR(OTableDescWin,NULL);

	m_pTextWin = new MultiLineEdit( this, WB_VSCROLL | WB_LEFT | WB_BORDER );
	m_pTextWin->SetHelpId(HID_TAB_DESIGN_TABLE_DESC);
	m_pTextWin->SetModifyHdl(LINK(this, OTableDescWin, OnModified)) ;
	m_pTextWin->Show();

	m_pFTTableDesc = new FixedText(this,WB_LEFT);
	m_pFTTableDesc->SetText(String(ModuleRes(STR_TAB_TABLE_DESCRIPTION)));
	m_pFTTableDesc->Show();

	m_pHeader = new FixedText( this, WB_CENTER | WB_INFO );
	m_pHeader->SetText(String(ModuleRes(STR_TAB_TABLE_PROPERTIES)));
	m_pHeader->Show();
}

//------------------------------------------------------------------------------
OTableDescWin::~OTableDescWin()
{
	{
		::std::auto_ptr<Window> aTemp(m_pTextWin);
		m_pTextWin = NULL;
	}
	{
		::std::auto_ptr<Window> aTemp(m_pFTTableDesc);
		m_pFTTableDesc = NULL;
	}
	{
		::std::auto_ptr<Window> aTemp(m_pHeader);
		m_pHeader = NULL;
	}

    DBG_DTOR(OTableDescWin,NULL);
}

//------------------------------------------------------------------------------
String OTableDescWin::GetTableDesc() const { return m_pTextWin->GetText(); }

//------------------------------------------------------------------------------
void OTableDescWin::SetReadOnly( sal_Bool bRead )
{
	m_pTextWin->Enable(!bRead);
}

//------------------------------------------------------------------------------
void OTableDescWin::Init()
{
	OTableDesignView* pView = static_cast<OTableDesignView*>(GetParent());
	OSL_ENSURE(pView,"No view available!");
	Reference< XPropertySet> xTable = pView->getController()->getTable();
	if(xTable.is() && xTable->getPropertySetInfo()->hasPropertyByName(PROPERTY_DESCRIPTION))
	{
		::rtl::OUString sDescription;
		xTable->getPropertyValue(PROPERTY_DESCRIPTION) >>= sDescription;

		m_pTextWin->SetText(sDescription);
		if(pView->getController()->isReadOnly())
			SetReadOnly(sal_True);
	}
}

//------------------------------------------------------------------------------
void OTableDescWin::GetFocus()
{
	TabPage::GetFocus();
	if (m_pTextWin)
		m_pTextWin->GrabFocus();
}

//------------------------------------------------------------------------------
void OTableDescWin::Paint( const Rectangle& rRect )
{
	//////////////////////////////////////////////////////////////////////
	// 3D-Linie am oberen Fensterrand
	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();

	//////////////////////////////////////////////////////////////////////
	// 3D-Linie zum Abtrennen des Headers
	SetLineColor(rStyleSettings.GetLightColor());
	DrawLine( Point(3, DETAILS_HEADER_HEIGHT), Point(GetSizePixel().Width()-6, DETAILS_HEADER_HEIGHT) );
	SetLineColor( rStyleSettings.GetShadowColor() );
	DrawLine( Point(3, DETAILS_HEADER_HEIGHT-1), Point(GetSizePixel().Width()-6, DETAILS_HEADER_HEIGHT-1) );
}

//------------------------------------------------------------------------------
IMPL_LINK( OTableDescWin, OnModified, void*, EMPTYARG )
{
	m_bModified = sal_True;

	OTableDesignView* pView = static_cast<OTableDesignView*>(GetParent());
	OSL_ENSURE(pView,"No view available!");
	pView->getController()->setModified( sal_True );

	pView->getController()->InvalidateFeature(SID_UNDO);
	pView->getController()->InvalidateFeature(SID_REDO);
	pView->getController()->InvalidateFeature(SID_SAVEDOC);
	return 0L;
}
//------------------------------------------------------------------------------
void OTableDescWin::Resize()
{
	//////////////////////////////////////////////////////////////////////
	// Abmessungen parent window
	Size aOutputSize( GetSizePixel() );

	m_pHeader->SetPosSizePixel( Point(0, STANDARD_MARGIN), Size(aOutputSize.Width(), 15) );

	m_pFTTableDesc->SetPosSizePixel(Point(STANDARD_MARGIN+1,DETAILS_HEADER_HEIGHT+STANDARD_MARGIN+3),
									 Size(aOutputSize.Width()-(2*STANDARD_MARGIN)-2,20));
	//////////////////////////////////////////////////////////////////////
	// TextWin anpassen
	m_pTextWin->SetPosSizePixel( Point(STANDARD_MARGIN+1, DETAILS_HEADER_HEIGHT+STANDARD_MARGIN+29),
		Size(aOutputSize.Width()-(2*STANDARD_MARGIN)-2,	20) );
}



