/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FormShellManager.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:04:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FORM_SHELL_MANAGER_HXX
#define SD_FORM_SHELL_MANAGER_HXX

#include <tools/link.hxx>

class VclWindowEvent;
class FmFormShell;

namespace sd {

class PaneManagerEvent;
class ViewShell;
class ViewShellBase;

/** This simple class is responsible for putting the form shell at the top
    or the bottom of the shell stack maintained by the ObjectBarManager.

    The form shell is moved to the top of the shell stack when it is
    activated, i.e. the FormControlActivated handler is called.
    
    It is moved to the bottom of the shell stack when the main window of the
    view shell displayed in the center pane is focused.
*/
class FormShellManager
{
public:
    FormShellManager (ViewShellBase& rBase);
    ~FormShellManager (void);

private:
    ViewShellBase& mrBase;

    enum StackPosition {SP_BELOW_VIEW_SHELL, SP_ABOVE_VIEW_SHELL, SP_UNKNOWN};
    
    /** Register at window of center pane and at the form shell that
        represents the form tool bar.  The former informs this manager about
        the deselection of the form shell.  The later informs about its
        selection.
    */
    void RegisterAtCenterPane (void);

    /** Unregister the listeners that were registered in
        RegisterAtCenterPane().
    */
    void UnregisterAtCenterPane (void);

    /** Remember whether the form shell is currently at the top of the shell
        stack or below the view shell.  Until one of the event handlers is
        called the stack position is unknown.
    */
    StackPosition meStackPosition;

    /** This call back is called by the application window (among others)
        when the window gets the focus.  In this case the form shell is
        moved to the bottom of the shell stack.
    */
    DECL_LINK(WindowEventHandler, VclWindowEvent*);

    /** This call back is called when the PaneManager switches shells in a
        pane.  When this happens in the center pane we unregister at the
        window of the old and register at the window of the new shell.
    */
    DECL_LINK(PaneManagerEventHandler, PaneManagerEvent*);

    /** This call back is called by the form shell when it gets the focus.
        In this case the form shell is moved to the top of the shell stack.
    */
    DECL_LINK(FormControlActivated, FmFormShell*);
};

} // end of namespace sd

#endif
