/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: urllst.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:53:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// includes ******************************************************************

#define _SVSTDARR_STRINGSSORTDTOR
#include <svtools/svstdarr.hxx>

#pragma hdrstop
#include "urllst.hxx"
#include "sfxuno.hxx"

// defines *******************************************************************

// Makros ********************************************************************


//****************************************************************************
// SfxUrlList_Impl
//****************************************************************************

SfxUrlList_Impl::SfxUrlList_Impl()
: mpStringList ( 0 )
{
}

SfxUrlList_Impl::SfxUrlList_Impl(SvStringsSortDtor* pStringList)
: mpStringList ( pStringList )
/*
	Die StringListe gehoert SfxUrlList_Impl
*/
{
}

SfxUrlList_Impl::~SfxUrlList_Impl()
{
	if ( mpStringList )
		delete mpStringList;
}

com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL SfxUrlList_Impl::getList(void) throw ( com::sun::star::uno::RuntimeException )
{
	if ( !mpStringList )
		return com::sun::star::uno::Sequence< rtl::OUString >();
	else
	{
		// Url-Anzahl
		USHORT nListCount = mpStringList->Count();
		// Sequence dafuer
		com::sun::star::uno::Sequence< rtl::OUString > aUlist ( nListCount );

		rtl::OUString* pUString = aUlist.getArray();
		for ( USHORT i = 0	; i < nListCount ; i++ )
		{
			*(pUString) = S2U(*mpStringList->GetObject(i));
			pUString++;
		}
		return aUlist;
	}
}

void SAL_CALL SfxUrlList_Impl::setList(const com::sun::star::uno::Sequence< rtl::OUString >& List_) throw ( com::sun::star::uno::RuntimeException )
{
	if ( mpStringList )
		delete mpStringList;
	mpStringList = new SvStringsSortDtor;
	const rtl::OUString* pUStr = List_.getConstArray();
	for ( USHORT i = 0; i < List_.getLength(); i++ )
	{
		mpStringList->Insert(new XubString ( U2S(*pUStr)));
		pUStr++;
	}
}

com::sun::star::uno::Any SAL_CALL SfxUrlList_Impl::queryInterface( const com::sun::star::uno::Type& rType ) throw ( com::sun::star::uno::RuntimeException )
{
	/* Attention: Don't use mutex or guard in this method!!! Is a method of XInterface.	*/
	/* Ask for my own supported interfaces ...											*/
	com::sun::star::uno::Any aReturn ( ::cppu::queryInterface(	rType,
																static_cast< ::com::sun::star::frame::XUrlList* >( this )
															 )
									 );																															\
	/* If searched interface supported by this class ... */
	if ( aReturn.hasValue() == sal_True )
	{
		/* ... return this information. */
		return aReturn;
	}
	else
	{
		/* Else; ... ask baseclass for interfaces! */
		return OWeakObject::queryInterface( rType );
	}
}


