/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: bmkmenu.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:55:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _BMKMENU_HXX
#define _BMKMENU_HXX

#include <vcl/menu.hxx>
#include <vcl/image.hxx>

class SfxBmkMenu_Impl;
class String;
class ImageList;

#define BMKMENU_ITEMID_START    20000

class SfxBmkMenu : public PopupMenu
{
private:
	static ImageList*  _pSmallImages;
	static ImageList*  _pBigImages;

	SfxBmkMenu_Impl*   _pImp;

	Image				GetImage( USHORT nId, BOOL bBig );

						SfxBmkMenu( const String& rURL, SfxBmkMenu* pRoot );

protected:
    void                Activate();
    void                Deactivate();
    void                Select();
    USHORT              CreateMenuId();

public:
                        SfxBmkMenu( const String& rURL, const String& rReferer );
                        ~SfxBmkMenu();

	void				Initialize(); // Synchrones Laden der Eintraege
};

#endif // #ifndef _BMKMENU_HXX


