/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbedctrl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:30:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#pragma hdrstop

#include "tbedctrl.hxx"
#include "sfx.hrc"
#include "dispatch.hxx"
#include "bindings.hxx"
#include "statcach.hxx"
#include "viewsh.hxx"
#include <viewfrm.hxx>

void ReleaseFocus_Impl()
{
	SfxViewFrame::Current()->GetFrame()->GrabFocusOnComponent_Impl();
}

SfxFrameEdit_Impl::SfxFrameEdit_Impl( Window* pParent, USHORT nSlotId )
	: Edit( pParent )
	, nId ( nSlotId )
{
	Size aSize;
	aSize.Height() = GetTextHeight();
	aSize.Width() = 200;
#ifndef MAC
	aSize.Height() += 6;
#else
	aSize.Height() += 5;
#endif
	SetSizePixel( aSize );
	SetText( String() );
}

// **************************************************************************

void SfxFrameEdit_Impl::KeyInput( const KeyEvent& rKeyEvent )
/*
	[Beschreibung]
*/
{
	SfxViewShell* pSh = SfxViewShell::Current();
	const KeyCode& rKey = rKeyEvent.GetKeyCode();
	USHORT	nCode = rKey.GetCode(),
			nMod = rKey.GetModifier(),
			nGrp = rKey.GetGroup();
	if ( nCode == KEY_TAB && !rKey.IsMod1() || nCode == KEY_RETURN )
	{
		// Achtung: wie leeren String als Filename setzen ??
		// Ausfuehrung des URLs
		String aName( GetText() );
		SfxStringItem aItem( nId, aName );
        SFX_APP()->GetDispatcher_Impl()->Execute( nId, SFX_CALLMODE_RECORD, &aItem, 0L );
		SetContent( aName );
		ClearModifyFlag();

		if ( nCode == KEY_TAB )
			// TAB-Steuerung
			Edit::KeyInput( rKeyEvent );
		else if ( pSh )
			// Focus wieder ins Dokument
			ReleaseFocus_Impl();
	}
	else if ( nCode == KEY_ESCAPE )
	{
		// Text zur"uckholen und Focus wieder ins Dokument
		SetText( aContent );
		ReleaseFocus_Impl();
	}
	else
		Edit::KeyInput( rKeyEvent );
}

void SfxFrameEdit_Impl::LoseFocus()
{
	SetText( aContent );
}

void SfxFrameEdit_Impl::SetContent( const String& rContent)
{
	aContent = rContent;
	SetText( aContent );
}

SFX_IMPL_TOOLBOX_CONTROL( SfxFrameEditToolBoxControl_Impl, SfxStringItem )

SfxFrameEditToolBoxControl_Impl::SfxFrameEditToolBoxControl_Impl( USHORT nSlotID, USHORT nId, ToolBox& rBox ) :
    SfxToolBoxControl( nSlotID, nId, rBox )
{
}

//***************************************************************************

Window* SfxFrameEditToolBoxControl_Impl::CreateItemWindow( Window* pParent )
{
	SfxFrameEdit_Impl* pEdit = new SfxFrameEdit_Impl( pParent, GetId() );
	return pEdit;
}

//***************************************************************************

void SfxFrameEditToolBoxControl_Impl::StateChanged
(
	USHORT 				nSID,
	SfxItemState 		eState,
	const SfxPoolItem* 	pState
)

/*	[Beschreibung]

*/

{
	if ( !GetEdit()->IsModified() && SFX_ITEM_AVAILABLE <= eState )
	{
		GetEdit()->Enable();
		const SfxStringItem *pStr = PTR_CAST(SfxStringItem,pState);
		GetEdit()->SetContent( pStr->GetValue() );
	}

	if ( SFX_ITEM_DISABLED == eState )
	{
		GetEdit()->SetText( String() );
		GetEdit()->Disable();
	}
}

SfxFrameNumericField_Impl::SfxFrameNumericField_Impl( Window* pParent, WinBits nBits )
	: NumericField( pParent, nBits )
{
	Size aSize;
	aSize.Width() = 20 + GetTextWidth( DEFINE_CONST_UNICODE( "10 Pixel" ) );
	aSize.Height() = GetTextHeight();
#ifndef MAC
	aSize.Height() += 6;
#else
	aSize.Height() += 5;
#endif
	SetSizePixel( aSize );
	SetMax( 500 );
	SetMin( 0 );
	SetLast( 500 );
	SetFirst( 0 );

	SetSpinSize( 1 );
	Show();
}

SfxFrameNumericField_Impl::~SfxFrameNumericField_Impl()
{
}

void SfxFrameNumericField_Impl::Modify()
{
	long nTmp = GetValue();
	if ( nTmp > 500 )
		SetValue( 500 );
	if ( nTmp < 0 )
		SetValue( 0 );
}

void SfxFrameNumericField_Impl::Execute()
{
	if ( GetText().Len() )
	{
		long nTmp = GetValue();
		SfxUInt16Item aItem( SID_FRAMESPACING, (USHORT) nTmp );
        SFX_APP()->GetDispatcher_Impl()->Execute( SID_FRAMESPACING, SFX_CALLMODE_RECORD, &aItem, 0L );
	}
	else
        SFX_APP()->GetDispatcher_Impl()->Execute( SID_FRAMESPACING, SFX_CALLMODE_RECORD );
}

long SfxFrameNumericField_Impl::Notify( NotifyEvent& rNEvt )
{
	switch ( rNEvt.GetType() )
	{
		case EVENT_GETFOCUS :
			GetFocus_Impl();
			break;
		case EVENT_LOSEFOCUS:
			LoseFocus_Impl();
			break;
		case EVENT_KEYINPUT:
		{
			SfxViewShell* pSh = SfxViewShell::Current();
			const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
			const KeyCode& rKey = pKEvt->GetKeyCode();
			USHORT	nCode = rKey.GetCode(),
					nMod = rKey.GetModifier(),
					nGrp = rKey.GetGroup();
			if ( nCode == KEY_TAB && !rKey.IsMod1() ||
				 nCode == KEY_RETURN )
			{
				if ( GetText().Len() )
				{
					Reformat();
					aCurTxt = String::CreateFromInt32( GetValue() );
					aCurTxt += DEFINE_CONST_UNICODE( " Pixel" );
					SetText( aCurTxt );
				}
				else
					aCurTxt.Erase();
				Execute();
				if ( nCode != KEY_TAB )
					ReleaseFocus_Impl();
			}
			else if ( nCode == KEY_ESCAPE )
			{
				SetText( aCurTxt );
				ReleaseFocus_Impl();
				break;
			}
		}
		default:
			break;
	}

	return NumericField::Notify( rNEvt );
}

void SfxFrameNumericField_Impl::GetFocus_Impl()
{
	aCurTxt = GetText();
}

void SfxFrameNumericField_Impl::LoseFocus_Impl()
{
	SetText( aCurTxt );
}

void SfxFrameNumericField_Impl::Down()
{
	long nValue = GetValue();
	nValue -= GetSpinSize();

	// Um unter OS/2 einen Sprung auf Max zu verhindern
	if ( nValue >= GetMin() )
		NumericField::Down();
	aCurTxt = String::CreateFromInt32( GetValue() );
	aCurTxt += DEFINE_CONST_UNICODE( " Pixel" );
	SetText( aCurTxt );
	Execute();
}

void SfxFrameNumericField_Impl::Up()
{
	NumericField::Up();
	aCurTxt = String::CreateFromInt32( GetValue() );
	aCurTxt += DEFINE_CONST_UNICODE( " Pixel" );
	SetText( aCurTxt );
	Execute();
}

SFX_IMPL_TOOLBOX_CONTROL( SfxFrameSpacingControl_Impl, SfxUInt16Item )

SfxFrameSpacingControl_Impl::SfxFrameSpacingControl_Impl( USHORT nSlotID, USHORT nId, ToolBox& rBox )
	: 	SfxToolBoxControl( nSlotID, nId, rBox )
{
}

Window* SfxFrameSpacingControl_Impl::CreateItemWindow( Window *pParent )
{
	return new SfxFrameNumericField_Impl( pParent );
}

void SfxFrameSpacingControl_Impl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
{
	NumericField* pWin = (NumericField*) GetToolBox().GetItemWindow( GetId() );

	DBG_ASSERT( pWin, "Window not found" );

	if ( eState == SFX_ITEM_DISABLED )
	{
		pWin->Disable();
		pWin->SetText( String() );
	}
	else
	{
		pWin->Enable();
		if ( eState == SFX_ITEM_SET )
		{
			String aValue = String::CreateFromInt32( ( (const SfxUInt16Item*)pState )->GetValue() );
			aValue += DEFINE_CONST_UNICODE( " Pixel" );
			pWin->SetText( aValue );
		}
		else
			// Default
			pWin->SetText( String() );
	}
}


