/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: intnunx.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:26:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdlib.h>  // for getenv()
#include <stdio.h>

#ifndef _STRING_HXX
#include <string.hxx>
#endif
#ifndef _INTNTAB_HXX
#include <intntab.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <isolang.hxx>
#endif

#ifdef MACOSX
#ifndef _OSL_PROCESS_H_
#include <osl/process.h>
#endif
#ifndef _RTL_LOCALE_H_
#include <rtl/locale.h>
#endif
#endif

// =======================================================================

static LanguageType eImplSystemLanguage = LANGUAGE_DONTKNOW;

// =======================================================================

void SetSystemLanguage( LanguageType eLang )
{
    eImplSystemLanguage = eLang;
}

// =======================================================================

USHORT ImplGetSystemLanguageCount()
{
    return 0;
}

// -----------------------------------------------------------------------

// Get locale of category LC_CTYPE of environment variables
static sal_Char* GetLangFromEnvironment()
{
    static sal_Char* pFallback = "C";
    sal_Char *pLang = NULL;

    pLang = getenv ( "LC_ALL" );
    if (! pLang)
        pLang = getenv ( "LC_CTYPE" );
    if (! pLang)
        pLang = getenv( "LANG" );
    if (! pLang)
        pLang = pFallback;

    return pLang;
}

// -----------------------------------------------------------------------

// Get locale of category LC_MESSAGES of environment variables
static sal_Char* GetUILangFromEnvironment()
{
    static sal_Char* pFallback = "C";
    sal_Char *pLang = NULL;

    pLang = getenv ( "LANGUAGE" );      // respect the GNU extension
    if (! pLang)
        pLang = getenv ( "LC_ALL" );
    if (! pLang)
        pLang = getenv ( "LC_MESSAGES" );
    if (! pLang)
        pLang = getenv( "LANG" );
    if (! pLang)
        pLang = pFallback;

    return pLang;
}

// -----------------------------------------------------------------------

LanguageType GetSystemLanguage( USHORT nIndex )
{
    /* get the language from the user environment */
    if (nIndex == INTERNATIONAL_SYSTEM_DEFAULT)
    {
        if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
        {
#ifdef MACOSX
            rtl_Locale    *procLocale;
            
            if ( osl_getProcessLocale(&procLocale) == osl_Process_E_None )
            {
                UniString     rLang( procLocale->Language->buffer );
                UniString     rCountry( procLocale->Country->buffer );
            
                eImplSystemLanguage = ConvertIsoNamesToLanguage( rLang, rCountry );
#ifdef DEBUG
                if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
                    fprintf( stderr, "intnunx.cxx:  failed to convert osl_getProcessLocale() language to system language.\n" );
#endif
            }
#else   /* MACOSX */
            ByteString aUnxLang (GetLangFromEnvironment());
            eImplSystemLanguage = ConvertUnxByteStringToLanguage( aUnxLang );
#endif  /* MACOSX */
        }
        return eImplSystemLanguage;
    }

    return LANGUAGE_DONTKNOW;
}

// -----------------------------------------------------------------------

LanguageType GetSystemUILanguage( USHORT nIndex )
{
    /* get the language from the user environment */
    if (nIndex == INTERNATIONAL_SYSTEM_DEFAULT)
    {
        if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
        {
#ifdef MACOSX
            rtl_Locale    *procLocale;
            
            if ( osl_getProcessLocale(&procLocale) == osl_Process_E_None )
            {
                UniString     rLang( procLocale->Language->buffer );
                UniString     rCountry( procLocale->Country->buffer );
            
                eImplSystemLanguage = ConvertIsoNamesToLanguage( rLang, rCountry );
#ifdef DEBUG
                if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
                    fprintf( stderr, "intnunx.cxx:  failed to convert osl_getProcessLocale() language to system language.\n" );
#endif
            }
#else   /* MACOSX */
            ByteString aUnxLang (GetUILangFromEnvironment());
            eImplSystemLanguage = ConvertUnxByteStringToLanguage( aUnxLang );
#endif  /* MACOSX */
        }
        return eImplSystemLanguage;
    }

    return LANGUAGE_DONTKNOW;
}

// =======================================================================

void ImplUpdateSystemLanguage( LanguageType, LanguageTable* )
{
}

// =======================================================================

USHORT ImplGetSystemFormatCount()
{
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemFormatLanguage( USHORT nIndex )
{
    return GetSystemLanguage( nIndex );
}

// -----------------------------------------------------------------------

void ImplUpdateSystemFormat( LanguageType, FormatTable* )
{
}
