/*
 * Frame.java
 *
 * Created on 5. M?rz 2003, 17:33
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;

import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.accessibility.AccessibleStateType;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.NameProvider;

/**
 * Offers the possibilities to search for objects at the specified X and Y (with the
 * AccessibleObjectFind class), afterwards the found object will be showed with all
 * properties. Besides this the additional information will be shown as well, such as -
 * location of this object in StarOffice and futher properties of this object. This
 * information is showed graphically.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class ActionFrame extends JFrame implements IAccessibleObjectDisplay {
	private XExtendedToolkit m_XToolkit;
	private static ActionFrame m_actionFrame;
	private XAccessibleContext m_xaccessContext;
	private String m_classTyp;
	private AccessibleObjectFind m_xaccessOF;
	private MethodDialog m_methodDialog;
	private ActionPanel m_actinPanel;
	private XFramework m_frame;

	/// A textutal representation of the currently focused object.
	private TextualDisplay maTextualDisplay;

	/// A graphical representation of the currently focused object.
	private GraphicalDisplay maGraphicalDisplay;

	/**
	 * Creates a new ActionFrame object.
	 *
	 * @param xframe
	 */
	public ActionFrame(XFramework xframe) {
		m_frame = xframe;
		m_actionFrame = this;
		m_classTyp = xframe.getConnectedDocumentTyp();
		m_XToolkit = xframe.getXExtendedToolkit();
		m_xaccessOF = new AccessibleObjectFind(m_XToolkit);
		m_methodDialog = new MethodDialog(m_actionFrame);
		init();
	}

	/**
	 * Initializes the class.
	 */
	private void init() {
		JPanel contentPane = (JPanel) getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		setBounds(200, 70, 600, 600);
		setTitle("StarOffice object finder");

		maTextualDisplay = new TextualDisplay();
		maGraphicalDisplay = new GraphicalDisplay();

		JPanel textPanel = new JPanel(new BorderLayout());
		TitledBorder textBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Focused Object:");
		textPanel.setPreferredSize(new Dimension(300, 100));
		textPanel.setBorder(textBorder);
		textPanel.add(maTextualDisplay);

		JPanel graphicPanel = new JPanel(new BorderLayout());
		TitledBorder graphicBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Graphical:");
		graphicPanel.setPreferredSize(new Dimension(300, 200));
		graphicPanel.setBorder(graphicBorder);
		graphicPanel.add(maGraphicalDisplay);

		JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		sp.setDividerLocation(270);
		sp.setLeftComponent(textPanel);
		sp.setRightComponent(graphicPanel);
		sp.setOneTouchExpandable(true);
		sp.setDividerSize(15);

		JButton quit = new JButton("Cancel");
		JButton addActions = new JButton("Ok");
		JButton menu = new JButton("Get MenuBar");
		final JButton press_release = new JButton("Press and release over office application");

		JPanel buttoms = new JPanel(new GridLayout(1, 2));
		buttoms.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 6));
		buttoms.add(addActions);
		buttoms.add(quit);

		JPanel buttom1 = new JPanel(new BorderLayout());
		buttom1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		buttom1.add(press_release, BorderLayout.CENTER);

		JPanel buttom2 = new JPanel(new BorderLayout());
		buttom2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
		buttom2.add(menu, BorderLayout.CENTER);

		JPanel buttonPanel = new JPanel(new BorderLayout());
		buttonPanel.add(buttoms, BorderLayout.EAST);
		buttonPanel.add(buttom1, BorderLayout.CENTER);
		buttonPanel.add(buttom2, BorderLayout.WEST);

		m_actinPanel = new ActionPanel(m_actionFrame);

		contentPane.add(sp, BorderLayout.NORTH);
		contentPane.add(m_actinPanel, BorderLayout.CENTER);
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		setDefaultMenuBar();

		//setVisible( true );
		addActions.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				m_frame.addActionstoStep(m_actinPanel.getDataVector());
				setDefaultMenuBar();
				m_frame.showStepFrame(getBounds());
				dispose();
				initActionFrame();
			}
		});

		menu.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MenuFactory aMenuFactory = new MenuFactory((IAccessibleObjectDisplay) m_actionFrame);
				JMenuBar aMenuBar = aMenuFactory.GetJMenuBar(m_XToolkit);
				setJMenuBar(aMenuBar);
				aMenuBar = getJMenuBar();
				aMenuBar.updateUI();
			}
		});

		press_release.addMouseListener(new java.awt.event.MouseListener() {
			public void mousePressed(MouseEvent e) {
				int x = e.getX();
				int y = e.getY();
				Component aSource = e.getComponent();
				x += aSource.getX();
				y += aSource.getY();
			}

			public void mouseReleased(MouseEvent e) {
				int x = e.getX();
				int y = e.getY();
				Component aSource = e.getComponent();
				boolean bMouseOverTrackButton = false;

				while (aSource != null) {
					if (aSource == press_release) {
						bMouseOverTrackButton = true;
					}

					x += aSource.getX();
					y += aSource.getY();
					aSource = aSource.getParent();
				}

				if (bMouseOverTrackButton) {
					XAccessible xacces = m_xaccessOF.findAccessibleObject(x, y);

					if (xacces != null) {
						setAccessibleObject(xacces.getAccessibleContext());
					}
				}
			}

			public void mouseClicked(MouseEvent e) {
			}

			public void mouseEntered(MouseEvent e) {
			}

			public void mouseExited(MouseEvent e) {
			}
		});

		quit.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setDefaultMenuBar();
				dispose();
				initActionFrame();
				m_frame.showStepFrame(getBounds());
			}
		});
	}

	/**
	 * Check whether the child object has the status "SHOWING", otherwise get the parent
	 * object and check it.
	 *
	 * @param xacces child
	 *
	 * @return SHOWING object
	 */
	private XAccessible getVisibleAccessible(XAccessible xacces) {
		if (xacces != null) {
			if (AccessibilityTools.checkState(xacces.getAccessibleContext(), AccessibleStateType.SHOWING)) {
				return xacces;
			} else {
				getVisibleAccessible(xacces.getAccessibleContext().getAccessibleParent());
			}
		}

		return null;
	}

	/**
	 * Set the default office menu bar.
	 */
	public void setDefaultMenuBar() {
		JMenuBar menuBar = new JMenuBar();
		JMenuItem office = new JMenuItem("Office MenuBar");
		office.setEnabled(false);
		menuBar.add(office);
		setJMenuBar(menuBar);
	}

	/**
	 * Main purpose consists in the window closing clean up.
	 *
	 * @param e WindowEvent
	 */
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);

		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			dispose();
			m_frame.showStepFrame(getBounds());
		}
	}

	/**
	 * Set the view of the properties for found staroffice object.
	 *
	 * @param xContext - the found staroffice object
	 */
	public void setAccessibleObject(XAccessibleContext xContext) {
		if (xContext != null) {
			m_xaccessContext = xContext;
			maTextualDisplay.setAccessibleObject(xContext);
			maGraphicalDisplay.setAccessibleObject(xContext);
			m_actinPanel.action.setEnabled(true);
		} else {
			m_actinPanel.setButtonsProperties();
		}
	}

	/**
	 * Refresh the view of the properties for found staroffice object.
	 *
	 * @param xContext - the found staroffice object
	 */
	public void updateAccessibleObject(XAccessibleContext xContext) {
		if (xContext != null) {
			m_xaccessContext = xContext;
		}

		maTextualDisplay.updateAccessibleObject(xContext);
		maGraphicalDisplay.updateAccessibleObject(xContext);
	}

	/**
	 * Initialize action frame
	 */
	public void initActionFrame() {
		m_xaccessContext = null;
		updateAccessibleObject(null);
		m_actinPanel.initTable();
		m_actinPanel.action.setEnabled(false);
		m_actinPanel.setButtonsProperties();
	}

	/**
	 * Check if the staroffice object is found.
	 *
	 * @return true if found, false otherwise
	 */
	public boolean isAccessibleObjectFound() {
		if (m_xaccessContext != null) {
			return true;
		}

		return false;
	}

	/**
	 * Get the properties of the current found staroffice object.
	 *
	 * @return properties as string array
	 */
	private String[] getAccessibleObjProperties() {
		String[] poperties = new String[2];
		String path = "";
		poperties[1] = m_classTyp;

		try {
			for (XAccessibleContext xcon = m_xaccessContext; xcon != null;) {
				if (xcon.getAccessibleRole() == AccessibleRole.PARAGRAPH) {
					path = NameProvider.getRoleName(xcon.getAccessibleRole()) + "#Paragraph:" + xcon.getAccessibleIndexInParent() + "#" + xcon.getAccessibleIndexInParent() + ";" + path;
				} else if (xcon.getAccessibleIndexInParent() == -1) {
					int index = -1;
					short role = xcon.getAccessibleRole();
					String name = xcon.getAccessibleName();

					try {
						index = AccessibilityTools.getXWindowIndex(Helper.getTopWindows(m_XToolkit), name, role);
					} catch (com.sun.star.uno.Exception ex) {
					}

					if ((poperties[1] == "DesktopMenu") && (path.split("MENU").length > 3)) {
						index = index + (path.split("MENU").length - 3);
					}

					if ((role == AccessibleRole.FRAME) && name.equals(m_frame.getConnectedDocumentTitle())) {
						path = "{D}" + NameProvider.getRoleName(role) + "#" + name + "#" + index + ";" + path;
					} else {
						path = NameProvider.getRoleName(role) + "#" + name + "#" + index + ";" + path;
					}
				} else {
					try {
/*						XAccessibleContext test = xcon.getAccessibleParent().getAccessibleContext();
						Helper.log("**************************************");
						Helper.log("childer : " + test.getAccessibleChildCount());

						for (int ii = 0; ii < test.getAccessibleChildCount(); ii++) {
							Helper.log("child : " + test.getAccessibleChild(ii).getAccessibleContext().getAccessibleRole() + " **** " + test.getAccessibleChild(ii).getAccessibleContext().getAccessibleName());
						}
*/
						Helper.log("GET child ROLE & NAME : " + xcon.getAccessibleRole() + " & " + xcon.getAccessibleName());
						Helper.log("GET child INDEX : " + xcon.getAccessibleIndexInParent());
						Helper.log("**************************************");
					} catch (Exception ex) {
					}

					path = NameProvider.getRoleName(xcon.getAccessibleRole()) + "#" + xcon.getAccessibleName() + "#" + xcon.getAccessibleIndexInParent() + ";" + path;
				}

				if (xcon.getAccessibleRole() == AccessibleRole.MENU_BAR) {
					poperties[1] = "DesktopMenu";
				} else if (xcon.getAccessibleRole() == AccessibleRole.DIALOG) {
					poperties[1] = "DesktopDialog";
				}

				if (xcon.getAccessibleParent() == null || xcon.getAccessibleIndexInParent() == -1) {
					xcon = null;
				} else {
					xcon = xcon.getAccessibleParent().getAccessibleContext();
				}
			}
		} catch (com.sun.star.lang.DisposedException ex) {
		}

		poperties[0] = path;

		return poperties;
	}

	/**
	 * Open the methods dialog, where some actions can be selected for the found
	 * staroffice object.
	 */
	public void openMethodsDialog() {
		String[] properties = getAccessibleObjProperties();
		m_methodDialog.initMethodDialog(properties[0], properties[1]);
		m_methodDialog.setVisible(true);
	}

	/**
	 * Add action for the found staroffice object.
	 */
	public void addAction() {
		Vector data = m_methodDialog.getDataVector();
		m_actinPanel.addAction(data);
	}
}
