/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Localizer.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/01/26 17:22:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.star.wizards.tutorial.executer.util;

import java.io.File;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.tutorial.executer.util.MacroCreator;
import com.sun.star.wizards.tutorial.executer.util.MacroListener;
import com.sun.star.wizards.tutorial.executer.util.MacroReader;
import com.sun.star.wizards.tutorial.executer.util.URLDispatcher;

import complexlib.ComplexTestCase;

/**
 * DOCUMENT ME!
 *
 * @author $author$
 * @version $Revision: 1.4 $
 */
public class Localizer extends ComplexTestCase {
	public static boolean macro_next = false;
	public XMultiServiceFactory m_msf = null;

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public String[] getTestMethodNames() {
		return new String[] { "localize" };
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public String getTestObjectName() {
		return "Localizer";
	}

	/**
	 * DOCUMENT ME!
	 */
	public void localize() {
		try {
			m_msf = (XMultiServiceFactory) param.getMSF();

			java.net.URL url = new java.net.URL(util.utils.getFullTestURL(""));
			System.out.println("Path :" + url.getPath());

			File files = new File(url.getPath());
			String[] fileNames = files.list();
			util.dbg.printArray(fileNames);

			// load BasicBridge with MarcoEceutionMode = Always-no warn
			XDesktop xdes;
			XComponent doc = null;
			xdes = getXDesktop();

			XComponentLoader xcom = (XComponentLoader) UnoRuntime.queryInterface(XComponentLoader.class, xdes);
			PropertyValue[] DocArgs = new PropertyValue[1];
			PropertyValue DocArg = new PropertyValue();

			DocArg.Name = "MacroExecutionMode";
			DocArg.Value = new Short(com.sun.star.document.MacroExecMode.ALWAYS_EXECUTE_NO_WARN);
			DocArgs[0] = DocArg;

			for (int ii = 0; ii < fileNames.length; ii++) {
				String FileName = fileNames[ii];
				String file = util.utils.getFullTestURL(FileName);
				System.out.println("Trying to load: " + file);

				doc = xcom.loadComponentFromURL(file, "_blank", 0, DocArgs);

				Thread.sleep(3000);

				Thread thread = new Thread(new Runnable() {
					public void run() {
						try {
							Thread.sleep(1000);
							localizeHelper();
						} catch (Exception ex) {
							ex.printStackTrace();
						}
					}
				});
				thread.setPriority(Thread.MAX_PRIORITY);
				thread.start();
				thread.join();

				XStorable store = (XStorable) UnoRuntime.queryInterface(XStorable.class, doc);
				XCloseable closer = (XCloseable) UnoRuntime.queryInterface(XCloseable.class, doc);
				store.store();
				closer.close(true);
			}
		} catch (com.sun.star.util.CloseVetoException e) {
			System.out.println("Couldn't close document " + e.getMessage());
			failed("Couldn't close document");
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws com.sun.star.uno.Exception DOCUMENT ME!
	 */
	private void localizeHelper() throws com.sun.star.uno.Exception {
		//get macro names        
		String[] macroNames = MacroReader.getDocumentMacroNames(getXModel(), "Standard");
		assure(macroNames.length > 0);
		setLocalisation(macroNames);
		MacroListener.createDocumentMacroListener(getXModel(), "Standard");
		macro_next = false;

		//run macros & check for success        
		long startTime = System.currentTimeMillis();

		for (int i = 0, wait = 0; i < macroNames.length; i++) {
			String macroName = macroNames[i];
			assure(runMacro(macroName));

			while (!macro_next) {
				System.out.println("Macro is active :" + macroName);
				System.out.println("Current wait : " + wait + " sec. Max localisation wait is 120 sec.");

				try {
					Thread.sleep(6000);
				} catch (java.lang.InterruptedException ex) {
					ex.printStackTrace();
				}

				if ((System.currentTimeMillis() - startTime) > 120000)
					break;
				else
					wait = ((wait * 1000) + 6000) / 1000;
			}

			macro_next = false;
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param macroName DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public boolean runMacro(String macroName) {
		boolean result = true;
		String url = "macro://./Standard." + macroName + ".Main" + macroName + "()";
		System.out.println("dispatch path= " + url);

		try {
			URLDispatcher.dispatch_Thread(getXFrame(), url, "_self", 0, null);
		} catch (com.sun.star.uno.Exception ex) {
			ex.printStackTrace();
			result = false;
		}

		return result;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 *
	 * @throws com.sun.star.uno.Exception DOCUMENT ME!
	 */
	private XFrame getXFrame() throws com.sun.star.uno.Exception {
		XModel xModel = getXModel();
		XController xController = xModel.getCurrentController();
		XFrame xFrame = xController.getFrame();

		return xFrame;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 *
	 * @throws com.sun.star.uno.Exception DOCUMENT ME!
	 */
	public XDesktop getXDesktop() throws com.sun.star.uno.Exception {
		XDesktop desk = (XDesktop) UnoRuntime.queryInterface(XDesktop.class, m_msf.createInstance("com.sun.star.frame.Desktop"));

		return desk;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 *
	 * @throws com.sun.star.uno.Exception DOCUMENT ME!
	 */
	public XModel getXModel() throws com.sun.star.uno.Exception {
		XComponent xComponent = getXComponent();
		XModel xModel = xModel = (XModel) UnoRuntime.queryInterface(XModel.class, xComponent);

		return xModel;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 *
	 * @throws com.sun.star.uno.Exception DOCUMENT ME!
	 */
	public XComponent getXComponent() throws com.sun.star.uno.Exception {
		XDesktop xDesktop = getXDesktop();
		XComponent xcomp = xDesktop.getCurrentComponent();

		return xcomp;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param macroNames DOCUMENT ME!
	 *
	 * @throws com.sun.star.uno.Exception DOCUMENT ME!
	 */
	public void setLocalisation(String[] macroNames) throws com.sun.star.uno.Exception {
		for (int i = 0; i < macroNames.length; i++) {
			String macro = MacroReader.readDocumentMacro(getXModel(), "Standard", macroNames[i]);

			String temp = "properties(2).Value = " + '"';

			if (macro.indexOf(temp) > -1) {
				int index = macro.indexOf(temp) + temp.length();
				String part1 = macro.substring(0, index);
				String part3 = macro.substring(index);
				String part2 = part3.substring(0, part3.indexOf('"'));
				part3 = part3.substring(part3.indexOf('"'));

				//System.out.println("part1 = " + part1);
				//System.out.println("part2 = " + part2);
				//System.out.println("part3 = " + part3);
				if (!part2.equalsIgnoreCase("True")) {
					macro = part1 + "True" + part3;
					MacroCreator.createDocumentMacro(getXModel(), "Standard", macroNames[i], macro, true);
				}
			}
		}
	}
}
