/*
 * PathProperties.java
 *
 * Created on 7. Oktober 2003, 17:11
 */
package com.sun.star.wizards.tutorial.executer.util;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class PathProperties {
	private static short m_role = -1;
	private static String m_name = "";
	private static int m_index = -1;

	/**
	 * Create a new Child.
	 *
	 * @param path node
	 * @param index node index in parent node
	 */
	public static void putPath(String[] path, int index) {
		String identify = path[index].trim();
		String[] idents = identify.split("#", 3);
		String[] result = new String[3];

		if (idents.length == 3) {
			String sRole = idents[0].trim();

			if (NameProvider.getRoleId(sRole) > -1) {
				m_role = (short) NameProvider.getRoleId(sRole);
				m_name = idents[1].trim();
				m_index = Integer.parseInt((String) idents[2]);
			}
		}
	}

	/**
	 * Get the context form child object
	 *
	 * @return child context
	 */
	public static short getRole() {
		return m_role;
	}

	/**
	 * Get the child index in parent node
	 *
	 * @return child index
	 */
	public static String getName() {
		return m_name;
	}

	/**
	 * Get the child index in parent node
	 *
	 * @return child index
	 */
	public static int getIndex() {
		return m_index;
	}
}
