/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DataInterpreter.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:54:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "DataInterpreter.hxx"
#include "DataSeries.hxx"
#include "macros.hxx"

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _COM_SUN_STAR_CHART2_XDATASINK_HPP_
#include <com/sun/star/chart2/XDataSink.hpp>
#endif

using namespace ::com::sun::star;

using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::Sequence;
using ::rtl::OUString;

namespace chart
{


::std::vector< Reference< chart2::XDataSeries > >
    DataInterpreter::InterpretData(
        const Reference< chart2::XDataSource > & rSource )
{
    ::std::vector< uno::Reference< chart2::XDataSeries > > aSeriesVec;

    if( ! rSource.is())
        return aSeriesVec;

    Sequence< uno::Reference< chart2::XDataSequence > > xData( rSource->getDataSequences() );
    OUString aRole;

    ::std::vector< uno::Reference< chart2::XDataSequence > > aCategories;
    ::std::vector< uno::Reference< chart2::XDataSequence > > aLabels;
    ::std::vector< uno::Reference< chart2::XDataSequence > > aSeries;

    for( sal_Int32 i=0; i < xData.getLength(); ++i )
    {
        uno::Reference< chart2::XDataSequence > xSeq( xData[ i ] );
        uno::Reference< beans::XPropertySet > xProp( xSeq, uno::UNO_QUERY );
        if( xProp.is())
            xProp->getPropertyValue( C2U( "Role" )) >>= aRole;

        if( aRole.equals( C2U( "categories" )))
        {
            aCategories.push_back( xSeq );
        }
        else if( aRole.equals( C2U( "label" )))
        {
            aLabels.push_back( xSeq );
        }
        else // everything else is treated as "y-values"
        {
            if( ! aRole.equals( C2U( "y-values" )) &&
                xProp.is() )
            {
                xProp->setPropertyValue( C2U( "Role" ), uno::makeAny( C2U( "y-values" )));
            }

            aSeries.push_back( xSeq );
        }
    }

    // create DataSeries
    ::std::vector< uno::Reference< chart2::XDataSequence > >::const_iterator
          aSeriesIt = aSeries.begin(),
          aLabelsIt = aLabels.begin();

    bool bHasCategories = ( aCategories.begin() != aCategories.end() );

    const OUString aIdStub( RTL_CONSTASCII_USTRINGPARAM( "@ser" ));
    sal_Int32 nSeriesCounter = 1;

    for( ;aSeriesIt != aSeries.end(); ++aSeriesIt, ++nSeriesCounter )
    {
        sal_Int32 nLength =
            1 +   // values
            ( bHasCategories ? 1: 0 ) +
            (( aLabelsIt != aLabels.end() ) ? 1 : 0 );

        Sequence< uno::Reference< chart2::XDataSequence > > aData( nLength );

        sal_Int32 nIndex = 0;
        aData[ nIndex ] = *aSeriesIt;
        ++nIndex;

        if( bHasCategories )
        {
            aData[ nIndex ] = *(aCategories.begin());
            ++nIndex;
        }
        if( aLabelsIt != aLabels.end() )
        {
            aData[ nIndex ] = *aLabelsIt;
            ++aLabelsIt;
            ++nIndex;
        }

        uno::Reference< chart2::XDataSeries > xSeries(
            new DataSeries(
                aIdStub + OUString::valueOf( static_cast< sal_Int32 >( nSeriesCounter ))));
        OSL_ASSERT( xSeries.is() );
        uno::Reference< chart2::XDataSink > xSink( xSeries, uno::UNO_QUERY );
        OSL_ASSERT( xSink.is() );
        xSink->setData( aData );

        aSeriesVec.push_back( xSeries );
    }

    return aSeriesVec;
}


} // namespace chart
